/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.incoming;

import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.jml.Email;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnContactList;
import net.sf.jml.MsnList;
import net.sf.jml.MsnMessageChain;
import net.sf.jml.MsnProtocol;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.impl.MsnContactImpl;
import net.sf.jml.impl.MsnContactListImpl;
import net.sf.jml.protocol.MsnIncomingMessage;
import net.sf.jml.protocol.MsnMessage;
import net.sf.jml.protocol.MsnOutgoingMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.protocol.outgoing.OutgoingADL;
import net.sf.jml.protocol.outgoing.OutgoingFQY;
import net.sf.jml.util.XmlUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IncomingADL
extends MsnIncomingMessage {
    private boolean isChunkSupported = true;
    private static final Log logger = LogFactory.getLog(IncomingADL.class);

    public IncomingADL(MsnProtocol msnProtocol) {
        super(msnProtocol);
    }

    protected boolean isSupportChunkData() {
        return this.isChunkSupported;
    }

    protected boolean load(ByteBuffer byteBuffer) {
        boolean bl = super.load(byteBuffer);
        if (!bl) {
            this.isChunkSupported = false;
            bl = super.load(byteBuffer);
        }
        return bl;
    }

    protected void messageReceived(MsnSession msnSession) {
        Object object;
        Object object2;
        super.messageReceived(msnSession);
        if (this.protocol.after(MsnProtocol.MSNP13) && msnSession.getContactList().isADLSent()) {
            msnSession.getContactList().processInit();
        }
        MsnMessageChain msnMessageChain = msnSession.getOutgoingMessageChain();
        int n = this.getTransactionId();
        Object object3 = msnMessageChain.iterator();
        while (object3.hasPrevious()) {
            object2 = (MsnOutgoingMessage)object3.previous();
            if (((MsnMessage)object2).getTransactionId() != n || (object = ((OutgoingADL)object2).getContact()) == null) continue;
            MsnList msnList = null;
            if (((MsnContactImpl)object).isInList(MsnList.FL)) {
                msnList = MsnList.FL;
            } else if (((MsnContactImpl)object).isInList(MsnList.AL)) {
                msnList = MsnList.AL;
            }
            ((AbstractMessenger)msnSession.getMessenger()).fireContactAddCompleted((MsnContact)object, msnList);
            OutgoingFQY outgoingFQY = new OutgoingFQY(this.protocol);
            outgoingFQY.setContact((MsnContactImpl)object);
            msnSession.getMessenger().send(outgoingFQY);
            return;
        }
        object3 = this.getChunkData();
        if (object3 == null || ((Object)object3).length == 0) {
            return;
        }
        try {
            object2 = (MsnContactListImpl)msnSession.getMessenger().getContactList();
            object = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object).setIgnoringComments(true);
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object3);
            Document document = documentBuilder.parse(byteArrayInputStream);
            Element element = document.getDocumentElement();
            String string = XmlUtils.findChild(element, "d").getAttribute("n");
            String string2 = XmlUtils.findChildByChain(element, new String[]{"d", "c"}).getAttribute("n");
            String string3 = XmlUtils.findChildByChain(element, new String[]{"d", "c"}).getAttribute("t");
            String string4 = XmlUtils.findChildByChain(element, new String[]{"d", "c"}).getAttribute("l");
            String string5 = XmlUtils.findChildByChain(element, new String[]{"d", "c"}).getAttribute("f");
            MsnContactImpl msnContactImpl = (MsnContactImpl)((MsnContactListImpl)object2).getContactByEmail(Email.parseStr(string2 + "@" + string));
            if (msnContactImpl == null) {
                msnContactImpl = new MsnContactImpl((MsnContactList)object2);
                msnContactImpl.setEmail(Email.parseStr(string2 + "@" + string));
                msnContactImpl.setFriendlyName(string5);
                msnContactImpl.setDisplayName(string5);
                ((MsnContactListImpl)object2).addContact(msnContactImpl);
            }
            boolean bl = msnContactImpl.isInList(MsnList.RL);
            int n2 = Integer.parseInt(string4);
            if (bl || (n2 & MsnList.RL.getListId()) != MsnList.RL.getListId()) {
                return;
            }
            if (n == 0 && n2 == MsnList.RL.getListId()) {
                msnContactImpl.setInList(MsnList.RL, true);
                ((AbstractMessenger)msnSession.getMessenger()).fireContactAddedMe(msnContactImpl);
            } else {
                MsnList[] msnListArray = new MsnList[]{MsnList.AL, MsnList.BL, MsnList.FL, MsnList.PL, MsnList.RL};
                for (int i = 0; i < msnListArray.length; ++i) {
                    MsnList msnList = msnListArray[i];
                    if ((n2 & msnList.getListId()) == msnList.getListId()) {
                        msnContactImpl.setInList(msnList, true);
                        continue;
                    }
                    msnContactImpl.setInList(msnList, false);
                }
                ((AbstractMessenger)msnSession.getMessenger()).fireContactAddedMe(msnContactImpl);
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Erro parsing incoming ADL!", (Throwable)exception);
        }
    }
}

