/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.console;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.profiler4j.console.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project {
    private boolean changed;
    private File file;
    private String name = "Sample Profiling Project";
    private String hostname = "localhost";
    private int port = 7890;
    private boolean beanprops = true;
    private Rule.AccessOption access = Rule.AccessOption.PRIVATE;
    private List<Rule> rules = new ArrayList<Rule>();

    public Project() {
        this.rules.add(new Rule("net.java.sip.communicator.*(*)", Rule.Action.ACCEPT));
        this.rules.add(new Rule("net.java.sip.communicator.plugin.profiler4j.*(*)", Rule.Action.REJECT));
        this.rules.add(new Rule("net.java.sip.communicator.impl.media.device.*(*)", Rule.Action.REJECT));
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.changed = true;
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.changed = true;
        this.port = port;
    }

    public Rule.AccessOption getAccess() {
        return this.access;
    }

    public void setAccess(Rule.AccessOption access) {
        this.changed = true;
        this.access = access;
    }

    public boolean isBeanprops() {
        return this.beanprops;
    }

    public void setBeanprops(boolean beanprops) {
        this.beanprops = beanprops;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(List<Rule> rules) {
        this.changed = true;
        this.rules = rules;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.changed = true;
        this.file = file;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void clearChanged() {
        this.changed = false;
    }

    public String formatOptions() {
        StringBuilder out = new StringBuilder();
        out.append("-beanprops:" + (this.isBeanprops() ? "on" : "off"));
        out.append(" -access:" + this.getAccess().toString().toLowerCase());
        return out.toString();
    }

    public String formtRules() {
        StringBuilder out = new StringBuilder();
        for (Rule r : this.getRules()) {
            out.append(r.getPattern() + " : " + r.getAction().toString().toLowerCase() + "; ");
        }
        return out.toString();
    }
}

