/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.renderer.audio;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.MediaLocator;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.MediaUtils;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.PulseAudioSystem;
import org.jitsi.impl.neomedia.jmfext.media.renderer.audio.AbstractAudioRenderer;
import org.jitsi.impl.neomedia.pulseaudio.PA;
import org.jitsi.service.neomedia.BasicVolumeControl;
import org.jitsi.util.StringUtils;

public class PulseAudioRenderer
extends AbstractAudioRenderer<PulseAudioSystem> {
    private static final String PLUGIN_NAME = "PulseAudio Renderer";
    private static final boolean SOFTWARE_GAIN = true;
    private static final Format[] SUPPORTED_INPUT_FORMATS = new Format[]{new AudioFormat("LINEAR", -1.0, 16, -1, 0, 1, -1, -1.0, Format.byteArray)};
    private int channels;
    private boolean corked = true;
    private long cvolume;
    private String dev;
    private float gainControlLevel;
    private final String mediaRole;
    private long stream;
    private final PA.stream_request_cb_t writeCallback = new PA.stream_request_cb_t(){

        @Override
        public void callback(long s, int nbytes) {
            ((PulseAudioSystem)PulseAudioRenderer.this.audioSystem).signalMainloop(false);
        }
    };

    public PulseAudioRenderer() {
        this(null);
    }

    public PulseAudioRenderer(String mediaRole) {
        super(PulseAudioSystem.getPulseAudioSystem(), mediaRole == null || "phone".equals(mediaRole) ? AudioSystem.DataFlow.PLAYBACK : AudioSystem.DataFlow.NOTIFY);
        if (this.audioSystem == null) {
            throw new IllegalStateException("audioSystem");
        }
        this.mediaRole = mediaRole == null ? "phone" : mediaRole;
    }

    private void applyGain(GainControl gainControl, byte[] data, int offset, int length) {
        if (length > 0) {
            BasicVolumeControl.applyGain(gainControl, data, offset, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ((PulseAudioSystem)this.audioSystem).lockMainloop();
        try {
            long stream = this.stream;
            if (stream != 0L) {
                try {
                    this.stopWithMainloopLock();
                }
                finally {
                    long cvolume = this.cvolume;
                    this.cvolume = 0L;
                    this.stream = 0L;
                    this.corked = true;
                    this.dev = null;
                    ((PulseAudioSystem)this.audioSystem).signalMainloop(false);
                    if (cvolume != 0L) {
                        PA.cvolume_free(cvolume);
                    }
                    PA.stream_disconnect(stream);
                    PA.stream_unref(stream);
                }
            }
            super.close();
        }
        finally {
            ((PulseAudioSystem)this.audioSystem).unlockMainloop();
        }
    }

    private void cork(boolean b) {
        try {
            PulseAudioSystem.corkStream(this.stream, b);
            this.corked = b;
        }
        catch (IOException ioe) {
            throw new UndeclaredThrowableException(ioe);
        }
        finally {
            ((PulseAudioSystem)this.audioSystem).signalMainloop(false);
        }
    }

    private String getLocatorDev() {
        String locatorDev;
        MediaLocator locator = this.getLocator();
        if (locator == null) {
            locatorDev = null;
        } else {
            locatorDev = locator.getRemainder();
            if (locatorDev != null && locatorDev.length() <= 0) {
                locatorDev = null;
            }
        }
        return locatorDev;
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    @Override
    public Format[] getSupportedInputFormats() {
        return (Format[])SUPPORTED_INPUT_FORMATS.clone();
    }

    @Override
    public void open() throws ResourceUnavailableException {
        ((PulseAudioSystem)this.audioSystem).lockMainloop();
        try {
            this.openWithMainloopLock();
            super.open();
        }
        finally {
            ((PulseAudioSystem)this.audioSystem).unlockMainloop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openWithMainloopLock() throws ResourceUnavailableException {
        if (this.stream != 0L) {
            return;
        }
        AudioFormat format = (AudioFormat)this.inputFormat;
        int sampleRate = (int)format.getSampleRate();
        int channels = format.getChannels();
        int sampleSizeInBits = format.getSampleSizeInBits();
        if (sampleRate == -1 && MediaUtils.MAX_AUDIO_SAMPLE_RATE != -1.0) {
            sampleRate = (int)MediaUtils.MAX_AUDIO_SAMPLE_RATE;
        }
        if (channels == -1) {
            channels = 1;
        }
        if (sampleSizeInBits == -1) {
            sampleSizeInBits = 16;
        }
        long stream = 0L;
        RuntimeException exception = null;
        try {
            stream = ((PulseAudioSystem)this.audioSystem).createStream(sampleRate, channels, this.getClass().getName(), this.mediaRole);
            this.channels = channels;
        }
        catch (IllegalStateException ise) {
            exception = ise;
        }
        catch (RuntimeException re) {
            exception = re;
        }
        if (exception != null) {
            ResourceUnavailableException rue = new ResourceUnavailableException();
            rue.initCause((Throwable)exception);
            throw rue;
        }
        if (stream == 0L) {
            throw new ResourceUnavailableException("stream");
        }
        try {
            long attr = PA.buffer_attr_new(-1, 2 * (sampleRate / 100) * channels * (sampleSizeInBits / 8), -1, -1, -1);
            if (attr == 0L) {
                throw new ResourceUnavailableException("pa_buffer_attr_new");
            }
            try {
                Runnable stateCallback = new Runnable(){

                    @Override
                    public void run() {
                        ((PulseAudioSystem)PulseAudioRenderer.this.audioSystem).signalMainloop(false);
                    }
                };
                PA.stream_set_state_callback(stream, stateCallback);
                String dev = this.getLocatorDev();
                PA.stream_connect_playback(stream, dev, attr, 8193, 0L, 0L);
                try {
                    int state;
                    if (attr != 0L) {
                        PA.buffer_attr_free(attr);
                        attr = 0L;
                    }
                    if ((state = ((PulseAudioSystem)this.audioSystem).waitForStreamState(stream, 2)) != 2) {
                        throw new ResourceUnavailableException("stream.state");
                    }
                    PA.stream_set_write_callback(stream, this.writeCallback);
                    this.setStreamVolume(stream);
                    this.stream = stream;
                    this.dev = dev;
                }
                finally {
                    if (this.stream == 0L) {
                        PA.stream_disconnect(stream);
                    }
                }
            }
            finally {
                if (attr != 0L) {
                    PA.buffer_attr_free(attr);
                }
            }
        }
        finally {
            if (this.stream == 0L) {
                PA.stream_unref(stream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void playbackDevicePropertyChange(PropertyChangeEvent ev) {
        block6: {
            ((PulseAudioSystem)this.audioSystem).lockMainloop();
            try {
                String streamDev;
                String locatorDev;
                boolean open;
                boolean bl = open = this.stream != 0L;
                if (!open || StringUtils.isEquals(this.dev, locatorDev = this.getLocatorDev()) || StringUtils.isEquals(streamDev = PA.stream_get_device_name(this.stream), locatorDev)) break block6;
                boolean start = !this.corked;
                this.close();
                try {
                    this.open();
                }
                catch (ResourceUnavailableException rue) {
                    throw new UndeclaredThrowableException(rue);
                }
                if (start) {
                    this.start();
                }
            }
            finally {
                ((PulseAudioSystem)this.audioSystem).unlockMainloop();
            }
        }
    }

    public int process(Buffer buffer) {
        int ret;
        if (buffer.isDiscard()) {
            return 0;
        }
        if (buffer.getLength() <= 0) {
            return 0;
        }
        ((PulseAudioSystem)this.audioSystem).lockMainloop();
        try {
            ret = this.processWithMainloopLock(buffer);
        }
        finally {
            ((PulseAudioSystem)this.audioSystem).unlockMainloop();
        }
        if (ret != 1 && buffer.getLength() > 0) {
            ret |= 2;
        }
        return ret;
    }

    private int processWithMainloopLock(Buffer buffer) {
        int ret;
        if (this.stream == 0L || this.corked) {
            return 1;
        }
        int writableSize = PA.stream_writable_size(this.stream);
        if (writableSize <= 0) {
            ((PulseAudioSystem)this.audioSystem).waitMainloop();
            ret = 0;
        } else {
            int writtenSize;
            GainControl gainControl;
            byte[] data = (byte[])buffer.getData();
            int offset = buffer.getOffset();
            int length = buffer.getLength();
            if (writableSize > length) {
                writableSize = length;
            }
            if ((gainControl = this.getGainControl()) != null) {
                this.applyGain(gainControl, data, offset, writableSize);
            }
            if ((writtenSize = PA.stream_write(this.stream, data, offset, writableSize, null, 0L, 0)) < 0) {
                ret = 1;
            } else {
                ret = 0;
                buffer.setLength(length - writtenSize);
                buffer.setOffset(offset + writtenSize);
            }
        }
        return ret;
    }

    private void setStreamVolume(long stream) {
    }

    private void setStreamVolume(long stream, float level) {
        int volume = PA.sw_volume_from_linear(level * 2.0f);
        PA.cvolume_set(this.cvolume, this.channels, volume);
        long o = PA.context_set_sink_input_volume(((PulseAudioSystem)this.audioSystem).getContext(), PA.stream_get_index(stream), this.cvolume, null);
        if (o != 0L) {
            PA.operation_unref(o);
        }
    }

    public void start() {
        ((PulseAudioSystem)this.audioSystem).lockMainloop();
        try {
            if (this.stream == 0L) {
                try {
                    this.openWithMainloopLock();
                }
                catch (ResourceUnavailableException rue) {
                    throw new UndeclaredThrowableException(rue);
                }
            }
            this.cork(false);
        }
        finally {
            ((PulseAudioSystem)this.audioSystem).unlockMainloop();
        }
    }

    public void stop() {
        ((PulseAudioSystem)this.audioSystem).lockMainloop();
        try {
            this.stopWithMainloopLock();
        }
        finally {
            ((PulseAudioSystem)this.audioSystem).unlockMainloop();
        }
    }

    private void stopWithMainloopLock() {
        if (this.stream != 0L) {
            this.cork(true);
        }
    }
}

