/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.beans.editors;

import java.awt.geom.Rectangle2D;
import java.beans.PropertyEditorSupport;
import org.jdesktop.beans.editors.PropertyEditorUtil;

public class Rectangle2DPropertyEditor
extends PropertyEditorSupport {
    @Override
    public Rectangle2D getValue() {
        return (Rectangle2D.Double)super.getValue();
    }

    @Override
    public String getJavaInitializationString() {
        Rectangle2D rect = this.getValue();
        return rect == null ? "null" : "new java.awt.geom.Rectangle2D.Double(" + rect.getX() + ", " + rect.getY() + ", " + rect.getWidth() + ", " + rect.getHeight() + ")";
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        String originalParam = text;
        try {
            Rectangle2D val = (Rectangle2D)PropertyEditorUtil.createValueFromString(text, 4, Rectangle2D.Double.class, Double.TYPE);
            this.setValue(val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The input value " + originalParam + " is not formatted correctly. Please " + "try something of the form [x,y,w,h] or [x , y , w , h] or [x y w h]", e);
        }
    }

    @Override
    public String getAsText() {
        Rectangle2D rect = this.getValue();
        return rect == null ? "[]" : "[" + rect.getX() + ", " + rect.getY() + ", " + rect.getWidth() + ", " + rect.getHeight() + "]";
    }

    public static void main(String ... args) {
        Rectangle2DPropertyEditor.test("[1.5,1.2,10,35]");
        Rectangle2DPropertyEditor.test("1.5,1.2,10,35]");
        Rectangle2DPropertyEditor.test("[1.5,1.2,10,35");
        Rectangle2DPropertyEditor.test("[ 1.5 , 1.2 ,10,35]");
        Rectangle2DPropertyEditor.test(" 1.5 , 1.2 ,10,35]");
        Rectangle2DPropertyEditor.test("[ 1.5 , 1.2,10,35");
        Rectangle2DPropertyEditor.test("1.5,1.2,10,35");
        Rectangle2DPropertyEditor.test(" 1.5 , 1.2 10 35");
        Rectangle2DPropertyEditor.test("1.5 1.2, 10 35");
        Rectangle2DPropertyEditor.test("");
        Rectangle2DPropertyEditor.test("null");
        Rectangle2DPropertyEditor.test("[]");
        Rectangle2DPropertyEditor.test("[ ]");
        Rectangle2DPropertyEditor.test("[1.5 1.2 10 35]");
    }

    private static void test(String input) {
        System.out.print("Input '" + input + "'");
        try {
            Rectangle2DPropertyEditor ed = new Rectangle2DPropertyEditor();
            ed.setAsText(input);
            Rectangle2D rect = ed.getValue();
            System.out.println(" succeeded: " + rect);
        }
        catch (Exception e) {
            System.out.println(" failed: " + e.getMessage());
        }
    }
}

