/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.beans.editors;

import java.awt.Dimension;
import java.beans.PropertyEditorSupport;
import org.jdesktop.beans.editors.PropertyEditorUtil;

public class DimensionPropertyEditor
extends PropertyEditorSupport {
    @Override
    public Dimension getValue() {
        return (Dimension)super.getValue();
    }

    @Override
    public String getJavaInitializationString() {
        Dimension point = this.getValue();
        return point == null ? "null" : "new java.awt.Dimension(" + point.width + ", " + point.height + ")";
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        String originalParam = text;
        try {
            Dimension val = (Dimension)PropertyEditorUtil.createValueFromString(text, 2, Dimension.class, Integer.TYPE);
            this.setValue(val);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            throw new IllegalArgumentException("The input value " + originalParam + " is not formatted correctly. Please " + "try something of the form [w,h] or [w , h] or [w h]", ex);
        }
    }

    @Override
    public String getAsText() {
        Dimension dim = this.getValue();
        return dim == null ? "[]" : "[" + dim.width + ", " + dim.height + "]";
    }
}

