/*
 * Decompiled with CFR 0.152.
 */
package msearch.filmlisten;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Random;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import msearch.filmlisten.DatenFilmlisteUrl;
import msearch.filmlisten.ListeFilmlistenUrls;
import msearch.tool.MSConfig;
import msearch.tool.MSFunktionen;
import msearch.tool.MSLog;

public class MSFilmlistenSuchen {
    public ListeFilmlistenUrls listeFilmlistenUrls_akt = new ListeFilmlistenUrls();
    public ListeFilmlistenUrls listeFilmlistenUrls_diff = new ListeFilmlistenUrls();
    private static boolean firstSearchAkt = true;
    private static boolean firstSearchDiff = true;
    private final int UPDATE_LISTE_MAX = 10;

    public String suchenAkt(ArrayList<String> bereitsVersucht) {
        int nr;
        if (this.listeFilmlistenUrls_akt.isEmpty()) {
            this.updateURLsFilmlisten(true);
        } else if (firstSearchAkt && (nr = new Random().nextInt(10)) == 0) {
            this.updateURLsFilmlisten(true);
        }
        firstSearchAkt = false;
        String retUrl = this.listeFilmlistenUrls_akt.getRand(bereitsVersucht);
        if (bereitsVersucht != null) {
            bereitsVersucht.add(retUrl);
        }
        return retUrl;
    }

    public String suchenDiff(ArrayList<String> bereitsVersucht) {
        int nr;
        if (this.listeFilmlistenUrls_diff.isEmpty()) {
            this.updateURLsFilmlisten(false);
        } else if (firstSearchDiff && (nr = new Random().nextInt(10)) == 0) {
            this.updateURLsFilmlisten(false);
        }
        firstSearchDiff = false;
        String retUrl = this.listeFilmlistenUrls_diff.getRand(bereitsVersucht);
        if (bereitsVersucht != null) {
            bereitsVersucht.add(retUrl);
        }
        return retUrl;
    }

    public void updateURLsFilmlisten(boolean akt) {
        ListeFilmlistenUrls tmp = new ListeFilmlistenUrls();
        if (akt) {
            MSFilmlistenSuchen.getDownloadUrlsFilmlisten("http://zdfmediathk.sourceforge.net/akt.xml", tmp, MSConfig.getUserAgent(), "akt");
            if (tmp.isEmpty()) {
                MSFilmlistenSuchen.getDownloadUrlsFilmlisten("http://92.51.131.172/akt.xml", tmp, MSConfig.getUserAgent(), "akt");
            }
            if (!tmp.isEmpty()) {
                this.listeFilmlistenUrls_akt = tmp;
            } else if (this.listeFilmlistenUrls_akt.isEmpty()) {
                this.listeFilmlistenUrls_akt.add(new DatenFilmlisteUrl("http://wp11128329.server-he.de/filme/Filmliste-akt.xz", "akt"));
                this.listeFilmlistenUrls_akt.add(new DatenFilmlisteUrl("http://wp11234018.server-he.de/filme/Filmliste-akt.xz", "akt"));
                this.listeFilmlistenUrls_akt.add(new DatenFilmlisteUrl("http://mv.mynews.de/filme/Filmliste-akt.xz", "akt"));
                this.listeFilmlistenUrls_akt.add(new DatenFilmlisteUrl("http://mv.hostingkunde.de/filme/Filmliste-akt.xz", "akt"));
                this.listeFilmlistenUrls_akt.add(new DatenFilmlisteUrl("http://mv-1.df-kunde.de/filme/Filmliste-akt.xz", "akt"));
                this.listeFilmlistenUrls_akt.add(new DatenFilmlisteUrl("http://mv-2.df-kunde.de/filme/Filmliste-akt.xz", "akt"));
                this.listeFilmlistenUrls_akt.add(new DatenFilmlisteUrl("http://mv-3.df-kunde.de/filme/Filmliste-akt.xz", "akt"));
                this.listeFilmlistenUrls_akt.add(new DatenFilmlisteUrl("http://hosting1735.af906.netcup.net/filme/Filmliste-akt.xz", "akt"));
                this.listeFilmlistenUrls_akt.add(new DatenFilmlisteUrl("http://hosting1766.af915.netcup.net/filme/Filmliste-akt.xz", "akt"));
                this.listeFilmlistenUrls_akt.add(new DatenFilmlisteUrl("http://hosting1767.af915.netcup.net/filme/Filmliste-akt.xz", "akt"));
                this.listeFilmlistenUrls_akt.add(new DatenFilmlisteUrl("http://mediathek.alfahosting.org/filme/Filmliste-akt.xz", "akt"));
                this.listeFilmlistenUrls_akt.add(new DatenFilmlisteUrl("http://mediathekview.alfahosting.org/filme/Filmliste-akt.xz", "akt"));
            }
            this.listeFilmlistenUrls_akt.sort();
        } else {
            MSFilmlistenSuchen.getDownloadUrlsFilmlisten("http://zdfmediathk.sourceforge.net/diff.xml", tmp, MSConfig.getUserAgent(), "diff");
            if (tmp.isEmpty()) {
                MSFilmlistenSuchen.getDownloadUrlsFilmlisten("http://92.51.131.172/diff.xml", tmp, MSConfig.getUserAgent(), "diff");
            }
            if (!tmp.isEmpty()) {
                this.listeFilmlistenUrls_diff = tmp;
            } else if (this.listeFilmlistenUrls_diff.isEmpty()) {
                this.listeFilmlistenUrls_diff.add(new DatenFilmlisteUrl("http://wp11128329.server-he.de/filme/Filmliste-diff.xz", "diff"));
                this.listeFilmlistenUrls_diff.add(new DatenFilmlisteUrl("http://wp11234018.server-he.de/filme/Filmliste-diff.xz", "diff"));
                this.listeFilmlistenUrls_diff.add(new DatenFilmlisteUrl("http://mv.mynews.de/filme/Filmliste-diff.xz", "diff"));
                this.listeFilmlistenUrls_diff.add(new DatenFilmlisteUrl("http://mv.hostingkunde.de/filme/Filmliste-diff.xz", "diff"));
                this.listeFilmlistenUrls_diff.add(new DatenFilmlisteUrl("http://mv-1.df-kunde.de/filme/Filmliste-diff.xz", "diff"));
                this.listeFilmlistenUrls_diff.add(new DatenFilmlisteUrl("http://mv-2.df-kunde.de/filme/Filmliste-diff.xz", "diff"));
                this.listeFilmlistenUrls_diff.add(new DatenFilmlisteUrl("http://mv-3.df-kunde.de/filme/Filmliste-diff.xz", "diff"));
                this.listeFilmlistenUrls_diff.add(new DatenFilmlisteUrl("http://hosting1735.af906.netcup.net/filme/Filmliste-diff.xz", "diff"));
                this.listeFilmlistenUrls_diff.add(new DatenFilmlisteUrl("http://hosting1766.af915.netcup.net/filme/Filmliste-diff.xz", "diff"));
                this.listeFilmlistenUrls_diff.add(new DatenFilmlisteUrl("http://hosting1767.af915.netcup.net/filme/Filmliste-diff.xz", "diff"));
                this.listeFilmlistenUrls_diff.add(new DatenFilmlisteUrl("http://mediathek.alfahosting.org/filme/Filmliste-diff.xz", "diff"));
                this.listeFilmlistenUrls_diff.add(new DatenFilmlisteUrl("http://mediathekview.alfahosting.org/filme/Filmliste-diff.xz", "diff"));
            }
            this.listeFilmlistenUrls_diff.sort();
        }
        if (tmp.isEmpty()) {
            MSLog.fehlerMeldung(491203216, new String[]{"Es ist ein Fehler aufgetreten!", "Es konnten keine Updateserver zum aktualisieren der Filme", "gefunden werden."});
        }
    }

    public static void getDownloadUrlsFilmlisten(String dateiUrl, ListeFilmlistenUrls listeFilmlistenUrls, String userAgent, String art) {
        try {
            InputStreamReader inReader;
            XMLInputFactory inFactory = XMLInputFactory.newInstance();
            inFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            if (MSFunktionen.istUrl(dateiUrl)) {
                int timeout = 20000;
                URLConnection conn = new URL(dateiUrl).openConnection();
                conn.setRequestProperty("User-Agent", userAgent);
                conn.setReadTimeout(timeout);
                conn.setConnectTimeout(timeout);
                inReader = new InputStreamReader(conn.getInputStream(), "UTF-8");
            } else {
                File f = new File(dateiUrl);
                if (!f.exists()) {
                    return;
                }
                inReader = new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8");
            }
            XMLStreamReader parser = inFactory.createXMLStreamReader(inReader);
            while (parser.hasNext()) {
                String parsername;
                int event = parser.next();
                if (event != 1 || !(parsername = parser.getLocalName()).equals("Server")) continue;
                MSFilmlistenSuchen.getServer(parser, listeFilmlistenUrls, art);
            }
        }
        catch (Exception ex) {
            MSLog.fehlerMeldung(821069874, ex, "Die URL-Filmlisten konnte nicht geladen werden: " + dateiUrl);
        }
    }

    private static void getServer(XMLStreamReader parser, ListeFilmlistenUrls listeFilmlistenUrls, String art) {
        String serverUrl = "";
        String prio = "";
        try {
            while (parser.hasNext()) {
                int event = parser.next();
                if (event == 1) {
                    switch (parser.getLocalName()) {
                        case "URL": {
                            serverUrl = parser.getElementText();
                            break;
                        }
                        case "Prio": {
                            prio = parser.getElementText();
                        }
                    }
                }
                if (event != 2 || !parser.getLocalName().equals("Server")) continue;
                if (!serverUrl.equals("")) {
                    if (prio.equals("")) {
                        prio = "1";
                    }
                    listeFilmlistenUrls.addWithCheck(new DatenFilmlisteUrl(serverUrl, prio, art));
                }
                break;
            }
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }
}

