/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt.export;

import java.awt.Dimension;
import java.io.File;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.xmind.verify.ui.VerifyWizardPageWithPro20141031;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;
import org.xmind.core.ITopic;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.GEF;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.ui.gantt.GanttMessages;
import org.xmind.ui.gantt.GanttPlugin;
import org.xmind.ui.gantt.export.DateInfoPickerViewer2;
import org.xmind.ui.gantt.export.ExportConstants;
import org.xmind.ui.gantt.export.GanttImageCreator;
import org.xmind.ui.gantt.export.GanttPdfExporter;
import org.xmind.ui.gantt2.viewer.GanttViewer;
import org.xmind.ui.gantt2.viewer.TaskTreeHeaderViewer;
import org.xmind.ui.gantt2.viewer.TaskTreeViewer;
import org.xmind.ui.gantt2.viewer.TimelineModel;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.dialogs.DialogUtils;
import org.xmind.ui.internal.exports.vector.pdf.PDFMapConstants;
import org.xmind.ui.internal.print.multipage.DialogSettingsDecorator;
import org.xmind.ui.internal.print.multipage.MultipageImagePreviewViewer;
import org.xmind.ui.internal.taskinfo.DateInfo;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;
import org.xmind.ui.internal.wizards.UncompletablePage;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.Logger;
import org.xmind.ui.util.MindMapUtils;
import org.xmind.ui.util.UnitConvertor;
import org.xmind.ui.wizards.AbstractExportPage;
import org.xmind.ui.wizards.AbstractExportWizard;

public class ExportToPdfWizard
extends AbstractExportWizard {
    private static final String PDF_EXPORT_PAGE_NAME = "pdfExportPage";
    private static final String FILE_EXT = ".pdf";
    private static final long PREVIEW_DELAY = 1000L;
    private static final Point PAGE_DPI = new Point(72, 72);
    private GanttViewer ganttViewer;
    private IDialogSettings settings;
    private PdfExportPage page;

    public ExportToPdfWizard(GanttViewer ganttViewer) {
        this.ganttViewer = ganttViewer;
        this.setWindowTitle(GanttMessages.ExportWizard_Window_Title);
        this.setDefaultPageImageDescriptor(MindMapUI.getImages().getWizBan("export_wiz.png"));
        this.setDialogSettings(GanttPlugin.getDefault().getDialogSettings());
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        if (this.ganttViewer != null) {
            this.addPage((IWizardPage)new VerifyWizardPageWithPro20141031("ExportGanttToPDF", GanttMessages.ExportToPdfWizard_Exporting_Gantt_To_PDF_Action));
            this.page = new PdfExportPage(this.ganttViewer);
            this.addPage((IWizardPage)this.page);
        } else {
            UncompletablePage errorPage = new UncompletablePage(WizardMessages.NoContentPage_title, WizardMessages.NoContentPage_message);
            errorPage.setDescription(WizardMessages.NoContentPage_description);
            this.addPage((IWizardPage)errorPage);
        }
    }

    public boolean performFinish() {
        if (this.page.getPreviewState() == PreviewState.Error && !MessageDialog.openConfirm((Shell)this.getShell(), (String)GanttMessages.ExportWizard_Confirm_text, (String)GanttMessages.ExportWizard_Confirm_message)) {
            return false;
        }
        if (!this.isLegalPath(this.getTargetPath())) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)WizardMessages.ExportPage_FindFileFail_title, (String)WizardMessages.ExportPage_FindFileFail_message);
            return false;
        }
        if (this.page != null) {
            this.page.cancel();
        }
        if (!this.hasTargetPath()) {
            return false;
        }
        if (!this.isExtensionCompatible(FileUtils.getExtension((String)this.getTargetPath()), FileUtils.getExtension((String)this.getTargetPath()))) {
            String fileName = new File(this.getTargetPath()).getName();
            String formatName = this.getFormatName();
            String messages = NLS.bind((String)WizardMessages.Export_UncompatibleFormat_message, (Object)fileName, (Object)formatName);
            if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)WizardMessages.Export_UncompatibleFormat_title, (String)messages)) {
                return false;
            }
        }
        if (!this.isOverwriteWithoutPrompt() && new File(this.getTargetPath()).exists() && !DialogUtils.confirmOverwrite((Shell)this.getShell(), (String)this.getTargetPath())) {
            return false;
        }
        return this.doExport();
    }

    private boolean isLegalPath(String targetPath) {
        boolean isLagel = true;
        String path = targetPath.substring(0, targetPath.lastIndexOf(File.separator));
        File directory = new File(path);
        if (!directory.exists() || !directory.isDirectory()) {
            isLagel = false;
            return isLagel;
        }
        String fileName = targetPath.substring(targetPath.lastIndexOf(File.separator) + 1);
        String[] letters = new String[]{"/", ":", "\\", "*", "?", "\"", "<", ">", "|"};
        int i = 0;
        while (i < letters.length) {
            if (fileName.indexOf(letters[i]) != -1) {
                isLagel = false;
                return isLagel;
            }
            ++i;
        }
        return isLagel;
    }

    /*
     * Unable to fully structure code
     */
    private boolean doExport() {
        display = Display.getCurrent();
        parentShell = this.findParentShell(display);
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    display.syncExec(new Runnable(){

                        public void run() {
                            try {
                                ExportToPdfWizard.this.doExport(monitor, display, parentShell);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                ExportToPdfWizard.this.deleteTargetFile();
                                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)GanttMessages.ExportWizard_Error_text, (String)GanttMessages.ExportWizard_Error_message);
                            }
                        }
                    });
                }
            });
            return true;
        }
        catch (Throwable e) {
            if (!(e instanceof InterruptedException) && !(e instanceof InterruptedIOException)) ** GOTO lbl11
            return false;
        }
        while ((t = ((InvocationTargetException)e).getCause()) != null) {
            e = t;
lbl11:
            // 2 sources

            if (e instanceof InvocationTargetException) continue;
        }
        ex = e;
        display.asyncExec(new Runnable((Throwable)ex){
            private final /* synthetic */ Throwable val$ex;
            {
                this.val$ex = throwable;
            }

            public void run() {
                ExportToPdfWizard.this.handleExportException(this.val$ex);
            }
        });
        return false;
    }

    protected void doExport(IProgressMonitor monitor, Display display, Shell parentShell) throws InvocationTargetException, InterruptedException {
        new GanttPdfExporter(this.ganttViewer, this.getTargetPath(), this.getDialogSettings(), display).export();
        if (!monitor.isCanceled()) {
            this.launchTargetFile(true, monitor, display, parentShell);
        }
    }

    private void deleteTargetFile() {
        String path = this.getTargetPath();
        File file = new File(path);
        file.delete();
    }

    private Shell findParentShell(Display display) {
        Shell parentShell;
        Composite shellParent;
        Shell shell = this.getContainer().getShell();
        if (shell != null && (shellParent = shell.getParent()) instanceof Shell && !(parentShell = (Shell)shellParent).isDisposed() && parentShell.getDisplay() == display) {
            return parentShell;
        }
        return null;
    }

    protected String getFormatName() {
        return GanttMessages.ExportWizard_FileFormat_PDF;
    }

    protected boolean isExtensionCompatible(String path, String extension) {
        return FILE_EXT.equals(extension);
    }

    private void handleExportException(Throwable e) {
        Logger.log((Throwable)e, (String)NLS.bind((String)WizardMessages.Export_FailedWhenExport, (Object)this.getFormatName()));
        this.page.setErrorMessage(e.getLocalizedMessage());
    }

    private ITopic getCentralTopic() {
        return (ITopic)this.ganttViewer.getInput();
    }

    protected String getSuggestedFileName() {
        String fileName = this.getCentralTopic().getTitleText();
        String replacedFileName = MindMapUtils.trimFileName((String)fileName);
        return String.valueOf(replacedFileName) + FILE_EXT;
    }

    public IDialogSettings getDialogSettings() {
        if (this.settings == null) {
            this.settings = new DialogSettingsDecorator(super.getDialogSettings());
        }
        return this.settings;
    }

    private static int find(Object[] array, Object obj) {
        if (obj != null) {
            int i = 0;
            while (i < array.length) {
                if (array[i].equals(obj)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private Rectangle getImageBorderBounds() {
        int usefulPerPageHeightByRatio;
        int lines;
        int heightByRatio;
        double ratio;
        boolean fullWidth;
        TaskTreeHeaderViewer headerViewer = this.ganttViewer.getTaskTreeHeaderViewer();
        RangeModel rangeModel = headerViewer.getViewport().getHorizontalRangeModel();
        int value = rangeModel.getValue() + rangeModel.getExtent();
        int leftWidth = ExportConstants.round(value, this.ganttViewer.getWidthsSupport());
        int headerHeight = headerViewer.getCanvas().getSize().y;
        TaskTreeViewer taskTreeViewer = this.ganttViewer.getTaskTreeViewer();
        int contentHeight = ((FreeformLayer)taskTreeViewer.getLayer((Object)GEF.LAYER_CONTENTS)).getFreeformExtent().height;
        TimelineModel timelineModel = this.ganttViewer.getEditDomain().getTimelineModel();
        long startTime = this.settings.getLong("startTime");
        long endTime = this.settings.getLong("endTime");
        int rightWidth = 0;
        if (startTime != endTime) {
            rightWidth = timelineModel.getPixelsFromMillis(endTime - startTime) + 100;
        }
        int sourceWidth = leftWidth + rightWidth;
        String orientation1 = this.settings.get("Orientation");
        java.awt.Insets margins = PDFMapConstants.getMargins((String)PDFMapConstants.PageMargins.Small.name(), (String)orientation1);
        int leftMarginPixel = margins.left;
        int rightMarginPixel = margins.right;
        int topMarginPixel = margins.top;
        int bottomMarginPixel = margins.bottom;
        int orientation = this.getInteger("orientation", 2);
        int perPageWidth = orientation == 2 ? 1403 : 992;
        int usefulPerPageWidth = perPageWidth - leftMarginPixel - rightMarginPixel;
        int perPageHeight = orientation == 1 ? 1403 : 992;
        int usefulPerPageHeight = perPageHeight - topMarginPixel - bottomMarginPixel;
        int widthPages = this.getInteger("widthPages", 1);
        int heightPages = this.getInteger("heightPages", 1);
        boolean isAspectRatio = this.settings.getBoolean("aspectRatioLocked");
        boolean bl = fullWidth = !this.settings.getBoolean("fillHeight");
        if (!isAspectRatio) {
            double fillWidthratio = (double)usefulPerPageWidth * (double)widthPages / (double)sourceWidth;
            double fillHeightRatio = (double)usefulPerPageHeight * (double)heightPages / (double)(contentHeight + heightPages * headerHeight);
            int heightByRatio2 = (int)((double)usefulPerPageHeight / fillHeightRatio);
            int lines2 = (heightByRatio2 - headerHeight) / ExportConstants.ITEM_HEIGHT;
            lines2 = (heightByRatio2 - headerHeight) % ExportConstants.ITEM_HEIGHT == 0 ? lines2 : lines2 + 1;
            int usefulPerPageHeightByRatio2 = headerHeight + lines2 * ExportConstants.ITEM_HEIGHT;
            fillHeightRatio = (double)usefulPerPageHeight / (double)usefulPerPageHeightByRatio2;
            fullWidth = fillWidthratio <= fillHeightRatio;
        }
        int usefulWidthPages = widthPages;
        int usefulHeightPages = heightPages;
        if (fullWidth) {
            ratio = (double)usefulPerPageWidth * (double)widthPages / (double)sourceWidth;
            heightByRatio = (int)((double)usefulPerPageHeight / ratio);
            lines = (heightByRatio - headerHeight) / ExportConstants.ITEM_HEIGHT;
            usefulPerPageHeightByRatio = headerHeight + lines * ExportConstants.ITEM_HEIGHT;
            usefulHeightPages = contentHeight / (usefulPerPageHeightByRatio - headerHeight);
            usefulHeightPages = contentHeight % (usefulPerPageHeightByRatio - headerHeight) == 0 ? usefulHeightPages : usefulHeightPages + 1;
        } else {
            ratio = (double)usefulPerPageHeight * (double)heightPages / (double)(contentHeight + heightPages * headerHeight);
            heightByRatio = (int)((double)usefulPerPageHeight / ratio);
            lines = (heightByRatio - headerHeight) / ExportConstants.ITEM_HEIGHT;
            lines = (heightByRatio - headerHeight) % ExportConstants.ITEM_HEIGHT == 0 ? lines : lines + 1;
            usefulPerPageHeightByRatio = headerHeight + lines * ExportConstants.ITEM_HEIGHT;
            ratio = (double)usefulPerPageHeight / (double)usefulPerPageHeightByRatio;
            usefulWidthPages = sourceWidth / (int)((double)usefulPerPageWidth / ratio);
            usefulWidthPages = sourceWidth % (int)((double)usefulPerPageWidth / ratio) == 0 ? usefulWidthPages : usefulWidthPages + 1;
        }
        int usefulPerPageWidthByRatio = (int)((double)usefulPerPageWidth / ratio);
        int leftMarginByRatio = (int)((double)leftMarginPixel / ratio);
        int topMarginByRation = (int)((double)topMarginPixel / ratio);
        return new Rectangle(leftMarginByRatio, topMarginByRation, usefulPerPageWidthByRatio, usefulPerPageHeightByRatio);
    }

    private int getInteger(String key, int defaultValue) {
        try {
            return this.getDialogSettings().getInt(key);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PdfExportPage
    extends AbstractExportPage {
        private GanttViewer ganttViewer;
        private PreviewImageCreator previewImageCreator;
        private GeneratePreviewJob generatePreviewJob;
        private Combo pageSizeCombo;
        private Button allTasksRadio;
        private Button tasksBetweenRadio;
        private DateInfoPickerViewer2 startDatePicker;
        private DateInfoPickerViewer2 endDatePicker;
        private Calendar minTime;
        private Calendar maxTime;
        private Button landscapeRadio;
        private Button portraitRadio;
        private Spinner widthPages;
        private Spinner heightPages;
        private Button pageLockCheck;
        private boolean updating;
        private MultipageImagePreviewViewer viewer;
        private boolean isRefreshingPages;
        private PreviewState previewState;

        private PdfExportPage(GanttViewer ganttViewer) {
            super(ExportToPdfWizard.PDF_EXPORT_PAGE_NAME, GanttMessages.ExportWizard_GeneratePdf_text, null);
            this.updating = false;
            this.isRefreshingPages = false;
            this.setDescription(GanttMessages.ExportWizard_ExportToPdf_message);
            this.ganttViewer = ganttViewer;
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 7;
            layout.marginWidth = 7;
            container.setLayout((Layout)layout);
            container.setLayoutData((Object)new GridData(1808));
            this.setControl((Control)container);
            this.createPreviewControl(container);
            this.createSettingsPart(container);
            this.update(null);
        }

        private void createSettingsPart(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridData layoutData = new GridData(4, 4, true, true);
            composite.setLayoutData((Object)layoutData);
            GridLayout layout = new GridLayout(2, false);
            layout.horizontalSpacing = 15;
            layout.verticalSpacing = 25;
            composite.setLayout((Layout)layout);
            this.createPageSizeControls(composite);
            this.createTimeRangeSection(composite);
            this.createOrientationSection(composite);
            this.createPagesSection(composite);
            this.createFileGroup(composite);
        }

        private void createPageSizeControls(Composite parent) {
            Label label = new Label(parent, 0);
            GridData layoutData = new GridData(131072, 128, false, false);
            layoutData.verticalIndent = 4;
            label.setLayoutData((Object)layoutData);
            label.setFont(FontUtils.getBold((Font)FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)0)));
            label.setText(GanttMessages.ExportWizard_PageSize);
            this.pageSizeCombo = new Combo(parent, 12);
            GridData gridData = new GridData(4, 0x1000000, true, false);
            gridData.widthHint = 250;
            this.pageSizeCombo.setLayoutData((Object)gridData);
            this.pageSizeCombo.setItems(this.getPageSizeDescriptions());
            this.pageSizeCombo.select(this.getPageSizeSelection());
            this.hookWidget((Widget)this.pageSizeCombo, 13);
        }

        private void createTimeRangeSection(Composite parent) {
            this.initTimeRange();
            Label label = new Label(parent, 0);
            label.setLayoutData((Object)new GridData(131072, 128, false, false));
            label.setFont(FontUtils.getBold((Font)FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)0)));
            label.setText(GanttMessages.ExportWizard_DateRange);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(4, 128, true, false));
            this.allTasksRadio = new Button(composite, 16);
            this.allTasksRadio.setText(GanttMessages.ExportWizard_AllTasks);
            this.allTasksRadio.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.hookWidget((Widget)this.allTasksRadio, 13);
            this.createTaskBetweenOption(composite);
        }

        private void createOrientationSection(Composite parent) {
            Label label = new Label(parent, 0);
            label.setLayoutData((Object)new GridData(131072, 128, false, false));
            label.setFont(FontUtils.getBold((Font)FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)0)));
            label.setText(GanttMessages.ExportWizard_Orientation);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.horizontalSpacing = 20;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(16384, 128, true, false));
            this.landscapeRadio = new Button(composite, 16);
            this.landscapeRadio.setData((Object)2);
            this.landscapeRadio.setText(DialogMessages.PageSetupDialog_Landscape);
            this.landscapeRadio.setLayoutData((Object)new GridData(4, 4, true, false));
            this.portraitRadio = new Button(composite, 16);
            this.portraitRadio.setData((Object)1);
            this.portraitRadio.setText(DialogMessages.PageSetupDialog_Portrait);
            this.portraitRadio.setLayoutData((Object)new GridData(4, 4, true, false));
            this.hookWidget((Widget)this.portraitRadio, 13);
        }

        private void createPagesSection(Composite parent) {
            Label label = new Label(parent, 0);
            GridData gridData = new GridData(131072, 128, false, false);
            gridData.verticalIndent = 3;
            label.setLayoutData((Object)gridData);
            label.setFont(FontUtils.getBold((Font)label.getFont()));
            label.setText(GanttMessages.ExportWizard_Pages);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.horizontalSpacing = 10;
            layout.verticalSpacing = 15;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(16384, 128, false, false));
            this.widthPages = this.createChangePageSection(composite, GanttMessages.ExportWizard_Horizontal);
            this.heightPages = this.createChangePageSection(composite, GanttMessages.ExportWizard_Vertical);
            this.pageLockCheck = new Button(composite, 32);
            this.pageLockCheck.setText(GanttMessages.ExportWizard_OptimalPagingEffect);
            GridData layoutData = new GridData(16384, 4, false, false);
            layoutData.horizontalSpan = 2;
            this.pageLockCheck.setLayoutData((Object)layoutData);
            this.hookWidget((Widget)this.pageLockCheck, 13);
            boolean isLinux = Util.isLinux();
            if (isLinux) {
                layout.numColumns = 1;
                layoutData.horizontalSpan = 1;
            }
        }

        private void createFileGroup(Composite parent) {
            Control fileGroup = this.createFileControls(parent);
            GridData layoutData = new GridData(4, 4, true, false);
            layoutData.horizontalSpan = 2;
            layoutData.verticalIndent = 30;
            fileGroup.setLayoutData((Object)layoutData);
        }

        private int getPageSizeSelection() {
            String sizeStr = this.getDialogSettings().get("PageSize");
            PDFMapConstants.PageSize selection = sizeStr == null ? PDFMapConstants.PageSize.A4 : PDFMapConstants.PageSize.valueOf((String)sizeStr);
            return ExportToPdfWizard.find(PDFMapConstants.PageSize.values(), selection);
        }

        private String[] getPageSizeDescriptions() {
            PDFMapConstants.PageSize[] sizes = PDFMapConstants.PageSize.values();
            String[] descriptions = new String[sizes.length];
            int i = 0;
            while (i < sizes.length) {
                descriptions[i] = this.getPageSizeDescription(sizes[i]);
                ++i;
            }
            return descriptions;
        }

        private String getPageSizeDescription(PDFMapConstants.PageSize pageSize) {
            PrecisionPoint s = UnitConvertor.dots2mm((Point)new Point(pageSize.getWidth(), pageSize.getHeight()), (Point)PAGE_DPI);
            return String.format("%s (%.1f mm x %.1f mm)", pageSize.getName(), Math.ceil(s.x * 10.0) / 10.0, Math.ceil(s.y * 10.0) / 10.0);
        }

        private void initTimeRange() {
            ITopic rootTopic = this.getCentralTopic();
            Date earliestDate = TaskInfoUtils.getEarliestStartDate((ITopic)rootTopic);
            if (earliestDate == null) {
                earliestDate = this.ganttViewer.getEditDomain().getTimelineModel().getOriginDate().getTime();
            }
            this.minTime = Calendar.getInstance();
            this.minTime.setTime(earliestDate);
            Date latestDate = TaskInfoUtils.getLatestEndDate((ITopic)rootTopic);
            if (latestDate == null) {
                latestDate = this.ganttViewer.getEditDomain().getTimelineModel().getOriginDate().getTime();
            }
            this.maxTime = Calendar.getInstance();
            this.maxTime.setTime(latestDate);
        }

        private ITopic getCentralTopic() {
            return (ITopic)this.ganttViewer.getInput();
        }

        private void createTaskBetweenOption(Composite parent) {
            this.tasksBetweenRadio = new Button(parent, 16);
            this.tasksBetweenRadio.setText(GanttMessages.ExportWizard_TasksBetween);
            this.tasksBetweenRadio.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.createChangeDateSection(parent);
        }

        private void createChangeDateSection(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            GridData gridData = new GridData(4, 0x1000000, true, false);
            gridData.horizontalIndent = 5;
            composite.setLayoutData((Object)gridData);
            boolean isLinux = Util.isLinux();
            if (isLinux) {
                layout.numColumns = 2;
            }
            this.startDatePicker = this.createDatePicker(composite);
            GridData gridData2 = new GridData(16384, 0x1000000, false, false);
            this.startDatePicker.getControl().setLayoutData((Object)gridData2);
            this.startDatePicker.setSelection((ISelection)new StructuredSelection((Object)new DateInfo(this.minTime, false)));
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            label.setText(GanttMessages.ExportWizard_and);
            this.endDatePicker = this.createDatePicker(composite);
            GridData gridData3 = new GridData(16384, 0x1000000, true, false);
            this.endDatePicker.getControl().setLayoutData((Object)gridData3);
            this.endDatePicker.setSelection((ISelection)new StructuredSelection((Object)new DateInfo(this.maxTime, false)));
            this.startDatePicker.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Calendar selectedTime = PdfExportPage.this.startDatePicker.getSelectedDate();
                    Calendar minTime = PdfExportPage.this.startDatePicker.getMinTime();
                    Calendar maxTime = PdfExportPage.this.startDatePicker.getMaxTime();
                    if (!selectedTime.before(minTime) && !selectedTime.after(maxTime)) {
                        PdfExportPage.this.getDialogSettings().put("startTime", PdfExportPage.this.startDatePicker.getSelectedDate().getTimeInMillis());
                        if (PdfExportPage.this.previewImageCreator != null) {
                            PdfExportPage.this.previewImageCreator.setHeaderImageValid(false);
                            PdfExportPage.this.previewImageCreator.setContentImageValid(false);
                        }
                        PdfExportPage.this.endDatePicker.setMinTime(PdfExportPage.this.startDatePicker.getSelectedDate());
                        PdfExportPage.this.refreshWidthHeightPages();
                        PdfExportPage.this.generatePreview(true);
                    }
                }
            });
            this.endDatePicker.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Calendar selectedTime = PdfExportPage.this.endDatePicker.getSelectedDate();
                    Calendar minTime = PdfExportPage.this.endDatePicker.getMinTime();
                    Calendar maxTime = PdfExportPage.this.endDatePicker.getMaxTime();
                    if (!selectedTime.before(minTime) && !selectedTime.after(maxTime)) {
                        PdfExportPage.this.getDialogSettings().put("endTime", PdfExportPage.this.endDatePicker.getSelectedDate().getTimeInMillis());
                        if (PdfExportPage.this.previewImageCreator != null) {
                            PdfExportPage.this.previewImageCreator.setHeaderImageValid(false);
                            PdfExportPage.this.previewImageCreator.setContentImageValid(false);
                        }
                        PdfExportPage.this.startDatePicker.setMaxTime(PdfExportPage.this.endDatePicker.getSelectedDate());
                        PdfExportPage.this.refreshWidthHeightPages();
                        PdfExportPage.this.generatePreview(true);
                    }
                }
            });
        }

        private DateInfoPickerViewer2 createDatePicker(Composite parent) {
            final DateInfoPickerViewer2 datePicker = new DateInfoPickerViewer2(parent);
            datePicker.setMinTime(this.minTime);
            datePicker.setMaxTime(this.maxTime);
            datePicker.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Calendar selectedTime = datePicker.getSelectedDate();
                    final Calendar minTime = datePicker.getMinTime();
                    final Calendar maxTime = datePicker.getMaxTime();
                    if (selectedTime.before(minTime)) {
                        Display.getCurrent().asyncExec(new Runnable(){

                            public void run() {
                                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)GanttMessages.ExportWizard_InvalidValue_text, (String)GanttMessages.ExportWizard_InvalidSmall_message);
                                datePicker.setSelection((ISelection)new StructuredSelection((Object)new DateInfo(minTime, false)));
                            }
                        });
                    } else if (selectedTime.after(maxTime)) {
                        Display.getCurrent().asyncExec(new Runnable(){

                            public void run() {
                                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)GanttMessages.ExportWizard_InvalidValue_text, (String)GanttMessages.ExportWizard_InvalidBig_message);
                                datePicker.setSelection((ISelection)new StructuredSelection((Object)new DateInfo(maxTime, false)));
                            }
                        });
                    }
                }
            });
            return datePicker;
        }

        private Spinner createChangePageSection(Composite parent, String text) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(16384, 4, false, true));
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            composite.setLayout((Layout)layout);
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            label.setText(text);
            Spinner spinner = new Spinner(composite, 2048);
            spinner.setDigits(0);
            spinner.setMinimum(1);
            spinner.setMaximum(100);
            spinner.setSelection(1);
            spinner.setIncrement(1);
            spinner.setPageIncrement(2);
            GridData gridData = new GridData(16384, 0x1000000, false, false);
            spinner.setLayoutData((Object)gridData);
            this.hookWidget((Widget)spinner, 24);
            return spinner;
        }

        private void createPreviewControl(Composite parent) {
            this.viewer = new MultipageImagePreviewViewer(true);
            this.viewer.createControl(parent);
            GridData layoutData = new GridData(16384, 128, false, false);
            layoutData.verticalIndent = 10;
            this.viewer.getControl().setLayoutData((Object)layoutData);
            this.viewer.getControl().setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)8));
            this.viewer.setBorderVisible(false);
        }

        private void generatePreview(boolean hasDelay) {
            if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
                this.updateViewer(null, PreviewState.Generating, false, null);
                this.viewer.setFeedbackVisible(false);
            }
            this.disposePreview();
            Display display = Display.getCurrent();
            this.generatePreviewJob = new GeneratePreviewJob(display);
            if (this.getDialogSettings() instanceof DialogSettingsDecorator) {
                ((DialogSettingsDecorator)this.getDialogSettings()).setDirty(false);
            }
            if (hasDelay) {
                this.generatePreviewJob.schedule(1000L);
            } else {
                this.generatePreviewJob.schedule();
            }
        }

        protected void handleWidgetEvent(Event event) {
            if (event.widget == this.pageSizeCombo) {
                PDFMapConstants.PageSize size = PDFMapConstants.PageSize.values()[this.pageSizeCombo.getSelectionIndex()];
                this.setProperty("PageSize", size.toString());
            } else if (event.widget == this.allTasksRadio || event.widget == this.tasksBetweenRadio) {
                this.setProperty("timeRange", this.tasksBetweenRadio.getSelection());
            } else if (event.widget == this.landscapeRadio || event.widget == this.portraitRadio) {
                this.getDialogSettings().put("Orientation", this.landscapeRadio.getSelection() ? PDFMapConstants.Orientation.Landscape.name() : PDFMapConstants.Orientation.Portrait.name());
                this.refreshWidthHeightPages();
                this.update("Orientation");
            } else if (event.widget == this.widthPages) {
                boolean locked = this.getBoolean("aspectRatioLocked");
                if (!this.isRefreshingPages) {
                    if (locked) {
                        this.isRefreshingPages = true;
                        this.getDialogSettings().put("fillHeight", false);
                        int heightPageNumber = this.getHeightPageByWidth(this.widthPages.getSelection());
                        this.heightPages.setSelection(heightPageNumber);
                        this.setProperty("widthPages", this.widthPages.getSelection());
                        this.isRefreshingPages = false;
                    } else {
                        this.getDialogSettings().put("fillHeight", false);
                        this.setProperty("widthPages", this.widthPages.getSelection());
                    }
                } else {
                    this.getDialogSettings().put("widthPages", this.widthPages.getSelection());
                }
            } else if (event.widget == this.heightPages) {
                boolean locked = this.getBoolean("aspectRatioLocked");
                if (!this.isRefreshingPages) {
                    if (locked) {
                        this.isRefreshingPages = true;
                        this.getDialogSettings().put("fillHeight", true);
                        this.widthPages.setSelection(this.getWidthPageByHeight(this.heightPages.getSelection()));
                        this.setProperty("heightPages", this.heightPages.getSelection());
                        this.isRefreshingPages = false;
                    } else {
                        this.getDialogSettings().put("fillHeight", true);
                        this.setProperty("heightPages", this.heightPages.getSelection());
                    }
                } else {
                    this.getDialogSettings().put("heightPages", this.heightPages.getSelection());
                }
            } else if (event.widget == this.pageLockCheck) {
                boolean locked = this.pageLockCheck.getSelection();
                this.getDialogSettings().put("aspectRatioLocked", locked);
                this.refreshWidthHeightPages();
                this.update("aspectRatioLocked");
            } else {
                super.handleWidgetEvent(event);
            }
        }

        private void refreshWidthHeightPages() {
            boolean locked = this.getBoolean("aspectRatioLocked");
            if (locked) {
                boolean fillWidth = !this.getDialogSettings().getBoolean("fillHeight");
                this.isRefreshingPages = true;
                if (fillWidth) {
                    this.heightPages.setSelection(this.getHeightPageByWidth(this.widthPages.getSelection()));
                } else {
                    this.widthPages.setSelection(this.getWidthPageByHeight(this.heightPages.getSelection()));
                }
                this.isRefreshingPages = false;
            }
        }

        private void update(String key) {
            if (this.updating) {
                return;
            }
            if (key == "fillHeight") {
                return;
            }
            boolean pageSizeChanged = key == null || "PageSize".equals(key);
            boolean timeRangeRadioChanged = key == null || "timeRange".equals(key);
            boolean orientationChanged = key == null || "Orientation".equals(key);
            boolean widthPagesChanged = key == null || "widthPages".equals(key);
            boolean heightPagesChanged = key == null || "heightPages".equals(key);
            boolean buttonLockChanged = key == null || "aspectRatioLocked".equals(key);
            this.updating = true;
            if (timeRangeRadioChanged) {
                this.updateTimeRange();
            }
            if (orientationChanged) {
                this.updateOrientation();
                this.updateBackgroundImage();
            }
            if (buttonLockChanged) {
                boolean isButtonLocked = this.getBoolean("aspectRatioLocked");
                this.pageLockCheck.setSelection(isButtonLocked);
            }
            if (key == null) {
                this.initWidthHeightPages();
            }
            if (key == null) {
                this.generatePreview(false);
            } else if (pageSizeChanged || timeRangeRadioChanged || orientationChanged || widthPagesChanged || heightPagesChanged || buttonLockChanged) {
                this.generatePreview(true);
            }
            this.updating = false;
        }

        private void updateBackgroundImage() {
            String orientation = this.getString("Orientation", PDFMapConstants.Orientation.Landscape.name());
            boolean landscape = orientation == PDFMapConstants.Orientation.Landscape.name();
            int prefWidth = landscape ? 289 : 204;
            int prefHeight = landscape ? 204 : 289;
            this.viewer.updateBackgroundImageComposite(true, landscape);
            this.viewer.updateBackgroundImage();
            this.viewer.setPrefSize(new org.eclipse.swt.graphics.Point(prefWidth, prefHeight));
            this.viewer.initPreviewImageRatio();
        }

        private void updateTimeRange() {
            boolean tasksBetween = this.getBoolean("timeRange");
            this.allTasksRadio.setSelection(!tasksBetween);
            this.tasksBetweenRadio.setSelection(tasksBetween);
            if (!tasksBetween) {
                this.getDialogSettings().put("startTime", this.minTime.getTimeInMillis());
                this.getDialogSettings().put("endTime", this.maxTime.getTimeInMillis());
                this.startDatePicker.setEnabled(false);
                this.endDatePicker.setEnabled(false);
            } else {
                this.getDialogSettings().put("startTime", this.startDatePicker.getSelectedDate().getTimeInMillis());
                this.getDialogSettings().put("endTime", this.endDatePicker.getSelectedDate().getTimeInMillis());
                this.startDatePicker.setEnabled(true);
                this.endDatePicker.setEnabled(true);
            }
            if (this.previewImageCreator != null) {
                this.previewImageCreator.setHeaderImageValid(false);
                this.previewImageCreator.setContentImageValid(false);
            }
            this.refreshWidthHeightPages();
        }

        private void updateOrientation() {
            String orientation = this.getString("Orientation", PDFMapConstants.Orientation.Landscape.name());
            boolean landscape = orientation == PDFMapConstants.Orientation.Landscape.name();
            this.landscapeRadio.setSelection(landscape);
            this.portraitRadio.setSelection(!landscape);
        }

        private void initWidthHeightPages() {
            boolean locked = this.getBoolean("aspectRatioLocked");
            boolean fillWidth = !this.getBoolean("fillHeight");
            int widthPageNumber = this.getInteger("widthPages", 1);
            int heightPageNumber = this.getInteger("heightPages", 1);
            if (locked) {
                if (fillWidth) {
                    this.widthPages.setSelection(widthPageNumber);
                } else {
                    this.heightPages.setSelection(heightPageNumber);
                }
            } else {
                this.widthPages.setSelection(widthPageNumber);
                this.heightPages.setSelection(heightPageNumber);
            }
            this.widthPages.setMaximum(this.getMaxWidthPages());
            this.heightPages.setMaximum(this.getMaxHeightPages());
        }

        private void setProperty(String key, int value) {
            this.getDialogSettings().put(key, value);
            this.update(key);
        }

        private void setProperty(String key, boolean value) {
            this.getDialogSettings().put(key, value);
            this.update(key);
        }

        private void setProperty(String key, String value) {
            this.getDialogSettings().put(key, value);
            this.update(key);
        }

        private int getInteger(String key, int defaultValue) {
            try {
                return this.getDialogSettings().getInt(key);
            }
            catch (NumberFormatException numberFormatException) {
                return defaultValue;
            }
        }

        private boolean getBoolean(String key) {
            return this.getDialogSettings().getBoolean(key);
        }

        private String getString(String key, String defaultValue) {
            String value = this.getDialogSettings().get(key);
            return value != null ? value : defaultValue;
        }

        private void updateViewer(Image image, PreviewState state, boolean largeImage, Point origin) {
            this.previewState = state;
            if (this.viewer == null || this.viewer.getControl().isDisposed()) {
                return;
            }
            if (image != null && origin != null) {
                this.viewer.setImage(image, (double)origin.x, (double)origin.y);
            } else {
                this.viewer.setImage(image);
            }
            this.viewer.setTitle(state.getTitle(image, largeImage));
            this.viewer.setTitlePlacement(state.getTitlePlacement());
            state.setColor(this.viewer.getControl());
            this.viewer.initPreviewImageRatio();
        }

        private void createPreviewImage() {
            this.previewImageCreator = this.getPreviewImageCreator(Display.getCurrent());
            this.viewer.setImageBorderBounds(ExportToPdfWizard.this.getImageBorderBounds());
            this.previewImageCreator.releaseResource();
            Image previewImage = this.previewImageCreator.createPrintPreviewDetailedImage();
            this.viewer.setWholeImage(previewImage);
            Image[] images = this.previewImageCreator.getSingleImages();
            this.viewer.setSingleImages(images);
        }

        private PreviewImageCreator getPreviewImageCreator(Display display) {
            if (this.previewImageCreator == null) {
                this.previewImageCreator = this.createPreviewImageCreator(display);
            }
            return this.previewImageCreator;
        }

        private PreviewImageCreator createPreviewImageCreator(Display display) {
            IDialogSettings settings = this.getDialogSettings();
            PreviewImageCreator creator = new PreviewImageCreator(display, this.ganttViewer, settings);
            return creator;
        }

        private void asyncUpdateViewer(Display display, final Image image, final PreviewState state, final boolean largeImage, final Point origin) {
            if (Thread.currentThread() != display.getThread()) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        PdfExportPage.this.updateViewer(image, state, largeImage, origin);
                    }
                });
            } else {
                this.updateViewer(image, state, largeImage, origin);
            }
        }

        public void dispose() {
            super.dispose();
            if (this.viewer != null && this.viewer.getImage() != null) {
                this.viewer.getImage().dispose();
            }
            this.viewer = null;
            if (this.previewImageCreator != null) {
                this.previewImageCreator.dispose();
                this.previewImageCreator = null;
            }
            this.disposePreview();
        }

        private void disposePreview() {
            this.cancel();
        }

        private void cancel() {
            if (this.generatePreviewJob != null) {
                this.generatePreviewJob.cancel();
                this.generatePreviewJob = null;
            }
        }

        private PreviewState getPreviewState() {
            return this.previewState;
        }

        protected void setDialogFilters(FileDialog dialog, List<String> filterNames, List<String> filterExtensions) {
            filterNames.add(0, "PDF (*.pdf)");
            filterExtensions.add(0, "*.pdf");
            super.setDialogFilters(dialog, filterNames, filterExtensions);
        }

        private int getMaxWidthPages() {
            TaskTreeHeaderViewer headerViewer = this.ganttViewer.getTaskTreeHeaderViewer();
            RangeModel rangeModel = headerViewer.getViewport().getHorizontalRangeModel();
            int value = rangeModel.getValue() + rangeModel.getExtent();
            int leftWidth = ExportConstants.round(value, this.ganttViewer.getWidthsSupport());
            TimelineModel timelineModel = this.ganttViewer.getEditDomain().getTimelineModel();
            long startTime = this.getDialogSettings().getLong("startTime");
            long endTime = this.getDialogSettings().getLong("endTime");
            int rightWidth = 0;
            if (startTime != endTime) {
                rightWidth = timelineModel.getPixelsFromMillis(endTime - startTime) + 100;
            }
            int sourceWidth = leftWidth + rightWidth;
            Rectangle pageClientArea = this.getPageClientArea();
            int usefulPerPageWidth = pageClientArea.width;
            int usefulPerPageHeight = pageClientArea.height;
            double maxRatio = (double)usefulPerPageHeight / (double)(ExportConstants.HEADER_HEIGHT + ExportConstants.ITEM_HEIGHT);
            int maxWidthPages = (int)(maxRatio * (double)sourceWidth / (double)usefulPerPageWidth);
            return maxWidthPages;
        }

        private int getMaxHeightPages() {
            TaskTreeViewer taskTreeViewer = this.ganttViewer.getTaskTreeViewer();
            int contentHeight = ((FreeformLayer)taskTreeViewer.getLayer((Object)GEF.LAYER_CONTENTS)).getFreeformExtent().height;
            int maxHeightPages = contentHeight / ExportConstants.ITEM_HEIGHT;
            return maxHeightPages;
        }

        private int getHeightPageByWidth(int widthPages) {
            TaskTreeHeaderViewer headerViewer = this.ganttViewer.getTaskTreeHeaderViewer();
            RangeModel rangeModel = headerViewer.getViewport().getHorizontalRangeModel();
            int value = rangeModel.getValue() + rangeModel.getExtent();
            int leftWidth = ExportConstants.round(value, this.ganttViewer.getWidthsSupport());
            int headerHeight = headerViewer.getCanvas().getSize().y;
            TaskTreeViewer taskTreeViewer = this.ganttViewer.getTaskTreeViewer();
            int contentHeight = ((FreeformLayer)taskTreeViewer.getLayer((Object)GEF.LAYER_CONTENTS)).getFreeformExtent().height;
            TimelineModel timelineModel = this.ganttViewer.getEditDomain().getTimelineModel();
            long startTime = this.getDialogSettings().getLong("startTime");
            long endTime = this.getDialogSettings().getLong("endTime");
            int rightWidth = 0;
            if (startTime != endTime) {
                rightWidth = timelineModel.getPixelsFromMillis(endTime - startTime) + 100;
            }
            int sourceWidth = leftWidth + rightWidth;
            Rectangle pageClientArea = this.getPageClientArea();
            int usefulPerPageWidth = pageClientArea.width;
            int usefulPerPageHeight = pageClientArea.height;
            double ratio = (double)usefulPerPageWidth * (double)widthPages / (double)sourceWidth;
            int heightByRatio = (int)((double)usefulPerPageHeight / ratio);
            int lines = (heightByRatio - headerHeight) / ExportConstants.ITEM_HEIGHT;
            int usefulPerPageHeightByRatio = headerHeight + lines * ExportConstants.ITEM_HEIGHT;
            int heightPages = contentHeight / (usefulPerPageHeightByRatio - headerHeight);
            heightPages = contentHeight % (usefulPerPageHeightByRatio - headerHeight) == 0 ? heightPages : heightPages + 1;
            return heightPages;
        }

        private int getWidthPageByHeight(int heightPages) {
            TaskTreeHeaderViewer headerViewer = this.ganttViewer.getTaskTreeHeaderViewer();
            RangeModel rangeModel = headerViewer.getViewport().getHorizontalRangeModel();
            int value = rangeModel.getValue() + rangeModel.getExtent();
            int leftWidth = ExportConstants.round(value, this.ganttViewer.getWidthsSupport());
            int headerHeight = headerViewer.getCanvas().getSize().y;
            TaskTreeViewer taskTreeViewer = this.ganttViewer.getTaskTreeViewer();
            int contentHeight = ((FreeformLayer)taskTreeViewer.getLayer((Object)GEF.LAYER_CONTENTS)).getFreeformExtent().height;
            TimelineModel timelineModel = this.ganttViewer.getEditDomain().getTimelineModel();
            long startTime = this.getDialogSettings().getLong("startTime");
            long endTime = this.getDialogSettings().getLong("endTime");
            int rightWidth = 0;
            if (startTime != endTime) {
                rightWidth = timelineModel.getPixelsFromMillis(endTime - startTime) + 100;
            }
            int sourceWidth = leftWidth + rightWidth;
            Rectangle pageClientArea = this.getPageClientArea();
            int usefulPerPageWidth = pageClientArea.width;
            int usefulPerPageHeight = pageClientArea.height;
            double ratio = (double)usefulPerPageHeight * (double)heightPages / (double)(contentHeight + heightPages * headerHeight);
            int heightByRatio = (int)((double)usefulPerPageHeight / ratio);
            int lines = (heightByRatio - headerHeight) / ExportConstants.ITEM_HEIGHT;
            lines = (heightByRatio - headerHeight) % ExportConstants.ITEM_HEIGHT == 0 ? lines : lines + 1;
            int usefulPerPageHeightByRatio = headerHeight + lines * ExportConstants.ITEM_HEIGHT;
            ratio = (double)usefulPerPageHeight / (double)usefulPerPageHeightByRatio;
            int widthPages = sourceWidth / (int)((double)usefulPerPageWidth / ratio);
            widthPages = sourceWidth % (int)((double)usefulPerPageWidth / ratio) == 0 ? widthPages : widthPages + 1;
            return widthPages;
        }

        private Rectangle getPageClientArea() {
            String orientation = this.getDialogSettings().get("Orientation");
            Dimension size = PDFMapConstants.getSize((String)this.getDialogSettings().get("PageSize"), (String)orientation);
            java.awt.Insets margins = PDFMapConstants.getMargins((String)PDFMapConstants.PageMargins.Small.name(), (String)orientation);
            Rectangle pageClientArea = new Rectangle(margins.left, margins.top, size.width - (margins.left + margins.right), size.height - (margins.top + margins.bottom));
            return pageClientArea;
        }

        private class GeneratePreviewJob
        extends Job {
            private Display display;

            public GeneratePreviewJob(Display display) {
                super(GanttMessages.ExportWizard_GenerateContent_text);
                this.display = display;
            }

            protected IStatus run(IProgressMonitor monitor) {
                if (PdfExportPage.this.getDialogSettings() instanceof DialogSettingsDecorator && ((DialogSettingsDecorator)PdfExportPage.this.getDialogSettings()).isDirty()) {
                    return new Status(8, "org.xmind.ui", GanttMessages.ExportWizard_Generating_text);
                }
                monitor.beginTask(null, 100);
                monitor.worked(50);
                this.display.asyncExec(new Runnable(){

                    public void run() {
                        PdfExportPage.this.asyncUpdateViewer(GeneratePreviewJob.this.display, null, PreviewState.Showing, false, null);
                        PdfExportPage.this.createPreviewImage();
                        PdfExportPage.this.viewer.setImageIndex(0);
                        PdfExportPage.this.viewer.initPreviewImageRatio();
                        if (!PdfExportPage.this.getPreviewImageCreator(GeneratePreviewJob.this.display).checkImage()) {
                            PdfExportPage.this.asyncUpdateViewer(GeneratePreviewJob.this.display, null, PreviewState.Error, false, null);
                        }
                    }
                });
                monitor.worked(50);
                if (PdfExportPage.this.generatePreviewJob == this) {
                    PdfExportPage.this.generatePreviewJob = null;
                }
                monitor.done();
                return new Status(0, "org.xmind.ui.gantt", GanttMessages.ExportWizard_Generated_text);
            }
        }
    }

    private static class PreviewImageCreator
    extends GanttImageCreator {
        public PreviewImageCreator(Display display, GanttViewer ganttViewer, IDialogSettings settings) {
            super(display, ganttViewer, settings);
        }

        protected Insets getPageMargins() {
            String orientation = this.settings.get("Orientation");
            java.awt.Insets margins = PDFMapConstants.getMargins((String)PDFMapConstants.PageMargins.Small.name(), (String)orientation);
            return new Insets(margins.top, margins.left, margins.bottom, margins.right);
        }

        protected org.eclipse.draw2d.geometry.Dimension getPageBounds() {
            String orientation = this.settings.get("Orientation");
            Dimension size = PDFMapConstants.getSize((String)this.settings.get("PageSize"), (String)orientation);
            return new org.eclipse.draw2d.geometry.Dimension(size.width, size.height);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PreviewState {
        Showing(null, 16, 132096){

            public String getTitle(Image image, boolean largeImage) {
                if (image == null || image.isDisposed()) {
                    return super.getTitle(image, largeImage);
                }
                Rectangle r = image.getBounds();
                return String.format("%d x %d", r.width, r.height);
            }
        }
        ,
        Generating(GanttMessages.ExportWizard_Generating_text, 16, 0),
        Error(String.valueOf(GanttMessages.ExportWizard_Failed_text) + "\n" + GanttMessages.ExportWizard_ExportDirectly_text, 4, 0){

            public String getTitle(Image image, boolean largeImage) {
                return PreviewState.makeErrorMessage(super.getTitle(image, largeImage), largeImage);
            }
        };

        private int colorId;
        private String title;
        private int titlePlacement;

        private static String makeErrorMessage(String originalMessage, boolean largeImage) {
            if (largeImage) {
                return String.valueOf(originalMessage) + " " + GanttMessages.ExportWizard_ContentLarge_text;
            }
            return originalMessage;
        }

        private PreviewState(String title, int colorId, int titlePlacement) {
            this.title = title;
            this.colorId = colorId;
            this.titlePlacement = titlePlacement;
        }

        public String getTitle(Image image, boolean largeImage) {
            return this.title;
        }

        public void setColor(Control control) {
            control.setForeground(control.getDisplay().getSystemColor(this.colorId));
        }

        public int getTitlePlacement() {
            return this.titlePlacement;
        }
    }
}

