/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.part;

import java.util.HashMap;
import java.util.Map;
import org.xmind.gef.EditDomain;
import org.xmind.gef.Request;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRequestHandler;
import org.xmind.gef.policy.IEditPolicy;

public class RequestHandler
implements IRequestHandler {
    private Map<String, IEditPolicy> editPolicies = null;
    private Map<String, String> editPolicyIds = null;
    private IPart host;

    public RequestHandler(IPart host) {
        this.host = host;
    }

    public IEditPolicy getPolicy(String role) {
        IEditPolicy editPolicy;
        IEditPolicy iEditPolicy = editPolicy = this.editPolicies == null ? null : this.editPolicies.get(role);
        if (editPolicy == null) {
            String editPolicyId;
            String string = editPolicyId = this.editPolicyIds == null ? null : this.editPolicyIds.get(role);
            if (editPolicyId != null) {
                EditDomain domain = this.host.getSite().getDomain();
                if (domain != null && (editPolicy = domain.getEditPolicy(role, editPolicyId)) != null) {
                    this.installEditPolicy(role, editPolicy);
                }
                if (editPolicy != null) {
                    this.editPolicyIds.remove(role);
                }
            }
        }
        return editPolicy;
    }

    public boolean hasRole(String role) {
        return this.editPolicies != null && this.editPolicies.containsKey(role) || this.editPolicyIds != null && this.editPolicyIds.containsKey(role);
    }

    public void installEditPolicy(String role, IEditPolicy editPolicy) {
        if (this.editPolicies == null) {
            this.editPolicies = new HashMap<String, IEditPolicy>();
        }
        this.editPolicies.put(role, editPolicy);
    }

    public void installEditPolicy(String role, String editPolicyId) {
        if (this.editPolicyIds == null) {
            this.editPolicyIds = new HashMap<String, String>();
        }
        this.editPolicyIds.put(role, editPolicyId);
    }

    public void uninstallEditPolicy(String role) {
        if (this.editPolicies != null) {
            this.editPolicies.remove(role);
        }
        if (this.editPolicyIds != null) {
            this.editPolicyIds.remove(role);
        }
    }

    public void handleRequest(Request request, String role) {
        IEditPolicy editPolicy = this.getPolicy(role);
        if (editPolicy != null && editPolicy.understands(request.getType())) {
            if (request.getPrimaryTarget() == null) {
                request.setPrimaryTarget(this.host);
            }
            editPolicy.handle(request);
        } else {
            IPart parent = this.host.getParent();
            if (parent != null) {
                parent.handleRequest(request, role);
            }
        }
    }
}

