/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.impl.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.css.core.dom.CSSProperty;
import org.eclipse.e4.ui.css.core.dom.CSSPropertyList;
import org.eclipse.e4.ui.css.core.exceptions.DOMExceptionImpl;
import org.eclipse.e4.ui.css.core.impl.dom.AbstractCSSNode;
import org.eclipse.e4.ui.css.core.impl.dom.CSSPropertyImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSStyleDeclarationImpl
extends AbstractCSSNode
implements CSSStyleDeclaration {
    private boolean readOnly;
    private CSSRule parentRule;
    private List<CSSProperty> properties = new ArrayList<CSSProperty>();
    private CSSPropertyList cssPropertyListView;

    public CSSStyleDeclarationImpl(CSSRule parentRule) {
        this.parentRule = parentRule;
    }

    @Override
    public String getCssText() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.properties.size()) {
            CSSProperty property = this.properties.get(i);
            sb.append(property.getName()).append(": ");
            sb.append(property.getValue().getCssText());
            sb.append(";");
            if (i < this.properties.size() - 1) {
                sb.append("\n");
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public int getLength() {
        return this.properties.size();
    }

    @Override
    public CSSRule getParentRule() {
        return this.parentRule;
    }

    @Override
    public CSSValue getPropertyCSSValue(String propertyName) {
        CSSProperty property = this.findCSSProperty(propertyName);
        return property == null ? null : property.getValue();
    }

    @Override
    public String getPropertyPriority(String propertyName) {
        CSSProperty property = this.findCSSProperty(propertyName);
        return property != null && property.isImportant() ? CSSPropertyImpl.IMPORTANT_IDENTIFIER : "";
    }

    @Override
    public String getPropertyValue(String propertyName) {
        CSSProperty property = this.findCSSProperty(propertyName);
        return property == null ? "" : property.getValue().toString();
    }

    @Override
    public String item(int index) {
        return this.properties.get(index).getName();
    }

    @Override
    public String removeProperty(String propertyName) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, 20);
        }
        int i = 0;
        while (i < this.properties.size()) {
            CSSProperty property = this.properties.get(i);
            if (CSSPropertyImpl.sameName(property, propertyName)) {
                this.properties.remove(i);
                return property.getValue().toString();
            }
            ++i;
        }
        return "";
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, 20);
        }
        throw new UnsupportedOperationException("NOT YET IMPLEMENTED");
    }

    @Override
    public void setProperty(String propertyName, String value, String priority) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, 20);
        }
        throw new UnsupportedOperationException("NOT YET IMPLEMENTED");
    }

    public void addProperty(CSSProperty property) {
        this.properties.add(property);
    }

    public CSSPropertyList getCSSPropertyList() {
        if (this.cssPropertyListView == null) {
            this.cssPropertyListView = new CSSPropertyList(){

                @Override
                public int getLength() {
                    return CSSStyleDeclarationImpl.this.properties.size();
                }

                @Override
                public CSSProperty item(int i) {
                    return (CSSProperty)CSSStyleDeclarationImpl.this.properties.get(i);
                }
            };
        }
        return this.cssPropertyListView;
    }

    protected void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    private CSSProperty findCSSProperty(String propertyName) {
        for (CSSProperty property : this.properties) {
            if (!CSSPropertyImpl.sameName(property, propertyName)) continue;
            return property;
        }
        return null;
    }
}

