/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.print.multipage;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.image.FigureRenderer;
import org.xmind.gef.image.IExportSourceProvider;
import org.xmind.gef.util.Properties;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.print.PrintConstants;
import org.xmind.ui.internal.print.PrintUtils;
import org.xmind.ui.internal.print.multipage.PrintMultipageUtils;
import org.xmind.ui.mindmap.GhostShellProvider;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMapExportViewer;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.mindmap.MindMapViewerExportSourceProvider;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.Logger;
import org.xmind.ui.util.UnitConvertor;

public class MultipagePrintClient
extends FigureRenderer {
    private static final int TEXT_MARGIN = 0;
    private String jobName;
    private Shell parentShell;
    private PrinterData printerData;
    private IDialogSettings settings;
    private IMindMap sourceMap;
    private Printer printer;
    private Rectangle pageClientArea;
    private Point dpi;
    private IExportSourceProvider source;
    private boolean jobStarted = false;
    private Transform transform;

    public MultipagePrintClient(String jobName, Shell parentShell, PrinterData printerData, IDialogSettings settings) {
        this.jobName = jobName;
        this.parentShell = parentShell;
        this.printerData = printerData;
        this.settings = settings;
    }

    public void print(IMindMap sourceMap) {
        this.sourceMap = sourceMap;
        if (!this.start()) {
            return;
        }
        try {
            new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(false, false, new IRunnableWithProgress(){

                public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    MultipagePrintClient.this.parentShell.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MultipagePrintClient.this.print(monitor);
                        }
                    });
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void print(IProgressMonitor monitor) {
        Properties properties = new Properties();
        properties.set("gradient", (Object)Boolean.FALSE);
        boolean plusVisible = this.getBoolean(this.settings, "plusVisible", true);
        boolean minusVisible = this.getBoolean(this.settings, "minusVisible", true);
        properties.set("plusVisible", plusVisible);
        properties.set("minusVisible", minusVisible);
        GhostShellProvider shell = new GhostShellProvider(this.parentShell.getDisplay());
        MindMapExportViewer exportViewer = new MindMapExportViewer(shell, (Object)this.sourceMap, properties);
        this.source = new MindMapViewerPrintSourceProvider(exportViewer, 0, this.settings);
        this.setFigures(this.source.getContents());
        int margin = PrintMultipageUtils.getMargin(this.source.getSourceArea());
        this.setBounds(new Rectangle(this.source.getSourceArea()).expand(new Insets(margin)));
        this.internalPrint(monitor);
    }

    private boolean getBoolean(IDialogSettings settings, String key, boolean defaultValue) {
        boolean value = defaultValue;
        if (settings.get(key) != null) {
            value = settings.getBoolean(key);
        }
        return value;
    }

    private void internalPrint(IProgressMonitor monitor) {
        boolean fullWidth;
        Rectangle bounds = this.getBounds();
        int sourceWidth = bounds.width;
        int sourceHeight = bounds.height;
        int leftMarginPixel = PrintConstants.toPixel(this.getDouble("leftMargin", 0.2));
        int rightMarginPixel = PrintConstants.toPixel(this.getDouble("rightMargin", 0.2));
        int topMarginPixel = PrintConstants.toPixel(this.getDouble("topMargin", 0.2));
        int bottomMarginPixel = PrintConstants.toPixel(this.getDouble("bottomMargin", 0.2));
        int headerHeight = PrintUtils.getHeaderHeight(this.settings, 120);
        int footerHeight = PrintUtils.getBottomHeight(this.settings, 120);
        int orientation = this.getInteger("orientation", 2);
        int perPageWidth = orientation == 2 ? 1403 : 992;
        int usefulPerPageWidth = perPageWidth - leftMarginPixel - rightMarginPixel;
        int perPageHeight = orientation == 1 ? 1403 : 992;
        int usefulPerPageHeight = perPageHeight - topMarginPixel - bottomMarginPixel;
        usefulPerPageHeight -= headerHeight + footerHeight;
        int widthPages = this.getInteger("widthPages", 1);
        int heightPages = this.getInteger("heightPages", 1);
        boolean isAspectRatio = this.settings.getBoolean("aspectRatioLocked");
        boolean bl = fullWidth = !this.settings.getBoolean("fillHeight");
        if (!isAspectRatio) {
            double fillWidthratio = (double)usefulPerPageWidth * (double)widthPages / (double)sourceWidth;
            double fillHeightRatio = (double)usefulPerPageHeight * (double)heightPages / (double)sourceHeight;
            fullWidth = fillWidthratio <= fillHeightRatio;
        }
        double ratio = fullWidth ? (double)usefulPerPageWidth * (double)widthPages / (double)sourceWidth : (double)usefulPerPageHeight * (double)heightPages / (double)sourceHeight;
        int usefulPerPageWidthByRatio = (int)((double)usefulPerPageWidth / ratio);
        int usefulPerPageHeightByRatio = (int)((double)usefulPerPageHeight / ratio);
        int usefulWidthPages = widthPages;
        int usefulHeightPages = heightPages;
        if (fullWidth) {
            usefulHeightPages = sourceHeight / usefulPerPageHeightByRatio;
            usefulHeightPages = sourceHeight % usefulPerPageHeightByRatio == 0 ? usefulHeightPages : usefulHeightPages + 1;
        } else {
            usefulWidthPages = sourceWidth / usefulPerPageWidthByRatio;
            usefulWidthPages = sourceWidth % usefulPerPageWidthByRatio == 0 ? usefulWidthPages : usefulWidthPages + 1;
        }
        double widthScale = (double)this.pageClientArea.width / (double)usefulPerPageWidthByRatio;
        double heightScale = (double)this.pageClientArea.height / (double)usefulPerPageHeightByRatio;
        double scale = widthScale < heightScale ? widthScale : heightScale;
        this.setScale(scale);
        int originX = (int)((double)this.pageClientArea.width - (double)usefulPerPageWidthByRatio * scale) / 2 + this.pageClientArea.x;
        int originY = (int)((double)this.pageClientArea.height - (double)usefulPerPageHeightByRatio * scale) / 2 + this.pageClientArea.y;
        Rectangle realPageClientArea = new Rectangle(originX, originY, (int)((double)usefulPerPageWidthByRatio * scale), (int)((double)usefulPerPageHeightByRatio * scale));
        monitor.beginTask(MindMapMessages.MultipagePrint_Printing, widthPages * heightPages);
        int j = 0;
        while (j < heightPages) {
            int y = j * usefulPerPageHeightByRatio;
            int i = 0;
            while (i < widthPages) {
                int x = i * usefulPerPageWidthByRatio;
                int pageNumber = j * widthPages + i + 1;
                boolean isValidPage = i < usefulWidthPages && j < usefulHeightPages;
                this.render(realPageClientArea, new Point(-x, -y), pageNumber, isValidPage);
                monitor.worked(1);
                ++i;
            }
            ++j;
        }
        monitor.done();
    }

    private void render(Rectangle realPageClientArea, Point origin, int pageNumber, boolean isValidPage) {
        if (!this.printer.startPage()) {
            return;
        }
        this.pageClientArea = new Rectangle(realPageClientArea);
        GC gc = new GC((Drawable)this.printer);
        try {
            String footerText;
            if (isValidPage) {
                this.pushState(gc);
                this.render(gc, origin);
                this.popState(gc);
            }
            gc.setClipping(null);
            String headerText = this.settings.get("headerText");
            if (headerText != null && !"".equals(headerText)) {
                this.drawHeader(gc, headerText);
            }
            if ((footerText = this.settings.get("footerText")) != null && !"".equals(footerText)) {
                this.drawFooter(gc, footerText);
            }
            gc.setClipping(null);
            boolean hasBorder = this.settings.getBoolean("border");
            if (hasBorder) {
                gc.setLineWidth(1);
                gc.setForeground(Display.getCurrent().getSystemColor(2));
                gc.drawRectangle(this.pageClientArea.x - 1, this.pageClientArea.y - 1, this.pageClientArea.width + 2, this.pageClientArea.height + 2);
            }
            this.drawPageNumber(gc, "- " + pageNumber + " -");
        }
        finally {
            gc.dispose();
        }
        this.printer.endPage();
    }

    private void pushState(GC gc) {
        Transform tempTransform = new Transform(gc.getDevice());
        gc.getTransform(tempTransform);
        float[] elements = new float[6];
        tempTransform.getElements(elements);
        if (this.transform != null && !this.transform.isDisposed()) {
            this.transform.dispose();
        }
        this.transform = new Transform(gc.getDevice(), elements);
        tempTransform.dispose();
    }

    private void popState(GC gc) {
        gc.setTransform(this.transform);
    }

    private void drawHeader(GC gc, String text) {
        Font font = this.getFont("headerFont");
        try {
            this.drawText(gc, text, font, this.getAlign("headerAlign", 2), true);
        }
        finally {
            font.dispose();
        }
    }

    private void drawFooter(GC gc, String text) {
        Font font = this.getFont("footerFont");
        try {
            this.drawText(gc, text, font, this.getAlign("footerAlign", 4), false);
        }
        finally {
            font.dispose();
        }
    }

    private void drawPageNumber(GC gc, String text) {
        int footerAlign = this.getAlign("footerAlign", 4);
        int pageNumberAlign = footerAlign == 2 ? 4 : 2;
        this.drawPageNumber(gc, text, pageNumberAlign);
    }

    private Font getFont(String fontKey) {
        FontData[] fontData;
        Font font = null;
        String fontValue = this.settings.get(fontKey);
        if (fontValue != null && (fontData = FontUtils.toFontData((String)fontValue)) != null) {
            FontData[] fontDataArray = fontData;
            int n = fontData.length;
            int n2 = 0;
            while (n2 < n) {
                FontData fd = fontDataArray[n2];
                fd.setHeight(fd.getHeight() * this.dpi.y / UnitConvertor.getScreenDpi().y);
                ++n2;
            }
            font = new Font((Device)Display.getCurrent(), fontData);
        }
        if (font == null) {
            FontData[] defaultFontData = JFaceResources.getDefaultFontDescriptor().getFontData();
            int defaultHeight = defaultFontData[0].getHeight();
            font = new Font((Device)Display.getCurrent(), FontUtils.newHeight((FontData[])defaultFontData, (int)(defaultHeight * this.dpi.y / UnitConvertor.getScreenDpi().y)));
        }
        return font;
    }

    private int getAlign(String alignKey, int defaultAlign) {
        return PrintConstants.toDraw2DAlignment(this.settings.get(alignKey), defaultAlign);
    }

    private void drawText(GC gc, String text, Font font, int alignment, boolean top) {
        RotatableWrapLabel label = new RotatableWrapLabel();
        label.setText(text);
        label.setFont(font);
        label.setTextAlignment(alignment);
        label.setForegroundColor(this.parentShell.getDisplay().getSystemColor(2));
        int width = this.pageClientArea.width;
        int marginWidth = 0 * this.dpi.x / UnitConvertor.getScreenDpi().x;
        Dimension size = label.getPreferredSize(width -= marginWidth * 2, -1);
        int x = -width / 2;
        org.eclipse.swt.graphics.Rectangle pageBounds = this.printer.getClientArea();
        int y = top ? -this.pageClientArea.height / 2 - (this.pageClientArea.y - pageBounds.y) + Math.max((this.pageClientArea.y - pageBounds.y - size.height) / 2, marginWidth) : this.pageClientArea.height / 2 + (pageBounds.y + pageBounds.height - (this.pageClientArea.y + this.pageClientArea.height)) - size.height - Math.max((pageBounds.y + pageBounds.height - (this.pageClientArea.y + this.pageClientArea.height) - size.height) / 2, marginWidth);
        label.setBounds(new Rectangle(x, y, width, size.height));
        SWTGraphics baseGraphics = new SWTGraphics(gc);
        baseGraphics.translate(this.pageClientArea.x + this.pageClientArea.width / 2, this.pageClientArea.y + this.pageClientArea.height / 2);
        SWTGraphics graphics = baseGraphics;
        Object rotatedGraphics = null;
        try {
            try {
                label.paint((Graphics)graphics);
            }
            catch (Throwable e) {
                Logger.log(e, "Error occurred while printing");
                if (rotatedGraphics != null) {
                    rotatedGraphics.dispose();
                }
                baseGraphics.dispose();
            }
        }
        finally {
            if (rotatedGraphics != null) {
                rotatedGraphics.dispose();
            }
            baseGraphics.dispose();
        }
    }

    private void drawPageNumber(GC gc, String text, int alignment) {
        RotatableWrapLabel label = new RotatableWrapLabel();
        label.setText(text);
        Font font = Display.getCurrent().getSystemFont();
        font = FontUtils.getNewHeight((Font)font, (int)(font.getFontData()[0].getHeight() * this.dpi.y / UnitConvertor.getScreenDpi().y));
        label.setFont(font);
        label.setTextAlignment(alignment);
        label.setForegroundColor(this.parentShell.getDisplay().getSystemColor(2));
        Rectangle pageBounds = new Rectangle(this.printer.getClientArea());
        int width = this.pageClientArea.width;
        int marginWidth = 0 * this.dpi.x / UnitConvertor.getScreenDpi().x;
        Dimension size = label.getPreferredSize(width -= marginWidth * 2, -1);
        int x = -width / 2;
        int y = pageBounds.height / 2 - size.height - Math.max((pageBounds.y + pageBounds.height - (this.pageClientArea.y + this.pageClientArea.height) - size.height) / 2, marginWidth);
        label.setBounds(new Rectangle(x, y, width, size.height));
        SWTGraphics baseGraphics = new SWTGraphics(gc);
        baseGraphics.translate(pageBounds.x + pageBounds.width / 2, pageBounds.y + pageBounds.height / 2);
        SWTGraphics graphics = baseGraphics;
        Object rotatedGraphics = null;
        try {
            try {
                label.paint((Graphics)graphics);
            }
            catch (Throwable e) {
                Logger.log(e, "Error occurred while printing");
                if (rotatedGraphics != null) {
                    rotatedGraphics.dispose();
                }
                baseGraphics.dispose();
            }
        }
        finally {
            if (rotatedGraphics != null) {
                rotatedGraphics.dispose();
            }
            baseGraphics.dispose();
        }
    }

    private boolean start() {
        if (this.printer == null) {
            this.printer = new Printer(this.printerData);
        }
        this.receivePrinterInfo();
        if (this.pageClientArea.width <= 0 || this.pageClientArea.height <= 0) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)MindMapMessages.MultipagePrint_InvalidMargin_title, (String)MindMapMessages.MultipagePrint_InvalidMargin_message);
                }
            });
            return false;
        }
        if (!this.jobStarted) {
            if (!this.printer.startJob(this.jobName)) {
                return false;
            }
            this.jobStarted = true;
        }
        return this.jobStarted;
    }

    private void receivePrinterInfo() {
        this.dpi = new Point(this.printer.getDPI());
        this.pageClientArea = new Rectangle(this.printer.getClientArea());
        int leftMargin = this.getUserMargin("leftMargin");
        int rightMargin = this.getUserMargin("rightMargin");
        int topMargin = this.getUserMargin("topMargin");
        int bottomMargin = this.getUserMargin("bottomMargin");
        this.pageClientArea.x += leftMargin;
        this.pageClientArea.y += topMargin;
        this.pageClientArea.width -= leftMargin + rightMargin;
        this.pageClientArea.height -= topMargin + bottomMargin;
        int headerHeight = PrintUtils.getHeaderHeight(this.settings, this.dpi.y);
        int footerHeight = PrintUtils.getBottomHeight(this.settings, this.dpi.y);
        this.pageClientArea.expand(new Insets(-headerHeight, 0, -footerHeight, 0));
    }

    private int getUserMargin(String key) {
        double marginInch;
        try {
            marginInch = this.settings.getDouble(key);
        }
        catch (NumberFormatException numberFormatException) {
            marginInch = 0.2;
        }
        double dpi = "leftMargin".equals(key) || "rightMargin".equals(key) ? (double)this.dpi.x : (double)this.dpi.y;
        return (int)(marginInch * dpi);
    }

    public void dispose() {
        if (this.printer != null) {
            if (!this.printer.isDisposed()) {
                this.printer.endJob();
            }
            this.printer.dispose();
            this.printer = null;
        }
        this.jobStarted = false;
        if (this.transform != null) {
            this.transform.dispose();
        }
    }

    protected void createGraphics(Graphics graphics, Stack<Graphics> stack) {
        graphics.clipRect(new Rectangle(this.pageClientArea.x, this.pageClientArea.y, this.pageClientArea.width, this.pageClientArea.height));
        graphics.translate(this.pageClientArea.x, this.pageClientArea.y);
        if (this.getScale() > 0.0) {
            graphics.scale(this.getScale());
            stack.push(graphics);
        }
        Rectangle bounds = this.getBounds();
        graphics.translate(-bounds.x, -bounds.y);
    }

    private double getDouble(String key, double defaultValue) {
        try {
            return this.settings.getDouble(key);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private int getInteger(String key, int defaultValue) {
        try {
            return this.settings.getInt(key);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private static class MindMapViewerPrintSourceProvider
    extends MindMapViewerExportSourceProvider {
        private IDialogSettings settings;

        public MindMapViewerPrintSourceProvider(IGraphicalViewer viewer, IDialogSettings settings) {
            super(viewer);
            this.settings = settings;
        }

        public MindMapViewerPrintSourceProvider(IGraphicalViewer viewer, int margins, IDialogSettings settings) {
            super(viewer, margins);
            this.settings = settings;
        }

        @Override
        protected void collectContents(List<IFigure> figures) {
            if (this.settings != null && !this.settings.getBoolean("noBackground")) {
                figures.add((IFigure)this.getViewer().getLayer(GEF.LAYER_BACKGROUND));
            }
            figures.add((IFigure)this.getViewer().getLayer(GEF.LAYER_CONTENTS));
            figures.add((IFigure)this.getViewer().getLayer(MindMapUI.LAYER_TITLE));
        }
    }
}

