/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.layouts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.core.IPositioned;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.geometry.DelegatingIntersectionSolver;
import org.xmind.gef.draw2d.geometry.IBoundsProvider;
import org.xmind.gef.draw2d.geometry.IPositionSolver;
import org.xmind.gef.draw2d.geometry.SplitIntersectionSolver;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.policy.GraphicalPartBoundsProvider;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ILegendPart;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.util.MindMapUtils;

public class SheetIntersectionSolver
extends DelegatingIntersectionSolver {
    private static final SteadyBoundsProvider STEADY_BOUNDS_PROVIDER_INSTANCE = new SteadyBoundsProvider();

    public void recordInitPositions(ISheetPart sheet, boolean useModelOrGraphicalPosition) {
        IBranchPart centralBranch = sheet.getCentralBranch();
        if (centralBranch != null) {
            this.recordBranchPosition(centralBranch, sheet, false, useModelOrGraphicalPosition);
        }
        for (IBranchPart floatingBranch : sheet.getFloatingBranches()) {
            this.recordFreePosition(floatingBranch, useModelOrGraphicalPosition, sheet);
        }
        ILegendPart legend = sheet.getLegend();
        if (legend != null) {
            this.recordFreePosition(legend, useModelOrGraphicalPosition, sheet);
        }
    }

    private void recordBranchPosition(IBranchPart branch, ISheetPart sheet, boolean freeable, boolean useModelOrGraphicalPosition) {
        IFigure figure = branch.getFigure();
        if (!figure.isVisible() || !figure.isEnabled()) {
            return;
        }
        this.recordInitPosition(branch, this.getPosition(branch, sheet), "steady", false);
        if (!branch.isFolded() && !this.takesEntireBranch(branch)) {
            boolean childrenFreeable = MindMapUtils.isSubBranchesFreeable(branch);
            for (IBranchPart sub : branch.getSubBranches()) {
                this.recordBranchPosition(sub, sheet, childrenFreeable, useModelOrGraphicalPosition);
            }
            for (IBranchPart sum : branch.getSummaryBranches()) {
                this.recordBranchPosition(sum, sheet, childrenFreeable, useModelOrGraphicalPosition);
            }
        }
    }

    private boolean takesEntireBranch(IBranchPart branch) {
        return false;
    }

    private void recordFreePosition(IGraphicalPart part, boolean useModelOrGraphicalPosition, ISheetPart sheet) {
        Point offset;
        Object model;
        IFigure figure = part.getFigure();
        if (!figure.isVisible() || !figure.isEnabled()) {
            return;
        }
        Point position = null;
        if (useModelOrGraphicalPosition && (model = MindMapUtils.getRealModel((IPart)part)) instanceof IPositioned && (offset = MindMapUtils.toGraphicalPosition(((IPositioned)model).getPosition())) != null) {
            position = this.getOrigin().getTranslated(offset);
        }
        if (position == null) {
            position = this.getPosition(part, sheet);
        }
        this.recordInitPosition(part, position, "free", false);
    }

    private Point getPosition(IGraphicalPart part, ISheetPart sheet) {
        Point position = this.getActualPosition(part);
        Point lastRef = this.getLastSheetReference(sheet);
        return position.getTranslated(-lastRef.x, -lastRef.y);
    }

    private Point getLastSheetReference(ISheetPart sheet) {
        if (sheet.getFigure() instanceof IReferencedFigure) {
            return ((IReferencedFigure)sheet.getFigure()).getLastReference();
        }
        return sheet.getFigure().getBounds().getLocation();
    }

    private Point getActualPosition(IGraphicalPart part) {
        IFigure figure = part.getFigure();
        if (figure instanceof IReferencedFigure) {
            return ((IReferencedFigure)figure).getReference();
        }
        return figure.getBounds().getCenter();
    }

    protected IPositionSolver createDelegate() {
        SplitIntersectionSolver solver = new SplitIntersectionSolver(false);
        solver.setDefaultBoundsProvider((IBoundsProvider)GraphicalPartBoundsProvider.getDefault());
        solver.setGeneralBoundsProvider("steady", (IBoundsProvider)STEADY_BOUNDS_PROVIDER_INSTANCE);
        solver.setSpacing(15);
        return solver;
    }

    private static class SteadyBoundsProvider
    extends GraphicalPartBoundsProvider {
        private SteadyBoundsProvider() {
        }

        public Rectangle getPrefBounds(Object host, Point reference) {
            ITopicPart topicPart;
            IBranchPart branch;
            if (host instanceof IBranchPart && (branch = (IBranchPart)host).getBoundaries().isEmpty() && branch.getSummaries().isEmpty() && (topicPart = branch.getTopicPart()) != null) {
                host = topicPart.getFigure();
            }
            return super.getPrefBounds(host, reference);
        }
    }
}

