/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.comments;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.core.IComment;
import org.xmind.core.ICommentManager;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.util.TopicIterator;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.comments.CommentTextViewer;
import org.xmind.ui.internal.comments.CommentsUtils;
import org.xmind.ui.internal.comments.ICommentTextViewerContainer;
import org.xmind.ui.internal.comments.ICommentsActionBarContributor;
import org.xmind.ui.internal.comments.TopicCommentsViewer;
import org.xmind.ui.internal.e4models.CommentsPart;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.MindMapUtils;
import org.xmind.ui.util.TextFormatter;

public class SheetCommentsViewer
implements ICoreEventListener,
ISelectionChangedListener {
    private ResourceManager resources;
    private ISheet input;
    private ICommentsActionBarContributor contributor;
    private ISelectionProvider selectionProvider;
    private ICommentTextViewerContainer container;
    private IGraphicalEditor targetEditor;
    private TopicCommentsViewer topicViewer;
    private Label titleLabel;
    private ICoreEventRegister eventRegister;
    private List<CommentTextViewer> controls = new ArrayList<CommentTextViewer>();
    private List<CommentTextViewer> implementations = new ArrayList<CommentTextViewer>();
    private Map<ITopic, TopicCommentsViewer> topicViewers = new HashMap<ITopic, TopicCommentsViewer>();
    private Composite sheetCommentsComposite;
    private Control newCommentControl;
    private Button insertButton;
    private Hyperlink insertHyperlink;
    private ITopic select;
    private String creatingTargetId;
    private Composite content;
    private Composite parent;

    public SheetCommentsViewer(ISheet input, ICommentsActionBarContributor contributor, ISelectionProvider selectionProvider, ICommentTextViewerContainer container, IGraphicalEditor targetEditor) {
        this.input = input;
        this.contributor = contributor;
        this.selectionProvider = selectionProvider;
        this.container = container;
        this.targetEditor = targetEditor;
    }

    public void create(Composite parent) {
        this.parent = parent;
        this.init();
        this.createContent(parent, this.input);
        this.restoreEditing();
    }

    private void init() {
        if (this.controls != null) {
            this.controls.clear();
        } else {
            this.controls = new ArrayList<CommentTextViewer>();
        }
        if (this.implementations != null) {
            this.implementations.clear();
        } else {
            this.implementations = new ArrayList<CommentTextViewer>();
        }
        if (this.topicViewers != null) {
            this.topicViewers.clear();
        } else {
            this.topicViewers = new HashMap<ITopic, TopicCommentsViewer>();
        }
    }

    private Composite createContent(Composite parent, ISheet sheet) {
        Composite composite;
        this.content = composite = new Composite(parent, 0);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        composite.setBackground(composite.getParent().getBackground());
        GridData layoutData = new GridData(1808);
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        if (sheet == null || !this.existComment(sheet)) {
            this.container.getScrolledComposite().setExpandVertical(true);
            this.createNullContentArea(composite);
        } else {
            this.createAllComments(composite, sheet);
        }
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SheetCommentsViewer.this.handleControlDisposed(e);
            }
        });
        return composite;
    }

    private void restoreEditing() {
        final CommentsPart part = (CommentsPart)this.container;
        final String objectId = part.getInsertTarget();
        if (objectId != null) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SheetCommentsViewer.this.insertComment(objectId);
                    SheetCommentsViewer.this.container.setModified(false);
                    part.setInsertTarget(null);
                }
            });
        }
    }

    private boolean existComment(ISheet sheet) {
        if (sheet == null) {
            return false;
        }
        if (this.creatingTargetId != null) {
            return true;
        }
        ICommentManager commentManager = sheet.getOwnedWorkbook().getCommentManager();
        if (commentManager.isEmpty()) {
            return false;
        }
        if (commentManager.hasComments(sheet.getId())) {
            return true;
        }
        TopicIterator ite = new TopicIterator(sheet.getRootTopic());
        while (ite.hasNext()) {
            ITopic topic = ite.next();
            if (!commentManager.hasComments(topic.getId())) continue;
            return true;
        }
        return false;
    }

    private Control createAllComments(Composite parent, ISheet sheet) {
        boolean showSheetComments;
        this.container.getScrolledComposite().setExpandVertical(false);
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 9;
        gridLayout.marginBottom = 29;
        gridLayout.verticalSpacing = 18;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        boolean showTopicsComments = this.createTopicsComments(composite, sheet.getRootTopic());
        if (showTopicsComments) {
            this.createSeparatorLine(composite);
        }
        this.createSheetComments(composite, sheet);
        boolean bl = showSheetComments = sheet.getOwnedWorkbook().getCommentManager().getComments(sheet.getId()).size() != 0;
        if (showSheetComments) {
            this.createSeparatorLine(composite);
        }
        this.createInsertCommentHyperlink(composite);
        return composite;
    }

    private boolean createTopicsComments(Composite parent, ITopic root) {
        boolean hasContent = false;
        TopicIterator topicIt = new TopicIterator(root);
        while (topicIt.hasNext()) {
            ITopic topic = (ITopic)topicIt.next();
            if (!topic.getOwnedWorkbook().getCommentManager().hasComments(topic.getId()) && !topic.getId().equals(this.creatingTargetId)) continue;
            if (hasContent) {
                this.createSeparatorLine(parent);
            }
            this.createTopicLabelAndComments(parent, topic);
            hasContent = true;
        }
        return hasContent;
    }

    private void createSeparatorLine(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        Label sep = new Label(composite, 258);
        sep.setLayoutData((Object)new GridData(768));
        sep.setBackground(parent.getDisplay().getSystemColor(2));
    }

    private void createTopicLabelAndComments(Composite parent, ITopic topic) {
        this.topicViewer = new TopicCommentsViewer(topic, this.contributor, this.selectionProvider, this.container, true, this.targetEditor);
        this.topicViewer.create(parent);
        if (this.topicViewer.getControls() != null) {
            this.controls.addAll(this.topicViewer.getControls());
        }
        if (this.topicViewer.getImplementations() != null) {
            this.implementations.addAll(this.topicViewer.getImplementations());
        }
        this.topicViewers.put(topic, this.topicViewer);
    }

    private void createSheetComments(Composite parent, ISheet sheet) {
        TreeSet comments = new TreeSet(sheet.getOwnedWorkbook().getCommentManager().getComments(sheet.getId()));
        if (comments.isEmpty()) {
            return;
        }
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 5;
        composite.setLayout((Layout)layout);
        this.sheetCommentsComposite = composite;
        this.createSheetLabel(composite, sheet);
        for (IComment comment : comments) {
            this.createCommentControl(composite, comment);
        }
    }

    private void createSheetLabel(Composite parent, final ISheet sheet) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 10;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.titleLabel = new Label(composite, 16640);
        this.titleLabel.setBackground(parent.getBackground());
        this.titleLabel.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#353535")));
        GridData data = new GridData(0x1000000, 0x1000000, true, false);
        data.horizontalIndent = 2;
        this.titleLabel.setLayoutData((Object)data);
        this.titleLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])this.titleLabel.getFont().getFontData(), (int)1))));
        this.titleLabel.setText(String.valueOf(MindMapMessages.Comment_SHEET_text) + TextFormatter.removeNewLineCharacter((String)sheet.getTitleText()));
        this.hookSheetTitle();
        this.titleLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                CommentsUtils.reveal(SheetCommentsViewer.this.targetEditor, sheet);
            }
        });
    }

    private void createCommentControl(Composite parent, IComment comment) {
        CommentTextViewer implementation = new CommentTextViewer(comment, this.input.getId(), this.input.getOwnedWorkbook(), this.contributor, this.selectionProvider, this.container, this.targetEditor);
        implementation.createControl(parent);
        this.registerControl(implementation);
        this.registerImplementation(implementation);
    }

    private void createNullContentArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(composite.getParent().getBackground());
        GridData layoutData = new GridData(1808);
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.createNullContent(composite);
    }

    private void createNullContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(composite.getParent().getBackground());
        composite.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 25;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setBackground(label.getParent().getBackground());
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        label.setImage((Image)this.resources.get((DeviceResourceDescriptor)MindMapUI.getImages().get("comment-empty-bg.png", true)));
        Composite composite2 = new Composite(composite, 0);
        composite2.setBackground(composite2.getParent().getBackground());
        composite2.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        GridLayout layout2 = new GridLayout(1, false);
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        layout2.verticalSpacing = 0;
        composite2.setLayout((Layout)layout2);
        Label label2 = new Label(composite2, 0);
        label2.setBackground(label2.getParent().getBackground());
        label2.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#aaaaaa")));
        label2.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        label2.setText("");
        label2.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])label2.getFont().getFontData(), (int)2))));
        Label label3 = new Label(composite2, 0);
        label3.setBackground(label3.getParent().getBackground());
        label3.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#aaaaaa")));
        label3.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        label3.setText(MindMapMessages.Comment_FirstAdd_text);
        label3.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight((FontData[])label3.getFont().getFontData(), (int)2))));
        this.createInsertButtonSection(composite);
    }

    private void createInsertButtonSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 30;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.insertButton = new Button(composite, 8);
        this.insertButton.setBackground(composite.getBackground());
        GridData layoutData = new GridData(0x1000000, 0x1000000, true, false);
        layoutData.widthHint = 90;
        this.insertButton.setLayoutData((Object)layoutData);
        this.insertButton.setText(MindMapMessages.SheetCommentViewer_Insert_button);
        this.insertButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SheetCommentsViewer.this.insertComment();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.targetEditor != null) {
            this.targetEditor.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
            this.setSelection(this.targetEditor.getSite().getSelectionProvider().getSelection());
        } else {
            this.setSelection(null);
        }
    }

    private void createInsertCommentHyperlink(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 15;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.insertHyperlink = new Hyperlink(composite, 0);
        this.insertHyperlink.setBackground(composite.getBackground());
        this.insertHyperlink.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#0082F9")));
        GridData layoutData = new GridData(16384, 0x1000000, false, false);
        this.insertHyperlink.setLayoutData((Object)layoutData);
        this.insertHyperlink.setText(MindMapMessages.SheetCommentViewer_Insert_hyperlink);
        this.insertHyperlink.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                SheetCommentsViewer.this.insertComment();
            }
        });
        if (this.targetEditor != null) {
            this.targetEditor.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
            this.setSelection(this.targetEditor.getSite().getSelectionProvider().getSelection());
        } else {
            this.setSelection(null);
        }
    }

    private void insertComment() {
        if (this.select == null) {
            return;
        }
        String targetId = this.select.getId();
        if (this.container.isModified()) {
            this.container.setModified(false);
            ((CommentsPart)this.container).setInsertTarget(targetId);
            return;
        }
        this.insertComment(targetId);
    }

    private void insertComment(String targetId) {
        this.creatingTargetId = targetId;
        Composite contentComposite = this.container.getContentComposite();
        contentComposite.setRedraw(false);
        this.content.dispose();
        this.create(this.parent);
        this.createNewComment(targetId);
        contentComposite.pack();
        contentComposite.setRedraw(true);
        this.creatingTargetId = null;
    }

    private void update() {
        Composite contentComposite = this.container.getContentComposite();
        if (contentComposite == null || contentComposite.isDisposed()) {
            return;
        }
        contentComposite.setRedraw(false);
        this.content.dispose();
        this.create(this.parent);
        contentComposite.pack(true);
        contentComposite.layout(true, true);
        contentComposite.setRedraw(true);
    }

    private void registerControl(CommentTextViewer control) {
        this.controls.add(control);
    }

    private void registerImplementation(CommentTextViewer implementation) {
        this.implementations.add(implementation);
    }

    private void hookSheetTitle() {
        if (this.eventRegister == null) {
            this.eventRegister = new CoreEventRegister((Object)this.input, (ICoreEventListener)this);
        }
        this.eventRegister.register("titleText");
    }

    private void unhookSheetTitle() {
        if (this.eventRegister != null) {
            this.eventRegister.unregisterAll();
            this.eventRegister = null;
        }
    }

    public void handleCoreEvent(final CoreEvent event) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if ("titleText".equals(event.getType()) && SheetCommentsViewer.this.titleLabel != null && !SheetCommentsViewer.this.titleLabel.isDisposed()) {
                    SheetCommentsViewer.this.titleLabel.setText(String.valueOf(MindMapMessages.Comment_SHEET_text) + TextFormatter.removeNewLineCharacter((String)SheetCommentsViewer.this.input.getTitleText()));
                    SheetCommentsViewer.this.titleLabel.getParent().layout(true, true);
                }
            }
        });
    }

    private void handleControlDisposed(DisposeEvent e) {
        this.unhookSheetTitle();
        if (this.controls != null) {
            this.controls.clear();
            this.controls = null;
        }
        if (this.implementations != null) {
            this.implementations.clear();
            this.implementations = null;
        }
        if (this.topicViewers != null) {
            this.topicViewers.clear();
            this.topicViewers = null;
        }
    }

    public void setTargetEditor(IGraphicalEditor targetEditor) {
        if (targetEditor == this.targetEditor) {
            return;
        }
        if (this.targetEditor != null) {
            this.targetEditor.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.targetEditor = targetEditor;
        if (this.targetEditor != null) {
            this.targetEditor.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
            this.setSelection(targetEditor.getSite().getSelectionProvider().getSelection());
        } else {
            this.setSelection(null);
        }
        if (this.topicViewer != null) {
            this.topicViewer.setTargetEditor(targetEditor);
        }
        if (this.implementations != null) {
            for (CommentTextViewer implementation : this.implementations) {
                implementation.setTargetEditor(targetEditor);
            }
        }
    }

    public List<CommentTextViewer> getControls() {
        return this.controls;
    }

    public List<CommentTextViewer> getImplementations() {
        return this.controls;
    }

    public void createNewComment(String objectId) {
        Object object;
        if (this.newCommentControl != null && !this.newCommentControl.isDisposed()) {
            this.newCommentControl.dispose();
        }
        if ((object = this.input.getOwnedWorkbook().getElementById(objectId)) instanceof ITopic) {
            this.newCommentControl = this.topicViewers.get((ITopic)object).createNewComment();
        }
        if (object instanceof ISheet) {
            CommentTextViewer implementation = new CommentTextViewer(null, this.input.getId(), this.input.getOwnedWorkbook(), this.contributor, this.selectionProvider, this.container, this.targetEditor);
            this.newCommentControl = implementation.createControl(this.sheetCommentsComposite);
            this.newCommentControl.moveAbove(this.sheetCommentsComposite.getChildren()[0]);
            this.container.getContentComposite().pack();
            implementation.getTextViewer().getTextWidget().forceFocus();
        }
    }

    public void cancelCreateNewComment() {
        if (this.newCommentControl != null && !this.newCommentControl.isDisposed()) {
            this.newCommentControl.dispose();
            this.newCommentControl = null;
            this.update();
        }
    }

    public void save() {
        Composite contentComposite = this.container.getContentComposite();
        if (contentComposite != null && !contentComposite.isDisposed()) {
            contentComposite.forceFocus();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setSelection(event.getSelection());
    }

    private void setSelection(ISelection selection) {
        boolean isSingleTopic = MindMapUtils.isSingleTopic(selection);
        this.select = isSingleTopic ? (ITopic)MindMapUtils.getAllSuchElements(selection, "org.xmind.ui.topic").get(0) : null;
        if (this.insertButton != null && !this.insertButton.isDisposed()) {
            this.insertButton.setEnabled(isSingleTopic);
        }
        if (this.insertHyperlink != null && !this.insertHyperlink.isDisposed()) {
            this.insertHyperlink.setEnabled(isSingleTopic);
        }
        this.container.setModified(false);
    }
}

