/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.comments;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.actions.ActionFactory;
import org.xmind.core.IComment;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.internal.comments.CommentAction;
import org.xmind.ui.internal.comments.ICommentsActionBarContributor;
import org.xmind.ui.texteditor.IMenuContributor;
import org.xmind.ui.texteditor.ISpellingActivation;

public abstract class CommentsActionBarContributor
implements ICommentsActionBarContributor {
    protected IGraphicalEditor targetEditor;
    private Map<String, CommentAction> actions = new HashMap<String, CommentAction>();
    private ISpellingActivation spellingActivation;

    public CommentsActionBarContributor(IGraphicalEditor targetEditor) {
        this.targetEditor = targetEditor;
    }

    protected void makeActions() {
    }

    protected void addAction(CommentAction action) {
        if (action != null && action.getId() != null) {
            this.actions.put(action.getId(), action);
        }
    }

    @Override
    public void setSpellingActivation(ISpellingActivation spellingActivation) {
        this.spellingActivation = spellingActivation;
    }

    @Override
    public void fillToolBar(IToolBarManager toolbar) {
    }

    @Override
    public void fillContextMenu(IMenuManager menu) {
        IMenuContributor contributor;
        menu.add(this.getContextAction(ActionFactory.UNDO.getId()));
        menu.add(this.getContextAction(ActionFactory.REDO.getId()));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getContextAction(ActionFactory.CUT.getId()));
        menu.add(this.getContextAction(ActionFactory.COPY.getId()));
        menu.add(this.getContextAction(ActionFactory.PASTE.getId()));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getContextAction(ActionFactory.SELECT_ALL.getId()));
        if (this.spellingActivation != null && (contributor = (IMenuContributor)this.spellingActivation.getAdapter(IMenuContributor.class)) != null) {
            menu.add((IContributionItem)new Separator());
            contributor.fillMenu(menu);
        }
    }

    protected abstract IAction getContextAction(String var1);

    @Override
    public CommentAction getAction(String id) {
        return this.actions.get(id);
    }

    @Override
    public void selectionChanged(Object selection) {
        for (CommentAction action : this.actions.values()) {
            action.selectionChanged(selection);
        }
    }

    @Override
    public void selectedCommentChanged(IComment comment) {
        for (CommentAction action : this.actions.values()) {
            action.selectedCommentChanged(comment);
        }
    }

    @Override
    public void dispose() {
        this.actions.clear();
    }

    public void setTargetEditor(IGraphicalEditor targetEditor) {
        if (this.targetEditor != targetEditor) {
            this.targetEditor = targetEditor;
            for (Map.Entry<String, CommentAction> entry : this.actions.entrySet()) {
                entry.getValue().setTargetEditor(targetEditor);
            }
        }
    }
}

