/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.auth;

import com.evernote.auth.AuthException;
import com.evernote.auth.EvernoteService;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EvernoteAuth {
    private static final String CHARSET = "UTF-8";
    private static final String USER_STORE_PATH = "/edam/user";
    private static final Pattern TOKEN_REGEX = Pattern.compile("oauth_token=([^&]+)");
    private static final Pattern NOTESTORE_REGEX = Pattern.compile("edam_noteStoreUrl=([^&]+)");
    private static final Pattern WEBAPI_REGEX = Pattern.compile("edam_webApiUrlPrefix=([^&]+)");
    private static final Pattern USERID_REGEX = Pattern.compile("edam_userId=([^&]+)");
    private EvernoteService service;
    private String token;
    private String noteStoreUrl;
    private String webApiUrlPrefix;
    private int userId;

    public EvernoteAuth(EvernoteService service, String token) {
        if (service == null || token == null) {
            throw new IllegalArgumentException("EvernoteService and token must not be null.");
        }
        this.service = service;
        this.token = token;
    }

    public EvernoteAuth(EvernoteService service, String token, String noteStoreUrl, String webApiUrlPrefix, int userId) {
        if (service == null || token == null || noteStoreUrl == null || webApiUrlPrefix == null) {
            throw new IllegalArgumentException("EvernoteService, token, noteStoreUrl and webApiUrlPrefix must not be null.");
        }
        this.service = service;
        this.token = token;
        this.noteStoreUrl = noteStoreUrl;
        this.webApiUrlPrefix = webApiUrlPrefix;
        this.userId = userId;
    }

    public static EvernoteAuth parseOAuthResponse(EvernoteService service, String response) {
        if (service == null || response == null) {
            throw new IllegalArgumentException("EvernoteService and response must not be null.");
        }
        return new EvernoteAuth(service, EvernoteAuth.extractToken(response), EvernoteAuth.extractNoteStoreUrl(response), EvernoteAuth.extractWebApiUrl(response), Integer.parseInt(EvernoteAuth.extractUserId(response)));
    }

    static String extractToken(String response) {
        return EvernoteAuth.extract(response, TOKEN_REGEX);
    }

    static String extractNoteStoreUrl(String response) {
        return EvernoteAuth.extract(response, NOTESTORE_REGEX);
    }

    static String extractWebApiUrl(String response) {
        return EvernoteAuth.extract(response, WEBAPI_REGEX);
    }

    static String extractUserId(String response) {
        return EvernoteAuth.extract(response, USERID_REGEX);
    }

    private static String extract(String response, Pattern p) {
        Matcher matcher = p.matcher(response);
        if (matcher.find() && matcher.groupCount() >= 1 && matcher.group(1) != null) {
            try {
                return URLDecoder.decode(matcher.group(1), CHARSET);
            }
            catch (UnsupportedEncodingException e) {
                throw new AuthException("Charset not found while decoding string: UTF-8", e);
            }
        }
        throw new AuthException("Response body is incorrect. Can't extract token and secret from this: '" + response + "'", null);
    }

    public String getToken() {
        return this.token;
    }

    public String getUserStoreUrl() {
        return this.service.getEndpointUrl(USER_STORE_PATH);
    }

    public String getNoteStoreUrl() {
        return this.noteStoreUrl;
    }

    public void setNoteStoreUrl(String noteStoreUrl) {
        this.noteStoreUrl = noteStoreUrl;
    }

    public String getWebApiUrlPrefix() {
        return this.webApiUrlPrefix;
    }

    public int getUserId() {
        return this.userId;
    }
}

