/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public class ProgressIndicator
extends JPanel {
    ProgressMonitor m;
    private BoundedRangeModel progressModel;
    private JLabel messageLabel;
    private JLabel noteLabel;
    private JProgressBar progressBar;

    public ProgressIndicator() {
        this(null, null);
    }

    public ProgressIndicator(String message, String note) {
        this(message, note, 0, 100, true);
    }

    public ProgressIndicator(String message, String note, int min, int max, boolean indeterminate) {
        this.initComponents();
        this.messageLabel.setFont(this.messageLabel.getFont().deriveFont(1));
        this.progressModel = new DefaultBoundedRangeModel(0, 0, min, max);
        this.progressBar.setModel(this.progressModel);
        this.setMessage(message);
        this.setNote(note);
        this.setIndeterminate(indeterminate);
    }

    public void setMessage(String message) {
        this.messageLabel.setText(message);
    }

    public String getMessage() {
        return this.messageLabel.getText();
    }

    public void setNote(final String newValue) {
        String oldValue = this.noteLabel.getText();
        this.noteLabel.setText(newValue);
        if (oldValue == null || newValue == null && oldValue != newValue) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    ProgressIndicator.this.noteLabel.setVisible(newValue != null);
                    ProgressIndicator.this.validate();
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    public String getNote() {
        return this.noteLabel.getText();
    }

    public void setProgressModel(BoundedRangeModel m) {
        this.progressModel = m;
        this.progressBar.setModel(m);
    }

    public int getMinimum() {
        return this.progressModel.getMinimum();
    }

    public void setMinimum(int m) {
        this.progressModel.setMinimum(m);
    }

    public void setProgress(int nv) {
        this.progressModel.setValue(nv);
    }

    public int getMaximum() {
        return this.progressModel.getMaximum();
    }

    public void setMaximum(int m) {
        this.progressModel.setMaximum(m);
    }

    public void setIndeterminate(boolean b) {
        this.progressBar.setIndeterminate(b);
    }

    public boolean isIndeterminate() {
        return this.progressBar.isIndeterminate();
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        this.noteLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new GridBagLayout());
        this.messageLabel.setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.add((Component)this.messageLabel, gridBagConstraints);
        this.noteLabel.setHorizontalAlignment(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.noteLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.progressBar, gridBagConstraints);
    }
}

