/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class Pinyin4jAppletDemo
extends JApplet {
    private static final Dimension APP_SIZE = new Dimension(600, 400);
    private static final long serialVersionUID = -1934962385592030162L;
    private JPanel jContentPane = null;
    private JTabbedPane jTabbedPane = null;
    private JPanel formattedCharPanel = null;
    private JPanel optionPanel = null;
    private JButton convertButton = null;
    private JPanel buttonPanel = null;
    private JTextArea formattedOutputField = null;
    private JComboBox toneTypesComboBox = null;
    private JComboBox vCharTypesComboBox = null;
    private JComboBox caseTypesComboBox = null;
    private static String appName = "pinyin4j-2.0.0 applet demo";
    String[] caseTypes = new String[]{"LOWERCASE", "UPPERCASE"};
    String[] vCharTypes = new String[]{"WITH_U_AND_COLON", "WITH_V", "WITH_U_UNICODE"};
    String[] toneTypes = new String[]{"WITH_TONE_NUMBER", "WITHOUT_TONE", "WITH_TONE_MARK"};
    private JLabel toneLabel = null;
    private JLabel charLabel = null;
    private JTextField charTextField = null;
    private JPanel unformattedCharPanel = null;
    private JLabel unformattedHanyuPinyinLabel = null;
    private JTextArea unformattedHanyuPinyinTextArea = null;
    private JPanel unformattedHanyuPinyinPanel = null;
    private JPanel unformattedTongyongPinyinPanel = null;
    private JLabel unformattedTongyongPinyinLabel = null;
    private JTextArea unformattedTongyongPinyinTextArea = null;
    private JPanel unformattedWadePinyinPanel = null;
    private JLabel unformattedWadePinyinLabel = null;
    private JTextArea unformattedWadePinyinTextArea = null;
    private JPanel unformattedMPS2PinyinPanel = null;
    private JLabel unformattedMPS2PinyinLabel = null;
    private JTextArea unformattedMPS2PinyinTextArea = null;
    private JPanel unformattedYalePinyinPanel = null;
    private JLabel unformattedYalePinyinLabel = null;
    private JTextArea unformattedYalePinyinTextArea = null;
    private JPanel unformattedGwoyeuRomatzyhPanel = null;
    private JLabel unformattedGwoyeuRomatzyhLabel = null;
    private JTextArea unformattedGwoyeuRomatzyhTextArea = null;
    private JScrollPane unformattedMPS2PinyinScrollPane = null;
    private JScrollPane unformattedHanyuPinyinScrollPane = null;
    private JScrollPane unformattedTongyongPinyinScrollPane = null;
    private JScrollPane unformattedWadePinyinScrollPane = null;
    private JScrollPane unformattedYalePinyinScrollPane = null;
    private JScrollPane unformattedGwoyeuRomatzyhScrollPane = null;

    private JTextField getCharTextField() {
        if (this.charTextField == null) {
            this.charTextField = new JTextField();
            this.charTextField.setFont(new Font("Dialog", 0, 12));
            this.charTextField.setText("\u548c");
            this.charTextField.setPreferredSize(new Dimension(26, 20));
        }
        return this.charTextField;
    }

    private JPanel getUnformattedCharPanel() {
        if (this.unformattedCharPanel == null) {
            this.unformattedHanyuPinyinLabel = new JLabel();
            this.unformattedHanyuPinyinLabel.setText("Hanyu Pinyin");
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(2);
            gridLayout.setHgap(1);
            gridLayout.setVgap(1);
            gridLayout.setColumns(3);
            this.unformattedCharPanel = new JPanel();
            this.unformattedCharPanel.setLayout(gridLayout);
            this.unformattedCharPanel.add((Component)this.getUnformattedHanyuPinyinPanel(), null);
            this.unformattedCharPanel.add((Component)this.getUnformattedTongyongPinyinPanel(), null);
            this.unformattedCharPanel.add((Component)this.getUnformattedWadePinyinPanel(), null);
            this.unformattedCharPanel.add((Component)this.getUnformattedMPS2PinyinPanel(), null);
            this.unformattedCharPanel.add((Component)this.getUnformattedYalePinyinPanel(), null);
            this.unformattedCharPanel.add((Component)this.getUnformattedGwoyeuRomatzyhPanel(), null);
        }
        return this.unformattedCharPanel;
    }

    private JTextArea getUnformattedHanyuPinyinTextArea() {
        if (this.unformattedHanyuPinyinTextArea == null) {
            this.unformattedHanyuPinyinTextArea = new JTextArea();
            this.unformattedHanyuPinyinTextArea.setEditable(false);
            this.unformattedHanyuPinyinTextArea.setLineWrap(true);
        }
        return this.unformattedHanyuPinyinTextArea;
    }

    private JPanel getUnformattedHanyuPinyinPanel() {
        if (this.unformattedHanyuPinyinPanel == null) {
            this.unformattedHanyuPinyinPanel = new JPanel();
            this.unformattedHanyuPinyinPanel.setLayout(new BorderLayout());
            this.unformattedHanyuPinyinPanel.add((Component)this.unformattedHanyuPinyinLabel, "North");
            this.unformattedHanyuPinyinPanel.add((Component)this.getUnformattedHanyuPinyinScrollPane(), "Center");
        }
        return this.unformattedHanyuPinyinPanel;
    }

    private JPanel getUnformattedTongyongPinyinPanel() {
        if (this.unformattedTongyongPinyinPanel == null) {
            this.unformattedTongyongPinyinLabel = new JLabel();
            this.unformattedTongyongPinyinLabel.setText("Tongyong Pinyin");
            this.unformattedTongyongPinyinPanel = new JPanel();
            this.unformattedTongyongPinyinPanel.setLayout(new BorderLayout());
            this.unformattedTongyongPinyinPanel.add((Component)this.unformattedTongyongPinyinLabel, "North");
            this.unformattedTongyongPinyinPanel.add((Component)this.getUnformattedTongyongPinyinScrollPane(), "Center");
        }
        return this.unformattedTongyongPinyinPanel;
    }

    private JTextArea getUnformattedTongyongPinyinTextArea() {
        if (this.unformattedTongyongPinyinTextArea == null) {
            this.unformattedTongyongPinyinTextArea = new JTextArea();
            this.unformattedTongyongPinyinTextArea.setEditable(false);
            this.unformattedTongyongPinyinTextArea.setLineWrap(true);
        }
        return this.unformattedTongyongPinyinTextArea;
    }

    private JPanel getUnformattedWadePinyinPanel() {
        if (this.unformattedWadePinyinPanel == null) {
            this.unformattedWadePinyinLabel = new JLabel();
            this.unformattedWadePinyinLabel.setText("Wade-Giles  Pinyin");
            this.unformattedWadePinyinPanel = new JPanel();
            this.unformattedWadePinyinPanel.setLayout(new BorderLayout());
            this.unformattedWadePinyinPanel.add((Component)this.unformattedWadePinyinLabel, "North");
            this.unformattedWadePinyinPanel.add((Component)this.getUnformattedWadePinyinScrollPane(), "Center");
        }
        return this.unformattedWadePinyinPanel;
    }

    private JTextArea getUnformattedWadePinyinTextArea() {
        if (this.unformattedWadePinyinTextArea == null) {
            this.unformattedWadePinyinTextArea = new JTextArea();
            this.unformattedWadePinyinTextArea.setEditable(false);
            this.unformattedWadePinyinTextArea.setLineWrap(true);
        }
        return this.unformattedWadePinyinTextArea;
    }

    private JPanel getUnformattedMPS2PinyinPanel() {
        if (this.unformattedMPS2PinyinPanel == null) {
            this.unformattedMPS2PinyinLabel = new JLabel();
            this.unformattedMPS2PinyinLabel.setText("MPSII Pinyin");
            this.unformattedMPS2PinyinPanel = new JPanel();
            this.unformattedMPS2PinyinPanel.setLayout(new BorderLayout());
            this.unformattedMPS2PinyinPanel.add((Component)this.unformattedMPS2PinyinLabel, "North");
            this.unformattedMPS2PinyinPanel.add((Component)this.getUnformattedMPS2PinyinScrollPane(), "Center");
        }
        return this.unformattedMPS2PinyinPanel;
    }

    private JTextArea getUnformattedMPS2PinyinTextArea() {
        if (this.unformattedMPS2PinyinTextArea == null) {
            this.unformattedMPS2PinyinTextArea = new JTextArea();
            this.unformattedMPS2PinyinTextArea.setEditable(false);
            this.unformattedMPS2PinyinTextArea.setLineWrap(true);
        }
        return this.unformattedMPS2PinyinTextArea;
    }

    private JPanel getUnformattedYalePinyinPanel() {
        if (this.unformattedYalePinyinPanel == null) {
            this.unformattedYalePinyinLabel = new JLabel();
            this.unformattedYalePinyinLabel.setText("Yale Pinyin");
            this.unformattedYalePinyinPanel = new JPanel();
            this.unformattedYalePinyinPanel.setLayout(new BorderLayout());
            this.unformattedYalePinyinPanel.add((Component)this.unformattedYalePinyinLabel, "North");
            this.unformattedYalePinyinPanel.add((Component)this.getUnformattedYalePinyinScrollPane(), "Center");
        }
        return this.unformattedYalePinyinPanel;
    }

    private JTextArea getUnformattedYalePinyinTextArea() {
        if (this.unformattedYalePinyinTextArea == null) {
            this.unformattedYalePinyinTextArea = new JTextArea();
            this.unformattedYalePinyinTextArea.setEditable(false);
            this.unformattedYalePinyinTextArea.setLineWrap(true);
        }
        return this.unformattedYalePinyinTextArea;
    }

    private JPanel getUnformattedGwoyeuRomatzyhPanel() {
        if (this.unformattedGwoyeuRomatzyhPanel == null) {
            this.unformattedGwoyeuRomatzyhLabel = new JLabel();
            this.unformattedGwoyeuRomatzyhLabel.setText("Gwoyeu Romatzyh");
            this.unformattedGwoyeuRomatzyhPanel = new JPanel();
            this.unformattedGwoyeuRomatzyhPanel.setLayout(new BorderLayout());
            this.unformattedGwoyeuRomatzyhPanel.add((Component)this.unformattedGwoyeuRomatzyhLabel, "North");
            this.unformattedGwoyeuRomatzyhPanel.add((Component)this.getUnformattedGwoyeuRomatzyhScrollPane(), "Center");
        }
        return this.unformattedGwoyeuRomatzyhPanel;
    }

    private JTextArea getUnformattedGwoyeuRomatzyhTextArea() {
        if (this.unformattedGwoyeuRomatzyhTextArea == null) {
            this.unformattedGwoyeuRomatzyhTextArea = new JTextArea();
            this.unformattedGwoyeuRomatzyhTextArea.setEditable(false);
            this.unformattedGwoyeuRomatzyhTextArea.setLineWrap(true);
        }
        return this.unformattedGwoyeuRomatzyhTextArea;
    }

    private JScrollPane getUnformattedMPS2PinyinScrollPane() {
        if (this.unformattedMPS2PinyinScrollPane == null) {
            this.unformattedMPS2PinyinScrollPane = new JScrollPane();
            this.unformattedMPS2PinyinScrollPane.setViewportView(this.getUnformattedMPS2PinyinTextArea());
        }
        return this.unformattedMPS2PinyinScrollPane;
    }

    private JScrollPane getUnformattedHanyuPinyinScrollPane() {
        if (this.unformattedHanyuPinyinScrollPane == null) {
            this.unformattedHanyuPinyinScrollPane = new JScrollPane();
            this.unformattedHanyuPinyinScrollPane.setViewportView(this.getUnformattedHanyuPinyinTextArea());
        }
        return this.unformattedHanyuPinyinScrollPane;
    }

    private JScrollPane getUnformattedTongyongPinyinScrollPane() {
        if (this.unformattedTongyongPinyinScrollPane == null) {
            this.unformattedTongyongPinyinScrollPane = new JScrollPane();
            this.unformattedTongyongPinyinScrollPane.setViewportView(this.getUnformattedTongyongPinyinTextArea());
        }
        return this.unformattedTongyongPinyinScrollPane;
    }

    private JScrollPane getUnformattedWadePinyinScrollPane() {
        if (this.unformattedWadePinyinScrollPane == null) {
            this.unformattedWadePinyinScrollPane = new JScrollPane();
            this.unformattedWadePinyinScrollPane.setViewportView(this.getUnformattedWadePinyinTextArea());
        }
        return this.unformattedWadePinyinScrollPane;
    }

    private JScrollPane getUnformattedYalePinyinScrollPane() {
        if (this.unformattedYalePinyinScrollPane == null) {
            this.unformattedYalePinyinScrollPane = new JScrollPane();
            this.unformattedYalePinyinScrollPane.setViewportView(this.getUnformattedYalePinyinTextArea());
        }
        return this.unformattedYalePinyinScrollPane;
    }

    private JScrollPane getUnformattedGwoyeuRomatzyhScrollPane() {
        if (this.unformattedGwoyeuRomatzyhScrollPane == null) {
            this.unformattedGwoyeuRomatzyhScrollPane = new JScrollPane();
            this.unformattedGwoyeuRomatzyhScrollPane.setViewportView(this.getUnformattedGwoyeuRomatzyhTextArea());
        }
        return this.unformattedGwoyeuRomatzyhScrollPane;
    }

    public static void main(String[] stringArray) {
        final Pinyin4jAppletDemo pinyin4jAppletDemo = new Pinyin4jAppletDemo();
        System.runFinalizersOnExit((boolean)true);
        JFrame jFrame = new JFrame(appName);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                pinyin4jAppletDemo.stop();
                pinyin4jAppletDemo.destroy();
                System.exit(0);
            }
        });
        jFrame.add("Center", pinyin4jAppletDemo);
        pinyin4jAppletDemo.init();
        pinyin4jAppletDemo.start();
        jFrame.setSize(APP_SIZE);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public Pinyin4jAppletDemo() {
        this.init();
    }

    public void init() {
        this.setSize(APP_SIZE);
        this.setContentPane(this.getJContentPane());
        this.setName(appName);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJTabbedPane(), "Center");
            this.jContentPane.add((Component)this.getOptionPanel(), "North");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.jContentPane;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.addTab("Unformatted Chinese Romanization Systems", null, this.getUnformattedCharPanel(), null);
            this.jTabbedPane.addTab("Formatted Hanyu Pinyin", null, this.getFormattedCharPanel(), null);
        }
        return this.jTabbedPane;
    }

    private JPanel getFormattedCharPanel() {
        if (this.formattedCharPanel == null) {
            this.formattedCharPanel = new JPanel();
            this.formattedCharPanel.setLayout(new BorderLayout());
            this.formattedCharPanel.add((Component)this.getFormattedOutputField(), "Center");
        }
        return this.formattedCharPanel;
    }

    private JPanel getOptionPanel() {
        if (this.optionPanel == null) {
            this.charLabel = new JLabel();
            this.charLabel.setText("Input Chinese:");
            this.toneLabel = new JLabel();
            this.toneLabel.setText(" Format:");
            this.optionPanel = new JPanel();
            this.optionPanel.setPreferredSize(new Dimension(640, 34));
            this.optionPanel.add((Component)this.charLabel, null);
            this.optionPanel.add((Component)this.getCharTextField(), null);
            this.optionPanel.add((Component)this.toneLabel, null);
            this.optionPanel.add((Component)this.getToneTypesComboBox(), null);
            this.optionPanel.add((Component)this.getVCharTypesComboBox(), null);
            this.optionPanel.add((Component)this.getCaseTypesComboBox(), null);
        }
        return this.optionPanel;
    }

    private JButton getConvertButton() {
        if (this.convertButton == null) {
            this.convertButton = new JButton();
            this.convertButton.setText("Convert to Pinyin");
            this.convertButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    char c = Pinyin4jAppletDemo.this.getChineseCharText().charAt(0);
                    this.updateUnformattedTextField(c);
                    String string = (String)Pinyin4jAppletDemo.this.toneTypesComboBox.getSelectedItem();
                    String string2 = (String)Pinyin4jAppletDemo.this.vCharTypesComboBox.getSelectedItem();
                    String string3 = (String)Pinyin4jAppletDemo.this.caseTypesComboBox.getSelectedItem();
                    this.updateFormattedTextField(c, string, string2, string3);
                }

                private void updateUnformattedTextField(char c) {
                    Pinyin4jAppletDemo.this.unformattedHanyuPinyinTextArea.setText(this.concatPinyinStringArray(PinyinHelper.toHanyuPinyinStringArray(c)));
                    Pinyin4jAppletDemo.this.unformattedTongyongPinyinTextArea.setText(this.concatPinyinStringArray(PinyinHelper.toTongyongPinyinStringArray(c)));
                    Pinyin4jAppletDemo.this.unformattedWadePinyinTextArea.setText(this.concatPinyinStringArray(PinyinHelper.toWadeGilesPinyinStringArray(c)));
                    Pinyin4jAppletDemo.this.unformattedMPS2PinyinTextArea.setText(this.concatPinyinStringArray(PinyinHelper.toMPS2PinyinStringArray(c)));
                    Pinyin4jAppletDemo.this.unformattedYalePinyinTextArea.setText(this.concatPinyinStringArray(PinyinHelper.toYalePinyinStringArray(c)));
                    Pinyin4jAppletDemo.this.unformattedGwoyeuRomatzyhTextArea.setText(this.concatPinyinStringArray(PinyinHelper.toGwoyeuRomatzyhStringArray(c)));
                }

                private void updateFormattedTextField(char c, String string, String string2, String string3) {
                    HanyuPinyinOutputFormat hanyuPinyinOutputFormat = new HanyuPinyinOutputFormat();
                    if (Pinyin4jAppletDemo.this.toneTypes[0] == string) {
                        hanyuPinyinOutputFormat.setToneType(HanyuPinyinToneType.WITH_TONE_NUMBER);
                    } else if (Pinyin4jAppletDemo.this.toneTypes[1] == string) {
                        hanyuPinyinOutputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
                    } else if (Pinyin4jAppletDemo.this.toneTypes[2] == string) {
                        hanyuPinyinOutputFormat.setToneType(HanyuPinyinToneType.WITH_TONE_MARK);
                    }
                    if (Pinyin4jAppletDemo.this.vCharTypes[0] == string2) {
                        hanyuPinyinOutputFormat.setVCharType(HanyuPinyinVCharType.WITH_U_AND_COLON);
                    } else if (Pinyin4jAppletDemo.this.vCharTypes[1] == string2) {
                        hanyuPinyinOutputFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
                    } else if (Pinyin4jAppletDemo.this.vCharTypes[2] == string2) {
                        hanyuPinyinOutputFormat.setVCharType(HanyuPinyinVCharType.WITH_U_UNICODE);
                    }
                    if (Pinyin4jAppletDemo.this.caseTypes[0] == string3) {
                        hanyuPinyinOutputFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
                    } else if (Pinyin4jAppletDemo.this.caseTypes[1] == string3) {
                        hanyuPinyinOutputFormat.setCaseType(HanyuPinyinCaseType.UPPERCASE);
                    }
                    String[] stringArray = null;
                    try {
                        stringArray = PinyinHelper.toHanyuPinyinStringArray(c, hanyuPinyinOutputFormat);
                    }
                    catch (BadHanyuPinyinOutputFormatCombination badHanyuPinyinOutputFormatCombination) {
                        badHanyuPinyinOutputFormatCombination.printStackTrace();
                    }
                    String string4 = this.concatPinyinStringArray(stringArray);
                    Pinyin4jAppletDemo.this.formattedOutputField.setText(string4);
                }

                private String concatPinyinStringArray(String[] stringArray) {
                    StringBuffer stringBuffer = new StringBuffer();
                    if (null != stringArray && stringArray.length > 0) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            stringBuffer.append(stringArray[i]);
                            stringBuffer.append(System.getProperty("line.separator"));
                        }
                    }
                    String string = stringBuffer.toString();
                    return string;
                }
            });
        }
        return this.convertButton;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.add((Component)this.getConvertButton(), null);
        }
        return this.buttonPanel;
    }

    private JTextArea getFormattedOutputField() {
        if (this.formattedOutputField == null) {
            this.formattedOutputField = new JTextArea();
            this.formattedOutputField.setEditable(false);
        }
        return this.formattedOutputField;
    }

    private JComboBox getToneTypesComboBox() {
        if (this.toneTypesComboBox == null) {
            this.toneTypesComboBox = new JComboBox<String>(this.toneTypes);
            this.toneTypesComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Pinyin4jAppletDemo.this.toneTypes[2] == (String)Pinyin4jAppletDemo.this.toneTypesComboBox.getSelectedItem()) {
                        Pinyin4jAppletDemo.this.vCharTypesComboBox.setSelectedIndex(2);
                        Pinyin4jAppletDemo.this.vCharTypesComboBox.setEnabled(false);
                    } else {
                        Pinyin4jAppletDemo.this.vCharTypesComboBox.setEnabled(true);
                    }
                }
            });
        }
        return this.toneTypesComboBox;
    }

    private JComboBox getVCharTypesComboBox() {
        if (this.vCharTypesComboBox == null) {
            this.vCharTypesComboBox = new JComboBox<String>(this.vCharTypes);
        }
        return this.vCharTypesComboBox;
    }

    private JComboBox getCaseTypesComboBox() {
        if (this.caseTypesComboBox == null) {
            this.caseTypesComboBox = new JComboBox<String>(this.caseTypes);
        }
        return this.caseTypesComboBox;
    }

    private String getChineseCharText() {
        return this.charTextField.getText();
    }
}

