/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import com.nexes.wizard.Wizard;
import com.nexes.wizard.WizardModel;
import com.nexes.wizard.WizardPanelDescriptor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.alert.GoogleMail;
import org.yccheok.jstock.analysis.Indicator;
import org.yccheok.jstock.analysis.OperatorIndicator;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Duration;
import org.yccheok.jstock.engine.Observer;
import org.yccheok.jstock.engine.RealTimeStockMonitor;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockHistoryMonitor;
import org.yccheok.jstock.engine.StockHistorySerializer;
import org.yccheok.jstock.engine.StockHistoryServer;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.StockInfoDatabase;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.file.Statements;
import org.yccheok.jstock.file.UserDataDirectory;
import org.yccheok.jstock.file.UserDataFile;
import org.yccheok.jstock.gui.AlertStateManager;
import org.yccheok.jstock.gui.FairUsagePolicyJDialog;
import org.yccheok.jstock.gui.GUIOptions;
import org.yccheok.jstock.gui.IndicatorProjectManager;
import org.yccheok.jstock.gui.IndicatorTableModel;
import org.yccheok.jstock.gui.JStock;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.JTableUtilities;
import org.yccheok.jstock.gui.StockTableCellRenderer;
import org.yccheok.jstock.gui.TableColumnSelectionPopupListener;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.gui.WizardSelectIndicatorDescriptor;
import org.yccheok.jstock.gui.WizardSelectIndicatorJPanel;
import org.yccheok.jstock.gui.WizardSelectStockDescriptor;
import org.yccheok.jstock.gui.WizardSelectStockJPanel;
import org.yccheok.jstock.internationalization.GUIBundle;

public class IndicatorScannerJPanel
extends JPanel
implements ChangeListener,
Observer<Indicator, Boolean> {
    private Wizard wizard;
    private RealTimeStockMonitor realTimeStockMonitor;
    private final Observer<RealTimeStockMonitor, RealTimeStockMonitor.Result> realTimeStockMonitorObserver = this.getRealTimeStockMonitorObserver();
    private final Map<Code, List<OperatorIndicator>> operatorIndicators = new ConcurrentHashMap<Code, List<OperatorIndicator>>();
    private Set<Code> successCodes;
    private Set<Code> failedCodes;
    private AlertStateManager alertStateManager;
    private ExecutorService emailAlertPool;
    private ExecutorService systemTrayAlertPool;
    private final Observer<StockHistoryMonitor, StockHistoryMonitor.StockHistoryRunnable> stockHistoryMonitorObserver = this.getStockHistoryMonitorObserver();
    private StockHistoryMonitor stockHistoryMonitor = null;
    private volatile Boolean allowIndicatorShown = true;
    private volatile boolean stop_button_pressed = true;
    private final Lock reader;
    private final Lock writer;
    private volatile Thread startScanThread = null;
    private static final Log log = LogFactory.getLog(IndicatorScannerJPanel.class);
    private static final int HISTORY_MONITOR_MAX_THREAD = 4;
    private JButton jButton1;
    private JButton jButton2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public IndicatorScannerJPanel() {
        this.initComponents();
        this.initTableHeaderToolTips();
        this.initGUIOptions();
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.reader = readWriteLock.readLock();
        this.writer = readWriteLock.writeLock();
        this.initRealTimeStockMonitor();
        this.initStockHistoryMonitor();
        this.initAlertDataStructures();
        this.initCompleteProgressDataStructures();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.setLayout(new BorderLayout(5, 5));
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/player_play.png")));
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.jButton1.setText(bundle.getString("IndicatorScannerJPanel_Scan..."));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndicatorScannerJPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton1);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/stop.png")));
        this.jButton2.setText(bundle.getString("IndicatorScannerJPanel_Stop"));
        this.jButton2.setEnabled(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IndicatorScannerJPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton2);
        this.add((Component)this.jPanel1, "South");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(bundle.getString("IndicatorScannerJPanel_IndicatorScanResult")));
        this.jPanel2.setLayout(new BorderLayout());
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setFont(this.jTable1.getFont().deriveFont(this.jTable1.getFont().getStyle() | 1, this.jTable1.getFont().getSize() + 1));
        this.jTable1.setModel(new IndicatorTableModel());
        this.jTable1.setAutoResizeMode(0);
        this.jTable1.setDefaultRenderer(Number.class, new StockTableCellRenderer(4));
        this.jTable1.setDefaultRenderer(Double.class, new StockTableCellRenderer(4));
        this.jTable1.setDefaultRenderer(Object.class, new StockTableCellRenderer(2));
        this.jTable1.getTableHeader().addMouseListener(new TableColumnSelectionPopupListener(2));
        this.jTable1.addMouseListener(new TableRowPopupListener());
        this.jTable1.addKeyListener(new TableKeyEventListener());
        if (JStock.instance().getJStockOptions().useLargeFont()) {
            this.jTable1.setRowHeight((int)((double)this.jTable1.getRowHeight() * 1.2));
        }
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.add((Component)this.jPanel2, "Center");
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.stop();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        assert (this.startScanThread == null);
        JStock mainFrame = JStock.instance();
        FairUsagePolicyJDialog fairUsagePolicyJDialog = new FairUsagePolicyJDialog((Frame)mainFrame, true);
        fairUsagePolicyJDialog.setLocationRelativeTo(this);
        fairUsagePolicyJDialog.setVisible(true);
        int speed = fairUsagePolicyJDialog.getSpeed();
        if (speed == 0) {
            return;
        }
        JStock.instance().getJStockOptions().setIndicatorScanningSpeed(speed);
        this.realTimeStockMonitor.setDelay(speed);
        this.stop_button_pressed = false;
        JStock m = JStock.instance();
        if (m.getStockInfoDatabase() == null) {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("org/yccheok/jstock/data/messages").getString("info_message_we_havent_connected_to_stock_server"), ResourceBundle.getBundle("org/yccheok/jstock/data/messages").getString("info_title_we_havent_connected_to_stock_server"), 1);
            return;
        }
        this.allowIndicatorShown = true;
        this.initWizardDialog();
        int ret = this.wizard.showModalDialog(680, -1, false);
        if (ret != 0) {
            return;
        }
        WizardModel wizardModel = this.wizard.getModel();
        this.startScanThread = this.getStartScanThread(wizardModel);
        this.startScanThread.start();
        this.jButton1.setEnabled(false);
        this.jButton2.setEnabled(true);
        m.setStatusBar(true, GUIBundle.getString("IndicatorScannerJPanel_IndicatorScannerIsScanning..."));
    }

    public void initGUIOptions() {
        File f = new File(UserDataDirectory.Config.get() + UserDataFile.IndicatorScannerJPanelXml.get());
        GUIOptions guiOptions = Utils.fromXML(GUIOptions.class, f);
        if (guiOptions == null) {
            JTableUtilities.removeTableColumn(this.jTable1, GUIBundle.getString("MainFrame_Open"));
            return;
        }
        if (guiOptions.getJTableOptionsSize() <= 0) {
            JTableUtilities.removeTableColumn(this.jTable1, GUIBundle.getString("MainFrame_Open"));
            return;
        }
        JTableUtilities.setJTableOptions(this.jTable1, guiOptions.getJTableOptions(0));
    }

    public boolean saveGUIOptions() {
        if (!Utils.createCompleteDirectoryHierarchyIfDoesNotExist(UserDataDirectory.Config.get())) {
            return false;
        }
        GUIOptions.JTableOptions jTableOptions = new GUIOptions.JTableOptions();
        int count = this.jTable1.getColumnCount();
        for (int i = 0; i < count; ++i) {
            String name = this.jTable1.getColumnName(i);
            TableColumn column = this.jTable1.getColumnModel().getColumn(i);
            jTableOptions.addColumnOption(GUIOptions.JTableOptions.ColumnOption.newInstance(name, column.getWidth()));
        }
        GUIOptions guiOptions = new GUIOptions();
        guiOptions.addJTableOptions(jTableOptions);
        File f = new File(UserDataDirectory.Config.get() + UserDataFile.IndicatorScannerJPanelXml.get());
        return Utils.toXML((Object)guiOptions, f);
    }

    private void initOperatorIndicators(WizardModel wizardModel) {
        List<Object> result;
        this.operatorIndicators.clear();
        WizardPanelDescriptor wizardPanelDescriptor0 = wizardModel.getPanelDescriptor("SELECT_STOCK_PANEL");
        WizardSelectStockJPanel wizardSelectStockJPanel = (WizardSelectStockJPanel)wizardPanelDescriptor0.getPanelComponent();
        WizardPanelDescriptor wizardPanelDescriptor1 = wizardModel.getPanelDescriptor("SELECT_INDICATOR_PANEL");
        WizardSelectIndicatorJPanel wizardSelectIndicatorJPanel = (WizardSelectIndicatorJPanel)wizardPanelDescriptor1.getPanelComponent();
        JStock m = JStock.instance();
        IndicatorProjectManager alertIndicatorProjectManager = m.getAlertIndicatorProjectManager();
        List<String> projects = wizardSelectIndicatorJPanel.getSelectedProjects();
        List<StockInfo> stockInfos = wizardSelectStockJPanel.getSelectedStockInfos();
        for (StockInfo stockInfo : stockInfos) {
            if (this.stop_button_pressed) {
                return;
            }
            result = new ArrayList();
            this.operatorIndicators.put(stockInfo.code, result);
            for (String project : projects) {
                OperatorIndicator operatorIndicator = alertIndicatorProjectManager.getOperatorIndicator(project);
                if (operatorIndicator == null) continue;
                Stock stock = org.yccheok.jstock.engine.Utils.getEmptyStock(stockInfo);
                operatorIndicator.setStock(stock);
                result.add(operatorIndicator);
            }
        }
        for (StockInfo stockInfo : stockInfos) {
            if (this.stop_button_pressed) {
                return;
            }
            result = this.operatorIndicators.get(stockInfo.code);
            if (result != null) {
                this.submitOperatorIndicatorToMonitor(result);
            }
            try {
                Thread.sleep(JStock.instance().getJStockOptions().getIndicatorScanningSpeed());
            }
            catch (InterruptedException ex) {
                log.error(null, (Throwable)ex);
                break;
            }
        }
    }

    private void submitOperatorIndicatorToMonitor(List<OperatorIndicator> indicators) {
        Duration historyDuration = Duration.getTodayDurationByDays(0);
        for (OperatorIndicator operatorIndicator : indicators) {
            historyDuration = historyDuration.getUnionDuration(operatorIndicator.getNeededStockHistoryDuration());
        }
        this.stockHistoryMonitor.setDuration(historyDuration);
        boolean done = true;
        for (OperatorIndicator operatorIndicator : indicators) {
            if (this.stop_button_pressed) {
                return;
            }
            if (!operatorIndicator.isStockHistoryCalculationDone()) {
                done = false;
                break;
            }
            operatorIndicator.preCalculate();
        }
        if (indicators.size() > 0) {
            Code code = indicators.get((int)0).getStock().code;
            if (done) {
                this.realTimeStockMonitor.addStockCode(code);
                this.realTimeStockMonitor.startNewThreadsIfNecessary();
                this.realTimeStockMonitor.refresh();
            } else {
                StockHistoryServer stockHistoryServer = this.stockHistoryMonitor.getStockHistoryServer(code);
                if (stockHistoryServer == null) {
                    this.stockHistoryMonitor.addStockCode(code);
                } else {
                    this.processHistory(code, stockHistoryServer);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(final Indicator indicator, Boolean result) {
        Runnable r;
        ExecutorService _emailAlertPool = null;
        ExecutorService _systemTrayAlertPool = null;
        this.reader.lock();
        try {
            _emailAlertPool = this.emailAlertPool;
            _systemTrayAlertPool = this.systemTrayAlertPool;
            if (this.stop_button_pressed) {
                return;
            }
        }
        finally {
            this.reader.unlock();
        }
        boolean flag = result;
        if (!flag) {
            this.removeIndicatorFromTable(indicator);
            return;
        }
        this.addIndicatorToTable(indicator);
        final JStock m = JStock.instance();
        final JStockOptions jStockOptions = m.getJStockOptions();
        if (jStockOptions.isPopupMessage()) {
            r = new Runnable(){

                @Override
                public void run() {
                    Stock stock = indicator.getStock();
                    double price = stock.getLastPrice();
                    String template = GUIBundle.getString("IndicatorScannerJPanel_Hit_template");
                    String message = MessageFormat.format(template, stock.symbol, price, indicator.toString());
                    if (jStockOptions.isPopupMessage()) {
                        m.displayPopupMessage(stock.symbol.toString(), message);
                        if (jStockOptions.isSoundEnabled()) {
                            Utils.playAlertSound();
                        }
                        try {
                            Thread.sleep(jStockOptions.getAlertSpeed() * 1000);
                        }
                        catch (InterruptedException exp) {
                            log.error(null, (Throwable)exp);
                        }
                    }
                }
            };
            try {
                _systemTrayAlertPool.submit(r);
            }
            catch (RejectedExecutionException exp) {
                log.error(null, (Throwable)exp);
            }
        }
        if (!jStockOptions.isPopupMessage() && jStockOptions.isSoundEnabled()) {
            r = new Runnable(){

                @Override
                public void run() {
                    if (jStockOptions.isSoundEnabled()) {
                        Utils.playAlertSound();
                        try {
                            Thread.sleep(jStockOptions.getAlertSpeed() * 1000);
                        }
                        catch (InterruptedException exp) {
                            log.error(null, (Throwable)exp);
                        }
                    }
                }
            };
            try {
                _systemTrayAlertPool.submit(r);
            }
            catch (RejectedExecutionException exp) {
                log.error(null, (Throwable)exp);
            }
        }
        if (jStockOptions.isSendEmail()) {
            r = new Runnable(){

                @Override
                public void run() {
                    Stock stock = indicator.getStock();
                    double price = stock.getLastPrice();
                    String template = GUIBundle.getString("IndicatorScannerJPanel_Hit_template");
                    String title = MessageFormat.format(template, stock.symbol, price, indicator.toString());
                    String message = title + "\n(JStock)";
                    String ccEmail = Utils.decrypt(jStockOptions.getCCEmail());
                    try {
                        GoogleMail.Send(ccEmail, title, message);
                    }
                    catch (Exception ex) {
                        log.error(null, (Throwable)ex);
                    }
                }
            };
            try {
                _emailAlertPool.submit(r);
            }
            catch (RejectedExecutionException exp) {
                log.error(null, (Throwable)exp);
            }
        }
    }

    private void initTableHeaderToolTips() {
        JTableHeader header = this.jTable1.getTableHeader();
        ColumnHeaderToolTips tips = new ColumnHeaderToolTips();
        header.addMouseMotionListener(tips);
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
    }

    public void clear() {
        this.initRealTimeStockMonitor();
        this.initStockHistoryMonitor();
        this.operatorIndicators.clear();
        this.allowIndicatorShown = false;
        this.removeAllIndicatorsFromTable();
        JStock m = JStock.instance();
        m.setStatusBar(false, GUIBundle.getString("IndicatorScannerJPanel_Connected"));
    }

    public void stop() {
        this.writer.lock();
        try {
            this.stop_button_pressed = true;
            Thread thread = this.startScanThread;
            this.startScanThread = null;
            if (thread != null) {
                thread.interrupt();
                try {
                    thread.join();
                }
                catch (InterruptedException ex) {
                    log.error(null, (Throwable)ex);
                }
            }
            JStock m = JStock.instance();
            this.initRealTimeStockMonitor();
            this.initStockHistoryMonitor();
            this.initAlertDataStructures();
            this.initCompleteProgressDataStructures();
        }
        finally {
            this.writer.unlock();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IndicatorScannerJPanel.this.jButton1.setEnabled(true);
                IndicatorScannerJPanel.this.jButton2.setEnabled(false);
            }
        });
        JStock.instance().setStatusBar(false, ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("IndicatorScannerJPanel_Connected"));
    }

    private void initWizardDialog() {
        JStock m = JStock.instance();
        this.wizard = new Wizard(m);
        this.wizard.getDialog().setTitle(ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("IndicatorScannerJPanel_IndicatorScanningWizard"));
        this.wizard.getDialog().setResizable(false);
        WizardSelectIndicatorDescriptor wizardSelectIndicatorDescriptor = new WizardSelectIndicatorDescriptor();
        this.wizard.registerWizardPanel("SELECT_INDICATOR_PANEL", wizardSelectIndicatorDescriptor);
        WizardSelectStockDescriptor wizardSelectStockDescriptor = new WizardSelectStockDescriptor(m.getStockInfoDatabase());
        this.wizard.registerWizardPanel("SELECT_STOCK_PANEL", wizardSelectStockDescriptor);
        this.wizard.setCurrentPanel("SELECT_INDICATOR_PANEL");
        this.wizard.getDialog().setLocationRelativeTo(null);
    }

    public void updateScanningSpeed(int speed) {
        this.realTimeStockMonitor.setDelay(speed);
    }

    public final void initStockHistoryMonitor() {
        final StockHistoryMonitor oldStockHistoryMonitor = this.stockHistoryMonitor;
        if (oldStockHistoryMonitor != null) {
            Utils.getZoombiePool().execute(new Runnable(){

                @Override
                public void run() {
                    log.info((Object)("Prepare to shut down " + oldStockHistoryMonitor + "..."));
                    oldStockHistoryMonitor.clearStockCodes();
                    oldStockHistoryMonitor.dettachAll();
                    oldStockHistoryMonitor.stop();
                    log.info((Object)("Shut down " + oldStockHistoryMonitor + " peacefully."));
                }
            });
        }
        this.stockHistoryMonitor = new StockHistoryMonitor(4);
        this.stockHistoryMonitor.attach(this.stockHistoryMonitorObserver);
        this.stockHistoryMonitor.setStockHistorySerializer(new StockHistorySerializer(Utils.getHistoryDirectory()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processHistory(Code code, StockHistoryServer stockHistoryServer) {
        Set<Code> _failedCodes = null;
        RealTimeStockMonitor _realTimeStockMonitor = null;
        this.reader.lock();
        try {
            _failedCodes = this.failedCodes;
            _realTimeStockMonitor = this.realTimeStockMonitor;
            if (this.stop_button_pressed) {
                return;
            }
        }
        finally {
            this.reader.unlock();
        }
        JStock m = JStock.instance();
        List<OperatorIndicator> indicators = this.operatorIndicators.get(code);
        if (indicators == null) {
            return;
        }
        if (stockHistoryServer == null) {
            _failedCodes.add(code);
            Symbol symbol = m.getStockInfoDatabase().codeToSymbol(code);
            String template = GUIBundle.getString("IndicatorScannerJPanel_IndicatorScannerFoundHistory_template");
            ScannedResult scannedResult = this.getScannedResult();
            String message = MessageFormat.format(template, symbol != null ? symbol : code, scannedResult.getTotal(), scannedResult.expected, this.getCompleteScannedStocksPercentage(scannedResult));
            this.updateStatusBarIfStopButtonIsNotPressed(message);
            return;
        }
        _failedCodes.remove(code);
        Symbol symbol = m.getStockInfoDatabase().codeToSymbol(code);
        String template = GUIBundle.getString("IndicatorScannerJPanel_IndicatorScannerFoundHistory_template");
        ScannedResult scannedResult = this.getScannedResult();
        String message = MessageFormat.format(template, symbol != null ? symbol : code, scannedResult.getTotal(), scannedResult.expected, this.getCompleteScannedStocksPercentage(scannedResult));
        this.updateStatusBarIfStopButtonIsNotPressed(message);
        for (OperatorIndicator operatorIndicator : indicators) {
            if (operatorIndicator.isStockHistoryServerNeeded()) {
                operatorIndicator.setStockHistoryServer(stockHistoryServer);
            }
            operatorIndicator.preCalculate();
        }
        _realTimeStockMonitor.addStockCode(code);
        _realTimeStockMonitor.startNewThreadsIfNecessary();
        _realTimeStockMonitor.refresh();
    }

    @Override
    private void update(StockHistoryMonitor monitor, StockHistoryMonitor.StockHistoryRunnable runnable) {
        Code code = runnable.getCode();
        StockHistoryServer stockHistoryServer = runnable.getStockHistoryServer();
        this.processHistory(code, stockHistoryServer);
    }

    private Observer<StockHistoryMonitor, StockHistoryMonitor.StockHistoryRunnable> getStockHistoryMonitorObserver() {
        return new Observer<StockHistoryMonitor, StockHistoryMonitor.StockHistoryRunnable>(){

            @Override
            public void update(StockHistoryMonitor monitor, StockHistoryMonitor.StockHistoryRunnable runnable) {
                IndicatorScannerJPanel.this.update(monitor, runnable);
            }
        };
    }

    private void initCompleteProgressDataStructures() {
        Set<Code> oldSuccessCodes = this.successCodes;
        Set<Code> oldFailedCodes = this.failedCodes;
        if (oldSuccessCodes != null) {
            oldSuccessCodes.clear();
        }
        if (oldFailedCodes != null) {
            oldFailedCodes.clear();
        }
        this.successCodes = new CopyOnWriteArraySet<Code>();
        this.failedCodes = new CopyOnWriteArraySet<Code>();
    }

    private void initAlertDataStructures() {
        AlertStateManager oldAlertStateManager = this.alertStateManager;
        if (oldAlertStateManager != null) {
            oldAlertStateManager.dettachAll();
            oldAlertStateManager.clearState();
        }
        final ExecutorService oldSystemTrayAlertPool = this.systemTrayAlertPool;
        final ExecutorService oldEmailAlertPool = this.emailAlertPool;
        Utils.getZoombiePool().execute(new Runnable(){

            @Override
            public void run() {
                if (oldSystemTrayAlertPool != null) {
                    log.info((Object)("Prepare to shut down " + oldSystemTrayAlertPool + "..."));
                    oldSystemTrayAlertPool.shutdownNow();
                    try {
                        oldSystemTrayAlertPool.awaitTermination(100L, TimeUnit.DAYS);
                    }
                    catch (InterruptedException exp) {
                        log.error(null, (Throwable)exp);
                    }
                    log.info((Object)("Shut down " + oldSystemTrayAlertPool + " peacefully."));
                    log.info((Object)("Prepare to shut down " + oldEmailAlertPool + "..."));
                }
                if (oldEmailAlertPool != null) {
                    oldEmailAlertPool.shutdownNow();
                    try {
                        oldEmailAlertPool.awaitTermination(100L, TimeUnit.DAYS);
                    }
                    catch (InterruptedException exp) {
                        log.error(null, (Throwable)exp);
                    }
                    log.info((Object)("Shut down " + oldEmailAlertPool + " peacefully."));
                }
            }
        });
        this.alertStateManager = new AlertStateManager();
        this.alertStateManager.attach(this);
        this.emailAlertPool = Executors.newFixedThreadPool(1);
        this.systemTrayAlertPool = Executors.newFixedThreadPool(1);
    }

    public final void initRealTimeStockMonitor() {
        final RealTimeStockMonitor oldRealTimeStockMonitor = this.realTimeStockMonitor;
        if (oldRealTimeStockMonitor != null) {
            Utils.getZoombiePool().execute(new Runnable(){

                @Override
                public void run() {
                    log.info((Object)("Prepare to shut down " + oldRealTimeStockMonitor + "..."));
                    oldRealTimeStockMonitor.clearStockCodes();
                    oldRealTimeStockMonitor.dettachAll();
                    oldRealTimeStockMonitor.stop();
                    log.info((Object)("Shut down " + oldRealTimeStockMonitor + " peacefully."));
                }
            });
        }
        this.realTimeStockMonitor = new RealTimeStockMonitor(4, 20, JStock.instance().getJStockOptions().getIndicatorScanningSpeed());
        this.realTimeStockMonitor.attach(this.realTimeStockMonitorObserver);
    }

    private Observer<RealTimeStockMonitor, RealTimeStockMonitor.Result> getRealTimeStockMonitorObserver() {
        return new Observer<RealTimeStockMonitor, RealTimeStockMonitor.Result>(){

            @Override
            public void update(RealTimeStockMonitor monitor, RealTimeStockMonitor.Result result) {
                IndicatorScannerJPanel.this.update(monitor, result);
            }
        };
    }

    private void updateStatusBarIfStopButtonIsNotPressed(String message) {
        if (this.stop_button_pressed) {
            return;
        }
        JStock.instance().setStatusBar(true, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    private void update(RealTimeStockMonitor monitor, RealTimeStockMonitor.Result result) {
        String message;
        AlertStateManager _alertStateManager = null;
        Set<Code> _successCodes = null;
        Set<Code> _failedCodes = null;
        this.reader.lock();
        try {
            _alertStateManager = this.alertStateManager;
            _successCodes = this.successCodes;
            _failedCodes = this.failedCodes;
            RealTimeStockMonitor _realTimeStockMonitor = this.realTimeStockMonitor;
            if (this.stop_button_pressed || _realTimeStockMonitor != monitor) {
                return;
            }
        }
        finally {
            this.reader.unlock();
        }
        boolean isSymbolImmutable = org.yccheok.jstock.engine.Utils.isSymbolImmutable();
        List<Stock> stocks = result.stocks;
        int size = stocks.size();
        for (int i = 0; i < size; ++i) {
            StockInfoDatabase stock_info_database;
            Stock stock;
            Stock new_stock = stock = stocks.get(i);
            if (!isSymbolImmutable && !new_stock.symbol.toString().isEmpty() || (stock_info_database = JStock.instance().getStockInfoDatabase()) == null) continue;
            Symbol symbol = stock_info_database.codeToSymbol(stock.code);
            if (symbol != null) {
                new_stock = new_stock.deriveStock(symbol);
            } else {
                log.error((Object)("Wrong stock code " + stock.code + " given by stock server."));
            }
            if (stock == new_stock) continue;
            stocks.set(i, new_stock);
        }
        if (!stocks.isEmpty()) {
            String template = GUIBundle.getString("IndicatorScannerJPanel_IndicatorScannerIsScanning..._template");
            ScannedResult scannedResult = this.getScannedResult();
            message = MessageFormat.format(template, stocks.get((int)0).symbol, scannedResult.getTotal(), scannedResult.expected, this.getCompleteScannedStocksPercentage(scannedResult));
            this.updateStatusBarIfStopButtonIsNotPressed(message);
        }
        for (Stock stock : stocks) {
            List<OperatorIndicator> indicators = this.operatorIndicators.get(stock.code);
            if (indicators == null) continue;
            JStockOptions jStockOptions = JStock.instance().getJStockOptions();
            if (jStockOptions.isSingleIndicatorAlert()) {
                for (OperatorIndicator indicator : indicators) {
                    indicator.setStock(stock);
                    _alertStateManager.alert(indicator);
                }
            } else {
                for (OperatorIndicator indicator : indicators) {
                    indicator.setStock(stock);
                }
                _alertStateManager.alert(indicators);
            }
            _successCodes.add(stock.code);
            _failedCodes.remove(stock.code);
        }
        for (Code code : result.failedCodes) {
            _failedCodes.add(code);
            _successCodes.remove(code);
        }
        if (!stocks.isEmpty()) {
            String template = GUIBundle.getString("IndicatorScannerJPanel_IndicatorScannerIsScanning..._template");
            ScannedResult scannedResult = this.getScannedResult();
            message = MessageFormat.format(template, stocks.get((int)0).symbol, scannedResult.getTotal(), scannedResult.expected, this.getCompleteScannedStocksPercentage(scannedResult));
            this.updateStatusBarIfStopButtonIsNotPressed(message);
        }
    }

    private ScannedResult getScannedResult() {
        return new ScannedResult(this.operatorIndicators.size(), this.successCodes.size(), this.failedCodes.size());
    }

    private int getCompleteScannedStocksPercentage(ScannedResult scannedResult) {
        if (scannedResult.expected > 0) {
            int percentage = scannedResult.getTotal() * 100 / scannedResult.expected;
            return percentage;
        }
        return 0;
    }

    private void addIndicatorToTable(final Indicator indicator) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                IndicatorTableModel tableModel = (IndicatorTableModel)IndicatorScannerJPanel.this.jTable1.getModel();
                if (IndicatorScannerJPanel.this.allowIndicatorShown.booleanValue()) {
                    tableModel.addIndicator(indicator);
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    private void removeIndicatorFromTable(final Indicator indicator) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                IndicatorTableModel tableModel = (IndicatorTableModel)IndicatorScannerJPanel.this.jTable1.getModel();
                tableModel.removeIndicator(indicator);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    private void removeAllIndicatorsFromTable() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                IndicatorTableModel tableModel = (IndicatorTableModel)IndicatorScannerJPanel.this.jTable1.getModel();
                tableModel.removeAll();
            }
        };
        SwingUtilities.invokeLater(r);
    }

    private ImageIcon getImageIcon(String imageIcon) {
        return new ImageIcon(this.getClass().getResource(imageIcon));
    }

    private JPopupMenu getMyJTablePopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        final JStock m = JStock.instance();
        JMenuItem menuItem = new JMenuItem(ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("IndicatorScannerJPanel_History..."), this.getImageIcon("/images/16x16/strokedocker.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int[] rows = IndicatorScannerJPanel.this.jTable1.getSelectedRows();
                IndicatorTableModel tableModel = (IndicatorTableModel)IndicatorScannerJPanel.this.jTable1.getModel();
                for (int row : rows) {
                    int modelIndex = IndicatorScannerJPanel.this.jTable1.convertRowIndexToModel(row);
                    Indicator indicator = tableModel.getIndicator(modelIndex);
                    if (indicator == null) continue;
                    m.displayHistoryChart(StockInfo.newInstance(indicator.getStock()));
                }
            }
        });
        popup.add(menuItem);
        menuItem = new JMenuItem(ResourceBundle.getBundle("org/yccheok/jstock/data/gui").getString("IndicatorScannerJPanel_News..."), this.getImageIcon("/images/16x16/news.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int[] rows = IndicatorScannerJPanel.this.jTable1.getSelectedRows();
                IndicatorTableModel tableModel = (IndicatorTableModel)IndicatorScannerJPanel.this.jTable1.getModel();
                for (int row : rows) {
                    int modelIndex = IndicatorScannerJPanel.this.jTable1.convertRowIndexToModel(row);
                    Indicator indicator = tableModel.getIndicator(modelIndex);
                    if (indicator == null) continue;
                    m.displayStockNews(StockInfo.newInstance(indicator.getStock()));
                }
            }
        });
        popup.add(menuItem);
        popup.addSeparator();
        menuItem = new JMenuItem(GUIBundle.getString("IndicatorScannerJPanel_AddToRealTimeInfo"), this.getImageIcon("/images/16x16/add.png"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int[] rows = IndicatorScannerJPanel.this.jTable1.getSelectedRows();
                IndicatorTableModel tableModel = (IndicatorTableModel)IndicatorScannerJPanel.this.jTable1.getModel();
                for (int row : rows) {
                    int modelIndex = IndicatorScannerJPanel.this.jTable1.convertRowIndexToModel(row);
                    Indicator indicator = tableModel.getIndicator(modelIndex);
                    if (indicator == null) continue;
                    m.addStockToTable(indicator.getStock());
                }
            }
        });
        popup.add(menuItem);
        if (this.jTable1.getSelectedRowCount() == 1) {
            popup.addSeparator();
            menuItem = new JMenuItem(GUIBundle.getString("IndicatorScannerJPanel_Buy..."), this.getImageIcon("/images/16x16/inbox.png"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int row = IndicatorScannerJPanel.this.jTable1.getSelectedRow();
                    int modelIndex = IndicatorScannerJPanel.this.jTable1.getRowSorter().convertRowIndexToModel(row);
                    IndicatorTableModel tableModel = (IndicatorTableModel)IndicatorScannerJPanel.this.jTable1.getModel();
                    Indicator indicator = tableModel.getIndicator(modelIndex);
                    Stock stock = indicator.getStock();
                    JStock.instance().getPortfolioManagementJPanel().showNewBuyTransactionJDialog(StockInfo.newInstance(stock), stock.getLastPrice(), false);
                }
            });
            popup.add(menuItem);
            int row = this.jTable1.getSelectedRow();
            int modelIndex = this.jTable1.getRowSorter().convertRowIndexToModel(row);
            IndicatorTableModel tableModel = (IndicatorTableModel)this.jTable1.getModel();
            Indicator indicator = tableModel.getIndicator(modelIndex);
            Stock stock = indicator.getStock();
        }
        return popup;
    }

    public void repaintTable() {
        this.jTable1.repaint();
    }

    public void clearTableSelection() {
        this.jTable1.getSelectionModel().clearSelection();
    }

    public boolean saveAsCSVFile(File file) {
        TableModel tableModel = this.jTable1.getModel();
        Statements statements = Statements.newInstanceFromTableModel(tableModel, false);
        assert (statements != null);
        return statements.saveAsCSVFile(file);
    }

    public boolean saveAsExcelFile(File file) {
        TableModel tableModel = this.jTable1.getModel();
        Statements statements = Statements.newInstanceFromTableModel(tableModel, false);
        assert (statements != null);
        return statements.saveAsExcelFile(file, GUIBundle.getString("IndicatorScannerJPanel_Title"));
    }

    private Thread getStartScanThread(final WizardModel wizardModel) {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                WizardPanelDescriptor wizardPanelDescriptor0 = wizardModel.getPanelDescriptor("SELECT_STOCK_PANEL");
                WizardSelectStockJPanel wizardSelectStockJPanel = (WizardSelectStockJPanel)wizardPanelDescriptor0.getPanelComponent();
                if (!wizardSelectStockJPanel.buildSelectedStockCodes()) {
                    log.error((Object)"Fail to build selected stock");
                    return;
                }
                IndicatorScannerJPanel.this.removeAllIndicatorsFromTable();
                IndicatorScannerJPanel.this.initOperatorIndicators(wizardModel);
            }
        });
    }

    public void refreshRealTimeStockMonitor() {
        RealTimeStockMonitor _realTimeStockMonitor = this.realTimeStockMonitor;
        if (_realTimeStockMonitor != null) {
            _realTimeStockMonitor.refresh();
        }
    }

    public void rebuildRealTimeStockMonitor() {
        RealTimeStockMonitor _realTimeStockMonitor = this.realTimeStockMonitor;
        if (_realTimeStockMonitor != null) {
            _realTimeStockMonitor.rebuild();
        }
    }

    private class TableKeyEventListener
    extends KeyAdapter {
        private TableKeyEventListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            IndicatorScannerJPanel.this.clearTableSelection();
        }
    }

    private class TableRowPopupListener
    extends MouseAdapter {
        private TableRowPopupListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger() && IndicatorScannerJPanel.this.jTable1.getSelectedRowCount() > 0) {
                IndicatorScannerJPanel.this.getMyJTablePopupMenu().show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private static class ColumnHeaderToolTips
    extends MouseMotionAdapter {
        TableColumn curCol;
        Map<TableColumn, String> tips = new HashMap<TableColumn, String>();

        private ColumnHeaderToolTips() {
        }

        public void setToolTip(TableColumn col, String tooltip) {
            if (tooltip == null) {
                this.tips.remove(col);
            } else {
                this.tips.put(col, tooltip);
            }
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            TableColumn col = null;
            JTableHeader header = (JTableHeader)evt.getSource();
            JTable table = header.getTable();
            TableColumnModel colModel = table.getColumnModel();
            int vColIndex = colModel.getColumnIndexAtX(evt.getX());
            if (vColIndex >= 0) {
                col = colModel.getColumn(vColIndex);
            }
            if (col != this.curCol) {
                header.setToolTipText(this.tips.get(col));
                this.curCol = col;
            }
        }
    }

    private static final class ScannedResult {
        public final int expected;
        public final int pass;
        public final int fail;

        public ScannedResult(int expected, int pass, int fail) {
            this.pass = pass;
            this.fail = fail;
            this.expected = expected;
        }

        public int getTotal() {
            return this.pass + this.fail;
        }
    }
}

