/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;

public class SelectCommand
extends Command {
    private final Collection<OsmPrimitive> newSelection;
    private Collection<OsmPrimitive> oldSelection;

    public SelectCommand(Collection<OsmPrimitive> collection) {
        this.newSelection = collection == null || collection.isEmpty() ? Collections.emptySet() : new HashSet<OsmPrimitive>(collection);
    }

    public SelectCommand(DataSet dataSet, Collection<OsmPrimitive> collection) {
        super(dataSet);
        this.newSelection = collection == null || collection.isEmpty() ? Collections.emptySet() : new HashSet<OsmPrimitive>(collection);
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
    }

    @Override
    public void undoCommand() {
        this.ensurePrimitivesAreInDataset();
        this.getAffectedDataSet().setSelected(this.oldSelection);
    }

    @Override
    public boolean executeCommand() {
        this.ensurePrimitivesAreInDataset();
        this.oldSelection = this.getAffectedDataSet().getSelected();
        this.getAffectedDataSet().setSelected(this.newSelection);
        return true;
    }

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        return Collections.unmodifiableCollection(this.newSelection);
    }

    @Override
    public String getDescriptionText() {
        int n = this.newSelection != null ? this.newSelection.size() : 0;
        return I18n.trn("Selected {0} object", "Selected {0} objects", n, n);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.newSelection, this.oldSelection);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        SelectCommand selectCommand = (SelectCommand)object;
        return Objects.equals(this.newSelection, selectCommand.newSelection) && Objects.equals(this.oldSelection, selectCommand.oldSelection);
    }
}

