/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTextFileDestination;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ObjectArrayDataSet;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;
import net.sourceforge.squirrel_sql.fw.xml.XMLException;

public class DumpSessionCommand
implements ICommand {
    private final ILogger s_log = LoggerController.createLogger(DumpSessionCommand.class);
    private static final String PREFIX = "dump";
    private static final String SUFFIX = "tmp";
    private static String SEP = "===================================================";
    private ISession _session;
    private File _outFile;
    private IMessageHandler _msgHandler;

    public DumpSessionCommand() {
        this(null, null);
    }

    public DumpSessionCommand(File outFile) {
        this(outFile, null);
    }

    public DumpSessionCommand(File outFile, IMessageHandler msgHandler) {
        this._outFile = outFile;
        this._msgHandler = msgHandler;
    }

    public void setDumpFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Null Dump File passed");
        }
        this._outFile = file;
    }

    public void setSession(ISession session) {
        if (session == null) {
            throw new IllegalArgumentException("Null ISession passed");
        }
        this._session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (this._session == null) {
            throw new IllegalStateException("Trying to dump null session");
        }
        if (this._outFile == null) {
            throw new IllegalStateException("Trying to dump session to null file");
        }
        ArrayList<File> files = new ArrayList<File>();
        ArrayList<String> titles = new ArrayList<String>();
        ISession iSession = this._session;
        synchronized (iSession) {
            DataSetViewerTextFileDestination dest;
            File tempFile;
            String msg;
            ISQLConnection conn = this._session.getSQLConnection();
            SQLDatabaseMetaData md = conn.getSQLMetaData();
            try {
                files.add(this.createJavaBeanDumpFile(this._session.getProperties()));
                titles.add("Session Properties");
            }
            catch (Throwable th) {
                msg = "Error dumping driver info";
                this.showErrorMessage("Error dumping driver info");
                this.showErrorMessage(th);
                this.s_log.error("Error dumping driver info", th);
            }
            try {
                files.add(this.createJavaBeanDumpFile(this._session.getDriver()));
                titles.add("Driver");
            }
            catch (Throwable th) {
                msg = "Error dumping driver info";
                this.showErrorMessage("Error dumping driver info");
                this.showErrorMessage(th);
                this.s_log.error("Error dumping driver info", th);
            }
            try {
                files.add(this.createJavaBeanDumpFile(this._session.getAlias()));
                titles.add("Alias");
            }
            catch (Throwable th) {
                msg = "Error dumping alias info";
                this.showErrorMessage("Error dumping alias info");
                this.showErrorMessage(th);
                this.s_log.error("Error dumping alias info", th);
            }
            try {
                files.add(this.createGeneralConnectionDumpFile(conn));
                titles.add("Connection - General");
            }
            catch (Throwable th) {
                msg = "Error dumping general connection info";
                this.showErrorMessage("Error dumping general connection info");
                this.showErrorMessage(th);
                this.s_log.error("Error dumping general connection info", th);
            }
            try {
                tempFile = File.createTempFile(PREFIX, SUFFIX);
                dest = new DataSetViewerTextFileDestination(tempFile);
                dest.show(conn.getSQLMetaData().getMetaDataSet());
                files.add(tempFile);
                titles.add("Metadata");
            }
            catch (Throwable th) {
                msg = "Error dumping metadata";
                this.showErrorMessage("Error dumping metadata");
                this.showErrorMessage(th);
                this.s_log.error("Error dumping metadata", th);
            }
            try {
                tempFile = File.createTempFile(PREFIX, SUFFIX);
                dest = new DataSetViewerTextFileDestination(tempFile);
                dest.show(new ObjectArrayDataSet(md.getCatalogs()));
                files.add(tempFile);
                titles.add("Catalogs");
            }
            catch (Throwable th) {
                msg = "Error dumping catalogs";
                this.showErrorMessage("Error dumping catalogs");
                this.showErrorMessage(th);
                this.s_log.error("Error dumping catalogs", th);
            }
            try {
                tempFile = File.createTempFile(PREFIX, SUFFIX);
                dest = new DataSetViewerTextFileDestination(tempFile);
                dest.show(new ObjectArrayDataSet(this._session.getSchemaInfo().getSchemas()));
                files.add(tempFile);
                titles.add("Schemas");
            }
            catch (Throwable th) {
                msg = "Error dumping schemas";
                this.showErrorMessage("Error dumping schemas");
                this.showErrorMessage(th);
                this.s_log.error("Error dumping schemas", th);
            }
            try {
                tempFile = File.createTempFile(PREFIX, SUFFIX);
                dest = new DataSetViewerTextFileDestination(tempFile);
                dest.show(conn.getSQLMetaData().getTypesDataSet());
                files.add(tempFile);
                titles.add("Data Types");
            }
            catch (Throwable th) {
                msg = "Error dumping data types";
                this.showErrorMessage("Error dumping data types");
                this.showErrorMessage(th);
                this.s_log.error("Error dumping data types", th);
            }
            try {
                tempFile = File.createTempFile(PREFIX, SUFFIX);
                dest = new DataSetViewerTextFileDestination(tempFile);
                dest.show(new ObjectArrayDataSet(md.getTableTypes()));
                files.add(tempFile);
                titles.add("Table Types");
            }
            catch (Throwable th) {
                msg = "Error dumping table types";
                this.showErrorMessage("Error dumping table types");
                this.showErrorMessage(th);
                this.s_log.error("Error dumping table types", th);
            }
        }
        this.combineTempFiles(titles, files);
        this.deleteTempFiles(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void combineTempFiles(List<String> titles, List<File> files) {
        try (PrintWriter wtr = new PrintWriter(new FileWriter(this._outFile));){
            wtr.println("SQuirreL SQL Client Session Dump " + Calendar.getInstance().getTime());
            int limit = files.size();
            for (int i = 0; i < limit; ++i) {
                wtr.println();
                wtr.println();
                wtr.println(SEP);
                wtr.println(titles.get(i));
                wtr.println(SEP);
                File file = files.get(i);
                try (BufferedReader rdr = new BufferedReader(new FileReader(file));){
                    String line = null;
                    while ((line = rdr.readLine()) != null) {
                        wtr.println(line);
                    }
                    continue;
                }
            }
        }
        catch (IOException ex) {
            String msg = "Error combining temp files into dump file";
            this.showErrorMessage("Error combining temp files into dump file");
            this.showErrorMessage(ex);
            this.s_log.error("Error combining temp files into dump file", ex);
        }
    }

    private void deleteTempFiles(List<File> files) {
        int limit = files.size();
        for (int i = 0; i < limit; ++i) {
            if (files.get(i).delete()) continue;
            this.s_log.error("Couldn't delete temporary DumpSession file");
        }
    }

    private File createJavaBeanDumpFile(Object obj) throws IOException, XMLException {
        File tempFile = File.createTempFile(PREFIX, SUFFIX);
        XMLBeanWriter wtr = new XMLBeanWriter(obj);
        wtr.save(tempFile);
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createGeneralConnectionDumpFile(ISQLConnection conn) throws IOException {
        Connection myConn = conn.getConnection();
        File tempFile = File.createTempFile(PREFIX, SUFFIX);
        try (PrintWriter wtr = new PrintWriter(new FileWriter(tempFile));){
            String line = null;
            try {
                line = String.valueOf(myConn.getTransactionIsolation());
            }
            catch (Throwable th) {
                line = th.toString();
            }
            wtr.println("transIsolation: " + line);
            try {
                line = String.valueOf(myConn.isReadOnly());
            }
            catch (Throwable th) {
                line = th.toString();
            }
            wtr.println("readonly: " + line);
            File file = tempFile;
            return file;
        }
    }

    private void showErrorMessage(String msg) {
        if (this._session != null) {
            this._session.showErrorMessage(msg);
        } else if (this._msgHandler != null) {
            this._msgHandler.showErrorMessage(msg);
        } else {
            this.s_log.error("No IMessageHandler or ISession configured");
        }
    }

    private void showErrorMessage(Throwable th) {
        if (this._session != null) {
            this._session.showErrorMessage(th);
        } else if (this._msgHandler != null) {
            this._msgHandler.showErrorMessage(th, null);
        } else {
            this.s_log.error("No IMessageHandler or ISession configured");
        }
    }
}

