/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.parser;

import java.util.ArrayList;
import java.util.List;
import org.javacc.parser.JavaCCErrors;
import org.javacc.parser.LexGen;
import org.javacc.parser.Nfa;
import org.javacc.parser.NfaState;
import org.javacc.parser.RCharacterList;
import org.javacc.parser.RJustName;
import org.javacc.parser.RStringLiteral;
import org.javacc.parser.RegularExpression;

public class RChoice
extends RegularExpression {
    private List choices = new ArrayList();

    public void setChoices(List choices) {
        this.choices = choices;
    }

    public List getChoices() {
        return this.choices;
    }

    @Override
    public Nfa GenerateNfa(boolean ignoreCase) {
        this.CompressCharLists();
        if (this.getChoices().size() == 1) {
            return ((RegularExpression)this.getChoices().get(0)).GenerateNfa(ignoreCase);
        }
        Nfa retVal = new Nfa();
        NfaState startState = retVal.start;
        NfaState finalState = retVal.end;
        for (int i = 0; i < this.getChoices().size(); ++i) {
            RegularExpression curRE = (RegularExpression)this.getChoices().get(i);
            Nfa temp = curRE.GenerateNfa(ignoreCase);
            startState.AddMove(temp.start);
            temp.end.AddMove(finalState);
        }
        return retVal;
    }

    void CompressCharLists() {
        this.CompressChoices();
        RCharacterList curCharList = null;
        for (int i = 0; i < this.getChoices().size(); ++i) {
            RegularExpression curRE = (RegularExpression)this.getChoices().get(i);
            while (curRE instanceof RJustName) {
                curRE = ((RJustName)curRE).regexpr;
            }
            if (curRE instanceof RStringLiteral && ((RStringLiteral)curRE).image.length() == 1) {
                curRE = new RCharacterList(((RStringLiteral)curRE).image.charAt(0));
                this.getChoices().set(i, curRE);
            }
            if (!(curRE instanceof RCharacterList)) continue;
            if (((RCharacterList)curRE).negated_list) {
                ((RCharacterList)curRE).RemoveNegation();
            }
            List tmp = ((RCharacterList)curRE).descriptors;
            if (curCharList == null) {
                curCharList = new RCharacterList();
                curRE = curCharList;
                this.getChoices().set(i, curCharList);
            } else {
                this.getChoices().remove(i--);
            }
            int j = tmp.size();
            while (j-- > 0) {
                curCharList.descriptors.add(tmp.get(j));
            }
        }
    }

    void CompressChoices() {
        for (int i = 0; i < this.getChoices().size(); ++i) {
            RegularExpression curRE = (RegularExpression)this.getChoices().get(i);
            while (curRE instanceof RJustName) {
                curRE = ((RJustName)curRE).regexpr;
            }
            if (!(curRE instanceof RChoice)) continue;
            this.getChoices().remove(i--);
            int j = ((RChoice)curRE).getChoices().size();
            while (j-- > 0) {
                this.getChoices().add(((RChoice)curRE).getChoices().get(j));
            }
        }
    }

    public void CheckUnmatchability() {
        int numStrings = 0;
        for (int i = 0; i < this.getChoices().size(); ++i) {
            RegularExpression curRE = (RegularExpression)this.getChoices().get(i);
            if (!curRE.private_rexp && curRE.ordinal > 0 && curRE.ordinal < this.ordinal) {
                if (LexGen.lexStates[curRE.ordinal] == LexGen.lexStates[this.ordinal]) {
                    if (this.label != null) {
                        JavaCCErrors.warning(this, "Regular Expression choice : " + curRE.label + " can never be matched as : " + this.label);
                    } else {
                        JavaCCErrors.warning(this, "Regular Expression choice : " + curRE.label + " can never be matched as token of kind : " + this.ordinal);
                    }
                }
            }
            if (curRE.private_rexp || !(curRE instanceof RStringLiteral)) continue;
            ++numStrings;
        }
    }
}

