/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JdkJavaCompilerResult;
import org.gradle.api.internal.tasks.compile.incremental.RecompilationNotNecessary;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathSnapshotData;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathSnapshotProvider;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessingData;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessingResult;
import org.gradle.api.internal.tasks.compile.incremental.processing.GeneratedResource;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilationData;
import org.gradle.api.internal.tasks.compile.processing.AnnotationProcessorDeclaration;
import org.gradle.api.tasks.WorkResult;
import org.gradle.cache.internal.Stash;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;

class IncrementalResultStoringCompiler
implements Compiler<JavaCompileSpec> {
    private final Compiler<JavaCompileSpec> delegate;
    private final ClasspathSnapshotProvider classpathSnapshotProvider;
    private final Stash<PreviousCompilationData> stash;
    private final StringInterner interner;

    IncrementalResultStoringCompiler(Compiler<JavaCompileSpec> delegate, ClasspathSnapshotProvider classpathSnapshotProvider, Stash<PreviousCompilationData> stash, StringInterner interner) {
        this.delegate = delegate;
        this.classpathSnapshotProvider = classpathSnapshotProvider;
        this.stash = stash;
        this.interner = interner;
    }

    public WorkResult execute(JavaCompileSpec spec) {
        WorkResult result = this.delegate.execute((CompileSpec)spec);
        if (result instanceof RecompilationNotNecessary) {
            return result;
        }
        this.storeResult(spec, result);
        return result;
    }

    private void storeResult(JavaCompileSpec spec, WorkResult result) {
        ClasspathSnapshotData classpathSnapshot = this.classpathSnapshotProvider.getClasspathSnapshot(Iterables.concat((Iterable)spec.getCompileClasspath(), spec.getModulePath())).getData();
        AnnotationProcessingData annotationProcessingData = this.getAnnotationProcessingResult(spec, result);
        PreviousCompilationData data = new PreviousCompilationData(spec.getDestinationDir(), annotationProcessingData, classpathSnapshot, spec.getAnnotationProcessorPath());
        this.stash.put((Object)data);
    }

    private AnnotationProcessingData getAnnotationProcessingResult(JavaCompileSpec spec, WorkResult result) {
        Set<AnnotationProcessorDeclaration> processors = spec.getEffectiveAnnotationProcessors();
        if (processors == null || processors.isEmpty()) {
            return new AnnotationProcessingData();
        }
        if (result instanceof JdkJavaCompilerResult) {
            AnnotationProcessingResult processingResult = ((JdkJavaCompilerResult)result).getAnnotationProcessingResult();
            return this.convertProcessingResult(processingResult);
        }
        return new AnnotationProcessingData((Map<String, Set<String>>)ImmutableMap.of(), (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of(), (Map<String, Set<GeneratedResource>>)ImmutableMap.of(), (Set<GeneratedResource>)ImmutableSet.of(), "the chosen compiler did not support incremental annotation processing");
    }

    private AnnotationProcessingData convertProcessingResult(AnnotationProcessingResult processingResult) {
        Map<String, Set<String>> generatedTypesByOrigin = processingResult.getGeneratedTypesWithIsolatedOrigin();
        Map<String, Set<GeneratedResource>> generatedResourcesByOrigin = processingResult.getGeneratedResourcesWithIsolatedOrigin();
        Set<String> aggregatedTypes = processingResult.getAggregatedTypes();
        Set<String> aggregatingTypes = processingResult.getGeneratedAggregatingTypes();
        Set<GeneratedResource> aggregatingResources = processingResult.getGeneratedAggregatingResources();
        return new AnnotationProcessingData(this.intern(generatedTypesByOrigin), this.intern(aggregatedTypes), this.intern(aggregatingTypes), generatedResourcesByOrigin, aggregatingResources, processingResult.getFullRebuildCause());
    }

    private Set<String> intern(Set<String> types) {
        HashSet result = Sets.newHashSet();
        for (String string : types) {
            result.add(this.interner.intern(string));
        }
        return result;
    }

    private Map<String, Set<String>> intern(Map<String, Set<String>> types) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, Set<String>> entry : types.entrySet()) {
            result.put(this.interner.intern(entry.getKey()), this.intern(entry.getValue()));
        }
        return result;
    }
}

