/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.tasks.properties.DefaultPropertyWalker;
import org.gradle.api.internal.tasks.properties.DefaultTypeMetadataStore;
import org.gradle.api.internal.tasks.properties.InspectionScheme;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.internal.tasks.properties.TypeMetadataStore;
import org.gradle.api.internal.tasks.properties.annotations.NoOpPropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.PropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.TypeAnnotationHandler;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.internal.reflect.annotations.TypeAnnotationMetadataStore;

public class InspectionSchemeFactory {
    private final Map<Class<? extends Annotation>, PropertyAnnotationHandler> allKnownPropertyHandlers;
    private final ImmutableList<TypeAnnotationHandler> allKnownTypeHandlers;
    private final TypeAnnotationMetadataStore typeAnnotationMetadataStore;
    private final CrossBuildInMemoryCacheFactory cacheFactory;

    public InspectionSchemeFactory(List<? extends TypeAnnotationHandler> allKnownTypeHandlers, List<? extends PropertyAnnotationHandler> allKnownPropertyHandlers, TypeAnnotationMetadataStore typeAnnotationMetadataStore, CrossBuildInMemoryCacheFactory cacheFactory) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (PropertyAnnotationHandler propertyAnnotationHandler : allKnownPropertyHandlers) {
            builder.put(propertyAnnotationHandler.getAnnotationType(), (Object)propertyAnnotationHandler);
        }
        this.allKnownTypeHandlers = ImmutableList.copyOf(allKnownTypeHandlers);
        this.allKnownPropertyHandlers = builder.build();
        this.typeAnnotationMetadataStore = typeAnnotationMetadataStore;
        this.cacheFactory = cacheFactory;
    }

    public InspectionScheme inspectionScheme(Collection<Class<? extends Annotation>> annotations, Collection<Class<? extends Annotation>> propertyModifiers, InstantiationScheme instantiationScheme) {
        ImmutableList.Builder propertyHandlers = ImmutableList.builderWithExpectedSize((int)annotations.size());
        for (Class<? extends Annotation> annotation : annotations) {
            PropertyAnnotationHandler propertyHandler = this.allKnownPropertyHandlers.get(annotation);
            if (propertyHandler == null) {
                throw new IllegalArgumentException(String.format("@%s is not a registered property type annotation.", annotation.getSimpleName()));
            }
            propertyHandlers.add((Object)propertyHandler);
        }
        for (Class<? extends Annotation> annotation : instantiationScheme.getInjectionAnnotations()) {
            if (annotations.contains(annotation)) continue;
            propertyHandlers.add((Object)new NoOpPropertyAnnotationHandler(annotation));
        }
        return new InspectionSchemeImpl((List<TypeAnnotationHandler>)this.allKnownTypeHandlers, (List<PropertyAnnotationHandler>)propertyHandlers.build(), propertyModifiers, this.typeAnnotationMetadataStore, this.cacheFactory);
    }

    private static class InspectionSchemeImpl
    implements InspectionScheme {
        private final DefaultPropertyWalker propertyWalker;
        private final DefaultTypeMetadataStore metadataStore;

        public InspectionSchemeImpl(List<TypeAnnotationHandler> typeHandlers, List<PropertyAnnotationHandler> propertyHandlers, Collection<Class<? extends Annotation>> propertyModifiers, TypeAnnotationMetadataStore typeAnnotationMetadataStore, CrossBuildInMemoryCacheFactory cacheFactory) {
            this.metadataStore = new DefaultTypeMetadataStore(typeHandlers, propertyHandlers, propertyModifiers, typeAnnotationMetadataStore, cacheFactory);
            this.propertyWalker = new DefaultPropertyWalker(this.metadataStore);
        }

        @Override
        public TypeMetadataStore getMetadataStore() {
            return this.metadataStore;
        }

        @Override
        public PropertyWalker getPropertyWalker() {
            return this.propertyWalker;
        }
    }
}

