/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import org.gradle.api.internal.ClassPathProvider;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.internal.classpath.ClassPath;

public class DefaultClassPathProvider
implements ClassPathProvider {
    private final ModuleRegistry moduleRegistry;

    public DefaultClassPathProvider(ModuleRegistry moduleRegistry) {
        this.moduleRegistry = moduleRegistry;
    }

    @Override
    public ClassPath findClassPath(String name) {
        if (name.equals("GRADLE_RUNTIME")) {
            return this.moduleRegistry.getModule("gradle-launcher").getAllRequiredModulesClasspath();
        }
        if (name.equals("GRADLE_INSTALLATION_BEACON")) {
            return this.moduleRegistry.getModule("gradle-installation-beacon").getImplementationClasspath();
        }
        if (name.equals("GROOVY-COMPILER")) {
            ClassPath classpath = ClassPath.EMPTY;
            classpath = classpath.plus(this.moduleRegistry.getModule("gradle-language-groovy").getImplementationClasspath());
            classpath = classpath.plus(this.moduleRegistry.getExternalModule("groovy-all").getClasspath());
            classpath = classpath.plus(this.moduleRegistry.getExternalModule("asm").getClasspath());
            classpath = this.addJavaCompilerModules(classpath);
            return classpath;
        }
        if (name.equals("SCALA-COMPILER")) {
            ClassPath classpath = ClassPath.EMPTY;
            classpath = classpath.plus(this.moduleRegistry.getModule("gradle-language-scala").getImplementationClasspath());
            classpath = classpath.plus(this.moduleRegistry.getModule("gradle-scala").getImplementationClasspath());
            classpath = this.addJavaCompilerModules(classpath);
            return classpath;
        }
        if (name.equals("PLAY-COMPILER")) {
            ClassPath classpath = ClassPath.EMPTY;
            classpath = classpath.plus(this.moduleRegistry.getModule("gradle-platform-play").getImplementationClasspath());
            classpath = classpath.plus(this.moduleRegistry.getModule("gradle-javascript").getImplementationClasspath());
            classpath = this.addJavaCompilerModules(classpath);
            return classpath;
        }
        if (name.equals("JAVA-COMPILER")) {
            return this.addJavaCompilerModules(ClassPath.EMPTY);
        }
        if (name.equals("ANT")) {
            ClassPath classpath = ClassPath.EMPTY;
            classpath = classpath.plus(this.moduleRegistry.getExternalModule("ant").getClasspath());
            classpath = classpath.plus(this.moduleRegistry.getExternalModule("ant-launcher").getClasspath());
            return classpath;
        }
        return null;
    }

    private ClassPath addJavaCompilerModules(ClassPath classpath) {
        classpath = classpath.plus(this.moduleRegistry.getModule("gradle-language-java").getImplementationClasspath());
        classpath = classpath.plus(this.moduleRegistry.getModule("gradle-language-jvm").getImplementationClasspath());
        classpath = classpath.plus(this.moduleRegistry.getModule("gradle-platform-base").getImplementationClasspath());
        return classpath;
    }
}

