/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.plugins;

import java.io.File;
import org.apache.commons.lang.WordUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.ImmutableFileCollection;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.tasks.scala.IncrementalCompileOptions;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.language.scala.tasks.PlatformScalaCompile;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.play.PlayApplicationBinarySpec;
import org.gradle.play.internal.PlayApplicationBinarySpecInternal;
import org.gradle.play.plugins.PlayPluginConfigurations;
import org.gradle.util.SingleMessageLogger;

@Incubating
@Deprecated
public class PlayTestPlugin
extends RuleSource {
    @Mutate
    void createTestTasks(ModelMap<Task> tasks, @Path(value="binaries") ModelMap<PlayApplicationBinarySpecInternal> playBinaries, PlayPluginConfigurations configurations, FileResolver fileResolver, final ProjectIdentifier projectIdentifier, @Path(value="buildDir") File buildDir) {
        SingleMessageLogger.nagUserOfPluginReplacedWithExternalOne((String)"Play Test", (String)"org.gradle.playframework-test");
        for (final PlayApplicationBinarySpecInternal binary : playBinaries) {
            final FileCollection testCompileClasspath = this.getTestCompileClasspath(binary, configurations);
            final String testCompileTaskName = binary.getTasks().taskName("compile", "tests");
            File testSourceDir = fileResolver.resolve((Object)"test");
            FileTree testSources = ImmutableFileCollection.of((File[])new File[]{testSourceDir}).getAsFileTree().matching((PatternFilterable)new PatternSet().include(new String[]{"**/*.scala", "**/*.java"}));
            final File testClassesDir = new File(buildDir, binary.getProjectScopedName() + "/testClasses");
            tasks.create(testCompileTaskName, PlatformScalaCompile.class, (Action)new Action<PlatformScalaCompile>((FileCollection)testSources, buildDir, testCompileTaskName){
                final /* synthetic */ FileCollection val$testSources;
                final /* synthetic */ File val$buildDir;
                final /* synthetic */ String val$testCompileTaskName;
                {
                    this.val$testSources = fileCollection2;
                    this.val$buildDir = file2;
                    this.val$testCompileTaskName = string;
                }

                public void execute(PlatformScalaCompile scalaCompile) {
                    scalaCompile.setDescription("Compiles the scala and java test sources for the " + binary.getDisplayName() + ".");
                    scalaCompile.setClasspath(testCompileClasspath);
                    scalaCompile.dependsOn(new Object[]{binary.getBuildTask()});
                    scalaCompile.setPlatform(binary.getTargetPlatform().getScalaPlatform());
                    scalaCompile.setDestinationDir(testClassesDir);
                    scalaCompile.setSource((Object)this.val$testSources);
                    String targetCompatibility = binary.getTargetPlatform().getJavaPlatform().getTargetCompatibility().getMajorVersion();
                    scalaCompile.setSourceCompatibility(targetCompatibility);
                    scalaCompile.setTargetCompatibility(targetCompatibility);
                    IncrementalCompileOptions incrementalOptions = scalaCompile.getScalaCompileOptions().getIncrementalOptions();
                    incrementalOptions.getAnalysisFile().set(new File(this.val$buildDir, "tmp/scala/compilerAnalysis/" + this.val$testCompileTaskName + ".analysis"));
                }
            });
            final String testTaskName = binary.getTasks().taskName("test");
            final File binaryBuildDir = new File(buildDir, binary.getProjectScopedName());
            tasks.create(testTaskName, Test.class, (Action)new Action<Test>(){

                public void execute(Test test) {
                    test.setDescription("Runs " + WordUtils.uncapitalize((String)(binary.getDisplayName() + ".")));
                    test.setClasspath(PlayTestPlugin.this.getRuntimeClasspath(testClassesDir, testCompileClasspath));
                    test.setTestClassesDirs((FileCollection)ImmutableFileCollection.of((File[])new File[]{testClassesDir}));
                    test.setBinResultsDir(new File(binaryBuildDir, "results/" + testTaskName + "/bin"));
                    test.getReports().getJunitXml().setDestination(new File(binaryBuildDir, "reports/test/xml"));
                    test.getReports().getHtml().setDestination(new File(binaryBuildDir, "reports/test"));
                    test.dependsOn(new Object[]{testCompileTaskName});
                    test.setWorkingDir(projectIdentifier.getProjectDir());
                }
            });
            binary.getTasks().add(tasks.get(testTaskName));
        }
    }

    private FileCollection getTestCompileClasspath(PlayApplicationBinarySpec binary, PlayPluginConfigurations configurations) {
        return ImmutableFileCollection.of((File[])new File[]{binary.getJarFile()}).plus(configurations.getPlayTest().getAllArtifacts());
    }

    private FileCollection getRuntimeClasspath(File testClassesDir, FileCollection testCompileClasspath) {
        return ImmutableFileCollection.of((File[])new File[]{testClassesDir}).plus(testCompileClasspath);
    }

    @Mutate
    void attachTestSuitesToCheckTask(ModelMap<Task> tasks, final @Path(value="binaries") ModelMap<PlayApplicationBinarySpec> playBinaries) {
        tasks.named("check", (Action)new Action<Task>(){

            public void execute(Task checkTask) {
                for (PlayApplicationBinarySpec binary : playBinaries) {
                    checkTask.dependsOn(new Object[]{binary.getTasks().withType(Test.class)});
                }
            }
        });
    }
}

