/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.WorkerProtocol;

public class DefaultWorkerServer
implements WorkerProtocol {
    private final Instantiator instantiator;

    @Inject
    public DefaultWorkerServer(ServiceRegistry serviceRegistry) {
        this.instantiator = ((InstantiatorFactory)serviceRegistry.get(InstantiatorFactory.class)).inject((ServiceLookup)serviceRegistry);
    }

    @Override
    public DefaultWorkResult execute(ActionExecutionSpec spec) {
        try {
            Class<?> implementationClass = spec.getImplementationClass();
            Object action = this.instantiator.newInstance(implementationClass, spec.getParams());
            if (action instanceof Runnable) {
                ((Runnable)action).run();
                return new DefaultWorkResult(true, null);
            }
            if (action instanceof Callable) {
                Object result = ((Callable)action).call();
                if (result instanceof DefaultWorkResult) {
                    return (DefaultWorkResult)result;
                }
                if (result instanceof WorkResult) {
                    return new DefaultWorkResult(((WorkResult)result).getDidWork(), null);
                }
                throw new IllegalArgumentException("Worker actions must return a WorkResult.");
            }
            throw new IllegalArgumentException("Worker actions must either implement Runnable or Callable<WorkResult>.");
        }
        catch (Throwable t) {
            return new DefaultWorkResult(true, t);
        }
    }

    public String toString() {
        return "DefaultWorkerServer{}";
    }
}

