/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.util;

public class NumberUtil {
    public static int percentOf(long fraction, long total) {
        if (total < 0L || fraction < 0L) {
            throw new IllegalArgumentException("Unable to calculate percentage: " + fraction + " of " + total + ". All inputs must be >= 0");
        }
        if (total == 0L) {
            return 0;
        }
        float out = (float)fraction * 100.0f / (float)total;
        return (int)out;
    }

    public static String formatBytes(long bytes) {
        if (bytes < 0L) {
            return "-".concat(NumberUtil.formatBytes(-bytes));
        }
        int unit = 1000;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        char pre = "kMGTPE".charAt(exp - 1);
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), Character.valueOf(pre));
    }

    public static String ordinal(int value) {
        String[] sufixes = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
        switch (value % 100) {
            case 11: 
            case 12: 
            case 13: {
                return value + "th";
            }
        }
        return value + sufixes[value % 10];
    }
}

