/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class FCSDisplay
extends JPanel
implements ActionListener,
MouseMotionListener,
MouseListener {
    public static final float DEG_TO_RAD = 0.0174533f;
    public static final float THETA_H = 5.4977894f;
    public static final float PHI_H = 0.52359897f;
    public static final float AXISTICKS = 25.0f;
    public static final int SPLITTICKS = 5;
    public static final int IVRY = 5;
    public static final int FOOT = 30;
    public static final int HEAD = 10;
    public static final int L_MARGIN = 35;
    public static final int R_MARGIN = 10;
    public static final int PERCENT_LN = 5;
    public static final int PERCENT_PLACE = 2;
    public static final int STATSTA_HT = 10;
    public static final int STATSTA_WD = 78;
    public static final int NAME_WD = 12;
    public static final int PARWIDTH = 30;
    public static final int MAXDOTSIZE = 4;
    public static final int DEFDOTSIZE = 2;
    public static final int DOTSCALE = 100;
    public static final int SDBANNER = 26;
    public static final int GRIDS = 4;
    private static final String DOT_SIZE = "Dot Size";
    private static final String SHOW_GRIDS = "Grids On/Off";
    private static final String PRINT = "Print..";
    public static final int PARX = 0;
    public static final int PARY = 1;
    public static final int PARZ = 2;
    public static final int UP = 1;
    public static final int DOWN = -1;
    public static final int MAX = 0;
    public static final Color SPLITBGND = new Color(224, 224, 255);
    JPopupMenu parPum;
    JPopupMenu pum;
    private int changeAxis;
    JMenuItem miGrids;
    JMenu miDots;
    JMenuItem[] miPar;
    JMenuItem[] miDotSize;
    private int parPumItems;
    GDisplay gd;
    Plotter p;
    Dimension offDimension = null;
    Image offImage = null;
    Graphics offGraphics = null;
    public int show;
    public int dotSize;
    public boolean partialDrawing;
    public boolean newMove;
    public boolean fullyRepainted;
    public boolean fullPaint;
    public boolean firstReport = true;
    public int oldX;
    public int oldY;
    public int newX;
    public int newY;
    private String requestedPath;
    public int imageID;
    public boolean isSetting;
    public Rectangle[] parArea;
    private int dfPatternWidth = 0;
    private int dfPatternPlaces = 0;
    private DecimalFormat df;

    public FCSDisplay(GDisplay gd) {
        this.gd = gd;
        this.p = new Plotter(gd);
        this.parArea = new Rectangle[3];
        int i = 0;
        while (i < 3) {
            this.parArea[i] = new Rectangle(-1, 0, 0, 0);
            ++i;
        }
        this.show = 0;
        this.dotSize = 2;
        this.df = new DecimalFormat();
        this.parPum = new JPopupMenu();
        this.parPumItems = 0;
        this.miPar = new JMenuItem[64];
        i = 0;
        while (i < gd.cSymph.fs.nPars) {
            this.miPar[i] = this.parPum.add(this.getParName(0, i, 12));
            ++this.parPumItems;
            this.miPar[i].addActionListener(this);
            ++i;
        }
        this.pum = new JPopupMenu();
        this.miDots = new JMenu(DOT_SIZE);
        this.miDotSize = new JMenuItem[5];
        i = 0;
        while (i <= 4) {
            this.miDotSize[i] = new JMenuItem(String.valueOf(i));
            this.miDotSize[i].addActionListener(this);
            this.miDots.add(this.miDotSize[i]);
            ++i;
        }
        this.pum.add(this.miDots);
        this.miGrids = new JMenuItem(SHOW_GRIDS);
        this.miGrids.addActionListener(this);
        if (gd.mode == 1) {
            this.pum.add(this.miGrids);
        }
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.enableEvents(16L);
        this.setLocation(new Point(0, 0));
        this.newMove = false;
    }

    public void scaleUp(int up) {
    }

    public void updatePumParameters() {
        int i = 0;
        while (i < this.gd.cSymph.fs.nPars) {
            if (i < this.parPumItems) {
                this.miPar[i].setText(this.getParName(0, i, 12));
            } else {
                this.miPar[i] = this.parPum.add(this.getParName(0, i, 12));
                this.miPar[i].addActionListener(this);
                ++this.parPumItems;
            }
            ++i;
        }
        while (this.parPumItems > this.gd.cSymph.fs.nPars) {
            this.parPum.remove(--this.parPumItems);
        }
        this.parPum.pack();
    }

    public double getSplitEvry(double min) {
        double inc = 0.2;
        while ((int)(min / inc) > 5 && (int)(min / (inc *= 2.5)) > 5 && (int)(min / (inc *= 2.0)) > 5) {
            inc *= 2.0;
        }
        return inc;
    }

    public float getEvry(float res) {
        float ev = 0.1f;
        while (!(25.0f * ev * 1.6f > res && ev > 0.11f || 25.0f * (ev *= 1.6f) * 1.25f > res && ev > 0.161f || 25.0f * (ev *= 1.25f) * 2.0f > res || 25.0f * (ev *= 2.0f) * 1.25f > res || 25.0f * (ev *= 1.25f) * 2.0f > res && ev > 0.51f)) {
            ev *= 2.0f;
        }
        return ev;
    }

    String getParName(int f_num, int p_num, int width) {
        return this.stringPad(this.gd.cSymph.fs.parname[p_num], width);
    }

    void drawParLabel(int f_num, int p_num, int justify) {
        this.drawParLabel(f_num, p_num, justify, 0, null, null);
    }

    void drawParLabel(int f_num, int p_num, int justify, Rectangle rect) {
        this.drawParLabel(f_num, p_num, justify, 0, rect, null);
    }

    void drawParLabel(int f_num, int p_num, int justify, int rotation, Rectangle rect) {
        this.drawParLabel(f_num, p_num, justify, rotation, rect, null);
    }

    void drawParLabel(int f_num, int p_num, int justify, int rotation, Rectangle rect, String instrName) {
        String label = instrName != null ? String.valueOf(this.getParName(f_num, p_num, -1)) + ": " + instrName : this.getParName(f_num, p_num, -1);
        this.p.drwtxt(label, 1, justify, rotation, rect);
    }

    public String stringPad(String str, int width) {
        if (width == 0 || str == null) {
            return null;
        }
        if (width < 0) {
            return str.trim();
        }
        int length = str.length();
        if (length >= width) {
            return str.substring(0, width);
        }
        StringBuffer fstr = new StringBuffer(width);
        int padR = width - length;
        fstr.append(str);
        while (padR > 0) {
            fstr.append(' ');
            --padR;
        }
        return fstr.toString();
    }

    public String stringFormat(double x, int width, int places) {
        boolean pad;
        int TABWIDTH = 8;
        StringBuffer pattern = null;
        int index = 0;
        int leading = width - (places + 1);
        int trailing = places;
        boolean bl = pad = leading > 0;
        if (this.dfPatternWidth != width || this.dfPatternPlaces != places) {
            pattern = new StringBuffer();
            if (!pad) {
                pattern.append('#');
            }
            while (leading-- > 0) {
                pattern.append('0');
            }
            if (trailing >= 0) {
                pattern.append('.');
            }
            while (trailing-- > 0) {
                pattern.append('#');
            }
            this.df.applyPattern(pattern.toString());
            this.dfPatternWidth = width;
            this.dfPatternPlaces = places;
        }
        String str = x < 0.0 ? this.df.format(-x) : this.df.format(x);
        if (pad) {
            pattern = new StringBuffer(str);
            index = 0;
            while (index < width - places - 2 && pattern.charAt(index) == '0') {
                pattern.setCharAt(index++, ' ');
            }
            if (index > 0 && x < 0.0) {
                pattern.setCharAt(index - 1, '-');
            } else if (x < 0.0) {
                pattern.insert(0, '-');
            }
            str = pattern.toString();
        }
        if (str.length() >= 8) {
            index = str.indexOf(".");
            width = index >= 8 ? index : 7;
            str = str.substring(0, width);
        }
        return str;
    }

    public void fullRepaint() {
        this.fullPaint = true;
        this.repaint();
    }

    public Dimension getDspSize() {
        Dimension d = this.getSize();
        return new Dimension(d.width - 35 - 10, d.height - 10 - 30);
    }

    public void reportPaint() {
        Rectangle rv = null;
        Dimension me = this.getPreferredSize();
        int prefH = me.height;
        int prefW = me.width;
        me = this.getSize();
        if (this.firstReport && (me.height != prefH || me.width != prefW)) {
            this.setSize(this.getPreferredSize());
            this.gd.pack();
        }
        this.firstReport = false;
        rv = this.gd.getBounds(rv);
        this.gd.x = rv.x;
        this.gd.y = rv.y;
        this.gd.width = rv.width;
        this.gd.height = rv.height;
        this.setPreferredSize(this.getSize());
        Dimension d = this.getDspSize();
        this.gd.dspWidth = d.width;
        this.gd.dspHeight = d.height;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean repaint = false;
        Object target = e.getSource();
        if (target == this.miGrids) {
            this.show ^= 4;
            repaint = true;
        } else {
            int i = 0;
            while (i <= 4) {
                if (target == this.miDotSize[i]) {
                    this.dotSize = i;
                    repaint = true;
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < this.parPumItems) {
                if (target == this.miPar[i]) {
                    this.changeParameter(i);
                    break;
                }
                ++i;
            }
        }
        if (repaint) {
            this.fullRepaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.maybeShowPopup(evt);
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.maybeShowPopup(evt);
    }

    public void maybeShowPopup(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            int y;
            int x = evt.getX();
            int axis = this.clickedPar(x, y = evt.getY());
            if (axis >= 0) {
                this.changeAxis = axis;
                this.parPum.show(evt.getComponent(), x, y);
            } else {
                this.pum.show(evt.getComponent(), x, y);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    private int clickedPar(int x, int y) {
        int i = 0;
        while (i < 3) {
            if (this.parArea[i].contains(x, y)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void changeParameter(int par) {
        if (par != this.gd.parameter[this.changeAxis] && par < this.gd.cSymph.fs.nPars) {
            this.gd.parameter[this.changeAxis] = par;
            this.gd.instrName[this.changeAxis] = null;
            try {
                this.gd.cSymph.fs.readData(this.gd);
                this.fullRepaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void dragDisplay(int deltaX, int deltaY) {
        int rot = this.gd.cSymph.fs.scale[3];
        int tilt = this.gd.cSymph.fs.scale[4];
        rot = (rot + deltaX) % 360;
        tilt = (tilt += deltaY) < 0 ? 0 : tilt;
        tilt = tilt > 90 ? 90 : tilt;
        this.gd.cSymph.fs.scale[3] = rot;
        this.gd.cSymph.fs.scale[4] = tilt;
        this.fullRepaint();
        this.oldX += deltaX;
        this.oldY += deltaY;
    }
}

