/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.stats;

import java.util.Random;
import org.snpeff.interval.Marker;
import org.snpeff.stats.ChrPosStats;

public class PosStats
extends ChrPosStats {
    public static final int DEFAULT_BINS = 101;
    int maxIndex = 0;

    public PosStats() {
        super("", 101);
        this.name = "";
        this.maxBins = 101;
        this.init(this.maxBins);
        this.factor = 1;
    }

    public PosStats(String name) {
        super(name, 101);
        this.name = name;
        this.maxBins = 101;
        this.init(this.maxBins);
        this.factor = 1;
    }

    public PosStats(String name, int maxBins) {
        super(name, maxBins);
        this.name = name;
        this.maxBins = maxBins;
        this.init(maxBins);
    }

    public void rand(int maxLen, int countMax) {
        Random rand = new Random();
        double lambda = 0.95;
        int prev = 0;
        for (int i = 0; i < Math.min(maxLen, this.count.length); ++i) {
            double factor1 = (double)i / (double)maxLen;
            double factor2 = (double)(maxLen - i) / (double)maxLen;
            double factor = factor1 * factor2 / 0.25;
            this.count[i] = (int)(lambda * (double)prev + (1.0 - lambda) * factor * (double)rand.nextInt(countMax));
            prev = this.count[i];
        }
        this.maxIndex = maxLen;
    }

    public void sample(Marker marker, Marker markerReference) {
        if (!markerReference.intersects(marker)) {
            return;
        }
        int j = 0;
        int start = Math.max(marker.getStart(), markerReference.getStart());
        int end = Math.min(marker.getEnd(), markerReference.getEnd());
        double step2 = (double)markerReference.size() / (double)this.count.length;
        if (step2 <= 0.0) {
            step2 = 1.0;
        }
        if (markerReference.isStrandPlus()) {
            int jmin;
            j = jmin = (int)Math.round((double)(start - markerReference.getStart()) / step2);
            for (double pos = (double)start; pos <= (double)end && j < this.count.length; pos += step2) {
                int n = j++;
                this.count[n] = this.count[n] + 1;
            }
        } else {
            int jmin;
            j = jmin = (int)Math.round((double)(markerReference.getEnd() - end) / step2);
            for (double pos = (double)end; (double)start <= pos && j < this.count.length; pos -= step2) {
                int n = j++;
                this.count[n] = this.count[n] + 1;
            }
        }
        this.maxIndex = Math.max(this.maxIndex, j - 1);
    }

    @Override
    public int size() {
        return this.maxIndex + 1;
    }
}

