/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import org.junit.Assert;
import org.junit.Test;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.CytoBands;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.snpEffect.Config;
import org.snpeff.util.Gpr;

public class TestCasesCytoBands {
    boolean debug;
    boolean verbose;

    public TestCasesCytoBands() {
        this.verbose = this.debug = false;
    }

    @Test
    public void test01() {
        Gpr.debug("Test");
        String genomeVer = "testHg19Chr22";
        Config config = new Config(genomeVer);
        config.setVerbose(this.verbose);
        config.setDebug(this.debug);
        Genome genome = config.getGenome();
        CytoBands cytoBands = genome.getCytoBands();
        Assert.assertFalse("No cytobands found!", cytoBands.isEmpty());
    }

    @Test
    public void test02() {
        Gpr.debug("Test");
        String genomeVer = "testHg19Chr22";
        Config config = new Config(genomeVer);
        config.setVerbose(this.verbose);
        config.setDebug(this.debug);
        Genome genome = config.getGenome();
        CytoBands cytoBands = genome.getCytoBands();
        Chromosome chr = genome.getOrCreateChromosome("22");
        int pos = 4800000;
        Marker m = new Marker(chr, pos, pos);
        Markers cbs = cytoBands.query(m);
        if (this.verbose) {
            System.out.println("Resutls: ");
            for (Marker cb : cbs) {
                System.out.println(cb);
            }
        }
        Assert.assertTrue("Should find one cytoband for query: " + m, cbs.size() == 1);
        Assert.assertEquals("Expected cytoband 'p12' not found: " + m, "p12", cbs.get(0).getId());
    }
}

