/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.math;

import java.io.Serializable;
import org.biojava.bio.structure.math.SymbolTable;

public class SparseVector
implements Serializable {
    private static final long serialVersionUID = 1174668523213431927L;
    private final int N;
    private SymbolTable<Integer, Double> symbolTable;

    public SparseVector(int N) {
        this.N = N;
        this.symbolTable = new SymbolTable();
    }

    public void put(int i, double value2) {
        if (i < 0 || i >= this.N) {
            throw new IllegalArgumentException("Illegal index " + i + " should be > 0 and < " + this.N);
        }
        if (value2 == 0.0) {
            this.symbolTable.delete(i);
        } else {
            this.symbolTable.put(i, value2);
        }
    }

    public double get(int i) {
        if (i < 0 || i >= this.N) {
            throw new IllegalArgumentException("Illegal index " + i + " should be > 0 and < " + this.N);
        }
        if (this.symbolTable.contains(i)) {
            return this.symbolTable.get(i);
        }
        return 0.0;
    }

    public int nnz() {
        return this.symbolTable.size();
    }

    public int size() {
        return this.N;
    }

    public double dot(SparseVector b) {
        SparseVector a = this;
        if (a.N != b.N) {
            throw new IllegalArgumentException("Vector lengths disagree. " + a.N + " != " + b.N);
        }
        double sum2 = 0.0;
        if (a.symbolTable.size() <= b.symbolTable.size()) {
            for (int i : a.symbolTable) {
                if (!b.symbolTable.contains(i)) continue;
                sum2 += a.get(i) * b.get(i);
            }
        } else {
            for (int i : b.symbolTable) {
                if (!a.symbolTable.contains(i)) continue;
                sum2 += a.get(i) * b.get(i);
            }
        }
        return sum2;
    }

    public double norm() {
        SparseVector a = this;
        return Math.sqrt(a.dot(a));
    }

    public SparseVector scale(double alpha) {
        SparseVector a = this;
        SparseVector c = new SparseVector(this.N);
        for (int i : a.symbolTable) {
            c.put(i, alpha * a.get(i));
        }
        return c;
    }

    public SparseVector plus(SparseVector b) {
        SparseVector a = this;
        if (a.N != b.N) {
            throw new IllegalArgumentException("Vector lengths disagree : " + a.N + " != " + b.N);
        }
        SparseVector c = new SparseVector(this.N);
        for (int i : a.symbolTable) {
            c.put(i, a.get(i));
        }
        for (int i : b.symbolTable) {
            c.put(i, b.get(i) + c.get(i));
        }
        return c;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (int i : this.symbolTable) {
            s.append("(");
            s.append(i);
            s.append(", ");
            s.append(this.symbolTable.get(i));
            s.append(") ");
        }
        return s.toString();
    }
}

