/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.snpeff.SnpEff;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.VcfAnnotator;
import org.snpeff.snpEffect.commandLine.CommandLine;
import org.snpeff.util.Download;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfHeaderEntry;
import org.snpsift.SnpSiftCmdAlleleMatrix;
import org.snpsift.SnpSiftCmdAnnotate;
import org.snpsift.SnpSiftCmdCaseControl;
import org.snpsift.SnpSiftCmdConcordance;
import org.snpsift.SnpSiftCmdCovarianceMatrix;
import org.snpsift.SnpSiftCmdDbNsfp;
import org.snpsift.SnpSiftCmdExtractFields;
import org.snpsift.SnpSiftCmdFilter;
import org.snpsift.SnpSiftCmdFilterChrPos;
import org.snpsift.SnpSiftCmdFilterGt;
import org.snpsift.SnpSiftCmdGeneSets;
import org.snpsift.SnpSiftCmdGt;
import org.snpsift.SnpSiftCmdGwasCatalog;
import org.snpsift.SnpSiftCmdIntersect;
import org.snpsift.SnpSiftCmdIntervals;
import org.snpsift.SnpSiftCmdIntervalsIndex;
import org.snpsift.SnpSiftCmdJoin;
import org.snpsift.SnpSiftCmdPedShow;
import org.snpsift.SnpSiftCmdPhastCons;
import org.snpsift.SnpSiftCmdPrivate;
import org.snpsift.SnpSiftCmdRemoveReferenceGenotypes;
import org.snpsift.SnpSiftCmdRmInfo;
import org.snpsift.SnpSiftCmdSort;
import org.snpsift.SnpSiftCmdSplit;
import org.snpsift.SnpSiftCmdTsTv;
import org.snpsift.SnpSiftCmdVarType;
import org.snpsift.SnpSiftCmdVcf2Tped;
import org.snpsift.SnpSiftCmdVcfCheck;
import org.snpsift.SnpSiftCmdVcfOperator;
import org.snpsift.caseControl.SnpSiftCmdCaseControlSummary;
import org.snpsift.hwe.SnpSiftCmdHwe;

public class SnpSift
implements VcfAnnotator,
CommandLine {
    public static final String BUILD = SnpEff.BUILD;
    public static final String SOFTWARE_NAME = "SnpSift";
    public static final String VERSION_MAJOR = "4.3";
    public static final String REVISION = "t";
    public static final String VERSION_SHORT = "4.3t";
    public static final String VERSION = "4.3t (build " + BUILD + "), by " + "Pablo Cingolani";
    public static final String VERSION_NO_NAME = "SnpSift " + VERSION;
    public static final int MAX_ERRORS = 10;
    public static int SHOW_EVERY_VCFLINES = 100;
    public static final String[] EMPTY_ARGS = new String[0];
    protected boolean dbTabix;
    protected boolean debug;
    protected boolean download = true;
    protected boolean help;
    protected boolean log;
    protected boolean needsConfig;
    protected boolean needsDb;
    protected boolean needsGenome;
    protected boolean quiet;
    protected boolean saveOutput = false;
    protected boolean showVcfHeader = true;
    protected boolean showVersion = true;
    protected boolean suppressOutput = false;
    protected boolean vcfHeaderProcessed = false;
    protected boolean vcfHeaderAddProgramVersion = true;
    protected boolean verbose;
    protected String[] args;
    protected String command;
    protected String dbFileName;
    protected String dbType;
    protected String genomeVersion;
    protected String vcfInputFile;
    protected int numWorkers = 1;
    protected StringBuilder output = new StringBuilder();
    protected HashMap<String, Integer> errCount;
    protected Config config;
    protected String configFile;
    protected String dataDir;
    protected String[] shiftArgs;

    public static void main(String[] args) {
        SnpSift snpSift = new SnpSift(args);
        snpSift.run();
    }

    public SnpSift() {
        this.init();
    }

    public SnpSift(String[] args) {
        this.args = args;
        this.init();
    }

    @Override
    public boolean addHeaders(VcfFileIterator vcfFile) {
        for (VcfHeaderEntry hinf : this.headers()) {
            vcfFile.getVcfHeader().add(hinf);
        }
        return false;
    }

    @Override
    public boolean annotate(VcfEntry vcfEntry) {
        throw new RuntimeException("Unimplemented method!");
    }

    @Override
    public boolean annotateFinish(VcfFileIterator vcfFile) {
        if (vcfFile != null) {
            if (!this.vcfHeaderProcessed) {
                this.processVcfHeader(vcfFile);
            }
            vcfFile.close();
        }
        return true;
    }

    @Override
    public boolean annotateInit(VcfFileIterator vcfFile) {
        return true;
    }

    public SnpSift cmd() {
        this.parseArgs(this.args);
        SnpSift cmd = this.cmdFactory(this.command);
        this.copyValues(cmd);
        cmd.init();
        if (this.help) {
            cmd.usage(null);
            return null;
        }
        if ((this.verbose || this.debug) && this.showVersion) {
            Timer.showStdErr("SnpSift version " + VERSION);
            Timer.showStdErr("Command: '" + this.command + "'");
        }
        if (this.shiftArgs != null) {
            cmd.parseArgs(this.shiftArgs);
        }
        return cmd;
    }

    SnpSift cmdFactory(String command) {
        switch (command.trim().toLowerCase()) {
            case "all": 
            case "allelematrix": {
                return new SnpSiftCmdAlleleMatrix();
            }
            case "ann": 
            case "annotate": {
                return new SnpSiftCmdAnnotate();
            }
            case "ca": 
            case "casecontrol": {
                return new SnpSiftCmdCaseControl();
            }
            case "ccs": 
            case "casecontrolsummary": {
                return new SnpSiftCmdCaseControlSummary();
            }
            case "conc": 
            case "concordance": {
                return new SnpSiftCmdConcordance();
            }
            case "covmat": 
            case "covariancematrix": {
                return new SnpSiftCmdCovarianceMatrix();
            }
            case "dbnsfp": {
                return new SnpSiftCmdDbNsfp();
            }
            case "ex": 
            case "extractfields": {
                return new SnpSiftCmdExtractFields();
            }
            case "filterc": 
            case "filterchrpos": {
                return new SnpSiftCmdFilterChrPos();
            }
            case "fi": 
            case "filter": {
                return new SnpSiftCmdFilter();
            }
            case "genesets": {
                return new SnpSiftCmdGeneSets();
            }
            case "gtf": 
            case "filtergt": 
            case "gtfilter": {
                return new SnpSiftCmdFilterGt();
            }
            case "gt": {
                return new SnpSiftCmdGt();
            }
            case "gwascat": 
            case "gwascatalog": {
                return new SnpSiftCmdGwasCatalog();
            }
            case "hw": 
            case "hwe": {
                return new SnpSiftCmdHwe();
            }
            case "intidx": 
            case "intervalsindex": {
                return new SnpSiftCmdIntervalsIndex();
            }
            case "inters": 
            case "intersect": {
                return new SnpSiftCmdIntersect();
            }
            case "interv": 
            case "intervals": {
                return new SnpSiftCmdIntervals();
            }
            case "join": {
                return new SnpSiftCmdJoin();
            }
            case "op": 
            case "vcfoperator": {
                return new SnpSiftCmdVcfOperator();
            }
            case "pedshow": {
                return new SnpSiftCmdPedShow();
            }
            case "phastcons": {
                return new SnpSiftCmdPhastCons();
            }
            case "private": {
                return new SnpSiftCmdPrivate();
            }
            case "rminfo": {
                return new SnpSiftCmdRmInfo();
            }
            case "rmref": 
            case "rmrefgen": 
            case "removereferencegenotypes": {
                return new SnpSiftCmdRemoveReferenceGenotypes();
            }
            case "sort": {
                return new SnpSiftCmdSort();
            }
            case "split": {
                return new SnpSiftCmdSplit();
            }
            case "ts": 
            case "tstv": {
                return new SnpSiftCmdTsTv();
            }
            case "vartype": {
                return new SnpSiftCmdVarType();
            }
            case "vcf2tped": {
                return new SnpSiftCmdVcf2Tped();
            }
            case "vcfcheck": {
                return new SnpSiftCmdVcfCheck();
            }
        }
        this.usage("Unknown command '" + command + "'");
        return null;
    }

    protected String commandLineStr() {
        if (this.args == null) {
            return "";
        }
        StringBuilder argsList = new StringBuilder();
        argsList.append("SnpSift " + this.command + " ");
        if (this.args != null) {
            for (String arg : this.args) {
                if ((arg = arg.replace('\n', ' ').replace('\r', ' ').replace('\t', ' ').trim()).indexOf(32) > 0) {
                    arg = "'" + arg + "'";
                }
                argsList.append(arg + " ");
            }
        }
        return argsList.toString().trim();
    }

    void copyValues(SnpSift cmd) {
        cmd.args = this.shiftArgs;
        cmd.config = this.config;
        cmd.configFile = this.configFile;
        cmd.dbFileName = this.dbFileName;
        cmd.dbType = this.dbType;
        cmd.debug = this.debug;
        cmd.download = this.download;
        cmd.genomeVersion = this.genomeVersion;
        cmd.help = this.help;
        cmd.log = this.log;
        cmd.needsConfig = this.needsConfig;
        cmd.needsDb = this.needsDb;
        cmd.needsGenome = this.needsGenome;
        cmd.numWorkers = this.numWorkers;
        cmd.quiet = this.quiet;
        cmd.showVcfHeader = cmd.showVcfHeader;
        cmd.suppressOutput = this.suppressOutput;
        cmd.vcfHeaderAddProgramVersion = this.vcfHeaderAddProgramVersion;
        cmd.verbose = this.verbose;
        if (cmd.dbType == null || cmd.dbType.isEmpty()) {
            cmd.dbType = this.dbType;
        }
    }

    protected boolean databaseDownload() {
        if (!this.download) {
            return false;
        }
        String dbUrl = this.config.getDatabaseRepository(this.dbType);
        if (dbUrl == null) {
            this.fatalError("Database URL name is missing (missing entry in config file?).");
        }
        Timer.showStdErr("Downlading database from " + dbUrl);
        Download download = new Download();
        download.setVerbose(this.verbose);
        download.setDebug(this.debug);
        boolean ok = download.download(dbUrl, this.dbFileName);
        if (!ok) {
            return false;
        }
        if (this.dbTabix) {
            String indexUrl = this.config.getDatabaseRepository(this.dbType) + ".tbi";
            Timer.showStdErr("Downlading index from " + indexUrl);
            download = new Download();
            download.setVerbose(this.verbose);
            download.setDebug(this.debug);
            ok &= download.download(indexUrl, this.dbFileName + ".tbi");
        }
        return ok;
    }

    protected String databaseFind() {
        if (this.dbType == null && this.dbFileName == null) {
            throw new RuntimeException("Neither database type nor database file name set: This should never happen!");
        }
        if (this.dbFileName == null || this.dbFileName.isEmpty()) {
            this.dbFileName = this.config.getDatabaseLocal(this.dbType);
            if (this.dbFileName == null || this.dbFileName.isEmpty()) {
                String confgiKey = this.config.getDatabaseLocalKey(this.dbType);
                this.fatalError("Database file name not found. Missing '" + confgiKey + "' entry in SnpEff's config file?");
            }
        }
        return this.dbFileName;
    }

    public void error(Throwable e, String message) {
        if (this.verbose && e != null) {
            e.printStackTrace();
        }
        if (!this.quiet) {
            System.err.println(message);
        }
    }

    public void fatalError(String message) {
        System.err.println("Fatal error: " + message);
        System.exit(-1);
    }

    @Override
    public String[] getArgs() {
        return this.args;
    }

    public Config getConfig() {
        return this.config;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getOutput() {
        return this.output.toString();
    }

    protected List<VcfHeaderEntry> headers() {
        ArrayList<VcfHeaderEntry> newHeaders = new ArrayList<VcfHeaderEntry>();
        if (this.vcfHeaderAddProgramVersion) {
            newHeaders.add(new VcfHeaderEntry("##SnpSiftVersion=\"" + VERSION_NO_NAME + "\""));
            newHeaders.add(new VcfHeaderEntry("##SnpSiftCmd=\"" + this.commandLineStr() + "\""));
        }
        return newHeaders;
    }

    public void init() {
        this.genomeVersion = "";
        this.errCount = new HashMap();
        this.setCommand(this.getClass());
    }

    protected boolean isOpt(String arg) {
        return arg.startsWith("-") && arg.length() > 1;
    }

    protected void loadConfig() {
        if (this.config != null) {
            return;
        }
        if (this.configFile == null || this.configFile.isEmpty()) {
            this.configFile = "snpEff.config";
        }
        if (this.verbose) {
            Timer.showStdErr("Reading configuration file '" + this.configFile + "'");
        }
        this.config = new Config(this.genomeVersion, this.configFile, this.dataDir, null);
        if (this.verbose) {
            Timer.showStdErr("done");
        }
        this.config.setDebug(this.debug);
        this.config.setVerbose(this.verbose);
    }

    protected VcfFileIterator openVcfInputFile() {
        if (this.vcfInputFile == null || this.vcfInputFile.isEmpty() || this.vcfInputFile.equals("-")) {
            this.vcfInputFile = "-";
        }
        if (this.verbose) {
            Timer.showStdErr("Opening VCF input '" + (this.vcfInputFile.equals("-") ? "STDIN" : this.vcfInputFile) + "'");
        }
        VcfFileIterator vcf = new VcfFileIterator(this.vcfInputFile);
        vcf.setDebug(this.debug);
        return vcf;
    }

    @Override
    public void parseArgs(String[] args) {
        if (args == null) {
            return;
        }
        if (args.length < 1) {
            this.usage(null);
        }
        this.command = args[0];
        ArrayList<String> argsList = new ArrayList<String>();
        block37: for (int i = 1; i < args.length; ++i) {
            String arg = args[i];
            if (this.isOpt(arg)) {
                switch (arg.toLowerCase()) {
                    case "-c": 
                    case "-config": {
                        if (i + 1 < args.length) {
                            this.configFile = args[++i];
                            break;
                        }
                        this.usage("Option '-c' without config file argument");
                        break;
                    }
                    case "-cpus": {
                        if (args.length <= i) {
                            this.usage("Missing argument for command line option '-cpus'");
                        }
                        this.numWorkers = Gpr.parseIntSafe(args[++i]);
                        if (this.numWorkers > 0) continue block37;
                        this.usage("Error: Number of cpus must be positive");
                        break;
                    }
                    case "-d": 
                    case "-debug": {
                        this.verbose = true;
                        this.debug = true;
                        break;
                    }
                    case "-datadir": {
                        if (i + 1 < args.length) {
                            this.dataDir = args[++i];
                            break;
                        }
                        this.usage("Option '-dataDir' without data_dir argument");
                        break;
                    }
                    case "-db": 
                    case "-database": {
                        if (args.length <= i) {
                            this.usage("Missing argument for command line option '-db'");
                        }
                        this.dbFileName = args[++i];
                        break;
                    }
                    case "-h": 
                    case "-help": {
                        this.help = true;
                        break;
                    }
                    case "-g": 
                    case "-genome": {
                        if (i + 1 < args.length) {
                            this.genomeVersion = args[++i];
                            break;
                        }
                        this.usage("Option '-g' without argument");
                        break;
                    }
                    case "-nodownload": {
                        this.download = false;
                        break;
                    }
                    case "-nolog": {
                        this.log = false;
                        break;
                    }
                    case "-noout": {
                        this.suppressOutput = true;
                        break;
                    }
                    case "-q": 
                    case "-quiet": {
                        this.quiet = true;
                        break;
                    }
                    case "-v": 
                    case "-verbose": {
                        this.verbose = true;
                        break;
                    }
                    case "-version": {
                        System.out.println(VERSION_SHORT);
                        System.exit(0);
                        break;
                    }
                    default: {
                        argsList.add(args[i]);
                        break;
                    }
                }
                continue;
            }
            argsList.add(args[i]);
        }
        this.shiftArgs = argsList.toArray(new String[0]);
    }

    void print(Object o) {
        if (this.saveOutput) {
            this.output.append(o.toString() + "\n");
        } else if (!this.suppressOutput) {
            System.out.println(o.toString());
        }
    }

    protected String processVcfHeader(VcfFileIterator vcf) {
        if (this.vcfHeaderProcessed || !vcf.isHeadeSection() && vcf.getLineNum() > 1) {
            return "";
        }
        this.addHeaders(vcf);
        this.vcfHeaderProcessed = true;
        if (this.showVcfHeader) {
            String headerStr = vcf.getVcfHeader().toString();
            if (!headerStr.isEmpty()) {
                this.print(headerStr);
            }
            return headerStr;
        }
        return "";
    }

    @Override
    public boolean run() {
        SnpSift cmd = this.cmd();
        cmd.run();
        return true;
    }

    public void setCommand(Class clss) {
        this.command = clss.getSimpleName();
        int idx = "SnpSiftCmd".length();
        if (this.command.length() > idx) {
            this.command = this.command.substring(idx);
        }
    }

    public void setCommand(String command) {
        this.command = command;
    }

    @Override
    public void setConfig(Config config) {
        this.config = config;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setDbFileName(String dbFileName) {
        this.dbFileName = dbFileName;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void setSaveOutput(boolean saveOutput) {
        this.saveOutput = saveOutput;
    }

    public void setShowVcfHeader(boolean showVcfHeader) {
        this.showVcfHeader = showVcfHeader;
    }

    public void setShowVersion(boolean showVersion) {
        this.showVersion = showVersion;
    }

    public void setSuppressOutput(boolean suppressOutput) {
        this.suppressOutput = suppressOutput;
    }

    public void setVcfHeaderAddProgramVersion(boolean vcfHeaderAddProgramVersion) {
        this.vcfHeaderAddProgramVersion = vcfHeaderAddProgramVersion;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void showCmd() {
        System.err.print(SnpSift.class.getSimpleName() + " " + this.command + " ");
        if (this.args != null) {
            for (String a : this.args) {
                System.err.print(a + " ");
            }
        }
        System.err.println("");
    }

    public void showVersion() {
        System.err.println(SnpSift.class.getSimpleName() + " version " + VERSION + "\n");
    }

    public String unSanitize(String str) {
        str = str.replaceAll("__lt__", "<");
        str = str.replaceAll("__gt__", ">");
        str = str.replaceAll("__sq__", "'");
        str = str.replaceAll("__dq__", "\"");
        str = str.replaceAll("__ob__", "[");
        str = str.replaceAll("__cb__", "]");
        str = str.replaceAll("__oc__", "{");
        str = str.replaceAll("__cc__", "}");
        str = str.replaceAll("__oc__", "{");
        str = str.replaceAll("__at__", "@");
        str = str.replaceAll("__cn__", "\n");
        str = str.replaceAll("__cr__", "\r");
        str = str.replaceAll("__tc__", "\t");
        return str;
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Usage: java -jar " + SnpSift.class.getSimpleName() + ".jar [command] params...\nCommand is one of:\n\talleleMat     : Create an allele matrix output.\n\tannotate      : Annotate 'ID' from a database (e.g. dbSnp). Assumes entries are sorted.\n\tcaseControl   : Compare how many variants are in 'case' and in 'control' groups; calculate p-values.\n\tccs           : Case control summary. Case and control summaries by region, allele frequency and variant's functional effect.\n\tconcordance   : Concordance metrics between two VCF files.\n\tcovMat        : Create an covariance matrix output (allele matrix as input).\n\tdbnsfp        : Annotate with multiple entries from dbNSFP.\n\textractFields : Extract fields from VCF file into tab separated format.\n\tfilter        : Filter using arbitrary expressions\n\tgeneSets      : Annotate using MSigDb gene sets (MSigDb includes: GO, KEGG, Reactome, BioCarta, etc.)\n\tgt            : Add Genotype to INFO fields and remove genotype fields when possible.\n\tgtfilter      : Filter genotype using arbitrary expressions.\n\tgwasCat       : Annotate using GWAS catalog\n\thwe           : Calculate Hardy-Weimberg parameters and perform a godness of fit test.\n\tintersect     : Intersect intervals (genomic regions).\n\tintervals     : Keep variants that intersect with intervals.\n\tintIdx        : Keep variants that intersect with intervals. Index-based method: Used for large VCF file and a few intervals to retrieve\n\tjoin          : Join files by genomic region.\n\top            : Annotate using an operator.\n\tphastCons     : Annotate using conservation scores (phastCons).\n\tprivate       : Annotate if a variant is private to a family or group.\n\trmRefGen      : Remove reference genotypes.\n\trmInfo        : Remove INFO fields.\n\tsort          : Sort VCF file/s (if multiple input VCFs, merge and sort).\n\tsplit         : Split VCF by chromosome.\n\ttstv          : Calculate transiton to transversion ratio.\n\tvarType       : Annotate variant type (SNP,MNP,INS,DEL or MIXED).\n\tvcfCheck      : Check that VCF file is well formed.\n\tvcf2tped      : Convert VCF to TPED.");
        this.usageGenericAndDb();
        System.exit(1);
    }

    protected void usageGenericAndDb() {
        System.err.println("\nOptions common to all SnpSift commands:\n" + (this.needsConfig ? "\t-c , -config <file>  : Specify config file\n" : "") + "\t-d                   : Debug.\n" + (this.needsDb ? "\t-db <file>           : Database file name (for commands that require databases).\n" : "") + "\t-download            : Download database, if not available locally. Default: " + this.download + ".\n" + (this.needsGenome ? "\t-g <name>            : Genome version (for commands that require databases).\n" : "") + "\t-noDownload          : Do not download a database, if not available locally.\n\t-noLog               : Do not report usage statistics to server.\n\t-h                   : Help.\n\t-v                   : Verbose.\n");
    }

    protected void warn(String warn) {
        if (!this.errCount.containsKey(warn)) {
            this.errCount.put(warn, 0);
        }
        int count2 = this.errCount.get(warn);
        this.errCount.put(warn, count2 + 1);
        if (count2 < 10) {
            System.err.println("WARNING: " + warn);
        }
    }
}

