/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.stats;

import java.util.List;
import org.snpeff.stats.SamplingStats;
import org.snpeff.vcf.VcfEntry;

public class HomHetStats
implements SamplingStats<VcfEntry> {
    List<String> sampleNames;
    long[] countHomRef;
    long[] countAlt1;
    long[] countAlt2;
    long[] countMissing;

    @Override
    public boolean hasData() {
        return this.countHomRef != null;
    }

    @Override
    public void sample(VcfEntry vcfEntry) {
        if (this.sampleNames == null) {
            this.sampleNames = vcfEntry.getVcfFileIterator().getSampleNames();
        }
        if (!vcfEntry.isVariant()) {
            return;
        }
        byte[] gt = vcfEntry.getGenotypesScores();
        if (gt == null || gt.length < 1) {
            return;
        }
        if (this.countHomRef == null) {
            int size2 = gt.length;
            this.countHomRef = new long[size2];
            this.countAlt1 = new long[size2];
            this.countAlt2 = new long[size2];
            this.countMissing = new long[size2];
        }
        block6: for (int i = 0; i < gt.length; ++i) {
            switch (gt[i]) {
                case -1: {
                    int n = i;
                    this.countMissing[n] = this.countMissing[n] + 1L;
                    continue block6;
                }
                case 0: {
                    int n = i;
                    this.countHomRef[n] = this.countHomRef[n] + 1L;
                    continue block6;
                }
                case 1: {
                    int n = i;
                    this.countAlt1[n] = this.countAlt1[n] + 1L;
                    continue block6;
                }
                case 2: {
                    int n = i;
                    this.countAlt2[n] = this.countAlt2[n] + 1L;
                    continue block6;
                }
                default: {
                    throw new RuntimeException("Unknown genotype code '" + gt[i] + "'");
                }
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (!this.hasData()) {
            sb.append("No results available (empty input?)");
        } else {
            sb.append("Sample ,");
            if (this.sampleNames != null) {
                for (String sname : this.sampleNames) {
                    sb.append(sname + ",");
                }
            }
            sb.append("Total");
            sb.append("\n");
            sb.append(this.toStringArray("Homozygous reference", this.countHomRef));
            sb.append(this.toStringArray("One ALT", this.countAlt1));
            sb.append(this.toStringArray("Two ALTs", this.countAlt2));
            sb.append(this.toStringArray("Missing", this.countMissing));
        }
        return sb.toString();
    }

    String toStringArray(String title, long[] count2) {
        StringBuilder sb = new StringBuilder();
        sb.append(title + ",");
        long total = 0L;
        for (int i = 0; i < count2.length; ++i) {
            sb.append(count2[i] + ",");
            total += count2[i];
        }
        sb.append(total + "\n");
        return sb.toString();
    }
}

