/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.coverage;

import java.io.Serializable;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.snpeff.coverage.CoverageChr;
import org.snpeff.fileIterator.SamFileIterator;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Marker;
import org.snpeff.sam.SamEntry;
import org.snpeff.sam.SamHeaderRecord;
import org.snpeff.sam.SamHeaderRecordSq;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;

public class CountFragments
implements Serializable {
    private static int SHOW_EVERY = 10000;
    private static final long serialVersionUID = 1150158182247576450L;
    HashMap<String, CoverageChr> coverageByName = new HashMap();

    public static CountFragments calculateFromSam(String samFile, boolean verbose) {
        int i = 1;
        boolean header = true;
        String chrPrev = "";
        SamFileIterator sfi = new SamFileIterator(samFile);
        CountFragments coverage = new CountFragments();
        Pattern patternCigar = Pattern.compile("(\\d+)([A-Z])");
        if (verbose) {
            Timer.showStdErr("Processing file '" + samFile + "'");
        }
        for (SamEntry se : sfi) {
            if (header) {
                header = false;
                for (SamHeaderRecord rec : sfi.getHeaders().getRecords("SQ")) {
                    SamHeaderRecordSq sq = (SamHeaderRecordSq)rec;
                    coverage.createChr(sq.getSequenceName(), sq.getLength());
                }
            }
            String chrName = se.getRname();
            int start = se.getPos() - 1;
            String cigar = se.getCigar();
            Matcher matcher = patternCigar.matcher(cigar);
            while (matcher.find()) {
                int len = Gpr.parseIntSafe(matcher.group(1));
                String op = matcher.group(2);
                if (op.equals("M")) {
                    coverage.inc(chrName, start, start + len - 1);
                }
                if (!op.equals("M") && !op.equals("D") && !op.equals("N") && !op.equals("EQ") && !op.equals("X") && !op.equals("P")) continue;
                start += len;
            }
            if (!verbose) continue;
            if (!chrName.equals(chrPrev)) {
                System.err.println("");
                Timer.showStdErr(chrName + "\t");
            }
            chrPrev = chrName;
            Gpr.showMark(i++, SHOW_EVERY);
        }
        return coverage;
    }

    public double avgCoverage(Marker m) {
        String chr = m.getChromosomeName();
        CoverageChr cchr = this.get(chr);
        if (cchr == null) {
            throw new RuntimeException("Chromosome '" + chr + "' not found!");
        }
        return cchr.avgCoverage(m.getStart(), m.getEnd());
    }

    public void createChr(String chr, int len) {
        this.coverageByName.put(Chromosome.simpleName(chr), new CoverageChr(len));
    }

    public CoverageChr get(String chr) {
        return this.coverageByName.get(Chromosome.simpleName(chr));
    }

    public void inc(String chr, int start, int end) {
        chr = Chromosome.simpleName(chr);
        this.get(chr).inc(start, end);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.toString();
    }
}

