/*
 * Decompiled with CFR 0.152.
 */
package akka.jsr166y;

import akka.jsr166y.ForkJoinTask;
import akka.jsr166y.ForkJoinWorkerThread;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import sun.misc.Unsafe;

public class ForkJoinPool
extends AbstractExecutorService {
    public static final ForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory;
    private static final AtomicInteger poolNumberGenerator;
    static final AtomicInteger nextSubmitterSeed;
    private static final RuntimePermission modifyThreadPermission;
    private static final ThreadSubmitter submitters;
    private static final long SHRINK_RATE = 4000000000L;
    private static final long SHRINK_TIMEOUT = 3600000000L;
    private static final int MAX_HELP = 32;
    private static final long COMPENSATION_DELAY = 100000L;
    private static final int SEED_INCREMENT = 1640531527;
    private static final int AC_SHIFT = 48;
    private static final int TC_SHIFT = 32;
    private static final int ST_SHIFT = 31;
    private static final int EC_SHIFT = 16;
    private static final int SMASK = 65535;
    private static final int MAX_CAP = Short.MAX_VALUE;
    private static final int SQMASK = 65534;
    private static final int SHORT_SIGN = 32768;
    private static final int INT_SIGN = Integer.MIN_VALUE;
    private static final long STOP_BIT = 0x80000000L;
    private static final long AC_MASK = -281474976710656L;
    private static final long TC_MASK = 0xFFFF00000000L;
    private static final long TC_UNIT = 0x100000000L;
    private static final long AC_UNIT = 0x1000000000000L;
    private static final int UAC_SHIFT = 16;
    private static final int UTC_SHIFT = 0;
    private static final int UAC_MASK = -65536;
    private static final int UTC_MASK = 65535;
    private static final int UAC_UNIT = 65536;
    private static final int UTC_UNIT = 1;
    private static final int E_MASK = Integer.MAX_VALUE;
    private static final int E_SEQ = 65536;
    private static final int SHUTDOWN = Integer.MIN_VALUE;
    static final int LIFO_QUEUE = 0;
    static final int FIFO_QUEUE = 1;
    static final int SHARED_QUEUE = -1;
    volatile long ctl;
    final int parallelism;
    final int localMode;
    final int submitMask;
    int nextSeed;
    volatile int runState;
    WorkQueue[] workQueues;
    final Mutex lock;
    final Condition termination;
    final ForkJoinWorkerThreadFactory factory;
    final Thread.UncaughtExceptionHandler ueh;
    final AtomicLong stealCount;
    final AtomicInteger nextWorkerNumber;
    final String workerNamePrefix;
    private static final Unsafe U;
    private static final long CTL;
    private static final long PARKBLOCKER;
    private static final int ABASE;
    private static final int ASHIFT;

    private static void checkPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(modifyThreadPermission);
        }
    }

    private void addWorker() {
        Throwable throwable = null;
        ForkJoinWorkerThread forkJoinWorkerThread = null;
        try {
            forkJoinWorkerThread = this.factory.newThread(this);
            if (forkJoinWorkerThread != null) {
                forkJoinWorkerThread.start();
                return;
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        this.deregisterWorker(forkJoinWorkerThread, throwable);
    }

    final String nextWorkerName() {
        return this.workerNamePrefix.concat(Integer.toString(this.nextWorkerNumber.addAndGet(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void registerWorker(WorkQueue workQueue) {
        Mutex mutex = this.lock;
        mutex.lock();
        try {
            WorkQueue[] workQueueArray = this.workQueues;
            if (workQueue != null && workQueueArray != null) {
                int n = workQueueArray.length;
                int n2 = n - 1;
                int n3 = this.nextSeed += 1640531527;
                workQueue.seed = n3 == 0 ? 1 : n3;
                int n4 = n3 << 1 | 1;
                if (workQueueArray[n4 &= n2] != null) {
                    int n5;
                    int n6 = 0;
                    int n7 = n5 = n <= 4 ? 2 : (n >>> 1 & 0xFFFE) + 2;
                    while (workQueueArray[n4 = n4 + n5 & n2] != null) {
                        if (++n6 < n) continue;
                        this.workQueues = workQueueArray = Arrays.copyOf(workQueueArray, n <<= 1);
                        n2 = n - 1;
                        n6 = 0;
                    }
                }
                workQueue.eventCount = workQueue.poolIndex = n4;
                workQueueArray[n4] = workQueue;
                int n8 = this.runState;
                this.runState = n8 & Integer.MIN_VALUE | n8 + 2 & Integer.MAX_VALUE;
            }
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void deregisterWorker(ForkJoinWorkerThread forkJoinWorkerThread, Throwable throwable) {
        long l;
        Mutex mutex = this.lock;
        WorkQueue workQueue = null;
        if (forkJoinWorkerThread != null && (workQueue = forkJoinWorkerThread.workQueue) != null) {
            workQueue.runState = -1;
            this.stealCount.getAndAdd(workQueue.totalSteals + (long)workQueue.nsteals);
            int n = workQueue.poolIndex;
            mutex.lock();
            try {
                WorkQueue[] workQueueArray = this.workQueues;
                if (workQueueArray != null && n >= 0 && n < workQueueArray.length && workQueueArray[n] == workQueue) {
                    workQueueArray[n] = null;
                }
            }
            finally {
                mutex.unlock();
            }
        }
        while (!U.compareAndSwapLong(this, CTL, l = this.ctl, l - 0x1000000000000L & 0xFFFF000000000000L | l - 0x100000000L & 0xFFFF00000000L | l & 0xFFFFFFFFL)) {
        }
        if (!this.tryTerminate(false, false) && workQueue != null) {
            workQueue.cancelAll();
            if (workQueue.array != null) {
                this.signalWork();
            }
            if (throwable == null) {
                ForkJoinTask.helpExpungeStaleExceptions();
            }
        }
        if (throwable != null) {
            U.throwException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void doSubmit(ForkJoinTask<?> var1_1) {
        var2_2 = (Submitter)ForkJoinPool.submitters.get();
        var3_3 = var2_2.seed;
        var4_4 = this.submitMask;
        while (true) lbl-1000:
        // 6 sources

        {
            block12: {
                block11: {
                    var7_7 = var3_3 & var4_4 & 65534;
                    if (this.runState < 0) break block11;
                    var5_5 = this.workQueues;
                    if (this.workQueues != null && var5_5.length > var7_7) break block12;
                }
                throw new RejectedExecutionException();
            }
            var6_6 = var5_5[var7_7];
            if (var6_6 == null) {
                var8_8 = new WorkQueue(this, null, -1);
                var9_9 = this.lock;
                var9_9.lock();
                try {
                    var10_10 = this.runState;
                    if (var5_5 != this.workQueues || var5_5[var7_7] != null) ** GOTO lbl-1000
                    var5_5[var7_7] = var8_8;
                    this.runState = var10_10 & -2147483648 | var10_10 + 2 & 0x7FFFFFFF;
                }
                finally {
                    var9_9.unlock();
                }
                continue;
            }
            if (var6_6.trySharedPush(var1_1)) {
                this.signalWork();
                return;
            }
            if (var4_4 > 1) {
                var3_3 ^= var3_3 << 13;
                var3_3 ^= var3_3 >>> 17;
                var3_3 ^= var3_3 << 5;
                var2_2.seed = var3_3;
                continue;
            }
            Thread.yield();
        }
    }

    final void incrementActiveCount() {
        long l;
        while (!U.compareAndSwapLong(this, CTL, l = this.ctl, l + 0x1000000000000L)) {
        }
    }

    final void signalWork() {
        long l;
        int n;
        while ((n = (int)((l = this.ctl) >>> 32)) < 0) {
            long l2;
            WorkQueue[] workQueueArray = this.workQueues;
            int n2 = (int)l;
            if (n2 > 0) {
                WorkQueue workQueue;
                int n3;
                if (workQueueArray == null || (n3 = n2 & 0xFFFF) >= workQueueArray.length || (workQueue = workQueueArray[n3]) == null || workQueue.eventCount != (n2 | Integer.MIN_VALUE)) break;
                l2 = (long)(workQueue.nextWait & Integer.MAX_VALUE) | (long)(n + 65536) << 32;
                if (!U.compareAndSwapLong(this, CTL, l, l2)) continue;
                workQueue.eventCount = n2 + 65536 & Integer.MAX_VALUE;
                Thread thread = workQueue.parker;
                if (thread == null) break;
                U.unpark(thread);
                break;
            }
            if (n2 != 0 || (n & 0x8000) == 0) break;
            l2 = (long)(n + 1 & 0xFFFF | n + 65536 & 0xFFFF0000) << 32;
            if (!U.compareAndSwapLong(this, CTL, l, l2)) continue;
            this.addWorker();
            break;
        }
    }

    final void runWorker(WorkQueue workQueue) {
        workQueue.growArray(false);
        do {
            workQueue.runTask(this.scan(workQueue));
        } while (workQueue.runState >= 0);
    }

    private final ForkJoinTask<?> scan(WorkQueue workQueue) {
        int n;
        int n2 = workQueue.seed;
        n2 ^= n2 << 13;
        n2 ^= n2 >>> 17;
        n2 ^= n2 << 5;
        workQueue.seed = n2;
        int n3 = this.runState;
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null && (n = workQueueArray.length - 1) > 0) {
            int n4;
            int n5;
            int n6 = workQueue.eventCount;
            int n7 = n2 >>> 16 | 1;
            int n8 = n + 1 << 2;
            while (true) {
                WorkQueue workQueue2;
                if ((workQueue2 = workQueueArray[n2 & n]) != null && (n5 = workQueue2.base) - workQueue2.top < 0) {
                    ForkJoinTask<?>[] forkJoinTaskArray = workQueue2.array;
                    if (workQueue2.array != null) {
                        n4 = ((forkJoinTaskArray.length - 1 & n5) << ASHIFT) + ABASE;
                        ForkJoinTask forkJoinTask = (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, n4);
                        if (workQueue2.base == n5 && n6 >= 0 && forkJoinTask != null && U.compareAndSwapObject(forkJoinTaskArray, n4, forkJoinTask, null)) {
                            workQueue2.base = n5 + 1;
                            return forkJoinTask;
                        }
                        if (n6 < 0 || n8 <= n) {
                            n3 = 0;
                            break;
                        }
                    }
                }
                if (--n8 < 0) break;
                n2 += n7;
            }
            long l = this.ctl;
            int n9 = (int)l;
            int n10 = (int)(l >> 48);
            if (n9 < 0) {
                workQueue.runState = -1;
            } else if (n3 == 0 || n3 != this.runState) {
                WorkQueue workQueue3;
                if (n9 > 0 && n10 < 0 && workQueue.eventCount == n6 && (workQueue3 = workQueueArray[n9 & n]) != null && workQueue3.eventCount == (n9 | Integer.MIN_VALUE)) {
                    long l2 = (long)(workQueue3.nextWait & Integer.MAX_VALUE) | l + 0x1000000000000L & 0xFFFFFFFF00000000L;
                    if (this.ctl == l && U.compareAndSwapLong(this, CTL, l, l2)) {
                        workQueue3.eventCount = n9 + 65536 & Integer.MAX_VALUE;
                        Thread thread = workQueue3.parker;
                        if (thread != null) {
                            U.unpark(thread);
                        }
                    }
                }
            } else if (n6 >= 0) {
                long l3 = (long)n6 | l - 0x1000000000000L & 0xFFFFFFFF00000000L;
                workQueue.nextWait = n9;
                workQueue.eventCount = n6 | Integer.MIN_VALUE;
                if (this.ctl != l || !U.compareAndSwapLong(this, CTL, l, l3)) {
                    workQueue.eventCount = n6;
                } else {
                    n4 = workQueue.nsteals;
                    if (n4 != 0) {
                        workQueue.nsteals = 0;
                        workQueue.rescans = n10 > 0 ? 0 : n10 + this.parallelism;
                        workQueue.totalSteals += (long)n4;
                    }
                    if (n10 == 1 - this.parallelism) {
                        this.idleAwaitWork(workQueue, l3, l);
                    }
                }
            } else if (workQueue.eventCount < 0) {
                n5 = workQueue.rescans;
                if (n5 > 0) {
                    int n11 = n10 + this.parallelism;
                    workQueue.rescans = n11 < n5 ? n11 : n5 - 1;
                    if ((workQueue.rescans & 3) == 0) {
                        Thread.yield();
                    }
                } else {
                    Thread.interrupted();
                    Thread thread = Thread.currentThread();
                    U.putObject(thread, PARKBLOCKER, this);
                    workQueue.parker = thread;
                    if (workQueue.eventCount < 0) {
                        U.park(false, 0L);
                    }
                    workQueue.parker = null;
                    U.putObject(thread, PARKBLOCKER, null);
                }
            }
        }
        return null;
    }

    private void idleAwaitWork(WorkQueue workQueue, long l, long l2) {
        if (workQueue.eventCount < 0 && !this.tryTerminate(false, false) && (int)l2 != 0 && !this.hasQueuedSubmissions() && this.ctl == l) {
            Thread thread = Thread.currentThread();
            Thread.yield();
            while (this.ctl == l) {
                long l3 = System.nanoTime();
                Thread.interrupted();
                U.putObject(thread, PARKBLOCKER, this);
                workQueue.parker = thread;
                if (this.ctl == l) {
                    U.park(false, 4000000000L);
                }
                workQueue.parker = null;
                U.putObject(thread, PARKBLOCKER, null);
                if (this.ctl != l) break;
                if (System.nanoTime() - l3 < 3600000000L || !U.compareAndSwapLong(this, CTL, l, l2)) continue;
                workQueue.eventCount = workQueue.eventCount + 65536 | Integer.MAX_VALUE;
                workQueue.runState = -1;
                break;
            }
        }
    }

    private boolean tryHelpStealer(WorkQueue workQueue, ForkJoinTask<?> forkJoinTask) {
        int n;
        int n2 = 32;
        boolean bl = false;
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null && (n = workQueueArray.length - 1) > 0 && forkJoinTask.status >= 0) {
            ForkJoinTask<?> forkJoinTask2 = forkJoinTask;
            WorkQueue workQueue2 = workQueue;
            block0: while (true) {
                WorkQueue workQueue3 = null;
                WorkQueue workQueue4 = workQueueArray[workQueue2.stealHint & n];
                if (workQueue4 != null && workQueue4.currentSteal == forkJoinTask2) {
                    workQueue3 = workQueue4;
                } else {
                    for (int i = 1; i <= n; i += 2) {
                        workQueue4 = workQueueArray[i];
                        if (workQueue4 == null || workQueue4.currentSteal != forkJoinTask2 || workQueue4 == workQueue) continue;
                        workQueue3 = workQueue4;
                        workQueue2.stealHint = i;
                        break;
                    }
                    if (workQueue3 == null) break;
                }
                WorkQueue workQueue5 = workQueue3;
                while (forkJoinTask.status >= 0) {
                    int n3 = workQueue5.base;
                    if (n3 - workQueue5.top < 0) {
                        ForkJoinTask<?>[] forkJoinTaskArray = workQueue5.array;
                        if (workQueue5.array != null) {
                            bl = true;
                            int n4 = ((forkJoinTaskArray.length - 1 & n3) << ASHIFT) + ABASE;
                            ForkJoinTask forkJoinTask3 = (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, n4);
                            if (forkJoinTask2.status < 0) break block0;
                            if (forkJoinTask3 != null && workQueue5.base == n3 && U.compareAndSwapObject(forkJoinTaskArray, n4, forkJoinTask3, null)) {
                                workQueue5.base = n3 + 1;
                                workQueue.runSubtask(forkJoinTask3);
                                continue;
                            }
                            if (workQueue5.base != n3) continue;
                            break block0;
                        }
                    }
                    ForkJoinTask<?> forkJoinTask4 = workQueue3.currentJoin;
                    if (--n2 <= 0 || forkJoinTask2.status < 0 || forkJoinTask4 == null || forkJoinTask4 == forkJoinTask2) break block0;
                    forkJoinTask2 = forkJoinTask4;
                    workQueue2 = workQueue3;
                    continue block0;
                }
                break;
            }
        }
        return bl;
    }

    private void tryPollForAndExec(WorkQueue workQueue, ForkJoinTask<?> forkJoinTask) {
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 1; i < workQueueArray.length && forkJoinTask.status >= 0; i += 2) {
                WorkQueue workQueue2 = workQueueArray[i];
                if (workQueue2 == null || !workQueue2.pollFor(forkJoinTask)) continue;
                workQueue.runSubtask(forkJoinTask);
                break;
            }
        }
    }

    final boolean tryCompensate(ForkJoinTask<?> forkJoinTask, ManagedBlocker managedBlocker) {
        int n = this.parallelism;
        long l = this.ctl;
        WorkQueue[] workQueueArray = this.workQueues;
        int n2 = (int)l;
        if (n2 >= 0 && workQueueArray != null) {
            WorkQueue workQueue;
            int n3 = (int)(l >>> 32);
            int n4 = (short)(n3 >>> 0) + n;
            boolean bl = false;
            int n5 = n3 >> 16;
            if (n5 <= 0) {
                int n6;
                int n7 = n5 + n;
                if (n7 <= 1) {
                    bl = true;
                } else if (n2 > 0 || forkJoinTask != null && n7 <= (n6 = n >>> 1) && n4 < n + n6) {
                    for (int i = 0; i < workQueueArray.length; ++i) {
                        workQueue = workQueueArray[i];
                        if (workQueue == null || workQueue.isEmpty()) continue;
                        bl = true;
                        break;
                    }
                }
            }
            if (!(forkJoinTask != null && forkJoinTask.status < 0 || managedBlocker != null && managedBlocker.isReleasable() || this.ctl != l)) {
                long l2;
                if (!bl) {
                    long l3 = l - 0x1000000000000L & 0xFFFF000000000000L | l & 0xFFFFFFFFFFFFL;
                    if (U.compareAndSwapLong(this, CTL, l, l3)) {
                        return true;
                    }
                } else if (n2 != 0) {
                    int n8 = n2 & 0xFFFF;
                    if (n8 < workQueueArray.length && (workQueue = workQueueArray[n8]) != null) {
                        long l4 = (long)(workQueue.nextWait & Integer.MAX_VALUE) | l & 0xFFFFFFFF00000000L;
                        if (workQueue.eventCount == (n2 | Integer.MIN_VALUE) && U.compareAndSwapLong(this, CTL, l, l4)) {
                            workQueue.eventCount = n2 + 65536 & Integer.MAX_VALUE;
                            Thread thread = workQueue.parker;
                            if (thread != null) {
                                U.unpark(thread);
                            }
                            return true;
                        }
                    }
                } else if (n4 < Short.MAX_VALUE && U.compareAndSwapLong(this, CTL, l, l2 = l + 0x100000000L & 0xFFFF00000000L | l & 0xFFFF0000FFFFFFFFL)) {
                    this.addWorker();
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int awaitJoin(WorkQueue workQueue, ForkJoinTask<?> forkJoinTask) {
        ForkJoinTask<?> forkJoinTask2 = workQueue.currentJoin;
        int n = forkJoinTask.status;
        if (n >= 0) {
            workQueue.currentJoin = forkJoinTask;
            long l = 0L;
            int n2 = 0;
            while (true) {
                if (workQueue.isEmpty() ? !this.tryHelpStealer(workQueue, forkJoinTask) : !workQueue.tryRemoveAndExec(forkJoinTask)) {
                    if (n2 == 0) {
                        l = System.nanoTime();
                        this.tryPollForAndExec(workQueue, forkJoinTask);
                    } else if ((n2 & 0x1F) == 0 && System.nanoTime() - l >= 100000L && this.tryCompensate(forkJoinTask, null)) {
                        long l2;
                        if (forkJoinTask.trySetSignal() && forkJoinTask.status >= 0) {
                            ForkJoinTask<?> forkJoinTask3 = forkJoinTask;
                            synchronized (forkJoinTask3) {
                                if (forkJoinTask.status >= 0) {
                                    try {
                                        forkJoinTask.wait();
                                    }
                                    catch (InterruptedException interruptedException) {}
                                } else {
                                    forkJoinTask.notifyAll();
                                }
                            }
                        }
                        while (!U.compareAndSwapLong(this, CTL, l2 = this.ctl, l2 + 0x1000000000000L)) {
                        }
                    }
                }
                if ((n = forkJoinTask.status) < 0) {
                    workQueue.currentJoin = forkJoinTask2;
                    break;
                }
                if ((n2++ & 0x1F) != 16) continue;
                Thread.yield();
            }
        }
        return n;
    }

    final int helpJoinOnce(WorkQueue workQueue, ForkJoinTask<?> forkJoinTask) {
        int n;
        while ((n = forkJoinTask.status) >= 0 && (workQueue.isEmpty() ? this.tryHelpStealer(workQueue, forkJoinTask) : workQueue.tryRemoveAndExec(forkJoinTask))) {
        }
        return n;
    }

    private WorkQueue findNonEmptyStealQueue(WorkQueue workQueue) {
        int n = workQueue.seed;
        n ^= n << 13;
        n ^= n >>> 17;
        n ^= n << 5;
        workQueue.seed = n;
        int n2 = n >>> 16 | 1;
        block0: while (true) {
            int n3;
            int n4 = this.runState;
            WorkQueue[] workQueueArray = this.workQueues;
            if (this.workQueues == null || (n3 = workQueueArray.length - 1) < 1) {
                return null;
            }
            int n5 = n3 + 1 << 2;
            while (true) {
                WorkQueue workQueue2;
                if ((workQueue2 = workQueueArray[(n << 1 | 1) & n3]) != null && !workQueue2.isEmpty()) {
                    return workQueue2;
                }
                if (--n5 < 0) {
                    if (this.runState != n4) continue block0;
                    return null;
                }
                n += n2;
            }
            break;
        }
    }

    final void helpQuiescePool(WorkQueue workQueue) {
        long l;
        boolean bl = true;
        while (true) {
            ForkJoinTask<?> forkJoinTask;
            if ((forkJoinTask = workQueue.nextLocalTask()) != null) {
                forkJoinTask.doExec();
                continue;
            }
            WorkQueue workQueue2 = this.findNonEmptyStealQueue(workQueue);
            if (workQueue2 != null) {
                ForkJoinTask<?> forkJoinTask2;
                int n;
                if (!bl) {
                    long l2;
                    bl = true;
                    while (!U.compareAndSwapLong(this, CTL, l2 = this.ctl, l2 + 0x1000000000000L)) {
                    }
                }
                if ((n = workQueue2.base) - workQueue2.top >= 0 || (forkJoinTask2 = workQueue2.pollAt(n)) == null) continue;
                workQueue.runSubtask(forkJoinTask2);
                continue;
            }
            if (bl) {
                bl = false;
                do {
                    l = this.ctl;
                } while (!U.compareAndSwapLong(this, CTL, l, l -= 0x1000000000000L));
            } else {
                l = this.ctl;
            }
            if ((int)(l >> 48) + this.parallelism == 0) break;
        }
        while (!U.compareAndSwapLong(this, CTL, l = this.ctl, l + 0x1000000000000L)) {
        }
    }

    final ForkJoinTask<?> nextTaskFor(WorkQueue workQueue) {
        ForkJoinTask<?> forkJoinTask;
        WorkQueue workQueue2;
        int n;
        do {
            if ((forkJoinTask = workQueue.nextLocalTask()) != null) {
                return forkJoinTask;
            }
            workQueue2 = this.findNonEmptyStealQueue(workQueue);
            if (workQueue2 != null) continue;
            return null;
        } while ((n = workQueue2.base) - workQueue2.top >= 0 || (forkJoinTask = workQueue2.pollAt(n)) == null);
        return forkJoinTask;
    }

    final int idlePerActive() {
        int n = this.parallelism;
        int n2 = n + (int)(this.ctl >> 48);
        return n2 > (n >>>= 1) ? 0 : (n2 > (n >>>= 1) ? 1 : (n2 > (n >>>= 1) ? 2 : (n2 > (n >>>= 1) ? 4 : 8)));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private boolean tryTerminate(boolean var1_1, boolean var2_2) {
        var3_3 = this.lock;
        block0: while (true) {
            if (((var4_4 = this.ctl) & 0x80000000L) != 0L) {
                if ((short)(var4_4 >>> 32) == -this.parallelism) {
                    var3_3.lock();
                    this.termination.signalAll();
                    var3_3.unlock();
                }
                return true;
            }
            if (this.runState >= 0) {
                if (!var2_2) {
                    return false;
                }
                var3_3.lock();
                this.runState |= -2147483648;
                var3_3.unlock();
            }
            if (!var1_1) {
                if ((int)(var4_4 >> 48) != -this.parallelism || this.hasQueuedSubmissions()) {
                    return false;
                }
                var6_5 = this.workQueues;
                if (var6_5 != null) {
                    for (var8_8 = 1; var8_8 < var6_5.length; var8_8 += 2) {
                        var7_7 /* !! */  = var6_5[var8_8];
                        if (var7_7 /* !! */  == null || var7_7 /* !! */ .eventCount < 0) continue;
                        return false;
                    }
                }
            }
            if (!ForkJoinPool.U.compareAndSwapLong(this, ForkJoinPool.CTL, var4_4, var4_4 | 0x80000000L)) continue;
            var6_6 = 0;
            while (true) {
                if (var6_6 < 3) ** break;
                continue block0;
                var7_7 /* !! */  = this.workQueues;
                if (var7_7 /* !! */  != null) {
                    var9_11 = var7_7 /* !! */ .length;
                    for (var10_12 = 0; var10_12 < var9_11; ++var10_12) {
                        var8_9 = var7_7 /* !! */ [var10_12];
                        if (var8_9 == null) continue;
                        var8_9.runState = -1;
                        if (var6_6 <= 0) continue;
                        var8_9.cancelAll();
                        if (var6_6 <= 1) continue;
                        var8_9.interruptOwner();
                    }
                    while ((var11_13 = (int)(var12_14 = this.ctl) & 0x7FFFFFFF) != 0 && (var10_12 = var11_13 & 65535) < var9_11 && (var8_10 = var7_7 /* !! */ [var10_12]) != null) {
                        var15_16 = (long)(var8_10.nextWait & 0x7FFFFFFF) | var12_14 + 0x1000000000000L & -281474976710656L | var12_14 & 0xFFFF80000000L;
                        if (var8_10.eventCount != (var11_13 | -2147483648) || !ForkJoinPool.U.compareAndSwapLong(this, ForkJoinPool.CTL, var12_14, var15_16)) continue;
                        var8_10.eventCount = var11_13 + 65536 & 0x7FFFFFFF;
                        var8_10.runState = -1;
                        var14_15 = var8_10.parker;
                        if (var14_15 == null) continue;
                        ForkJoinPool.U.unpark(var14_15);
                    }
                }
                ++var6_6;
            }
            break;
        }
    }

    public ForkJoinPool() {
        this(Runtime.getRuntime().availableProcessors(), defaultForkJoinWorkerThreadFactory, null, false);
    }

    public ForkJoinPool(int n) {
        this(n, defaultForkJoinWorkerThreadFactory, null, false);
    }

    public ForkJoinPool(int n, ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, boolean bl) {
        ForkJoinPool.checkPermission();
        if (forkJoinWorkerThreadFactory == null) {
            throw new NullPointerException();
        }
        if (n <= 0 || n > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.parallelism = n;
        this.factory = forkJoinWorkerThreadFactory;
        this.ueh = uncaughtExceptionHandler;
        this.localMode = bl ? 1 : 0;
        long l = -n;
        this.ctl = l << 48 & 0xFFFF000000000000L | l << 32 & 0xFFFF00000000L;
        int n2 = n - 1;
        n2 |= n2 >>> 1;
        n2 |= n2 >>> 2;
        n2 |= n2 >>> 4;
        n2 |= n2 >>> 8;
        n2 |= n2 >>> 16;
        int n3 = n2 + 1 << 1;
        this.submitMask = n3 - 1;
        this.workQueues = new WorkQueue[n3];
        this.lock = new Mutex();
        this.termination = this.lock.newCondition();
        this.stealCount = new AtomicLong();
        this.nextWorkerNumber = new AtomicInteger();
        int n4 = poolNumberGenerator.incrementAndGet();
        StringBuilder stringBuilder = new StringBuilder("ForkJoinPool-");
        stringBuilder.append(Integer.toString(n4));
        stringBuilder.append("-worker-");
        this.workerNamePrefix = stringBuilder.toString();
        this.lock.lock();
        this.runState = 1;
        this.lock.unlock();
    }

    public <T> T invoke(ForkJoinTask<T> forkJoinTask) {
        if (forkJoinTask == null) {
            throw new NullPointerException();
        }
        this.doSubmit(forkJoinTask);
        return forkJoinTask.join();
    }

    public void execute(ForkJoinTask<?> forkJoinTask) {
        if (forkJoinTask == null) {
            throw new NullPointerException();
        }
        this.doSubmit(forkJoinTask);
    }

    @Override
    public void execute(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        ForkJoinTask forkJoinTask = runnable instanceof ForkJoinTask ? (ForkJoinTask)((Object)runnable) : new ForkJoinTask.AdaptedRunnableAction(runnable);
        this.doSubmit(forkJoinTask);
    }

    public <T> ForkJoinTask<T> submit(ForkJoinTask<T> forkJoinTask) {
        if (forkJoinTask == null) {
            throw new NullPointerException();
        }
        this.doSubmit(forkJoinTask);
        return forkJoinTask;
    }

    public <T> ForkJoinTask<T> submit(Callable<T> callable) {
        ForkJoinTask.AdaptedCallable<T> adaptedCallable = new ForkJoinTask.AdaptedCallable<T>(callable);
        this.doSubmit(adaptedCallable);
        return adaptedCallable;
    }

    public <T> ForkJoinTask<T> submit(Runnable runnable, T t) {
        ForkJoinTask.AdaptedRunnable<T> adaptedRunnable = new ForkJoinTask.AdaptedRunnable<T>(runnable, t);
        this.doSubmit(adaptedRunnable);
        return adaptedRunnable;
    }

    public ForkJoinTask<?> submit(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        ForkJoinTask forkJoinTask = runnable instanceof ForkJoinTask ? (ForkJoinTask)((Object)runnable) : new ForkJoinTask.AdaptedRunnableAction(runnable);
        this.doSubmit(forkJoinTask);
        return forkJoinTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) {
        ArrayList<ForkJoinTask.AdaptedCallable<T>> arrayList;
        ArrayList<ForkJoinTask.AdaptedCallable<T>> arrayList2 = arrayList = new ArrayList<ForkJoinTask.AdaptedCallable<T>>(collection.size());
        boolean bl = false;
        try {
            for (Callable<T> iterator2 : collection) {
                ForkJoinTask.AdaptedCallable<T> adaptedCallable = new ForkJoinTask.AdaptedCallable<T>(iterator2);
                this.doSubmit(adaptedCallable);
                arrayList.add(adaptedCallable);
            }
            for (ForkJoinTask forkJoinTask : arrayList) {
                forkJoinTask.quietlyJoin();
            }
            bl = true;
            ArrayList<ForkJoinTask.AdaptedCallable<T>> arrayList3 = arrayList2;
            return arrayList3;
        }
        finally {
            if (!bl) {
                for (ForkJoinTask forkJoinTask : arrayList) {
                    forkJoinTask.cancel(false);
                }
            }
        }
    }

    public ForkJoinWorkerThreadFactory getFactory() {
        return this.factory;
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.ueh;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getPoolSize() {
        return this.parallelism + (short)(this.ctl >>> 32);
    }

    public boolean getAsyncMode() {
        return this.localMode != 0;
    }

    public int getRunningThreadCount() {
        int n = 0;
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 1; i < workQueueArray.length; i += 2) {
                WorkQueue workQueue = workQueueArray[i];
                if (workQueue == null || !workQueue.isApparentlyUnblocked()) continue;
                ++n;
            }
        }
        return n;
    }

    public int getActiveThreadCount() {
        int n = this.parallelism + (int)(this.ctl >> 48);
        return n <= 0 ? 0 : n;
    }

    public boolean isQuiescent() {
        return (int)(this.ctl >> 48) + this.parallelism == 0;
    }

    public long getStealCount() {
        long l = this.stealCount.get();
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 1; i < workQueueArray.length; i += 2) {
                WorkQueue workQueue = workQueueArray[i];
                if (workQueue == null) continue;
                l += workQueue.totalSteals;
            }
        }
        return l;
    }

    public long getQueuedTaskCount() {
        long l = 0L;
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 1; i < workQueueArray.length; i += 2) {
                WorkQueue workQueue = workQueueArray[i];
                if (workQueue == null) continue;
                l += (long)workQueue.queueSize();
            }
        }
        return l;
    }

    public int getQueuedSubmissionCount() {
        int n = 0;
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < workQueueArray.length; i += 2) {
                WorkQueue workQueue = workQueueArray[i];
                if (workQueue == null) continue;
                n += workQueue.queueSize();
            }
        }
        return n;
    }

    public boolean hasQueuedSubmissions() {
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < workQueueArray.length; i += 2) {
                WorkQueue workQueue = workQueueArray[i];
                if (workQueue == null || workQueue.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    protected ForkJoinTask<?> pollSubmission() {
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < workQueueArray.length; i += 2) {
                ForkJoinTask<?> forkJoinTask;
                WorkQueue workQueue = workQueueArray[i];
                if (workQueue == null || (forkJoinTask = workQueue.poll()) == null) continue;
                return forkJoinTask;
            }
        }
        return null;
    }

    protected int drainTasksTo(Collection<? super ForkJoinTask<?>> collection) {
        int n = 0;
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < workQueueArray.length; ++i) {
                ForkJoinTask<?> forkJoinTask;
                WorkQueue workQueue = workQueueArray[i];
                if (workQueue == null) continue;
                while ((forkJoinTask = workQueue.poll()) != null) {
                    collection.add(forkJoinTask);
                    ++n;
                }
            }
        }
        return n;
    }

    public String toString() {
        int n;
        int n2;
        long l = 0L;
        long l2 = 0L;
        int n3 = 0;
        long l3 = this.stealCount.get();
        long l4 = this.ctl;
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (n2 = 0; n2 < workQueueArray.length; ++n2) {
                WorkQueue workQueue = workQueueArray[n2];
                if (workQueue == null) continue;
                n = workQueue.queueSize();
                if ((n2 & 1) == 0) {
                    l2 += (long)n;
                    continue;
                }
                l += (long)n;
                l3 += workQueue.totalSteals;
                if (!workQueue.isApparentlyUnblocked()) continue;
                ++n3;
            }
        }
        n2 = this.parallelism;
        n = n2 + (short)(l4 >>> 32);
        int n4 = n2 + (int)(l4 >> 48);
        if (n4 < 0) {
            n4 = 0;
        }
        String string2 = (l4 & 0x80000000L) != 0L ? (n == 0 ? "Terminated" : "Terminating") : (this.runState < 0 ? "Shutting down" : "Running");
        return super.toString() + "[" + string2 + ", parallelism = " + n2 + ", size = " + n + ", active = " + n4 + ", running = " + n3 + ", steals = " + l3 + ", tasks = " + l + ", submissions = " + l2 + "]";
    }

    @Override
    public void shutdown() {
        ForkJoinPool.checkPermission();
        this.tryTerminate(false, true);
    }

    @Override
    public List<Runnable> shutdownNow() {
        ForkJoinPool.checkPermission();
        this.tryTerminate(true, true);
        return Collections.emptyList();
    }

    @Override
    public boolean isTerminated() {
        long l = this.ctl;
        return (l & 0x80000000L) != 0L && (short)(l >>> 32) == -this.parallelism;
    }

    public boolean isTerminating() {
        long l = this.ctl;
        return (l & 0x80000000L) != 0L && (short)(l >>> 32) != -this.parallelism;
    }

    @Override
    public boolean isShutdown() {
        return this.runState < 0;
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        long l2 = timeUnit.toNanos(l);
        Mutex mutex = this.lock;
        mutex.lock();
        try {
            while (true) {
                if (this.isTerminated()) {
                    boolean bl = true;
                    return bl;
                }
                if (l2 <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                l2 = this.termination.awaitNanos(l2);
            }
        }
        finally {
            mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void managedBlock(ManagedBlocker managedBlocker) throws InterruptedException {
        ForkJoinPool forkJoinPool;
        Thread thread = Thread.currentThread();
        ForkJoinPool forkJoinPool2 = forkJoinPool = thread instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)thread).pool : null;
        while (!managedBlocker.isReleasable()) {
            if (forkJoinPool != null && !forkJoinPool.tryCompensate(null, managedBlocker)) continue;
            try {
                while (!managedBlocker.isReleasable() && !managedBlocker.block()) {
                }
                break;
            }
            finally {
                if (forkJoinPool != null) {
                    forkJoinPool.incrementActiveCount();
                }
            }
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
        return new ForkJoinTask.AdaptedRunnable<T>(runnable, t);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new ForkJoinTask.AdaptedCallable<T>(callable);
    }

    private static Unsafe getUnsafe() {
        return akka.util.Unsafe.instance;
    }

    static {
        int n;
        poolNumberGenerator = new AtomicInteger();
        nextSubmitterSeed = new AtomicInteger(0x55555555);
        modifyThreadPermission = new RuntimePermission("modifyThread");
        defaultForkJoinWorkerThreadFactory = new DefaultForkJoinWorkerThreadFactory();
        submitters = new ThreadSubmitter();
        try {
            U = ForkJoinPool.getUnsafe();
            Class<ForkJoinPool> clazz = ForkJoinPool.class;
            Class<ForkJoinTask[]> clazz2 = ForkJoinTask[].class;
            CTL = U.objectFieldOffset(clazz.getDeclaredField("ctl"));
            Class<Thread> clazz3 = Thread.class;
            PARKBLOCKER = U.objectFieldOffset(clazz3.getDeclaredField("parkBlocker"));
            ABASE = U.arrayBaseOffset(clazz2);
            n = U.arrayIndexScale(clazz2);
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
        if ((n & n - 1) != 0) {
            throw new Error("data type scale not a power of two");
        }
        ASHIFT = 31 - Integer.numberOfLeadingZeros(n);
    }

    public static interface ManagedBlocker {
        public boolean block() throws InterruptedException;

        public boolean isReleasable();
    }

    static final class ThreadSubmitter
    extends ThreadLocal<Submitter> {
        ThreadSubmitter() {
        }

        @Override
        public Submitter initialValue() {
            return new Submitter();
        }
    }

    static final class Submitter {
        int seed;

        Submitter() {
            int n = nextSubmitterSeed.getAndAdd(1640531527);
            this.seed = n == 0 ? 1 : n;
        }
    }

    static final class WorkQueue {
        static final int INITIAL_QUEUE_CAPACITY = 8192;
        static final int MAXIMUM_QUEUE_CAPACITY = 0x4000000;
        volatile long totalSteals;
        int seed;
        volatile int eventCount;
        int nextWait;
        int rescans;
        int nsteals;
        final int mode;
        int poolIndex;
        int stealHint;
        volatile int runState;
        volatile int base;
        int top;
        ForkJoinTask<?>[] array;
        final ForkJoinPool pool;
        final ForkJoinWorkerThread owner;
        volatile Thread parker;
        ForkJoinTask<?> currentJoin;
        ForkJoinTask<?> currentSteal;
        Object p00;
        Object p01;
        Object p02;
        Object p03;
        Object p04;
        Object p05;
        Object p06;
        Object p07;
        Object p08;
        Object p09;
        Object p0a;
        Object p0b;
        Object p0c;
        Object p0d;
        Object p0e;
        private static final Unsafe U;
        private static final long RUNSTATE;
        private static final int ABASE;
        private static final int ASHIFT;

        WorkQueue(ForkJoinPool forkJoinPool, ForkJoinWorkerThread forkJoinWorkerThread, int n) {
            this.mode = n;
            this.pool = forkJoinPool;
            this.owner = forkJoinWorkerThread;
            this.top = 4096;
            this.base = 4096;
        }

        final int queueSize() {
            int n = this.base - this.top;
            return n >= 0 ? 0 : -n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final boolean isEmpty() {
            int n = this.top;
            int n2 = this.base - n;
            if (n2 >= 0) return true;
            if (n2 != -1) return false;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            if (this.array == null) return true;
            int n3 = forkJoinTaskArray.length - 1;
            if (n3 < 0) return true;
            if (U.getObjectVolatile(forkJoinTaskArray, ((n3 & n - 1) << ASHIFT) + ABASE) != null) return false;
            return true;
        }

        final void push(ForkJoinTask<?> forkJoinTask) {
            int n = this.top;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            if (this.array != null) {
                int n2 = forkJoinTaskArray.length - 1;
                U.putOrderedObject(forkJoinTaskArray, ((n2 & n) << ASHIFT) + ABASE, forkJoinTask);
                this.top = n + 1;
                int n3 = this.top - this.base;
                if (n3 <= 2) {
                    ForkJoinPool forkJoinPool = this.pool;
                    if (forkJoinPool != null) {
                        forkJoinPool.signalWork();
                    }
                } else if (n3 >= n2) {
                    this.growArray(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean trySharedPush(ForkJoinTask<?> forkJoinTask) {
            boolean bl = false;
            if (this.runState == 0 && U.compareAndSwapInt(this, RUNSTATE, 0, 1)) {
                ForkJoinTask<?>[] forkJoinTaskArray = this.array;
                int n = this.top;
                try {
                    if (forkJoinTaskArray != null && forkJoinTaskArray.length > n + 1 - this.base || (forkJoinTaskArray = this.growArray(false)) != null) {
                        int n2 = ((forkJoinTaskArray.length - 1 & n) << ASHIFT) + ABASE;
                        U.putObject(forkJoinTaskArray, n2, forkJoinTask);
                        this.top = n + 1;
                        bl = true;
                    }
                }
                finally {
                    this.runState = 0;
                }
            }
            return bl;
        }

        final ForkJoinTask<?> pop() {
            int n;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            if (this.array != null && (n = forkJoinTaskArray.length - 1) >= 0) {
                long l;
                ForkJoinTask forkJoinTask;
                int n2;
                while ((n2 = this.top - 1) - this.base >= 0 && (forkJoinTask = (ForkJoinTask)U.getObject(forkJoinTaskArray, l = (long)(((n & n2) << ASHIFT) + ABASE))) != null) {
                    if (!U.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask, null)) continue;
                    this.top = n2;
                    return forkJoinTask;
                }
            }
            return null;
        }

        final ForkJoinTask<?> pollAt(int n) {
            int n2;
            ForkJoinTask forkJoinTask;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            if (this.array != null && (forkJoinTask = (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, n2 = ((forkJoinTaskArray.length - 1 & n) << ASHIFT) + ABASE)) != null && this.base == n && U.compareAndSwapObject(forkJoinTaskArray, n2, forkJoinTask, null)) {
                this.base = n + 1;
                return forkJoinTask;
            }
            return null;
        }

        final ForkJoinTask<?> poll() {
            int n;
            while ((n = this.base) - this.top < 0) {
                ForkJoinTask<?>[] forkJoinTaskArray = this.array;
                if (this.array == null) break;
                int n2 = ((forkJoinTaskArray.length - 1 & n) << ASHIFT) + ABASE;
                ForkJoinTask forkJoinTask = (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, n2);
                if (forkJoinTask != null) {
                    if (this.base != n || !U.compareAndSwapObject(forkJoinTaskArray, n2, forkJoinTask, null)) continue;
                    this.base = n + 1;
                    return forkJoinTask;
                }
                if (this.base != n) continue;
                if (n + 1 == this.top) break;
                Thread.yield();
            }
            return null;
        }

        final ForkJoinTask<?> nextLocalTask() {
            return this.mode == 0 ? this.pop() : this.poll();
        }

        final ForkJoinTask<?> peek() {
            int n;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            if (forkJoinTaskArray == null || (n = forkJoinTaskArray.length - 1) < 0) {
                return null;
            }
            int n2 = this.mode == 0 ? this.top - 1 : this.base;
            int n3 = ((n2 & n) << ASHIFT) + ABASE;
            return (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, n3);
        }

        final boolean tryUnpush(ForkJoinTask<?> forkJoinTask) {
            int n;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            if (this.array != null && (n = this.top) != this.base && U.compareAndSwapObject(forkJoinTaskArray, ((forkJoinTaskArray.length - 1 & --n) << ASHIFT) + ABASE, forkJoinTask, null)) {
                this.top = n;
                return true;
            }
            return false;
        }

        final boolean pollFor(ForkJoinTask<?> forkJoinTask) {
            int n = this.base;
            if (n - this.top < 0) {
                int n2;
                ForkJoinTask<?>[] forkJoinTaskArray = this.array;
                if (this.array != null && U.getObjectVolatile(forkJoinTaskArray, n2 = ((forkJoinTaskArray.length - 1 & n) << ASHIFT) + ABASE) == forkJoinTask && this.base == n && U.compareAndSwapObject(forkJoinTaskArray, n2, forkJoinTask, null)) {
                    this.base = n + 1;
                    return true;
                }
            }
            return false;
        }

        final ForkJoinTask<?>[] growArray(boolean bl) {
            int n;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            int n2 = n = forkJoinTaskArray != null ? forkJoinTaskArray.length << 1 : 8192;
            if (n <= 0x4000000) {
                int n3;
                int n4;
                int n5;
                this.array = new ForkJoinTask[n];
                ForkJoinTask[] forkJoinTaskArray2 = this.array;
                if (forkJoinTaskArray != null && (n5 = forkJoinTaskArray.length - 1) >= 0 && (n4 = this.top) - (n3 = this.base) > 0) {
                    int n6 = n - 1;
                    do {
                        int n7 = ((n3 & n5) << ASHIFT) + ABASE;
                        int n8 = ((n3 & n6) << ASHIFT) + ABASE;
                        ForkJoinTask forkJoinTask = (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, n7);
                        if (forkJoinTask == null || !U.compareAndSwapObject(forkJoinTaskArray, n7, forkJoinTask, null)) continue;
                        U.putObjectVolatile(forkJoinTaskArray2, n8, forkJoinTask);
                    } while (++n3 != n4);
                }
                return forkJoinTaskArray2;
            }
            if (!bl) {
                return null;
            }
            throw new RejectedExecutionException("Queue capacity exceeded");
        }

        final void cancelAll() {
            ForkJoinTask<?> forkJoinTask;
            ForkJoinTask.cancelIgnoringExceptions(this.currentJoin);
            ForkJoinTask.cancelIgnoringExceptions(this.currentSteal);
            while ((forkJoinTask = this.poll()) != null) {
                ForkJoinTask.cancelIgnoringExceptions(forkJoinTask);
            }
        }

        final int nextSeed() {
            int n = this.seed;
            n ^= n << 13;
            n ^= n >>> 17;
            n ^= n << 5;
            this.seed = n;
            return n;
        }

        private void popAndExecAll() {
            while (true) {
                long l;
                ForkJoinTask forkJoinTask;
                int n;
                int n2;
                ForkJoinTask<?>[] forkJoinTaskArray = this.array;
                if (this.array == null || (n2 = forkJoinTaskArray.length - 1) < 0 || (n = this.top - 1) - this.base < 0 || (forkJoinTask = (ForkJoinTask)U.getObject(forkJoinTaskArray, l = (long)(((n2 & n) << ASHIFT) + ABASE))) == null) break;
                if (!U.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask, null)) continue;
                this.top = n;
                forkJoinTask.doExec();
            }
        }

        private void pollAndExecAll() {
            ForkJoinTask<?> forkJoinTask;
            while ((forkJoinTask = this.poll()) != null) {
                forkJoinTask.doExec();
            }
        }

        final boolean tryRemoveAndExec(ForkJoinTask<?> forkJoinTask) {
            int n;
            int n2;
            int n3;
            int n4;
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = true;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            if (this.array != null && (n4 = forkJoinTaskArray.length - 1) >= 0 && (n3 = (n2 = this.top) - (n = this.base)) > 0) {
                int n5;
                ForkJoinTask forkJoinTask2;
                while ((forkJoinTask2 = (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, n5 = ((--n2 & n4) << ASHIFT) + ABASE)) != null) {
                    if (forkJoinTask2 == forkJoinTask) {
                        if (n2 + 1 == this.top) {
                            if (!U.compareAndSwapObject(forkJoinTaskArray, n5, forkJoinTask, null)) break;
                            this.top = n2;
                            bl = true;
                            break;
                        }
                        if (this.base != n) break;
                        bl = U.compareAndSwapObject(forkJoinTaskArray, n5, forkJoinTask, new EmptyTask());
                        break;
                    }
                    if (forkJoinTask2.status >= 0) {
                        bl2 = false;
                    } else if (n2 + 1 == this.top) {
                        if (!U.compareAndSwapObject(forkJoinTaskArray, n5, forkJoinTask2, null)) break;
                        this.top = n2;
                        break;
                    }
                    if (--n3 != 0) continue;
                    if (bl2 || this.base != n) break;
                    bl3 = false;
                    break;
                }
            }
            if (bl) {
                forkJoinTask.doExec();
            }
            return bl3;
        }

        final void runTask(ForkJoinTask<?> forkJoinTask) {
            if (forkJoinTask != null) {
                this.currentSteal = forkJoinTask;
                forkJoinTask.doExec();
                if (this.top != this.base) {
                    if (this.mode == 0) {
                        this.popAndExecAll();
                    } else {
                        this.pollAndExecAll();
                    }
                }
                ++this.nsteals;
                this.currentSteal = null;
            }
        }

        final void runSubtask(ForkJoinTask<?> forkJoinTask) {
            if (forkJoinTask != null) {
                ForkJoinTask<?> forkJoinTask2 = this.currentSteal;
                this.currentSteal = forkJoinTask;
                forkJoinTask.doExec();
                this.currentSteal = forkJoinTask2;
            }
        }

        final boolean isApparentlyUnblocked() {
            Thread.State state;
            ForkJoinWorkerThread forkJoinWorkerThread;
            return this.eventCount >= 0 && (forkJoinWorkerThread = this.owner) != null && (state = forkJoinWorkerThread.getState()) != Thread.State.BLOCKED && state != Thread.State.WAITING && state != Thread.State.TIMED_WAITING;
        }

        final void interruptOwner() {
            Thread thread;
            ForkJoinWorkerThread forkJoinWorkerThread = this.owner;
            if (forkJoinWorkerThread != null && !forkJoinWorkerThread.isInterrupted()) {
                try {
                    forkJoinWorkerThread.interrupt();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            if ((thread = this.parker) != null) {
                U.unpark(thread);
            }
        }

        static {
            int n;
            try {
                U = ForkJoinPool.getUnsafe();
                Class<WorkQueue> clazz = WorkQueue.class;
                Class<ForkJoinTask[]> clazz2 = ForkJoinTask[].class;
                RUNSTATE = U.objectFieldOffset(clazz.getDeclaredField("runState"));
                ABASE = U.arrayBaseOffset(clazz2);
                n = U.arrayIndexScale(clazz2);
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
            if ((n & n - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            ASHIFT = 31 - Integer.numberOfLeadingZeros(n);
        }
    }

    static final class EmptyTask
    extends ForkJoinTask<Void> {
        EmptyTask() {
            this.status = -268435456;
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void void_) {
        }

        @Override
        public final boolean exec() {
            return true;
        }
    }

    static final class Mutex
    extends AbstractQueuedSynchronizer {
        Mutex() {
        }

        @Override
        public final boolean tryAcquire(int n) {
            return this.compareAndSetState(0, 1);
        }

        @Override
        public final boolean tryRelease(int n) {
            this.setState(0);
            return true;
        }

        public final void lock() {
            this.acquire(0);
        }

        public final void unlock() {
            this.release(0);
        }

        @Override
        public final boolean isHeldExclusively() {
            return this.getState() == 1;
        }

        public final Condition newCondition() {
            return new AbstractQueuedSynchronizer.ConditionObject(this);
        }
    }

    static class DefaultForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        DefaultForkJoinWorkerThreadFactory() {
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool forkJoinPool) {
            return new ForkJoinWorkerThread(forkJoinPool);
        }
    }

    public static interface ForkJoinWorkerThreadFactory {
        public ForkJoinWorkerThread newThread(ForkJoinPool var1);
    }
}

