/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.pattern;

import com.informagen.StateMonitor;
import com.informagen.Util;
import com.informagen.sa.AnalysisPanel;
import com.informagen.sa.ImagePrinter;
import com.informagen.sa.SAObject;
import com.informagen.sa.SequenceAnalysis;
import com.informagen.sa.pattern.PatternViewerPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;

public class PatternPanel
extends AnalysisPanel {
    private final StateMonitor stateMonitor = new StateMonitor();
    final JComboBox patternsComboBox = new JComboBox();
    final JTextField patternTextField = new JTextField(20);
    final JCheckBox overlapChbx = new JCheckBox("Allow Overlapping Patterns", true);
    final JButton addBtn = new JButton("Add");
    final JButton changeBtn = new JButton("Change");
    final JButton removeBtn = new JButton("Remove");
    final JButton removeAllBtn = new JButton("Remove All");
    private final PatternViewerPanel viewerPanel = new PatternViewerPanel(this);

    public static String getAnalysisName() {
        return "Pattern";
    }

    public PatternPanel() {
        this.buildUI();
        this.wireUI();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("orfSelectionChanged")) {
            if (this.sequence == null) {
                return;
            }
            this.pcs.firePropertyChange("selectionChanged", null, propertyChangeEvent.getNewValue());
        } else if (string.equals("orfDoubleClicked")) {
            if (this.sequence == null) {
                return;
            }
            this.pcs.firePropertyChange("action.translate", null, null);
        }
    }

    public boolean ignorePropertyChangeEvents() {
        return false;
    }

    public void changeSequence(SAObject sAObject, int[] nArray) {
        this.saObject = sAObject;
        this.sequence = sAObject.getSequence();
        this.graphIt();
    }

    public void sequenceUnavailable() {
        this.saObject = null;
        this.sequence = null;
        this.viewerPanel.clear();
    }

    public void sequenceChanged(SAObject sAObject) {
        this.saObject = sAObject;
        this.sequence = sAObject.getSequence();
        this.graphIt();
    }

    public void selectionChanged(int[] nArray) {
    }

    public void selectionCancelled() {
    }

    public void cursorPositionChanged(int n) {
    }

    public void savePanel() {
        int n = this.viewerPanel.getSize().width;
        int n2 = this.viewerPanel.getSize().height;
        Image image = this.viewerPanel.createImage(n, n2);
        Graphics graphics = image.getGraphics();
        this.viewerPanel.paintAll(graphics);
        graphics.dispose();
        String string = this.sequence != null ? this.sequence.getUID() : "";
        Frame frame = Util.thisFrame(this);
        SequenceAnalysis.saveImage(frame, image, string, "Structure");
    }

    public void printPanel() {
        ImagePrinter imagePrinter = new ImagePrinter();
        int n = this.viewerPanel.getSize().width;
        int n2 = this.viewerPanel.getSize().height;
        Image image = this.viewerPanel.createImage(n, n2);
        Graphics graphics = image.getGraphics();
        this.viewerPanel.paintAll(graphics);
        graphics.dispose();
        imagePrinter.setImage(image);
        imagePrinter.print();
    }

    private void buildUI() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 10;
        int n2 = 5;
        int n3 = 5;
        int n4 = 10;
        gridBagConstraints.insets = new Insets(10, 5, 5, 10);
        int n5 = 0;
        int n6 = 0;
        JPanel jPanel = new JPanel(gridBagLayout);
        Util.buildConstraints(gridBagConstraints, n6++, n5, 1, 1, 0.0, 0.0, 10, 3);
        JPanel jPanel2 = this.buildPatternPanel();
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n6++, n5, 1, 1, 0.0, 0.0, 10, 3);
        JSeparator jSeparator = new JSeparator(1);
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        jPanel.add(jSeparator);
        Util.buildConstraints(gridBagConstraints, n6++, n5, 1, 1, 0.0, 0.0, 10, 0);
        JPanel jPanel3 = this.buildButtonsPanel();
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        Util.buildConstraints(gridBagConstraints, n6++, n5, 1, 1, 1.0, 1.0, 10, 10);
        JPanel jPanel4 = new JPanel();
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel.add(jPanel4);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.viewerPanel.setBackground(Color.white);
        this.add((Component)this.viewerPanel, "Center");
    }

    private JPanel buildPatternPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)new JLabel("Patterns:"), "North");
        jPanel.add((Component)this.patternsComboBox, "Center");
        jPanel.add((Component)this.patternTextField, "South");
        return jPanel;
    }

    private JPanel buildButtonsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(3, 3));
        JPanel jPanel2 = new JPanel(new BorderLayout(3, 3));
        JPanel jPanel3 = new JPanel(new BorderLayout(3, 3));
        this.overlapChbx.setAlignmentX(0.5f);
        jPanel.add((Component)this.overlapChbx, "North");
        jPanel2.add((Component)this.removeBtn, "North");
        jPanel3.add((Component)this.removeAllBtn, "North");
        jPanel2.add((Component)this.addBtn, "South");
        jPanel3.add((Component)this.changeBtn, "South");
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "East");
        return jPanel;
    }

    private void wireUI() {
        this.stateMonitor.associate(this.changeBtn, "hasPatterns");
        this.stateMonitor.associate(this.patternsComboBox, "hasPatterns");
        this.stateMonitor.associate(this.removeBtn, "hasPatterns");
        this.stateMonitor.associate(this.removeAllBtn, "hasPatterns");
        this.patternTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PatternPanel.this.addBtn.doClick();
            }
        });
        this.patternsComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PatternPanel.this.patternTextField.setText(PatternPanel.this.patternsComboBox.getSelectedItem().toString());
            }
        });
        this.overlapChbx.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PatternPanel.this.graphIt();
            }
        });
        this.addBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = PatternPanel.this.patternsComboBox.getSelectedIndex();
                n = n == -1 ? 0 : n + 1;
                PatternPanel.this.patternsComboBox.insertItemAt(PatternPanel.this.patternTextField.getText(), n);
                PatternPanel.this.patternsComboBox.setSelectedItem(PatternPanel.this.patternTextField.getText());
                PatternPanel.this.stateMonitor.changeState("hasPatterns", true);
                PatternPanel.this.graphIt();
            }
        });
        this.changeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = PatternPanel.this.patternsComboBox.getSelectedIndex();
                PatternPanel.this.patternsComboBox.insertItemAt(PatternPanel.this.patternTextField.getText(), n);
                PatternPanel.this.patternsComboBox.removeItemAt(n + 1);
                PatternPanel.this.patternsComboBox.setSelectedItem(PatternPanel.this.patternTextField.getText());
                PatternPanel.this.graphIt();
            }
        });
        this.removeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PatternPanel.this.patternsComboBox.removeItemAt(PatternPanel.this.patternsComboBox.getSelectedIndex());
                PatternPanel.this.patternTextField.setText("");
                PatternPanel.this.stateMonitor.changeState("hasPatterns", PatternPanel.this.patternsComboBox.getItemCount() > 0);
                PatternPanel.this.graphIt();
            }
        });
        this.removeAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PatternPanel.this.patternsComboBox.removeAllItems();
                PatternPanel.this.patternTextField.setText("");
                PatternPanel.this.stateMonitor.changeState("hasPatterns", false);
                PatternPanel.this.graphIt();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                PatternPanel.this.graphIt();
            }
        });
    }

    String[] getPatterns() {
        int n = this.patternsComboBox.getItemCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)this.patternsComboBox.getItemAt(i);
        }
        return stringArray;
    }

    public void graphIt() {
        if (this.sequence == null) {
            return;
        }
        if (this.workThread != null) {
            return;
        }
        this.workThread = new Thread(){

            public void run() {
                String[] stringArray = PatternPanel.this.getPatterns();
                StringBuffer stringBuffer = new StringBuffer();
                int n = PatternPanel.this.sequence.getLength();
                stringBuffer.append("<?xml version=\"1.0\" standalone=\"yes\"?>");
                stringBuffer.append("<PATTERNS name=\"\" length=\"").append(n).append("\">");
                for (int i = 0; i < stringArray.length; ++i) {
                    Pattern pattern;
                    String string = stringArray[i];
                    if (StringUtils.isBlank(string)) continue;
                    String string2 = PatternPanel.this.sequence.getSequence();
                    string2 = string2.toUpperCase();
                    try {
                        pattern = Pattern.compile(string.toUpperCase());
                        stringBuffer.append("<panel label=\"").append(string).append("\">");
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        stringBuffer.append("<panel label=\"").append(string).append(" - ");
                        stringBuffer.append(patternSyntaxException.getDescription());
                        stringBuffer.append("\">");
                        stringBuffer.append("</panel>");
                        continue;
                    }
                    Matcher matcher = pattern.matcher(string2);
                    int n2 = 0;
                    while (matcher.find(n2)) {
                        int n3 = matcher.start();
                        int n4 = matcher.end();
                        stringBuffer.append("<match from=\"").append(n3 + 1).append("\" ");
                        stringBuffer.append("to=\"").append(n4).append("\"></match>");
                        n2 = PatternPanel.this.overlapChbx.isSelected() ? n3 + 1 : n4;
                    }
                    stringBuffer.append("</panel>");
                }
                stringBuffer.append("</PATTERNS>");
                PatternPanel.this.viewerPanel.buildORFmap(stringBuffer.toString());
                PatternPanel.this.viewerPanel.initialZoom();
                PatternPanel.this.viewerPanel.invalidate();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PatternPanel.this.revalidate();
                    }
                });
                PatternPanel.this.workThread = null;
            }
        };
        try {
            this.workThread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

