/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.sa.digest;

import com.informagen.sa.digest.Enzyme;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import org.apache.commons.collections.iterators.ArrayIterator;

public class Enzymes {
    private static String REBASE_VERSION = "601";
    private final Preferences preferences = Preferences.userNodeForPackage(this.getClass());
    private static Vector enzymes = null;
    private static Vector fourCutters = new Vector();
    private static Vector sixCutters = new Vector();
    private static Vector perfectCutters = new Vector();
    private static Hashtable enzymeDictionary = new Hashtable();

    private static void loadEnzymes() {
        Enzymes enzymes = new Enzymes();
        enzymes.loadTheEnzymes();
    }

    private void loadTheEnzymes() {
        enzymes = new Vector();
        String string = this.fetchFromPreferences();
        if (string == null) {
            string = this.fetchREBASE();
        }
        if (string != null) {
            ArrayIterator arrayIterator = new ArrayIterator(string.split("\\n"));
            while (arrayIterator.hasNext()) {
                String string2 = (String)arrayIterator.next();
                if (string2.startsWith("#")) continue;
                String[] stringArray = string2.split("\\s");
                String string3 = stringArray[0];
                this.preferences.put("REBASE." + string3, string2);
                String string4 = stringArray[1];
                int n = Integer.parseInt(stringArray[2]);
                int n2 = Integer.parseInt(stringArray[3]);
                boolean bl = Integer.parseInt(stringArray[4]) == 1;
                int n3 = Integer.parseInt(stringArray[5]);
                int n4 = Integer.parseInt(stringArray[6]);
                int n5 = Integer.parseInt(stringArray[7]);
                int n6 = Integer.parseInt(stringArray[8]);
                if (n3 > 0 && n3 < n) {
                    StringBuffer stringBuffer = new StringBuffer(n + 1);
                    stringBuffer.append(string4.substring(0, n3));
                    stringBuffer.append('/');
                    stringBuffer.append(string4.substring(n3));
                    string4 = stringBuffer.toString();
                    Enzymes.addEnzyme(new Enzyme(string3, string4.toUpperCase(), n3, n4));
                    continue;
                }
                Enzymes.addEnzyme(new Enzyme(string3, string4.toUpperCase(), n3, n4));
            }
        } else {
            Enzymes.addEnzyme(new Enzyme("AatII", "gacgt/c"));
            Enzymes.addEnzyme(new Enzyme("AccI", "gt/mkac"));
            Enzymes.addEnzyme(new Enzyme("AciI", "c/cgc"));
            Enzymes.addEnzyme(new Enzyme("AgeI", "a/ccggt"));
            Enzymes.addEnzyme(new Enzyme("AflII", "c/ttaag"));
            Enzymes.addEnzyme(new Enzyme("AflIII", "a/crygt"));
            Enzymes.addEnzyme(new Enzyme("AhaII", "gr/cgyc"));
            Enzymes.addEnzyme(new Enzyme("AluI", "ag/ct"));
            Enzymes.addEnzyme(new Enzyme("AlwI", "ggatc", 4, 5));
            Enzymes.addEnzyme(new Enzyme("AlwNI", "cagnnn/ctg"));
            Enzymes.addEnzyme(new Enzyme("ApaI", "gggcc/c"));
            Enzymes.addEnzyme(new Enzyme("ApaLI", "g/tgcac"));
            Enzymes.addEnzyme(new Enzyme("ApoI", "r/aatty"));
            Enzymes.addEnzyme(new Enzyme("AscI", "gg/cgcgcc"));
            Enzymes.addEnzyme(new Enzyme("AseI", "at/taat"));
            Enzymes.addEnzyme(new Enzyme("Asp718-b", "g/gtacc"));
            Enzymes.addEnzyme(new Enzyme("AvaI", "c/ycgrg"));
            Enzymes.addEnzyme(new Enzyme("*AvaII", "g/gwcc"));
            Enzymes.addEnzyme(new Enzyme("AvrII", "c/ctagg"));
            Enzymes.addEnzyme(new Enzyme("BamHI", "g/gatcc"));
            Enzymes.addEnzyme(new Enzyme("BanI", "g/gyrcc"));
            Enzymes.addEnzyme(new Enzyme("BanII", "grgcy/c"));
            Enzymes.addEnzyme(new Enzyme("BbsI", "gaagac", 2, 6));
            Enzymes.addEnzyme(new Enzyme("BbvI", "gcagc", 8, 12));
            Enzymes.addEnzyme(new Enzyme("BcgI", "cgannnnnntgc", -22, 13));
            Enzymes.addEnzyme(new Enzyme("*BclI", "t/gatca"));
            Enzymes.addEnzyme(new Enzyme("BglI", "gccnnnn/nggc"));
            Enzymes.addEnzyme(new Enzyme("BglII", "a/gatct"));
            Enzymes.addEnzyme(new Enzyme("BsaI", "ggtctc", 1, 5));
            Enzymes.addEnzyme(new Enzyme("BsaAI", "yac/gtr"));
            Enzymes.addEnzyme(new Enzyme("BsaBI", "gatnn/nnatc"));
            Enzymes.addEnzyme(new Enzyme("BsaJI", "c/cnngg"));
            Enzymes.addEnzyme(new Enzyme("BsiWI", "c/gtacg"));
            Enzymes.addEnzyme(new Enzyme("BsmI", "gaatgc", 1, -1));
            Enzymes.addEnzyme(new Enzyme("BsmAI", "gtctc", 1, 5));
            Enzymes.addEnzyme(new Enzyme("Bsp1286I", "gdgch/c"));
            Enzymes.addEnzyme(new Enzyme("BspEI", "t/ccgga"));
            Enzymes.addEnzyme(new Enzyme("BspHI", "t/catga"));
            Enzymes.addEnzyme(new Enzyme("BspMI", "acctgc", 4, 8));
            Enzymes.addEnzyme(new Enzyme("BsrI", "actgg", 1, -1));
            Enzymes.addEnzyme(new Enzyme("BsrBI", "gag/cgg"));
            Enzymes.addEnzyme(new Enzyme("BssHII", "g/cgcgc"));
            Enzymes.addEnzyme(new Enzyme("BstBI", "tt/cgaa"));
            Enzymes.addEnzyme(new Enzyme("BstEII", "g/gtnacc"));
            Enzymes.addEnzyme(new Enzyme("*BstNI", "cc/wgg"));
            Enzymes.addEnzyme(new Enzyme("BstUI", "cg/cg"));
            Enzymes.addEnzyme(new Enzyme("BstXI", "ccannnnn/ntgg"));
            Enzymes.addEnzyme(new Enzyme("BstYI", "r/gatcy"));
            Enzymes.addEnzyme(new Enzyme("Bsu36I", "cc/tnagg"));
            Enzymes.addEnzyme(new Enzyme("Cfr10I", "r/ccggy"));
            Enzymes.addEnzyme(new Enzyme("*ClaI", "at/cgat"));
            Enzymes.addEnzyme(new Enzyme("DdeI", "c/tnag"));
            Enzymes.addEnzyme(new Enzyme("*DpnI", "ga/tc"));
            Enzymes.addEnzyme(new Enzyme("DraI", "ttt/aaa"));
            Enzymes.addEnzyme(new Enzyme("DraIII", "cacnnn/gtg"));
            Enzymes.addEnzyme(new Enzyme("DrdI", "gacnnnn/nngtc"));
            Enzymes.addEnzyme(new Enzyme("DsaI-b", "c/crygg"));
            Enzymes.addEnzyme(new Enzyme("DsaV-b", "/ccngg"));
            Enzymes.addEnzyme(new Enzyme("EaeI", "y/ggccr"));
            Enzymes.addEnzyme(new Enzyme("EagI", "c/ggccg"));
            Enzymes.addEnzyme(new Enzyme("EarI", "ctcttc", 1, 4));
            Enzymes.addEnzyme(new Enzyme("Eco47III-b", "agc/gct"));
            Enzymes.addEnzyme(new Enzyme("EcoNI", "cctnn/nnnagg"));
            Enzymes.addEnzyme(new Enzyme("EcoO109I", "rg/gnccy"));
            Enzymes.addEnzyme(new Enzyme("EcoRI", "g/aattc"));
            Enzymes.addEnzyme(new Enzyme("EcoRII-s", "/ccwgg"));
            Enzymes.addEnzyme(new Enzyme("EcoRV", "gat/atc"));
            Enzymes.addEnzyme(new Enzyme("EheI-u", "ggc/gcc"));
            Enzymes.addEnzyme(new Enzyme("EspI-u", "gc/tnagc"));
            Enzymes.addEnzyme(new Enzyme("Fnu4HI", "gc/ngc"));
            Enzymes.addEnzyme(new Enzyme("FokI", "ggatg", 9, 13));
            Enzymes.addEnzyme(new Enzyme("FseI", "ggccgg/cc"));
            Enzymes.addEnzyme(new Enzyme("FspI", "tgc/gca"));
            Enzymes.addEnzyme(new Enzyme("HaeII", "rgcgc/y"));
            Enzymes.addEnzyme(new Enzyme("*HaeIII", "gg/cc"));
            Enzymes.addEnzyme(new Enzyme("HgaI", "gacgc", 5, 10));
            Enzymes.addEnzyme(new Enzyme("HgiAI", "gwgcw/c"));
            Enzymes.addEnzyme(new Enzyme("HhaI", "gcg/c"));
            Enzymes.addEnzyme(new Enzyme("HincII", "gty/rac"));
            Enzymes.addEnzyme(new Enzyme("HindIII", "a/agctt"));
            Enzymes.addEnzyme(new Enzyme("HinfI", "g/antc"));
            Enzymes.addEnzyme(new Enzyme("HinPI", "g/cgc"));
            Enzymes.addEnzyme(new Enzyme("HpaI", "gtt/aac"));
            Enzymes.addEnzyme(new Enzyme("*HpaII", "c/cgg"));
            Enzymes.addEnzyme(new Enzyme("HphI", "ggtga", 8, 7));
            Enzymes.addEnzyme(new Enzyme("KasI", "g/gcgcc"));
            Enzymes.addEnzyme(new Enzyme("KpnI", "ggtac/c"));
            Enzymes.addEnzyme(new Enzyme("MaeII-b", "a/cgt"));
            Enzymes.addEnzyme(new Enzyme("MaeIII-b", "/gtnac"));
            Enzymes.addEnzyme(new Enzyme("*MboII", "gaaga", 8, 7));
            Enzymes.addEnzyme(new Enzyme("MluI", "a/cgcgt"));
            Enzymes.addEnzyme(new Enzyme("MnlI", "cctc", 7, 7));
            Enzymes.addEnzyme(new Enzyme("MscI", "tgg/cca"));
            Enzymes.addEnzyme(new Enzyme("MseI", "t/taa"));
            Enzymes.addEnzyme(new Enzyme("NaeI", "gcc/ggc"));
            Enzymes.addEnzyme(new Enzyme("NarI", "gg/cgcc"));
            Enzymes.addEnzyme(new Enzyme("NciI", "cc/sgg"));
            Enzymes.addEnzyme(new Enzyme("NcoI", "c/catgg"));
            Enzymes.addEnzyme(new Enzyme("NdeI", "ca/tatg"));
            Enzymes.addEnzyme(new Enzyme("NheI", "g/ctagc"));
            Enzymes.addEnzyme(new Enzyme("NlaIII", "catg/"));
            Enzymes.addEnzyme(new Enzyme("NlaIV", "ggn/ncc"));
            Enzymes.addEnzyme(new Enzyme("NotI", "gc/ggccgc"));
            Enzymes.addEnzyme(new Enzyme("NruI", "tcg/cga"));
            Enzymes.addEnzyme(new Enzyme("NsiI", "atgca/t"));
            Enzymes.addEnzyme(new Enzyme("NspI-b", "rcatg/y"));
            Enzymes.addEnzyme(new Enzyme("PacI", "ttaat/taa"));
            Enzymes.addEnzyme(new Enzyme("PflMI", "ccannnn/ntgg"));
            Enzymes.addEnzyme(new Enzyme("PleI", "gagtc", 4, 5));
            Enzymes.addEnzyme(new Enzyme("PmeI", "gttt/aaac"));
            Enzymes.addEnzyme(new Enzyme("PmlI", "cac/gtg"));
            Enzymes.addEnzyme(new Enzyme("PpuMI", "rg/gwccy"));
            Enzymes.addEnzyme(new Enzyme("PstI", "ctgca/g"));
            Enzymes.addEnzyme(new Enzyme("*PvuI", "cgat/cg"));
            Enzymes.addEnzyme(new Enzyme("*PvuII", "cag/ctg"));
            Enzymes.addEnzyme(new Enzyme("RmaI", "c/tag"));
            Enzymes.addEnzyme(new Enzyme("RsaI", "gt/ac"));
            Enzymes.addEnzyme(new Enzyme("RsrII", "cg/gwccg"));
            Enzymes.addEnzyme(new Enzyme("SacI", "gagct/c"));
            Enzymes.addEnzyme(new Enzyme("SacII", "ccgc/gg"));
            Enzymes.addEnzyme(new Enzyme("*SalI", "g/tcgac"));
            Enzymes.addEnzyme(new Enzyme("Sau3AI", "/gatc"));
            Enzymes.addEnzyme(new Enzyme("*Sau96I", "g/gncc"));
            Enzymes.addEnzyme(new Enzyme("ScaI", "agt/act"));
            Enzymes.addEnzyme(new Enzyme("*ScrFI", "cc/ngg"));
            Enzymes.addEnzyme(new Enzyme("SfaNI", "gcatc", 5, 9));
            Enzymes.addEnzyme(new Enzyme("SfiI", "ggccnnnn/nggcc"));
            Enzymes.addEnzyme(new Enzyme("SgrAI-b", "gr/ccggyg"));
            Enzymes.addEnzyme(new Enzyme("SmaI", "ccc/ggg"));
            Enzymes.addEnzyme(new Enzyme("SnaBI", "tac/gta"));
            Enzymes.addEnzyme(new Enzyme("SpeI", "a/ctagt"));
            Enzymes.addEnzyme(new Enzyme("SphI", "gcatg/c"));
            Enzymes.addEnzyme(new Enzyme("Sse8387I-t", "cctgca/gg"));
            Enzymes.addEnzyme(new Enzyme("SspI", "aat/att"));
            Enzymes.addEnzyme(new Enzyme("*StuI", "agg/cct"));
            Enzymes.addEnzyme(new Enzyme("StyI", "c/cwwgg"));
            Enzymes.addEnzyme(new Enzyme("*TaqI", "t/cga"));
            Enzymes.addEnzyme(new Enzyme("TfiI", "g/awtc"));
            Enzymes.addEnzyme(new Enzyme("Tth111I", "gacn/nngtc"));
            Enzymes.addEnzyme(new Enzyme("*XbaI", "t/ctaga"));
            Enzymes.addEnzyme(new Enzyme("XcmI", "ccannnnn/nnnntgg"));
            Enzymes.addEnzyme(new Enzyme("XhoI", "c/tcgag"));
            Enzymes.addEnzyme(new Enzyme("XmaI", "c/ccggg"));
            Enzymes.addEnzyme(new Enzyme("XmnI", "gaann/nnttc"));
        }
    }

    private String fetchFromPreferences() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            ArrayIterator arrayIterator = new ArrayIterator(this.preferences.keys());
            while (arrayIterator.hasNext()) {
                String string = (String)arrayIterator.next();
                if (!string.startsWith("REBASE.")) continue;
                stringBuffer.append(this.preferences.get(string, "")).append("\n");
            }
        }
        catch (BackingStoreException backingStoreException) {
            return null;
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString() : null;
    }

    private String fetchREBASE() {
        String string = null;
        try {
            int n;
            InputStream inputStream = this.getClass().getResourceAsStream("/com/informagen/sa/digest/link_emboss_e.txt");
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            StringWriter stringWriter = new StringWriter();
            while ((n = inputStreamReader.read()) != -1) {
                stringWriter.write(n);
            }
            inputStreamReader.close();
            string = stringWriter.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(null, exception.getMessage());
        }
        return string;
    }

    private static void addEnzyme(Enzyme enzyme) {
        enzymes.add(enzyme);
        enzymeDictionary.put(enzyme.getName(), enzyme);
        if (enzyme.isFourCutter()) {
            fourCutters.add(enzyme);
        }
        if (enzyme.isSixCutter()) {
            sixCutters.add(enzyme);
        }
        if (enzyme.isPerfect()) {
            perfectCutters.add(enzyme);
        }
    }

    public static String getREBASEVersion() {
        return REBASE_VERSION;
    }

    public static void clear() {
        enzymes = null;
    }

    public static Enzyme getEnzyme(String string) {
        if (enzymes == null) {
            Enzymes.loadEnzymes();
        }
        return (Enzyme)enzymeDictionary.get(string);
    }

    public static Vector getAllEnzymes() {
        if (enzymes == null) {
            Enzymes.loadEnzymes();
        }
        return enzymes;
    }

    public static Vector getFourCutterEnzymes() {
        if (enzymes == null) {
            Enzymes.loadEnzymes();
        }
        return fourCutters;
    }

    public static Vector getSixCutterEnzymes() {
        if (enzymes == null) {
            Enzymes.loadEnzymes();
        }
        return sixCutters;
    }

    public static Vector getPerfectCutterEnzymes() {
        if (enzymes == null) {
            Enzymes.loadEnzymes();
        }
        return perfectCutters;
    }
}

