/*
 * Decompiled with CFR 0.152.
 */
package com.informagen.giv;

import com.informagen.giv.MapGlyph;
import com.informagen.giv.MapGlyphListener;
import com.informagen.giv.MapTile;
import com.informagen.giv.MapTileListener;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

class GlyphPanelMouseListener
extends MouseAdapter {
    private MapGlyph selectedGlyph = null;
    private MapTile selectedTile = null;
    private MapGlyphListener glyphListener = null;
    private MapTileListener tileListener = null;

    GlyphPanelMouseListener() {
    }

    private void buildUI() {
    }

    private boolean firePopupTrigger(MouseEvent mouseEvent) {
        return false;
    }

    MapGlyph getSelectedGlyph() {
        return this.selectedGlyph;
    }

    MapTile getSelectedTile() {
        return this.selectedTile;
    }

    void addGlyphListener(MapGlyphListener mapGlyphListener) {
        this.glyphListener = mapGlyphListener;
    }

    void addTileListener(MapTileListener mapTileListener) {
        this.tileListener = mapTileListener;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.firePopupTrigger(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component instanceof MapGlyph) {
            MapGlyph mapGlyph = (MapGlyph)component;
            if (this.selectedGlyph != null) {
                this.selectedGlyph.mSelected = false;
                this.selectedGlyph.repaint();
            }
            if (this.selectedTile != null) {
                this.selectedTile.selected = false;
                this.selectedTile.repaint();
            }
            this.selectedGlyph = mapGlyph;
            this.selectedGlyph.mSelected = true;
            this.selectedGlyph.repaint();
            if (this.glyphListener != null) {
                this.glyphListener.glyphSelected(this.selectedGlyph);
            }
        } else if (component instanceof MapTile) {
            MapTile mapTile = (MapTile)component;
            if (this.selectedGlyph != null) {
                this.selectedGlyph.mSelected = false;
                this.selectedGlyph.repaint();
            }
            if (this.selectedTile != null) {
                this.selectedTile.selected = false;
                this.selectedTile.repaint();
            }
            this.selectedTile = mapTile;
            this.selectedTile.selected = true;
            this.selectedTile.repaint();
            if (this.tileListener != null) {
                this.tileListener.tileSelected(mapTile);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.firePopupTrigger(mouseEvent);
        if (mouseEvent.getClickCount() == 2) {
            Component component = mouseEvent.getComponent();
            if (component instanceof MapGlyph) {
                if (this.glyphListener != null) {
                    this.glyphListener.glyphLaunched((MapGlyph)component);
                }
            } else if (component instanceof MapTile && this.tileListener != null) {
                this.tileListener.tileLaunched((MapTile)component);
            }
        }
    }
}

