/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.jaguar;

import ch.randelshofer.quaqua.QuaquaBorderFactory;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.VisuallyLayoutable;
import ch.randelshofer.quaqua.util.Debug;
import ch.randelshofer.quaqua.util.Images;
import ch.randelshofer.quaqua.util.InsetsUtil;
import ch.randelshofer.quaqua.util.NavigatableTabbedPaneUI;
import ch.randelshofer.quaqua.util.PaintableColor;
import ch.randelshofer.quaqua.util.TextureColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public class Quaqua13JaguarTabbedPaneUI
extends BasicTabbedPaneUI
implements VisuallyLayoutable,
NavigatableTabbedPaneUI {
    protected int minTabWidth = 40;
    protected Color tabAreaBackground;
    protected Color selectColor;
    protected Color selectHighlight;
    protected Color disabledForeground;
    private Insets currentContentBorderInsets = new Insets(0, 0, 0, 0);
    private int tabCount;
    private boolean isFrameActive;
    private static Border contentBorder;
    private static Border[] barTopBorder;
    private static Border[] barBottomBorder;
    private static Border[] barRightBorder;
    private static Border[] barLeftBorder;
    private static Border[] tabTopBorder;
    private static Border[] tabBottomBorder;
    private static Border[] tabRightBorder;
    private static Border[] tabLeftBorder;
    private Hashtable mnemonicToIndexMap;
    private InputMap mnemonicInputMap;
    private String propertyPrefix = "TabbedPane.";
    static /* synthetic */ Class class$ch$randelshofer$quaqua$jaguar$Quaqua13JaguarTabbedPaneUI;

    private Border getContentBorder() {
        if (contentBorder == null) {
            contentBorder = QuaquaBorderFactory.create(Images.createImage((class$ch$randelshofer$quaqua$jaguar$Quaqua13JaguarTabbedPaneUI == null ? (class$ch$randelshofer$quaqua$jaguar$Quaqua13JaguarTabbedPaneUI = Quaqua13JaguarTabbedPaneUI.class$("ch.randelshofer.quaqua.jaguar.Quaqua13JaguarTabbedPaneUI")) : class$ch$randelshofer$quaqua$jaguar$Quaqua13JaguarTabbedPaneUI).getResource("images/TabbedPane.contentBorder.png")), new Insets(8, 7, 8, 7), new Insets(1, 3, 3, 3), false, false);
        }
        return contentBorder;
    }

    private static Border createImageBorder(String name, Insets insets) {
        return QuaquaBorderFactory.create(Images.createImage((class$ch$randelshofer$quaqua$jaguar$Quaqua13JaguarTabbedPaneUI == null ? (class$ch$randelshofer$quaqua$jaguar$Quaqua13JaguarTabbedPaneUI = Quaqua13JaguarTabbedPaneUI.class$("ch.randelshofer.quaqua.jaguar.Quaqua13JaguarTabbedPaneUI")) : class$ch$randelshofer$quaqua$jaguar$Quaqua13JaguarTabbedPaneUI).getResource(name)), insets);
    }

    private static Border createNonCachedImageBorder(String name, Insets insets) {
        return QuaquaBorderFactory.create(Images.createImage((class$ch$randelshofer$quaqua$jaguar$Quaqua13JaguarTabbedPaneUI == null ? (class$ch$randelshofer$quaqua$jaguar$Quaqua13JaguarTabbedPaneUI = Quaqua13JaguarTabbedPaneUI.class$("ch.randelshofer.quaqua.jaguar.Quaqua13JaguarTabbedPaneUI")) : class$ch$randelshofer$quaqua$jaguar$Quaqua13JaguarTabbedPaneUI).getResource(name)), insets, insets, true, false);
    }

    private Border getBarTopBorder(int i) {
        if (barTopBorder == null) {
            Insets insets = new Insets(0, 1, 0, 1);
            barTopBorder = new Border[]{Quaqua13JaguarTabbedPaneUI.createImageBorder("images/TabbedPane.barTop.png", insets), Quaqua13JaguarTabbedPaneUI.createImageBorder("images/TabbedPane.barTop.I.png", insets), Quaqua13JaguarTabbedPaneUI.createImageBorder("images/TabbedPane.barTop.D.png", insets)};
        }
        return barTopBorder[i];
    }

    private Border getBarBottomBorder(int i) {
        if (barBottomBorder == null) {
            Insets insets = new Insets(0, 1, 0, 1);
            barBottomBorder = new Border[]{Quaqua13JaguarTabbedPaneUI.createImageBorder("images/TabbedPane.barBottom.png", insets), Quaqua13JaguarTabbedPaneUI.createImageBorder("images/TabbedPane.barBottom.I.png", insets), Quaqua13JaguarTabbedPaneUI.createImageBorder("images/TabbedPane.barBottom.D.png", insets)};
        }
        return barBottomBorder[i];
    }

    private Border getBarRightBorder(int i) {
        if (barRightBorder == null) {
            Insets insets = new Insets(1, 0, 1, 0);
            barRightBorder = new Border[]{Quaqua13JaguarTabbedPaneUI.createImageBorder("images/TabbedPane.barRight.png", insets), Quaqua13JaguarTabbedPaneUI.createImageBorder("images/TabbedPane.barRight.I.png", insets), Quaqua13JaguarTabbedPaneUI.createImageBorder("images/TabbedPane.barRight.D.png", insets)};
        }
        return barRightBorder[i];
    }

    private Border getBarLeftBorder(int i) {
        if (barLeftBorder == null) {
            Insets insets = new Insets(1, 0, 1, 0);
            barLeftBorder = new Border[]{Quaqua13JaguarTabbedPaneUI.createImageBorder("images/TabbedPane.barLeft.png", insets), Quaqua13JaguarTabbedPaneUI.createImageBorder("images/TabbedPane.barLeft.I.png", insets), Quaqua13JaguarTabbedPaneUI.createImageBorder("images/TabbedPane.barLeft.D.png", insets)};
        }
        return barLeftBorder[i];
    }

    private Border getTabTopBorder(int i) {
        if (tabTopBorder == null) {
            Insets insets = new Insets(12, 8, 11, 8);
            tabTopBorder = new Border[]{Quaqua13JaguarTabbedPaneUI.createNonCachedImageBorder("images/TabbedPane.tabTop.png", insets), Quaqua13JaguarTabbedPaneUI.createNonCachedImageBorder("images/TabbedPane.tabTop.S.png", insets), Quaqua13JaguarTabbedPaneUI.createNonCachedImageBorder("images/TabbedPane.tabTop.I.png", insets), Quaqua13JaguarTabbedPaneUI.createNonCachedImageBorder("images/TabbedPane.tabTop.D.png", insets), Quaqua13JaguarTabbedPaneUI.createNonCachedImageBorder("images/TabbedPane.tabTop.DS.png", insets)};
        }
        return tabTopBorder[i];
    }

    private Border getTabBottomBorder(int i) {
        if (tabBottomBorder == null) {
            Insets insets = new Insets(11, 8, 12, 8);
            tabBottomBorder = new Border[]{Quaqua13JaguarTabbedPaneUI.createNonCachedImageBorder("images/TabbedPane.tabBottom.png", insets), Quaqua13JaguarTabbedPaneUI.createNonCachedImageBorder("images/TabbedPane.tabBottom.S.png", insets), Quaqua13JaguarTabbedPaneUI.createNonCachedImageBorder("images/TabbedPane.tabBottom.I.png", insets), Quaqua13JaguarTabbedPaneUI.createNonCachedImageBorder("images/TabbedPane.tabBottom.D.png", insets), Quaqua13JaguarTabbedPaneUI.createNonCachedImageBorder("images/TabbedPane.tabBottom.DS.png", insets)};
        }
        return tabBottomBorder[i];
    }

    private Border getTabRightBorder(int i) {
        if (tabRightBorder == null) {
            Insets insets = new Insets(11, 1, 11, 7);
            Insets insetsS = new Insets(11, 2, 11, 7);
            tabRightBorder = new Border[]{Quaqua13JaguarTabbedPaneUI.createNonCachedImageBorder("images/TabbedPane.tabRight.png", insets), Quaqua13JaguarTabbedPaneUI.createNonCachedImageBorder("images/TabbedPane.tabRight.S.png", insetsS), Quaqua13JaguarTabbedPaneUI.createNonCachedImageBorder("images/TabbedPane.tabRight.I.png", insetsS), Quaqua13JaguarTabbedPaneUI.createNonCachedImageBorder("images/TabbedPane.tabRight.D.png", insets), Quaqua13JaguarTabbedPaneUI.createNonCachedImageBorder("images/TabbedPane.tabRight.DS.png", insetsS)};
        }
        return tabRightBorder[i];
    }

    private Border getTabLeftBorder(int i) {
        if (tabLeftBorder == null) {
            Insets insets = new Insets(11, 7, 11, 1);
            Insets insetsS = new Insets(11, 7, 11, 2);
            tabLeftBorder = new Border[]{Quaqua13JaguarTabbedPaneUI.createNonCachedImageBorder("images/TabbedPane.tabLeft.png", insets), Quaqua13JaguarTabbedPaneUI.createNonCachedImageBorder("images/TabbedPane.tabLeft.S.png", insetsS), Quaqua13JaguarTabbedPaneUI.createNonCachedImageBorder("images/TabbedPane.tabLeft.I.png", insetsS), Quaqua13JaguarTabbedPaneUI.createNonCachedImageBorder("images/TabbedPane.tabLeft.D.png", insets), Quaqua13JaguarTabbedPaneUI.createNonCachedImageBorder("images/TabbedPane.tabLeft.DS.png", insetsS)};
        }
        return tabLeftBorder[i];
    }

    protected String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public void setPropertyPrefix(String newValue) {
        this.propertyPrefix = newValue;
    }

    public static ComponentUI createUI(JComponent x) {
        return new Quaqua13JaguarTabbedPaneUI();
    }

    protected LayoutManager createLayoutManager() {
        return new TabbedPaneLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new QuaquaPropertyChangeHandler();
    }

    protected MouseListener createMouseListener() {
        return new QuaquaMouseHandler();
    }

    protected void installDefaults() {
        super.installDefaults();
        String prefix = this.getPropertyPrefix();
        LookAndFeel.installColorsAndFont(this.tabPane, prefix + "background", prefix + "foreground", prefix + "font");
        this.highlight = UIManager.getColor(prefix + "light");
        this.lightHighlight = UIManager.getColor(prefix + "highlight");
        this.shadow = UIManager.getColor(prefix + "shadow");
        this.darkShadow = UIManager.getColor(prefix + "darkShadow");
        this.focus = UIManager.getColor(prefix + "focus");
        this.textIconGap = UIManager.getInt(prefix + "textIconGap");
        this.tabInsets = UIManager.getInsets(prefix + "tabInsets");
        this.selectedTabPadInsets = UIManager.getInsets(prefix + "selectedTabPadInsets");
        this.tabAreaInsets = UIManager.getInsets(prefix + "tabAreaInsets");
        this.contentBorderInsets = UIManager.getInsets(prefix + "contentBorderInsets");
        this.tabRunOverlay = UIManager.getInt(prefix + "tabRunOverlay");
        this.tabAreaBackground = UIManager.getColor(prefix + "tabAreaBackground");
        this.selectColor = UIManager.getColor(prefix + "selected");
        this.selectHighlight = UIManager.getColor(prefix + "selectHighlight");
        this.disabledForeground = UIManager.getColor(prefix + "disabledForeground");
        LookAndFeel.installBorder(this.tabPane, prefix + "border");
        this.tabPane.setOpaque(QuaquaManager.getBoolean(prefix + "opaque"));
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        int bottom = y + (h - 1);
        int right = x + (w - 1);
        switch (tabPlacement) {
            case 2: {
                this.paintTabBorderLeft(tabIndex, g, x, y, w, h, bottom, right, isSelected);
                break;
            }
            case 3: {
                this.paintTabBorderBottom(tabIndex, g, x, y, w, h, bottom, right, isSelected);
                break;
            }
            case 4: {
                this.paintTabBorderRight(tabIndex, g, x, y, w, h, bottom, right, isSelected);
                break;
            }
            default: {
                this.paintTabBorderTop(tabIndex, g, x, y, w, h, bottom, right, isSelected);
            }
        }
    }

    protected void paintTabBorderTop(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        if (isSelected) {
            int border = this.tabPane.isEnabled() ? (this.isFrameActive ? 1 : 2) : 4;
            this.getTabTopBorder(border).paintBorder(this.tabPane, g, x - 1, y - 1, w + 3, h + 2);
        } else {
            int border = this.tabPane.isEnabled() ? (this.isFrameActive ? 0 : 3) : 3;
            this.getTabTopBorder(border).paintBorder(this.tabPane, g, x - 1, y - 1, w + 3, h + 1);
        }
    }

    protected boolean shouldFillGap(int currentRun, int tabIndex, int x, int y) {
        boolean result = false;
        if (currentRun == this.runCount - 2) {
            int currentTabRight;
            int lastTabLeft;
            int lastTabRight;
            Rectangle lastTabBounds = this.getTabBounds(this.tabPane, this.tabPane.getTabCount() - 1);
            Rectangle tabBounds = this.getTabBounds(this.tabPane, tabIndex);
            if (QuaquaUtilities.isLeftToRight(this.tabPane) ? (lastTabRight = lastTabBounds.x + lastTabBounds.width - 1) > tabBounds.x + 2 : (lastTabLeft = lastTabBounds.x) < (currentTabRight = tabBounds.x + tabBounds.width - 1) - 2) {
                return true;
            }
        } else {
            result = currentRun != this.runCount - 1;
        }
        return result;
    }

    protected Color getColorForGap(int currentRun, int x, int y) {
        int shadowWidth = 4;
        int selectedIndex = this.tabPane.getSelectedIndex();
        int startIndex = this.tabRuns[currentRun + 1];
        int endIndex = this.lastTabInRun(this.tabPane.getTabCount(), currentRun + 1);
        int tabOverGap = -1;
        for (int i = startIndex; i <= endIndex; ++i) {
            Rectangle tabBounds = this.getTabBounds(this.tabPane, i);
            int tabLeft = tabBounds.x;
            int tabRight = tabBounds.x + tabBounds.width - 1;
            if (!(QuaquaUtilities.isLeftToRight(this.tabPane) ? tabLeft <= x && tabRight - 4 > x : tabLeft + 4 < x && tabRight >= x)) continue;
            return selectedIndex == i ? this.selectColor : this.tabPane.getBackgroundAt(i);
        }
        return this.tabPane.getBackground();
    }

    protected void paintTabBorderLeft(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        if (isSelected) {
            int border = this.tabPane.isEnabled() ? (this.isFrameActive ? 1 : 2) : 4;
            this.getTabLeftBorder(border).paintBorder(this.tabPane, g, x - 2, y, w + 4, h + 1);
        } else {
            int border = this.tabPane.isEnabled() ? (this.isFrameActive ? 0 : 3) : 3;
            this.getTabLeftBorder(border).paintBorder(this.tabPane, g, x - 2, y, w + 2, h + 1);
        }
    }

    protected void paintTabBorderBottom(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        if (isSelected) {
            int border = this.tabPane.isEnabled() ? (this.isFrameActive ? 1 : 2) : 4;
            this.getTabBottomBorder(border).paintBorder(this.tabPane, g, x - 1, y - 1, w + 3, h + 2);
        } else {
            int border = this.tabPane.isEnabled() ? (this.isFrameActive ? 0 : 3) : 3;
            this.getTabBottomBorder(border).paintBorder(this.tabPane, g, x - 1, y, w + 3, h + 1);
        }
    }

    protected void paintTabBorderRight(int tabIndex, Graphics g, int x, int y, int w, int h, int btm, int rght, boolean isSelected) {
        if (isSelected) {
            int border = this.tabPane.isEnabled() ? (this.isFrameActive ? 1 : 2) : 4;
            this.getTabRightBorder(border).paintBorder(this.tabPane, g, x - 2, y, w + 4, h + 1);
        } else {
            int border = this.tabPane.isEnabled() ? (this.isFrameActive ? 0 : 3) : 3;
            this.getTabRightBorder(border).paintBorder(this.tabPane, g, x, y, w + 2, h + 1);
        }
    }

    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            g.setColor(this.tabAreaBackground);
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        this.paint(g, c);
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    protected Insets getVisualMargin() {
        Insets margin = (Insets)this.tabPane.getClientProperty("Quaqua.Component.visualMargin");
        if (margin == null) {
            margin = UIManager.getInsets("Component.visualMargin");
        }
        switch (this.tabPane.getTabPlacement()) {
            case 2: {
                return InsetsUtil.add(-1, -2, -4, -3, margin);
            }
            case 3: {
                return InsetsUtil.add(-1, -3, -5, -3, margin);
            }
            case 4: {
                return InsetsUtil.add(-1, -3, -4, -2, margin);
            }
        }
        return InsetsUtil.add(-3, -3, -4, -3, margin);
    }

    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        switch (tabPlacement) {
            case 2: {
                return 0;
            }
            case 3: {
                return -1;
            }
            case 4: {
                return 0;
            }
        }
        return 1;
    }

    protected void repaintTabArea() {
        int tabPlacement = this.tabPane.getTabPlacement();
        int tabCount = this.tabPane.getTabCount();
        Rectangle clipRect = new Rectangle();
        Insets insets = InsetsUtil.add(this.tabPane.getInsets(), this.getVisualMargin());
        Dimension size = this.tabPane.getSize();
        switch (tabPlacement) {
            case 2: {
                clipRect.setBounds(insets.left, insets.top, this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth) + 6, size.height - insets.bottom - insets.top);
                break;
            }
            case 3: {
                int totalTabHeight = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                clipRect.setBounds(insets.left, size.height - insets.bottom - totalTabHeight - 6, size.width - insets.left - insets.right, totalTabHeight + 6);
                break;
            }
            case 4: {
                int totalTabWidth = this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                clipRect.setBounds(size.width - insets.right - totalTabWidth - 6, insets.top, totalTabWidth + 6, size.height - insets.top - insets.bottom);
                break;
            }
            default: {
                clipRect.setBounds(insets.left, insets.top, size.width - insets.right - insets.left, this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight) + 6);
            }
        }
        this.tabPane.repaint(clipRect);
    }

    public void paint(Graphics gr, JComponent c) {
        int tc;
        Graphics2D g = (Graphics2D)gr;
        Object oldHints = QuaquaUtilities.beginGraphics(g);
        int tabPlacement = this.tabPane.getTabPlacement();
        this.isFrameActive = QuaquaUtilities.isOnActiveWindow(c);
        Insets insets = c.getInsets();
        Dimension size = c.getSize();
        if (this.tabPane.isOpaque()) {
            g.setPaint(TextureColor.getPaint(c.getBackground(), c));
            g.fillRect(0, 0, size.width, size.height);
        }
        if (this.tabCount != (tc = this.tabPane.getTabCount())) {
            this.tabCount = tc;
            this.updateMnemonics();
        }
        int selectedIndex = this.tabPane.getSelectedIndex();
        this.ensureCurrentLayout();
        this.paintContentBorder(g, tabPlacement, selectedIndex);
        this.paintTabArea(g, tabPlacement, selectedIndex);
        QuaquaUtilities.endGraphics(g, oldHints);
        Debug.paint(g, c, this);
    }

    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        int tabCount = this.tabPane.getTabCount();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Rectangle clipRect = g.getClipBounds();
        Rectangle tabClipRect = new Rectangle();
        for (int i = this.runCount - 1; i >= 0; --i) {
            int start = this.tabRuns[i];
            int next = this.tabRuns[i == this.runCount - 1 ? 0 : i + 1];
            int end = next != 0 ? next - 1 : tabCount - 1;
            for (int j = start; j <= end; ++j) {
                tabClipRect.setBounds(this.rects[j]);
                tabClipRect.grow(2, 2);
                if (!tabClipRect.intersects(clipRect)) continue;
                this.paintTab(g, tabPlacement, this.rects, j, iconRect, textRect);
            }
        }
        if (selectedIndex >= 0 && this.getRunForTab(tabCount, selectedIndex) == 0) {
            tabClipRect.setBounds(this.rects[selectedIndex]);
            tabClipRect.grow(2, 2);
            if (tabClipRect.intersects(clipRect)) {
                this.paintTab(g, tabPlacement, this.rects, selectedIndex, iconRect, textRect);
            }
        }
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            TabbedPaneLayout layout = (TabbedPaneLayout)this.tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
    }

    protected void updateMnemonics() {
    }

    protected void resetMnemonics() {
        if (this.mnemonicToIndexMap != null) {
            this.mnemonicToIndexMap.clear();
            this.mnemonicInputMap.clear();
        }
    }

    protected void addMnemonic(int index, int mnemonic) {
        if (this.mnemonicToIndexMap == null) {
            this.initMnemonics();
        }
        this.mnemonicInputMap.put(KeyStroke.getKeyStroke(mnemonic, 8), "setSelectedIndex");
        this.mnemonicToIndexMap.put(new Integer(mnemonic), new Integer(index));
    }

    private void initMnemonics() {
        this.mnemonicToIndexMap = new Hashtable();
        this.mnemonicInputMap = new InputMapUIResource();
        this.mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this.tabPane, 1));
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, this.mnemonicInputMap);
    }

    protected void paintHighlightBelowTab() {
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        if (tabPlacement == 4 || tabPlacement == 2) {
            return new Insets(this.tabInsets.top, 6, this.tabInsets.bottom, 5);
        }
        return this.tabInsets;
    }

    protected Insets getTabAreaInsets(int tabPlacement) {
        Insets i = (Insets)super.getTabAreaInsets(tabPlacement).clone();
        switch (tabPlacement) {
            case 1: {
                --i.top;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                ++i.bottom;
                break;
            }
        }
        return i;
    }

    protected Insets getContentBorderInsets(int tabPlacement) {
        Insets insets = this.contentBorderInsets;
        Component selectedComponent = this.tabPane.getSelectedComponent();
        if (selectedComponent instanceof JComponent) {
            insets = (Insets)((JComponent)selectedComponent).getClientProperty("Quaqua.TabbedPaneChild.contentInsets");
        }
        if (insets == null) {
            insets = this.contentBorderInsets;
        }
        this.currentContentBorderInsets.top = insets.top + 3;
        this.currentContentBorderInsets.left = insets.left + 3;
        this.currentContentBorderInsets.bottom = insets.bottom + 3;
        this.currentContentBorderInsets.right = insets.right + 3;
        switch (tabPlacement) {
            case 2: {
                this.currentContentBorderInsets.left += 5;
                ++this.currentContentBorderInsets.bottom;
                break;
            }
            case 4: {
                this.currentContentBorderInsets.right += 4;
                ++this.currentContentBorderInsets.bottom;
                break;
            }
            case 3: {
                ++this.currentContentBorderInsets.bottom;
                break;
            }
            default: {
                this.currentContentBorderInsets.top += 4;
            }
        }
        return this.currentContentBorderInsets;
    }

    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = InsetsUtil.add(this.tabPane.getInsets(), this.getVisualMargin());
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        switch (tabPlacement) {
            case 2: {
                this.paintContentArea(g, x + 6, y + 1, (w -= (x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth)) - insets.left) - 8, h - 6);
                this.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
                break;
            }
            case 4: {
                this.paintContentArea(g, x + 2, y + 1, (w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth)) - 7, h - 6);
                this.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
                break;
            }
            case 3: {
                this.paintContentArea(g, x + 2, y + 1, w - 4, (h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight)) - 6);
                this.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
                break;
            }
            default: {
                this.paintContentArea(g, x + 2, y + 7, w - 4, (h -= (y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight)) - insets.top) - 12);
                this.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
            }
        }
    }

    private int getDepth(JTabbedPane tp) {
        int depth = 1;
        for (Container parent = tp.getParent(); parent != null && !(parent instanceof RootPaneContainer); parent = parent.getParent()) {
            if (!(parent instanceof JTabbedPane)) continue;
            ++depth;
        }
        return depth;
    }

    protected void paintContentArea(Graphics gr, int x, int y, int width, int height) {
        Graphics2D g = (Graphics2D)gr;
        Color contentBackground = null;
        Component selectedComponent = this.tabPane.getSelectedComponent();
        if (selectedComponent instanceof JComponent) {
            contentBackground = (Color)((JComponent)selectedComponent).getClientProperty("Quaqua.TabbedPaneChild.contentBackground");
        }
        if (contentBackground == null) {
            contentBackground = this.tabPane.getBackground();
        }
        g.setPaint(PaintableColor.getPaint(contentBackground, this.tabPane, 0, -this.getDepth(this.tabPane) % 4));
        g.fillRect(x, y, width, height);
    }

    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Insets contentBorderInsets = this.getContentBorder().getBorderInsets(this.tabPane);
        this.getContentBorder().paintBorder(this.tabPane, g, x, y - contentBorderInsets.top + 1, w, h + contentBorderInsets.top - 1);
        int bar = this.tabPane.isEnabled() ? (this.isFrameActive ? 0 : 1) : 2;
        this.getBarTopBorder(bar).paintBorder(this.tabPane, g, x + contentBorderInsets.left, y, w - contentBorderInsets.left - contentBorderInsets.right, 7);
    }

    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Insets contentBorderInsets = this.getContentBorder().getBorderInsets(this.tabPane);
        this.getContentBorder().paintBorder(this.tabPane, g, x, y, w, h + contentBorderInsets.bottom);
        int bar = this.tabPane.isEnabled() ? (this.isFrameActive ? 0 : 1) : 2;
        this.getBarBottomBorder(bar).paintBorder(this.tabPane, g, x + contentBorderInsets.left, y + h - 6, w - contentBorderInsets.left - contentBorderInsets.right, 6);
    }

    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        this.getContentBorder().paintBorder(this.tabPane, g, x, y, w, h);
        int bar = this.tabPane.isEnabled() ? (this.isFrameActive ? 0 : 1) : 2;
        this.getBarLeftBorder(bar).paintBorder(this.tabPane, g, x, y + 1, 7, h - 6);
    }

    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        this.getContentBorder().paintBorder(this.tabPane, g, x, y, w + 3, h);
        int bar = this.tabPane.isEnabled() ? (this.isFrameActive ? 0 : 1) : 2;
        this.getBarRightBorder(bar).paintBorder(this.tabPane, g, x + w - 6, y + 1, 6, h - 6);
    }

    protected int calculateMaxTabHeight(int tabPlacement) {
        FontMetrics metrics = this.getFontMetrics();
        int height = metrics.getHeight();
        boolean tallerIcons = false;
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            Icon icon = this.tabPane.getIconAt(i);
            if (icon == null || icon.getIconHeight() <= height) continue;
            tallerIcons = true;
            break;
        }
        return super.calculateMaxTabHeight(tabPlacement) - (tallerIcons ? this.tabInsets.top + this.tabInsets.bottom : 0);
    }

    protected int getTabRunOverlay(int tabPlacement) {
        if (tabPlacement == 2 || tabPlacement == 4) {
            return 2;
        }
        return 1;
    }

    protected boolean shouldRotateTabRuns(int tabPlacement, int selectedRun) {
        return false;
    }

    protected boolean shouldPadTabRun(int tabPlacement, int run) {
        return this.runCount > 1;
    }

    private boolean isLastInRun(int tabIndex) {
        int run = this.getRunForTab(this.tabPane.getTabCount(), tabIndex);
        int lastIndex = this.lastTabInRun(this.tabPane.getTabCount(), run);
        return tabIndex == lastIndex;
    }

    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        View v = null;
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = -1;
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                g.setColor(this.tabPane.getForegroundAt(tabIndex));
                QuaquaUtilities.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            } else {
                g.setColor(this.disabledForeground);
                QuaquaUtilities.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            }
        }
    }

    public Rectangle getVisualBounds(JComponent c, int type, int width, int height) {
        Rectangle rect = new Rectangle(0, 0, width, height);
        InsetsUtil.subtractInto(c.getInsets(), rect);
        if (type != 0) {
            Insets margin = this.getVisualMargin();
            switch (((JTabbedPane)c).getTabPlacement()) {
                case 2: {
                    InsetsUtil.addTo(1, 2, 5, 3, margin);
                    break;
                }
                case 3: {
                    InsetsUtil.addTo(1, 3, 5, 3, margin);
                    break;
                }
                case 4: {
                    InsetsUtil.addTo(1, 3, 5, 2, margin);
                    break;
                }
                default: {
                    InsetsUtil.addTo(3, 3, 5, 3, margin);
                }
            }
            rect.x += margin.left;
            rect.y += margin.top;
            rect.width -= margin.left + margin.right;
            rect.height -= margin.top + margin.bottom;
        }
        return rect;
    }

    private int getTabAtLocation(int x, int y) {
        this.ensureCurrentLayout();
        int tabCount = this.tabPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            if (!this.rects[i].contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    public int getBaseline(JComponent component, int width, int height) {
        return -1;
    }

    public void navigateSelectedTab(int direction) {
        super.navigateSelectedTab(direction);
    }

    public Integer getIndexForMnemonic(int mnemonic) {
        return (Integer)this.mnemonicToIndexMap.get(new Integer(mnemonic));
    }

    public boolean requestFocusForVisibleComponent() {
        Component visibleComponent = this.getVisibleComponent();
        if (visibleComponent != null && visibleComponent.isFocusTraversable()) {
            QuaquaUtilities.compositeRequestFocus(visibleComponent);
            return true;
        }
        return visibleComponent instanceof JComponent && ((JComponent)visibleComponent).requestDefaultFocus();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class QuaquaMouseHandler
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (!Quaqua13JaguarTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int tabIndex = Quaqua13JaguarTabbedPaneUI.this.getTabAtLocation(e.getX(), e.getY());
            if (tabIndex >= 0 && Quaqua13JaguarTabbedPaneUI.this.tabPane.isEnabledAt(tabIndex)) {
                if (tabIndex == Quaqua13JaguarTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    if (Quaqua13JaguarTabbedPaneUI.this.tabPane.isRequestFocusEnabled()) {
                        Quaqua13JaguarTabbedPaneUI.this.tabPane.requestFocus();
                        Quaqua13JaguarTabbedPaneUI.this.tabPane.repaint(Quaqua13JaguarTabbedPaneUI.this.getTabBounds(Quaqua13JaguarTabbedPaneUI.this.tabPane, tabIndex));
                    }
                } else {
                    Quaqua13JaguarTabbedPaneUI.this.tabPane.setSelectedIndex(tabIndex);
                }
            }
        }
    }

    public class QuaquaPropertyChangeHandler
    extends BasicTabbedPaneUI.PropertyChangeHandler {
        public QuaquaPropertyChangeHandler() {
            super(Quaqua13JaguarTabbedPaneUI.this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name.equals("Frame.active")) {
                Quaqua13JaguarTabbedPaneUI.this.repaintTabArea();
            }
            if (!name.equals("tabLayoutPolicy")) {
                super.propertyChange(evt);
            }
        }
    }

    public class TabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        public TabbedPaneLayout() {
            super(Quaqua13JaguarTabbedPaneUI.this);
        }

        protected void calculateTabRects(int tabPlacement, int tabCount) {
            Rectangle rect;
            int i;
            int returnAt;
            int y;
            int x;
            Dimension size = Quaqua13JaguarTabbedPaneUI.this.tabPane.getSize();
            Insets insets = InsetsUtil.add(Quaqua13JaguarTabbedPaneUI.this.tabPane.getInsets(), Quaqua13JaguarTabbedPaneUI.this.getVisualMargin());
            Insets tabAreaInsets = Quaqua13JaguarTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            FontMetrics metrics = Quaqua13JaguarTabbedPaneUI.this.getFontMetrics();
            int fontHeight = metrics.getHeight();
            int selectedIndex = Quaqua13JaguarTabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            boolean leftToRight = QuaquaUtilities.isLeftToRight(Quaqua13JaguarTabbedPaneUI.this.tabPane);
            switch (tabPlacement) {
                case 2: {
                    Quaqua13JaguarTabbedPaneUI.this.maxTabWidth = Quaqua13JaguarTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                    break;
                }
                case 4: {
                    Quaqua13JaguarTabbedPaneUI.this.maxTabWidth = Quaqua13JaguarTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    x = size.width - insets.right - tabAreaInsets.right - Quaqua13JaguarTabbedPaneUI.this.maxTabWidth;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                    break;
                }
                case 3: {
                    Quaqua13JaguarTabbedPaneUI.this.maxTabHeight = Quaqua13JaguarTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = size.height - insets.bottom - tabAreaInsets.bottom - Quaqua13JaguarTabbedPaneUI.this.maxTabHeight;
                    returnAt = size.width - (insets.right + tabAreaInsets.right);
                    break;
                }
                default: {
                    Quaqua13JaguarTabbedPaneUI.this.maxTabHeight = Quaqua13JaguarTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.width - (insets.right + tabAreaInsets.right);
                }
            }
            int tabRunOverlay = Quaqua13JaguarTabbedPaneUI.this.getTabRunOverlay(tabPlacement);
            Quaqua13JaguarTabbedPaneUI.this.runCount = 0;
            Quaqua13JaguarTabbedPaneUI.this.selectedRun = -1;
            if (tabCount == 0) {
                return;
            }
            for (i = 0; i < tabCount; ++i) {
                rect = Quaqua13JaguarTabbedPaneUI.this.rects[i];
                if (!verticalTabRuns) {
                    if (i > 0) {
                        rect.x = ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).rects[i - 1].x + ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).rects[i - 1].width;
                    } else {
                        ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).tabRuns[0] = 0;
                        Quaqua13JaguarTabbedPaneUI.this.runCount = 1;
                        Quaqua13JaguarTabbedPaneUI.this.maxTabWidth = 0;
                        rect.x = x;
                    }
                    rect.width = Quaqua13JaguarTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
                    Quaqua13JaguarTabbedPaneUI.this.maxTabWidth = Math.max(Quaqua13JaguarTabbedPaneUI.this.maxTabWidth, rect.width);
                    if (rect.x != 2 + insets.left && rect.x + rect.width > returnAt) {
                        if (Quaqua13JaguarTabbedPaneUI.this.runCount > Quaqua13JaguarTabbedPaneUI.this.tabRuns.length - 1) {
                            Quaqua13JaguarTabbedPaneUI.this.expandTabRunsArray();
                        }
                        ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).tabRuns[((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).runCount] = i;
                        Quaqua13JaguarTabbedPaneUI.this.runCount++;
                        rect.x = x;
                    }
                    rect.y = y;
                    rect.height = Quaqua13JaguarTabbedPaneUI.this.maxTabHeight;
                } else {
                    if (i > 0) {
                        rect.y = ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).rects[i - 1].y + ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).rects[i - 1].height;
                    } else {
                        ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).tabRuns[0] = 0;
                        Quaqua13JaguarTabbedPaneUI.this.runCount = 1;
                        Quaqua13JaguarTabbedPaneUI.this.maxTabHeight = 0;
                        rect.y = y;
                    }
                    rect.height = Quaqua13JaguarTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                    Quaqua13JaguarTabbedPaneUI.this.maxTabHeight = Math.max(Quaqua13JaguarTabbedPaneUI.this.maxTabHeight, rect.height);
                    if (rect.y != 2 + insets.top && rect.y + rect.height > returnAt) {
                        if (Quaqua13JaguarTabbedPaneUI.this.runCount > Quaqua13JaguarTabbedPaneUI.this.tabRuns.length - 1) {
                            Quaqua13JaguarTabbedPaneUI.this.expandTabRunsArray();
                        }
                        ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).tabRuns[((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).runCount] = i;
                        Quaqua13JaguarTabbedPaneUI.this.runCount++;
                        rect.y = y;
                    }
                    rect.x = x;
                    rect.width = Quaqua13JaguarTabbedPaneUI.this.maxTabWidth;
                }
                if (i != selectedIndex) continue;
                Quaqua13JaguarTabbedPaneUI.this.selectedRun = Quaqua13JaguarTabbedPaneUI.this.runCount - 1;
            }
            if (Quaqua13JaguarTabbedPaneUI.this.runCount > 1) {
                this.normalizeTabRuns(tabPlacement, tabCount, verticalTabRuns ? y : x, returnAt);
                Quaqua13JaguarTabbedPaneUI.this.selectedRun = Quaqua13JaguarTabbedPaneUI.this.getRunForTab(tabCount, selectedIndex);
                if (Quaqua13JaguarTabbedPaneUI.this.shouldRotateTabRuns(tabPlacement)) {
                    this.rotateTabRuns(tabPlacement, Quaqua13JaguarTabbedPaneUI.this.selectedRun);
                }
            }
            int maxPad = 0;
            switch (tabPlacement) {
                case 2: 
                case 4: {
                    maxPad = size.height - tabAreaInsets.top - tabAreaInsets.bottom;
                    break;
                }
                default: {
                    maxPad = size.width - tabAreaInsets.left - tabAreaInsets.right;
                }
            }
            for (i = Quaqua13JaguarTabbedPaneUI.this.runCount - 1; i >= 0; --i) {
                int j;
                int end;
                int start = Quaqua13JaguarTabbedPaneUI.this.tabRuns[i];
                int next = Quaqua13JaguarTabbedPaneUI.this.tabRuns[i == Quaqua13JaguarTabbedPaneUI.this.runCount - 1 ? 0 : i + 1];
                int n = end = next != 0 ? next - 1 : tabCount - 1;
                if (!verticalTabRuns) {
                    for (j = start; j <= end; ++j) {
                        rect = Quaqua13JaguarTabbedPaneUI.this.rects[j];
                        rect.y = y;
                        rect.x += Quaqua13JaguarTabbedPaneUI.this.getTabRunIndent(tabPlacement, i);
                    }
                    if (Quaqua13JaguarTabbedPaneUI.this.shouldPadTabRun(tabPlacement, i)) {
                        this.padTabRun(tabPlacement, start, end, maxPad);
                    }
                    if (tabPlacement == 3) {
                        y -= Quaqua13JaguarTabbedPaneUI.this.maxTabHeight - tabRunOverlay;
                        continue;
                    }
                    y += Quaqua13JaguarTabbedPaneUI.this.maxTabHeight - tabRunOverlay;
                    continue;
                }
                for (j = start; j <= end; ++j) {
                    rect = Quaqua13JaguarTabbedPaneUI.this.rects[j];
                    rect.x = x;
                    rect.y += Quaqua13JaguarTabbedPaneUI.this.getTabRunIndent(tabPlacement, i);
                }
                if (Quaqua13JaguarTabbedPaneUI.this.shouldPadTabRun(tabPlacement, i)) {
                    this.padTabRun(tabPlacement, start, end, maxPad);
                }
                if (tabPlacement == 4) {
                    x -= Quaqua13JaguarTabbedPaneUI.this.maxTabWidth - tabRunOverlay;
                    continue;
                }
                x += Quaqua13JaguarTabbedPaneUI.this.maxTabWidth - tabRunOverlay;
            }
            this.padSelectedTab(tabPlacement, selectedIndex);
            if (!leftToRight && !verticalTabRuns) {
                int rightMargin = size.width - (insets.right + tabAreaInsets.right);
                for (i = 0; i < tabCount; ++i) {
                    ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).rects[i].x = rightMargin - ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).rects[i].x - ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).rects[i].width;
                }
            }
            switch (tabPlacement) {
                case 2: 
                case 4: {
                    int availableTabAreaHeight = size.height - insets.top - insets.bottom - tabAreaInsets.top - tabAreaInsets.bottom;
                    int usedTabAreaHeight = 0;
                    int pad = 0;
                    for (int run = 0; run < Quaqua13JaguarTabbedPaneUI.this.runCount; ++run) {
                        int firstIndex = Quaqua13JaguarTabbedPaneUI.this.tabRuns[run];
                        int lastIndex = Quaqua13JaguarTabbedPaneUI.this.lastTabInRun(tabCount, run);
                        if (run == 0) {
                            usedTabAreaHeight = 0;
                            for (i = firstIndex; i <= lastIndex; ++i) {
                                usedTabAreaHeight += ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).rects[i].height;
                            }
                            pad = (availableTabAreaHeight - usedTabAreaHeight) / 2;
                        }
                        for (i = firstIndex; i <= lastIndex; ++i) {
                            ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).rects[i].y += pad;
                        }
                    }
                    break;
                }
                default: {
                    int availableTabAreaWidth = size.width - insets.left - insets.right - tabAreaInsets.left - tabAreaInsets.right;
                    for (int run = 0; run < Quaqua13JaguarTabbedPaneUI.this.runCount; ++run) {
                        int firstIndex = Quaqua13JaguarTabbedPaneUI.this.tabRuns[run];
                        int lastIndex = Quaqua13JaguarTabbedPaneUI.this.lastTabInRun(tabCount, run);
                        int usedTabAreaWidth = 0;
                        for (i = firstIndex; i <= lastIndex; ++i) {
                            usedTabAreaWidth += ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).rects[i].width;
                        }
                        int pad = (availableTabAreaWidth - usedTabAreaWidth) / 2;
                        for (i = firstIndex; i <= lastIndex; ++i) {
                            ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).rects[i].x += pad;
                        }
                    }
                }
            }
        }

        protected void normalizeTabRuns(int tabPlacement, int tabCount, int start, int max) {
            if (tabPlacement == 1 || tabPlacement == 3) {
                boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
                int run = Quaqua13JaguarTabbedPaneUI.this.runCount - 1;
                boolean keepAdjusting = true;
                double weight = 1.33;
                while (keepAdjusting) {
                    int prevLastLen;
                    int end;
                    int last = Quaqua13JaguarTabbedPaneUI.this.lastTabInRun(tabCount, run);
                    int prevLast = Quaqua13JaguarTabbedPaneUI.this.lastTabInRun(tabCount, run - 1);
                    if (!verticalTabRuns) {
                        end = ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).rects[last].x + ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).rects[last].width;
                        prevLastLen = (int)((double)Quaqua13JaguarTabbedPaneUI.this.maxTabWidth * weight);
                    } else {
                        end = ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).rects[last].y + ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).rects[last].height;
                        prevLastLen = (int)((double)Quaqua13JaguarTabbedPaneUI.this.maxTabHeight * weight * 2.0);
                    }
                    if (max - end > prevLastLen) {
                        ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).tabRuns[run] = prevLast;
                        if (!verticalTabRuns) {
                            ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).rects[prevLast].x = start;
                        } else {
                            ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).rects[prevLast].y = start;
                        }
                        for (int i = prevLast + 1; i <= last; ++i) {
                            if (!verticalTabRuns) {
                                ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).rects[i].x = ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).rects[i - 1].x + ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).rects[i - 1].width;
                                continue;
                            }
                            ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).rects[i].y = ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).rects[i - 1].y + ((Quaqua13JaguarTabbedPaneUI)Quaqua13JaguarTabbedPaneUI.this).rects[i - 1].height;
                        }
                    } else if (run == Quaqua13JaguarTabbedPaneUI.this.runCount - 1) {
                        keepAdjusting = false;
                    }
                    if (run - 1 > 0) {
                        --run;
                        continue;
                    }
                    run = Quaqua13JaguarTabbedPaneUI.this.runCount - 1;
                    weight += 0.33;
                }
            }
        }

        protected void rotateTabRuns(int tabPlacement, int selectedRun) {
        }

        protected void padSelectedTab(int tabPlacement, int selectedIndex) {
        }

        public void calculateLayoutInfo() {
            int tabCount = Quaqua13JaguarTabbedPaneUI.this.tabPane.getTabCount();
            Quaqua13JaguarTabbedPaneUI.this.assureRectsCreated(tabCount);
            this.calculateTabRects(Quaqua13JaguarTabbedPaneUI.this.tabPane.getTabPlacement(), tabCount);
        }

        protected void padTabRun(int tabPlacement, int start, int end, int max) {
            if (tabPlacement == 1 || tabPlacement == 3) {
                super.padTabRun(tabPlacement, start, end, max);
            }
        }
    }
}

