/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.species.BasicSpecies;
import org.encog.ml.ea.species.Species;
import org.encog.neural.hyperneat.FactorHyperNEATGenome;
import org.encog.neural.hyperneat.HyperNEATCODEC;
import org.encog.neural.hyperneat.HyperNEATGenome;
import org.encog.neural.neat.FactorNEATGenome;
import org.encog.neural.neat.NEATCODEC;
import org.encog.neural.neat.NEATNeuronType;
import org.encog.neural.neat.NEATPopulation;
import org.encog.neural.neat.training.NEATGenome;
import org.encog.neural.neat.training.NEATInnovation;
import org.encog.neural.neat.training.NEATInnovationList;
import org.encog.neural.neat.training.NEATLinkGene;
import org.encog.neural.neat.training.NEATNeuronGene;
import org.encog.persist.EncogFileSection;
import org.encog.persist.EncogPersistor;
import org.encog.persist.EncogReadHelper;
import org.encog.persist.EncogWriteHelper;
import org.encog.util.csv.CSVFormat;

public class PersistNEATPopulation
implements EncogPersistor {
    public static final String TYPE_CPPN = "cppn";

    public static String neuronTypeToString(NEATNeuronType t) {
        switch (t) {
            case Bias: {
                return "b";
            }
            case Hidden: {
                return "h";
            }
            case Input: {
                return "i";
            }
            case None: {
                return "n";
            }
            case Output: {
                return "o";
            }
        }
        return null;
    }

    public static NEATNeuronType stringToNeuronType(String t) {
        if (t.equals("b")) {
            return NEATNeuronType.Bias;
        }
        if (t.equals("h")) {
            return NEATNeuronType.Hidden;
        }
        if (t.equals("i")) {
            return NEATNeuronType.Input;
        }
        if (t.equals("n")) {
            return NEATNeuronType.None;
        }
        if (t.equals("o")) {
            return NEATNeuronType.Output;
        }
        return null;
    }

    @Override
    public int getFileVersion() {
        return 1;
    }

    @Override
    public String getPersistClassString() {
        return NEATPopulation.class.getSimpleName();
    }

    @Override
    public Object read(InputStream is) {
        Species species;
        EncogFileSection section;
        long nextInnovationID = 0L;
        long nextGeneID = 0L;
        NEATPopulation result = new NEATPopulation();
        NEATInnovationList innovationList = new NEATInnovationList();
        innovationList.setPopulation(result);
        result.setInnovations(innovationList);
        EncogReadHelper in = new EncogReadHelper(is);
        while ((section = in.readNextSection()) != null) {
            if (section.getSectionName().equals("NEAT-POPULATION") && section.getSubSectionName().equals("INNOVATIONS")) {
                for (String line : section.getLines()) {
                    List<String> cols = EncogFileSection.splitColumns(line);
                    NEATInnovation innovation = new NEATInnovation();
                    int innovationID = Integer.parseInt(cols.get(1));
                    innovation.setInnovationID(innovationID);
                    innovation.setNeuronID(Integer.parseInt(cols.get(2)));
                    result.getInnovations().getInnovations().put(cols.get(0), innovation);
                    nextInnovationID = Math.max(nextInnovationID, (long)(innovationID + 1));
                }
                continue;
            }
            if (section.getSectionName().equals("NEAT-POPULATION") && section.getSubSectionName().equals("SPECIES")) {
                NEATGenome lastGenome = null;
                BasicSpecies lastSpecies = null;
                for (String line : section.getLines()) {
                    List<String> cols = EncogFileSection.splitColumns(line);
                    if (cols.get(0).equalsIgnoreCase("s")) {
                        lastSpecies = new BasicSpecies();
                        lastSpecies.setPopulation(result);
                        lastSpecies.setAge(Integer.parseInt(cols.get(1)));
                        lastSpecies.setBestScore(CSVFormat.EG_FORMAT.parse(cols.get(2)));
                        lastSpecies.setGensNoImprovement(Integer.parseInt(cols.get(3)));
                        result.getSpecies().add(lastSpecies);
                        continue;
                    }
                    if (cols.get(0).equalsIgnoreCase("g")) {
                        boolean isLeader = lastGenome == null;
                        lastGenome = new NEATGenome();
                        lastGenome.setInputCount(result.getInputCount());
                        lastGenome.setOutputCount(result.getOutputCount());
                        lastGenome.setSpecies(lastSpecies);
                        lastGenome.setAdjustedScore(CSVFormat.EG_FORMAT.parse(cols.get(1)));
                        lastGenome.setScore(CSVFormat.EG_FORMAT.parse(cols.get(2)));
                        lastGenome.setBirthGeneration(Integer.parseInt(cols.get(3)));
                        lastSpecies.add(lastGenome);
                        if (!isLeader) continue;
                        lastSpecies.setLeader(lastGenome);
                        continue;
                    }
                    if (cols.get(0).equalsIgnoreCase("n")) {
                        NEATNeuronGene neuronGene = new NEATNeuronGene();
                        int geneID = Integer.parseInt(cols.get(1));
                        neuronGene.setId(geneID);
                        ActivationFunction af = EncogFileSection.parseActivationFunction(cols.get(2));
                        neuronGene.setActivationFunction(af);
                        neuronGene.setNeuronType(PersistNEATPopulation.stringToNeuronType(cols.get(3)));
                        neuronGene.setInnovationId(Integer.parseInt(cols.get(4)));
                        lastGenome.getNeuronsChromosome().add(neuronGene);
                        nextGeneID = Math.max((long)(geneID + 1), nextGeneID);
                        continue;
                    }
                    if (!cols.get(0).equalsIgnoreCase("l")) continue;
                    NEATLinkGene linkGene = new NEATLinkGene();
                    linkGene.setId(Integer.parseInt(cols.get(1)));
                    linkGene.setEnabled(Integer.parseInt(cols.get(2)) > 0);
                    linkGene.setFromNeuronID(Integer.parseInt(cols.get(3)));
                    linkGene.setToNeuronID(Integer.parseInt(cols.get(4)));
                    linkGene.setWeight(CSVFormat.EG_FORMAT.parse(cols.get(5)));
                    linkGene.setInnovationId(Integer.parseInt(cols.get(6)));
                    lastGenome.getLinksChromosome().add(linkGene);
                }
                continue;
            }
            if (!section.getSectionName().equals("NEAT-POPULATION") || !section.getSubSectionName().equals("CONFIG")) continue;
            Map<String, String> params = section.parseParams();
            String afStr = params.get("neatAct");
            if (afStr.equalsIgnoreCase(TYPE_CPPN)) {
                HyperNEATGenome.buildCPPNActivationFunctions(result.getActivationFunctions());
            } else {
                result.setNEATActivationFunction(EncogFileSection.parseActivationFunction(params, "neatAct"));
            }
            result.setActivationCycles(EncogFileSection.parseInt(params, "cycles"));
            result.setInputCount(EncogFileSection.parseInt(params, "inputCount"));
            result.setOutputCount(EncogFileSection.parseInt(params, "outputCount"));
            result.setPopulationSize(EncogFileSection.parseInt(params, "populationSize"));
            result.setSurvivalRate(EncogFileSection.parseDouble(params, "survivalRate"));
            result.setActivationCycles(EncogFileSection.parseInt(params, "cycles"));
        }
        if (result.isHyperNEAT()) {
            result.setGenomeFactory(new FactorHyperNEATGenome());
            result.setCODEC(new HyperNEATCODEC());
        } else {
            result.setGenomeFactory(new FactorNEATGenome());
            result.setCODEC(new NEATCODEC());
        }
        result.getInnovationIDGenerate().setCurrentID(nextInnovationID);
        result.getGeneIDGenerate().setCurrentID(nextGeneID);
        if (result.getSpecies().size() > 0 && (species = result.getSpecies().get(0)).getMembers().size() > 0) {
            result.setBestGenome(species.getMembers().get(0));
        }
        return result;
    }

    @Override
    public void save(OutputStream os, Object obj) {
        EncogWriteHelper out = new EncogWriteHelper(os);
        NEATPopulation pop = (NEATPopulation)obj;
        out.addSection("NEAT-POPULATION");
        out.addSubSection("CONFIG");
        out.writeProperty("cycles", pop.getActivationCycles());
        if (pop.isHyperNEAT()) {
            out.writeProperty("neatAct", TYPE_CPPN);
        } else {
            ActivationFunction af = pop.getActivationFunctions().getList().get(0).getObj();
            out.writeProperty("neatAct", af);
        }
        out.writeProperty("inputCount", pop.getInputCount());
        out.writeProperty("outputCount", pop.getOutputCount());
        out.writeProperty("cycles", pop.getActivationCycles());
        out.writeProperty("populationSize", pop.getPopulationSize());
        out.writeProperty("survivalRate", pop.getSurvivalRate());
        out.addSubSection("INNOVATIONS");
        if (pop.getInnovations() != null) {
            for (String key : pop.getInnovations().getInnovations().keySet()) {
                NEATInnovation innovation = pop.getInnovations().getInnovations().get(key);
                out.addColumn(key);
                out.addColumn(innovation.getInnovationID());
                out.addColumn(innovation.getNeuronID());
                out.writeLine();
            }
        }
        out.addSubSection("SPECIES");
        Species bestSpecies = pop.determineBestSpecies();
        if (bestSpecies != null) {
            this.saveSpecies(out, bestSpecies);
        }
        for (Species species : pop.getSpecies()) {
            if (species == bestSpecies) continue;
            this.saveSpecies(out, species);
        }
        out.flush();
    }

    private void saveSpecies(EncogWriteHelper out, Species species) {
        out.addColumn("s");
        out.addColumn(species.getAge());
        out.addColumn(species.getBestScore());
        out.addColumn(species.getGensNoImprovement());
        out.writeLine();
        for (Genome genome : species.getMembers()) {
            NEATGenome neatGenome = (NEATGenome)genome;
            out.addColumn("g");
            out.addColumn(neatGenome.getAdjustedScore());
            out.addColumn(neatGenome.getScore());
            out.addColumn(neatGenome.getBirthGeneration());
            out.writeLine();
            for (NEATNeuronGene neatNeuronGene : neatGenome.getNeuronsChromosome()) {
                out.addColumn("n");
                out.addColumn(neatNeuronGene.getId());
                out.addColumn(neatNeuronGene.getActivationFunction());
                out.addColumn(PersistNEATPopulation.neuronTypeToString(neatNeuronGene.getNeuronType()));
                out.addColumn(neatNeuronGene.getInnovationId());
                out.writeLine();
            }
            for (NEATLinkGene neatLinkGene : neatGenome.getLinksChromosome()) {
                out.addColumn("l");
                out.addColumn(neatLinkGene.getId());
                out.addColumn(neatLinkGene.isEnabled());
                out.addColumn(neatLinkGene.getFromNeuronID());
                out.addColumn(neatLinkGene.getToNeuronID());
                out.addColumn(neatLinkGene.getWeight());
                out.addColumn(neatLinkGene.getInnovationId());
                out.writeLine();
            }
        }
    }
}

