/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ca.universe.basic;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.encog.ca.CellularAutomataError;
import org.encog.ca.universe.UniverseCell;
import org.encog.ca.universe.UniverseCellFactory;
import org.encog.ca.universe.basic.BasicCellFactory;
import org.encog.ca.universe.basic.BasicUniverse;
import org.encog.persist.EncogFileSection;
import org.encog.persist.EncogPersistor;
import org.encog.persist.EncogReadHelper;
import org.encog.persist.EncogWriteHelper;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;

public class PersistBasicUniverse
implements EncogPersistor {
    @Override
    public String getPersistClassString() {
        return "BasicUniverse";
    }

    @Override
    public Object read(InputStream is) {
        EncogFileSection section;
        int rows = 0;
        int cols = 0;
        int elementCount = 0;
        int size = 0;
        double min = 0.0;
        double max = 0.0;
        Map<String, String> objParams = null;
        BasicUniverse result = null;
        EncogReadHelper in = new EncogReadHelper(is);
        while ((section = in.readNextSection()) != null) {
            Map<String, String> params;
            if (section.getSectionName().equals("BasicUniverse") && section.getSubSectionName().equals("PARAMS")) {
                objParams = section.parseParams();
            }
            if (section.getSectionName().equals("BasicUniverse") && section.getSubSectionName().equals("UNIVERSE-PARAM")) {
                params = section.parseParams();
                cols = EncogFileSection.parseInt(params, "cols");
                rows = EncogFileSection.parseInt(params, "rows");
                continue;
            }
            if (section.getSectionName().equals("BasicUniverse") && section.getSubSectionName().equals("UNIVERSE-CELLS")) {
                params = section.parseParams();
                min = EncogFileSection.parseDouble(params, "min");
                max = EncogFileSection.parseDouble(params, "max");
                elementCount = EncogFileSection.parseInt(params, "elementCount");
                size = EncogFileSection.parseInt(params, "size");
                continue;
            }
            if (!section.getSectionName().equals("BasicUniverse") || !section.getSubSectionName().equals("UNIVERSE")) continue;
            BasicCellFactory factory = elementCount == -1 ? new BasicCellFactory(size, min, max) : new BasicCellFactory(size, elementCount);
            result = new BasicUniverse(rows, cols, factory);
            result.getProperties().putAll(objParams);
            int ec = 1;
            if (elementCount != -1) {
                ec = elementCount;
            }
            int row = 0;
            for (String line : section.getLines()) {
                double[] d = NumberList.fromList(CSVFormat.EG_FORMAT, line);
                int idx = 0;
                for (int col = 0; col < cols; ++col) {
                    UniverseCell cell = result.get(row, col);
                    for (int i = 0; i < size; ++i) {
                        cell.set(i, d[idx++]);
                    }
                }
                ++row;
            }
        }
        return result;
    }

    @Override
    public void save(OutputStream os, Object obj) {
        EncogWriteHelper out = new EncogWriteHelper(os);
        BasicUniverse universe = (BasicUniverse)obj;
        out.addSection("BasicUniverse");
        out.addSubSection("PARAMS");
        out.addProperties(universe.getProperties());
        out.addSubSection("UNIVERSE-PARAM");
        out.writeProperty("rows", universe.getRows());
        out.writeProperty("cols", universe.getColumns());
        out.addSubSection("UNIVERSE-CELLS");
        UniverseCellFactory factory = universe.getCellFactory();
        String className = factory.getClass().getSimpleName();
        out.writeProperty("type", className);
        if (!(factory instanceof BasicCellFactory)) {
            throw new CellularAutomataError("Unknown cell factory: " + className);
        }
        BasicCellFactory factory2 = (BasicCellFactory)factory;
        out.writeProperty("elementCount", factory2.getElementCount());
        out.writeProperty("max", factory2.getMax());
        out.writeProperty("min", factory2.getMin());
        out.writeProperty("size", factory2.size());
        out.addSubSection("UNIVERSE");
        for (int row = 0; row < universe.getRows(); ++row) {
            for (int col = 0; col < universe.getColumns(); ++col) {
                UniverseCell cell = universe.get(row, col);
                for (int i = 0; i < cell.size(); ++i) {
                    out.addColumn(cell.get(i));
                }
            }
            out.writeLine();
        }
        out.flush();
    }

    @Override
    public int getFileVersion() {
        return 0;
    }
}

