/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.DBLPHelper;
import net.sf.jabref.imports.DBLPParseException;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspector;

public class DBLPFetcher
implements EntryFetcher {
    private final String URL_START = "http://www.dblp.org/search/api/";
    private final String URL_PART1 = "?q=";
    private final String URL_END = "&h=1000&c=4&f=0&format=json";
    private volatile boolean shouldContinue = false;
    private String query;
    private final DBLPHelper helper = new DBLPHelper();

    @Override
    public void stopFetching() {
        this.shouldContinue = false;
    }

    @Override
    public boolean processQuery(String query, ImportInspector inspector, OutputPrinter status) {
        boolean res = false;
        this.query = query;
        this.shouldContinue = true;
        try {
            String address = this.makeSearchURL();
            URL url = new URL(address);
            String page = this.readFromURL(url);
            String[] lines = page.split("\n");
            ArrayList<String> bibtexUrlList = new ArrayList<String>();
            for (String line : lines) {
                if (!line.startsWith("\"url\"")) continue;
                String addr = line.replace("\"url\":\"", "");
                addr = addr.substring(0, addr.length() - 2);
                bibtexUrlList.add(addr);
            }
            int count = 1;
            for (String urlStr : bibtexUrlList) {
                if (!this.shouldContinue) break;
                URL bibUrl = new URL(urlStr);
                String bibtexPage = this.readFromURL(bibUrl);
                List<BibtexEntry> bibtexList = this.helper.getBibTexFromPage(bibtexPage);
                for (BibtexEntry bibtexEntry : bibtexList) {
                    inspector.addEntry(bibtexEntry);
                    if (this.shouldContinue) continue;
                    break;
                }
                inspector.setProgress(count, bibtexUrlList.size());
                ++count;
            }
            res = true;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            status.showMessage(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            status.showMessage(e.getMessage());
        }
        catch (DBLPParseException e) {
            e.printStackTrace();
            status.showMessage(e.getMessage());
        }
        return res;
    }

    private String readFromURL(URL source) throws IOException {
        int read;
        InputStream in = source.openStream();
        InputStreamReader ir = new InputStreamReader(in);
        StringBuffer sbuf = new StringBuffer();
        char[] cbuf = new char[256];
        while ((read = ir.read(cbuf)) != -1) {
            sbuf.append(cbuf, 0, read);
        }
        return sbuf.toString();
    }

    private String makeSearchURL() {
        StringBuffer sb = new StringBuffer("http://www.dblp.org/search/api/").append("?q=");
        String cleanedQuery = this.helper.cleanDBLPQuery(this.query);
        sb.append(cleanedQuery);
        sb.append("&h=1000&c=4&f=0&format=json");
        return sb.toString();
    }

    @Override
    public String getTitle() {
        return "DBLP";
    }

    @Override
    public String getKeyName() {
        return "DBLP";
    }

    @Override
    public URL getIcon() {
        return GUIGlobals.getIconUrl("www");
    }

    @Override
    public String getHelpPage() {
        return null;
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }
}

