/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JOptionPane;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexString;
import net.sf.jabref.DatabaseChangeEvent;
import net.sf.jabref.DatabaseChangeListener;
import net.sf.jabref.EntrySorter;
import net.sf.jabref.Globals;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.Util;

public class BibtexDatabase {
    Map<String, BibtexEntry> _entries = new Hashtable<String, BibtexEntry>();
    String _preamble = null;
    HashMap<String, BibtexString> _strings = new HashMap();
    Vector<String> _strings_ = new Vector();
    Set<DatabaseChangeListener> changeListeners = new HashSet<DatabaseChangeListener>();
    private boolean followCrossrefs = true;
    private HashMap<String, Integer> allKeys = new HashMap();
    private final VetoableChangeListener listener = new VetoableChangeListener(){

        @Override
        public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
            if (pce.getPropertyName() == null) {
                BibtexDatabase.this.fireDatabaseChanged(new DatabaseChangeEvent(BibtexDatabase.this, DatabaseChangeEvent.ChangeType.CHANGING_ENTRY, (BibtexEntry)pce.getSource()));
            } else if ("id".equals(pce.getPropertyName())) {
                BibtexEntry oldEntry = BibtexDatabase.this._entries.remove(pce.getOldValue());
                if (oldEntry != pce.getSource()) {
                    BibtexDatabase.this._entries.put((String)pce.getOldValue(), oldEntry);
                    throw new PropertyVetoException("Wrong old ID", pce);
                }
                if (BibtexDatabase.this._entries.get(pce.getNewValue()) != null) {
                    BibtexDatabase.this._entries.put((String)pce.getOldValue(), oldEntry);
                    throw new PropertyVetoException("New ID already in use, please choose another", pce);
                }
                BibtexDatabase.this._entries.put((String)pce.getNewValue(), (BibtexEntry)pce.getSource());
            } else {
                BibtexDatabase.this.fireDatabaseChanged(new DatabaseChangeEvent(BibtexDatabase.this, DatabaseChangeEvent.ChangeType.CHANGED_ENTRY, (BibtexEntry)pce.getSource()));
            }
        }
    };

    public synchronized int getEntryCount() {
        return this._entries.size();
    }

    public synchronized Set<String> getKeySet() {
        return this._entries.keySet();
    }

    public synchronized EntrySorter getSorter(Comparator<BibtexEntry> comp) {
        EntrySorter sorter = new EntrySorter(this._entries, comp);
        this.addDatabaseChangeListener(sorter);
        return sorter;
    }

    public Map<String, BibtexEntry> getEntryMap() {
        return this._entries;
    }

    public synchronized BibtexEntry getEntryById(String id) {
        return this._entries.get(id);
    }

    public synchronized Collection<BibtexEntry> getEntries() {
        return this._entries.values();
    }

    public synchronized BibtexEntry getEntryByKey(String key) {
        BibtexEntry back = null;
        int keyHash = key.hashCode();
        Set<String> keySet = this._entries.keySet();
        if (keySet != null) {
            for (String entrieID : keySet) {
                String citeKey;
                BibtexEntry entry = this.getEntryById(entrieID);
                if (entry == null || entry.getCiteKey() == null || (citeKey = entry.getCiteKey()) == null || keyHash != citeKey.hashCode()) continue;
                back = entry;
            }
        }
        return back;
    }

    public synchronized BibtexEntry[] getEntriesByKey(String key) {
        ArrayList<BibtexEntry> entries = new ArrayList<BibtexEntry>();
        for (BibtexEntry entry : this._entries.values()) {
            if (!key.equals(entry.getCiteKey())) continue;
            entries.add(entry);
        }
        return entries.toArray(new BibtexEntry[entries.size()]);
    }

    public synchronized boolean insertEntry(BibtexEntry entry) throws KeyCollisionException {
        String id = entry.getId();
        if (this.getEntryById(id) != null) {
            throw new KeyCollisionException("ID is already in use, please choose another");
        }
        entry.addPropertyChangeListener(this.listener);
        this._entries.put(id, entry);
        this.fireDatabaseChanged(new DatabaseChangeEvent(this, DatabaseChangeEvent.ChangeType.ADDED_ENTRY, entry));
        return this.checkForDuplicateKeyAndAdd(null, entry.getCiteKey(), false);
    }

    public synchronized BibtexEntry removeEntry(String id) {
        BibtexEntry oldValue = this._entries.remove(id);
        if (oldValue == null) {
            return null;
        }
        this.removeKeyFromSet(oldValue.getCiteKey());
        oldValue.removePropertyChangeListener(this.listener);
        this.fireDatabaseChanged(new DatabaseChangeEvent(this, DatabaseChangeEvent.ChangeType.REMOVED_ENTRY, oldValue));
        return oldValue;
    }

    public synchronized boolean setCiteKeyForEntry(String id, String key) {
        if (!this._entries.containsKey(id)) {
            return false;
        }
        BibtexEntry entry = this.getEntryById(id);
        String oldKey = entry.getCiteKey();
        if (key != null) {
            entry.setField("bibtexkey", key);
        } else {
            entry.clearField("bibtexkey");
        }
        return this.checkForDuplicateKeyAndAdd(oldKey, entry.getCiteKey(), false);
    }

    public synchronized void setPreamble(String preamble) {
        this._preamble = preamble;
    }

    public synchronized String getPreamble() {
        return this._preamble;
    }

    public synchronized void addString(BibtexString string) throws KeyCollisionException {
        if (this.hasStringLabel(string.getName())) {
            throw new KeyCollisionException("A string with this label already exists,");
        }
        if (this._strings.containsKey(string.getId())) {
            throw new KeyCollisionException("Duplicate BibtexString id.");
        }
        this._strings.put(string.getId(), string);
    }

    public synchronized void removeString(String id) {
        this._strings.remove(id);
    }

    public Set<String> getStringKeySet() {
        return this._strings.keySet();
    }

    public Collection<BibtexString> getStringValues() {
        return this._strings.values();
    }

    public synchronized BibtexString getString(String o) {
        return this._strings.get(o);
    }

    public synchronized int getStringCount() {
        return this._strings.size();
    }

    public synchronized boolean hasStringLabel(String label) {
        for (BibtexString value : this._strings.values()) {
            if (!value.getName().equals(label)) continue;
            return true;
        }
        return false;
    }

    public String resolveForStrings(String content) {
        if (content == null) {
            throw new IllegalArgumentException("Content for resolveForStrings must not be null.");
        }
        return this.resolveContent(content, new HashSet<String>());
    }

    public List<BibtexEntry> resolveForStrings(Collection<BibtexEntry> entries, boolean inPlace) {
        if (entries == null) {
            throw new NullPointerException();
        }
        ArrayList<BibtexEntry> results = new ArrayList<BibtexEntry>(entries.size());
        for (BibtexEntry entry : entries) {
            results.add(this.resolveForStrings(entry, inPlace));
        }
        return results;
    }

    public BibtexEntry resolveForStrings(BibtexEntry entry, boolean inPlace) {
        if (!inPlace) {
            entry = (BibtexEntry)entry.clone();
        }
        for (String field : entry.getAllFields()) {
            entry.setField(field.toString(), this.resolveForStrings(entry.getField(field.toString()).toString()));
        }
        return entry;
    }

    private String resolveString(String label, HashSet<String> usedIds) {
        for (BibtexString string : this._strings.values()) {
            if (!string.getName().toLowerCase().equals(label.toLowerCase())) continue;
            if (usedIds.contains(string.getId())) {
                Util.pr("Stopped due to circular reference in strings: " + label);
                return label;
            }
            usedIds.add(string.getId());
            String res = string.getContent();
            res = this.resolveContent(res, usedIds);
            usedIds.remove(string.getId());
            return res;
        }
        String o = Globals.MONTH_STRINGS.get(label.toLowerCase());
        if (o != null) {
            return o;
        }
        return null;
    }

    private String resolveContent(String res, HashSet<String> usedIds) {
        if (res.matches(".*#[^#]+#.*")) {
            StringBuffer newRes = new StringBuffer();
            int piv = 0;
            int next = 0;
            while ((next = res.indexOf("#", piv)) >= 0) {
                int stringEnd;
                if (next > 0) {
                    newRes.append(res.substring(piv, next));
                }
                if ((stringEnd = res.indexOf("#", next + 1)) >= 0) {
                    String refLabel = res.substring(next + 1, stringEnd);
                    String resolved = this.resolveString(refLabel, usedIds);
                    if (resolved == null) {
                        newRes.append(res.substring(next, stringEnd + 1));
                    } else {
                        newRes.append(resolved);
                    }
                    piv = stringEnd + 1;
                    continue;
                }
                newRes.append(res.substring(next));
                piv = res.length();
                break;
            }
            if (piv < res.length() - 1) {
                newRes.append(res.substring(piv));
            }
            res = newRes.toString();
        }
        return res;
    }

    public boolean checkForDuplicateKeyAndAdd(String oldKey, String newKey, boolean issueWarning) {
        boolean duplicate = false;
        if (oldKey == null) {
            duplicate = this.addKeyToSet(newKey);
        } else if (oldKey.equals(newKey)) {
            duplicate = false;
        } else {
            this.removeKeyFromSet(oldKey);
            duplicate = this.addKeyToSet(newKey);
        }
        if (duplicate && issueWarning) {
            JOptionPane.showMessageDialog(null, Globals.lang("Warning there is a duplicate key") + ":" + newKey, Globals.lang("Duplicate Key Warning"), 2);
        }
        return duplicate;
    }

    public int getNumberOfKeyOccurences(String key) {
        Integer o = this.allKeys.get(key);
        if (o == null) {
            return 0;
        }
        return o;
    }

    private boolean addKeyToSet(String key) {
        boolean exists = false;
        if (key == null || key.equals("")) {
            return false;
        }
        if (this.allKeys.containsKey(key)) {
            exists = true;
            this.allKeys.put(key, new Integer(this.allKeys.get(key) + 1));
        } else {
            this.allKeys.put(key, new Integer(1));
        }
        return exists;
    }

    private void removeKeyFromSet(String key) {
        if (key == null || key.equals("")) {
            return;
        }
        if (this.allKeys.containsKey(key)) {
            Integer tI = this.allKeys.get(key);
            if (tI == 1) {
                this.allKeys.remove(key);
            } else {
                this.allKeys.put(key, new Integer(tI - 1));
            }
        }
    }

    public void fireDatabaseChanged(DatabaseChangeEvent e) {
        for (DatabaseChangeListener listener : this.changeListeners) {
            listener.databaseChanged(e);
        }
    }

    public void addDatabaseChangeListener(DatabaseChangeListener l) {
        this.changeListeners.add(l);
    }

    public void removeDatabaseChangeListener(DatabaseChangeListener l) {
        this.changeListeners.remove(l);
    }

    public static String getResolvedField(String field, BibtexEntry bibtex, BibtexDatabase database) {
        BibtexEntry referred;
        String crossRef;
        if (field.equals("bibtextype")) {
            return bibtex.getType().getName();
        }
        String o = bibtex.getField(field);
        if (o == null && database != null && database.followCrossrefs && !field.equals("bibtexkey") && database != null && (crossRef = bibtex.getField("crossref")) != null && (referred = database.getEntryByKey(crossRef)) != null) {
            o = referred.getField(field);
        }
        return BibtexDatabase.getText(o, database);
    }

    public static String getText(String toResolve, BibtexDatabase database) {
        if (toResolve != null && database != null) {
            return database.resolveForStrings(toResolve);
        }
        return toResolve;
    }

    public void setFollowCrossrefs(boolean followCrossrefs) {
        this.followCrossrefs = followCrossrefs;
    }
}

