/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.snac.ClientSnacProcessor;
import net.kano.joscar.snac.SnacRequest;
import net.kano.joscar.snac.SnacRequestAdapter;
import net.kano.joscar.snac.SnacRequestListener;
import net.kano.joscar.snac.SnacResponseEvent;
import net.kano.joscar.snac.SnacResponseListener;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.CertificateInfo;
import net.kano.joscar.snaccmd.DirInfo;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.ExtraInfoData;
import net.kano.joscar.snaccmd.FullUserInfo;
import net.kano.joscar.snaccmd.ShortCapabilityBlock;
import net.kano.joscar.snaccmd.WarningLevel;
import net.kano.joscar.snaccmd.error.SnacError;
import net.kano.joscar.snaccmd.icbm.SingleBuddyRequest;
import net.kano.joscar.snaccmd.loc.GetInfoCmd;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.BuddyInfo;
import net.kano.joustsim.oscar.BuddyInfoChangeListener;
import net.kano.joustsim.oscar.GlobalBuddyInfoListener;
import net.kano.joustsim.oscar.OpenedServiceListener;
import net.kano.joustsim.oscar.oscar.service.Service;
import net.kano.joustsim.oscar.oscar.service.bos.MainBosService;
import net.kano.joustsim.oscar.oscar.service.bos.MainBosServiceListener;
import net.kano.joustsim.oscar.oscar.service.buddy.BuddyService;
import net.kano.joustsim.oscar.oscar.service.buddy.BuddyServiceListener;
import net.kano.joustsim.oscar.oscar.service.info.BuddyHashHolder;
import net.kano.joustsim.oscar.oscar.service.info.InfoService;
import net.kano.joustsim.oscar.oscar.service.info.InfoServiceListener;
import net.kano.joustsim.trust.BuddyCertificateInfo;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuddyInfoManager {
    private static final Logger LOGGER = Logger.getLogger(BuddyInfoManager.class.getName());
    private final AimConnection conn;
    private Map<Screenname, BuddyInfo> buddyInfos = new HashMap<Screenname, BuddyInfo>();
    private Map<BuddyHashHolder, BuddyCertificateInfo> cachedCertInfos = new HashMap<BuddyHashHolder, BuddyCertificateInfo>();
    private boolean initedBuddyService = false;
    private boolean initedInfoService = false;
    private boolean initedBosService = false;
    private final CopyOnWriteArrayList<GlobalBuddyInfoListener> listeners = new CopyOnWriteArrayList();
    private BuddyInfoChangeListener pcl = new BuddyInfoChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            BuddyInfoManager.this.fireGlobalPropertyChangeEvent(evt);
        }

        public void receivedBuddyStatusUpdate(BuddyInfo info) {
            BuddyInfoManager.this.fireReceivedStatusEvent(info);
        }
    };

    public BuddyInfoManager(AimConnection conn) {
        DefensiveTools.checkNull((Object)conn, (String)"conn");
        this.conn = conn;
        conn.addOpenedServiceListener(new OpenedServiceListener(){

            @Override
            public void openedServices(AimConnection conn, Collection<? extends Service> services) {
                BuddyInfoManager.this.initBuddyService();
                BuddyInfoManager.this.initInfoService();
                BuddyInfoManager.this.initBosService();
            }

            @Override
            public void closedServices(AimConnection conn, Collection<? extends Service> services) {
            }
        });
        this.initBuddyService();
        this.initInfoService();
        this.initBosService();
    }

    public AimConnection getAimConnection() {
        return this.conn;
    }

    private synchronized void cacheCertInfo(BuddyCertificateInfo certInfo) {
        DefensiveTools.checkNull((Object)certInfo, (String)"certInfo");
        Screenname buddy = certInfo.getBuddy();
        ByteBlock hash = certInfo.getCertificateInfoHash();
        BuddyHashHolder holder = new BuddyHashHolder(buddy, hash);
        if (this.cachedCertInfos.containsKey(holder)) {
            return;
        }
        this.cachedCertInfos.put(holder, certInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBuddyService() {
        BuddyService bs = this.conn.getBuddyService();
        if (bs == null) {
            return;
        }
        BuddyInfoManager buddyInfoManager = this;
        synchronized (buddyInfoManager) {
            if (this.initedBuddyService) {
                return;
            }
            this.initedBuddyService = true;
        }
        bs.addBuddyListener(new BuddyServiceListener(){

            public void gotBuddyStatus(BuddyService service, Screenname buddy, FullUserInfo info) {
                BuddyInfoManager.this.handleBuddyStatusUpdate(buddy, info);
            }

            public void buddyOffline(BuddyService service, Screenname buddy) {
                BuddyInfoManager.this.getBuddyInfoInstance(buddy).setOnline(false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initInfoService() {
        InfoService infoService = this.conn.getInfoService();
        if (infoService == null) {
            return;
        }
        BuddyInfoManager buddyInfoManager = this;
        synchronized (buddyInfoManager) {
            if (this.initedInfoService) {
                return;
            }
            this.initedInfoService = true;
        }
        infoService.addInfoListener(new InfoServiceListener(){

            public void handleDirectoryInfo(InfoService service, Screenname buddy, DirInfo info) {
                BuddyInfo buddyInfo = BuddyInfoManager.this.getBuddyInfoInstance(buddy);
                buddyInfo.setOnline(true);
                buddyInfo.setDirectoryInfo(info);
            }

            public void handleAwayMessage(InfoService service, Screenname buddy, String awayMsg) {
                BuddyInfo buddyInfo = BuddyInfoManager.this.getBuddyInfoInstance(buddy);
                buddyInfo.setOnline(true);
                buddyInfo.setAwayMessage(awayMsg);
            }

            public void handleUserProfile(InfoService service, Screenname buddy, String infoString) {
                BuddyInfo buddyInfo = BuddyInfoManager.this.getBuddyInfoInstance(buddy);
                buddyInfo.setOnline(true);
                buddyInfo.setUserProfile(infoString);
            }

            public void handleCertificateInfo(InfoService service, Screenname buddy, BuddyCertificateInfo certInfo) {
                LOGGER.fine("BuddyInfoManager got cert info for " + buddy);
                BuddyInfo buddyInfo = BuddyInfoManager.this.getBuddyInfoInstance(buddy);
                buddyInfo.setOnline(true);
                if (certInfo != null) {
                    BuddyInfoManager.this.cacheCertInfo(certInfo);
                }
                buddyInfo.setCertificateInfo(certInfo);
            }

            public void handleInvalidCertificates(InfoService service, Screenname buddy, CertificateInfo origCertInfo, Throwable ex) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBosService() {
        MainBosService bos = this.conn.getBosService();
        if (bos == null) {
            return;
        }
        BuddyInfoManager buddyInfoManager = this;
        synchronized (buddyInfoManager) {
            if (this.initedBosService) {
                return;
            }
            this.initedBosService = true;
        }
        bos.addMainBosServiceListener(new MainBosServiceListener(){

            @Override
            public void handleYourInfo(MainBosService service, FullUserInfo userInfo) {
                BuddyInfoManager.this.handleBuddyStatusUpdate(BuddyInfoManager.this.conn.getScreenname(), userInfo);
            }

            @Override
            public void handleYourExtraInfo(List<ExtraInfoBlock> extraInfos) {
                if (extraInfos != null) {
                    BuddyInfoManager.this.handleExtraInfoBlocks(BuddyInfoManager.this.conn.getScreenname(), extraInfos);
                }
            }
        });
        final ClientSnacProcessor processor = bos.getOscarConnection().getSnacProcessor();
        processor.addGlobalResponseListener((SnacResponseListener)new SnacRequestAdapter(){

            public void handleResponse(SnacResponseEvent e) {
                SnacCommand cmd = e.getSnacCommand();
                if (!(cmd instanceof SnacError)) {
                    return;
                }
                SnacError error = (SnacError)cmd;
                if (error.getErrorCode() != 4) {
                    return;
                }
                SnacCommand sent = e.getRequest().getCommand();
                if (!(sent instanceof SingleBuddyRequest)) {
                    return;
                }
                SingleBuddyRequest request = (SingleBuddyRequest)sent;
                final Screenname sn = new Screenname(request.getScreenname());
                BuddyInfo info = BuddyInfoManager.this.getBuddyInfoInstance(sn);
                if (info.isOnBuddyList() || !info.isOnline()) {
                    return;
                }
                LOGGER.info("I think " + sn + " might be offline after " + MiscTools.getClassName((Object)sent) + " returned 'user unvailable'; " + "pinging user to make sure");
                processor.sendSnac(new SnacRequest((SnacCommand)new GetInfoCmd(2L, request.getScreenname()), (SnacRequestListener)new SnacRequestAdapter(){

                    public void handleResponse(SnacResponseEvent snacResponseEvent) {
                        SnacCommand cmd = snacResponseEvent.getSnacCommand();
                        if (!(cmd instanceof SnacError)) {
                            return;
                        }
                        SnacError error = (SnacError)cmd;
                        if (error.getErrorCode() == 4) {
                            LOGGER.warning("Got two 'user unavailable' responses for " + sn + ", marking as offline");
                            BuddyInfoManager.this.getBuddyInfoInstance(sn).setOnline(false);
                        }
                    }
                }));
                info.setOnline(false);
            }
        });
    }

    public void addGlobalBuddyInfoListener(GlobalBuddyInfoListener l) {
        this.listeners.addIfAbsent((Object)l);
    }

    public void removeGlobalBuddyInfoListener(GlobalBuddyInfoListener l) {
        this.listeners.remove((Object)l);
    }

    private void handleBuddyStatusUpdate(Screenname buddy, FullUserInfo info) {
        int flags;
        List extraBlocks;
        Date idleSince;
        int idleMins;
        ByteBlock certHash;
        long icqStatus;
        Boolean awayStatus;
        BuddyInfo buddyInfo = this.getBuddyInfoInstance(buddy);
        buddyInfo.setOnline(true);
        Date onSince = info.getOnSince();
        if (onSince != null) {
            buddyInfo.setOnlineSince(onSince);
        }
        if ((awayStatus = info.getAwayStatus()) != null) {
            buddyInfo.setAway(awayStatus);
        }
        if ((icqStatus = info.getIcqStatus()) != -1L) {
            buddyInfo.setIcqStatus(icqStatus);
        }
        boolean mobile = false;
        List caps = info.getCapabilityBlocks();
        List shortCaps = info.getShortCapabilityBlocks();
        if (caps != null || shortCaps != null) {
            int numLong = caps == null ? 0 : caps.size();
            int numShort = shortCaps == null ? 0 : shortCaps.size();
            ArrayList<CapabilityBlock> blocks = new ArrayList<CapabilityBlock>(numLong + numShort);
            if (caps != null) {
                blocks.addAll(caps);
            }
            if (shortCaps != null) {
                for (ShortCapabilityBlock shortCap : shortCaps) {
                    blocks.add(shortCap.toCapabilityBlock());
                }
            }
            if (blocks.contains(CapabilityBlock.BLOCK_HIPTOP)) {
                mobile = true;
            }
            buddyInfo.setCapabilities(blocks);
        }
        if ((certHash = info.getCertInfoHash()) != null) {
            if (certHash.getLength() == 0) {
                certHash = null;
            }
            buddyInfo.setCertificateInfo(this.getAppropriateCertificateInfo(buddy, certHash));
        }
        if ((idleMins = info.getIdleMins()) == -1) {
            idleSince = null;
        } else {
            int idlems = idleMins * 1000 * 60;
            idleSince = new Date(System.currentTimeMillis() - (long)idlems);
        }
        buddyInfo.setIdleSince(idleSince);
        WarningLevel level = info.getWarningLevel();
        if (level != null) {
            int x10 = level.getX10Value();
            int rounder = x10 % 10 >= 5 ? 1 : 0;
            int warningLevel = x10 / 10 + rounder;
            buddyInfo.setWarningLevel(warningLevel);
        }
        if ((extraBlocks = info.getExtraInfoBlocks()) != null) {
            this.handleExtraInfoBlocks(buddy, extraBlocks);
        }
        buddyInfo.setMobile(mobile |= ((flags = info.getFlags()) & 0x80) != 0);
        buddyInfo.setRobot((flags & 0x400) != 0);
        buddyInfo.setAolUser((flags & 4) != 0);
        buddyInfo.receivedBuddyStatusUpdate();
    }

    private void handleExtraInfoBlocks(Screenname buddy, List<ExtraInfoBlock> extraBlocks) {
        BuddyInfo buddyInfo = this.getBuddyInfo(buddy);
        buddyInfo.setAwayMessage(null);
        for (ExtraInfoBlock block : extraBlocks) {
            String status;
            int type = block.getType();
            ExtraInfoData data = block.getExtraData();
            if (type == 1) {
                buddyInfo.setIconHash(block.getExtraData());
                continue;
            }
            if (type == 2) {
                status = ExtraInfoData.readAvailableMessage((ExtraInfoData)data);
                buddyInfo.setStatusMessage(status);
                continue;
            }
            if (type != 9) continue;
            status = ExtraInfoData.readAvailableMessage((ExtraInfoData)data);
            buddyInfo.setItunesUrl(status);
        }
    }

    private synchronized BuddyCertificateInfo getAppropriateCertificateInfo(Screenname buddy, ByteBlock certHash) {
        BuddyCertificateInfo cached = this.getCachedCertificateInfo(buddy, certHash);
        if (cached != null) {
            return cached;
        }
        if (certHash == null) {
            return null;
        }
        return new BuddyCertificateInfo(buddy, certHash);
    }

    public synchronized BuddyCertificateInfo getCachedCertificateInfo(Screenname buddy, ByteBlock hash) {
        DefensiveTools.checkNull((Object)buddy, (String)"buddy");
        if (hash == null) {
            return null;
        }
        BuddyHashHolder holder = new BuddyHashHolder(buddy, hash);
        return this.cachedCertInfos.get(holder);
    }

    @NotNull
    private synchronized BuddyInfo getBuddyInfoInstance(Screenname buddy) {
        BuddyInfo info = this.buddyInfos.get(buddy);
        if (info == null) {
            info = new BuddyInfo(buddy);
            info.addPropertyListener(this.pcl);
            this.buddyInfos.put(buddy, info);
        }
        return info;
    }

    @NotNull
    public synchronized BuddyInfo getBuddyInfo(Screenname buddy) {
        return this.getBuddyInfoInstance(buddy);
    }

    private void fireGlobalPropertyChangeEvent(PropertyChangeEvent evt) {
        assert (!Thread.holdsLock(this));
        BuddyInfo info = (BuddyInfo)evt.getSource();
        Screenname sn = info.getScreenname();
        for (GlobalBuddyInfoListener l : this.listeners) {
            l.buddyInfoChanged(this, sn, info, evt);
        }
    }

    private void fireReceivedStatusEvent(BuddyInfo info) {
        assert (!Thread.holdsLock(this));
        Screenname sn = info.getScreenname();
        for (GlobalBuddyInfoListener l : this.listeners) {
            l.receivedStatusUpdate(this, sn, info);
        }
    }

    public synchronized Set<BuddyInfo> getKnownBuddyInfos() {
        return DefensiveTools.getUnmodifiableSetCopy(this.buddyInfos.values());
    }
}

