/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public final class StringUtils {
    private StringUtils() {
    }

    public static String convertCamelCaseToDisplayString(String camelCase) {
        int wordEndIndex;
        if (camelCase == null) {
            return null;
        }
        int camelCaseLength = camelCase.length();
        if (camelCaseLength == 0) {
            return camelCase;
        }
        int wordBeginIndex = 0;
        StringBuilder display = new StringBuilder();
        for (wordEndIndex = 0; wordEndIndex < camelCaseLength; ++wordEndIndex) {
            char ch = camelCase.charAt(wordEndIndex);
            if (!Character.isUpperCase(ch) || wordBeginIndex == wordEndIndex) continue;
            display.append(camelCase.substring(wordBeginIndex, wordEndIndex));
            display.append(' ');
            wordBeginIndex = wordEndIndex;
        }
        if (wordEndIndex >= camelCaseLength) {
            display.append(camelCase.substring(wordBeginIndex));
        }
        return display.toString();
    }

    public static boolean isNullOrEmpty(String s) {
        return StringUtils.isNullOrEmpty(s, true);
    }

    public static boolean isNullOrEmpty(String s, boolean trim) {
        if (s == null) {
            return true;
        }
        if (trim) {
            s = s.trim();
        }
        return s.length() == 0;
    }

    public static boolean isEquals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public static InputStream fromString(String string) throws UnsupportedEncodingException {
        return StringUtils.fromString(string, "UTF-8");
    }

    public static InputStream fromString(String string, String encoding) throws UnsupportedEncodingException {
        return new ByteArrayInputStream(string.getBytes(encoding));
    }

    public static byte[] getUTF8Bytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException exc) {
            return string.getBytes();
        }
    }

    public static String getUTF8String(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException exc) {
            return new String(bytes);
        }
    }

    public static boolean isNumber(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsLetters(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isLetter(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String concatenateWords(String string) {
        char[] chars = string.toCharArray();
        StringBuilder buff = new StringBuilder(chars.length);
        for (char ch : chars) {
            if (ch == ' ') continue;
            buff.append(ch);
        }
        return buff.toString();
    }

    public static String newString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        Charset defaultCharset = Charset.defaultCharset();
        String charsetName = defaultCharset == null ? "UTF-8" : defaultCharset.name();
        try {
            return new String(bytes, charsetName);
        }
        catch (UnsupportedEncodingException ueex) {
            return new String(bytes);
        }
    }
}

