/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.console;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.profiler4j.console.LinkHoverWindow;
import net.sf.profiler4j.console.LinkView;
import net.sf.profiler4j.console.MethodBoxHoverWindow;
import net.sf.profiler4j.console.MethodView;
import net.sf.profiler4j.console.client.Snapshot;
import net.sf.profiler4j.console.util.hover.HoverManager;
import net.sf.profiler4j.console.util.hover.HoverablePanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallGraphPanel
extends HoverablePanel {
    private Snapshot snapshot;
    private MethodView[][] matrix = new MethodView[256][512];
    private List<MethodView> rootNodes;
    private MethodView selectedNode;
    private Map<Snapshot.Method, MethodView> nodes = new HashMap<Snapshot.Method, MethodView>();
    static double maxTime;
    private int[] iyMax = new int[256];
    private int ixMax = 1;
    private Stroke selStroke = new BasicStroke(3.0f);
    private Stroke linkStroke = new BasicStroke(0.15f, 1, 2);
    private Stroke selLinkStroke = new BasicStroke(2.0f, 1, 2);
    private Stroke defaultStroke = new BasicStroke(0.25f);
    private Color disabledBgColor = Color.decode("#eeeedd");
    private Color disabledFgColor = Color.decode("#ccccbb");
    private boolean geometryOk;
    static int offsetX;
    static int offsetY;
    static int spacingX;
    static int spacingY;
    static int methodWidth;
    static int methodHeight;
    static int r;
    private List<LinkView> links = new ArrayList<LinkView>();
    private List<LinkView> selectedLinks = new ArrayList<LinkView>();
    private HoverManager hoverManager = new HoverManager();
    private Comparator<MethodView> byNetTimeComparator = new Comparator<MethodView>(){

        @Override
        public int compare(MethodView o1, MethodView o2) {
            return (int)(-Math.signum(o1.method.getNetTime() - o2.method.getNetTime()));
        }
    };
    private MouseAdapter mouseAdapter = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            MethodView n = CallGraphPanel.this.findNode(e.getX(), e.getY());
            if (n != CallGraphPanel.this.selectedNode) {
                CallGraphPanel.this.geometryOk = false;
                CallGraphPanel.this.selectedNode = n;
                CallGraphPanel.this.repaint();
            }
        }

        public void mouseExited(MouseEvent e) {
            CallGraphPanel.this.hoverManager.reset();
        }
    };
    private boolean antialiased = true;
    private static int k;

    public CallGraphPanel() {
        this.setBackground(Color.decode("#ffffee"));
        Locale.setDefault(Locale.US);
        this.hoverManager.setContainer(this);
        this.hoverManager.registerHover(new MethodBoxHoverWindow());
        this.hoverManager.registerHover(new LinkHoverWindow());
        this.addMouseListener(this.mouseAdapter);
    }

    @Override
    public Object findHoverable(int x, int y) {
        MethodView n = this.findNode(x, y);
        if (n != null) {
            return n;
        }
        for (LinkView lnk : this.selectedLinks) {
            if (!lnk.contains(x, y)) continue;
            return lnk;
        }
        return null;
    }

    private MethodView findNode(int x, int y) {
        Rectangle r = new Rectangle();
        for (MethodView n : this.nodes.values()) {
            if (!n.visible) continue;
            r.x = n.x;
            r.y = n.y;
            r.width = n.w;
            r.height = n.h;
            if (!r.contains(x, y)) continue;
            return n;
        }
        return null;
    }

    public void setSnapshot(Snapshot snapshot) {
        this.snapshot = snapshot;
        if (snapshot == null) {
            this.nodes.clear();
            this.setPreferredSize(new Dimension(320, 300));
            this.repaint();
            this.revalidate();
        } else {
            this.refresh();
        }
    }

    @Override
    public void paint(Graphics g_) {
        super.paint(g_);
        Graphics2D g = (Graphics2D)g_;
        g.setStroke(this.defaultStroke);
        if (this.antialiased) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.drawMethods(g);
    }

    private void drawMethods(Graphics2D g) {
        if (!this.geometryOk) {
            this.computeGeometry();
            this.geometryOk = true;
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        g.setColor(Color.BLACK);
        g.setStroke(this.linkStroke);
        for (LinkView l : this.links) {
            l.paint(g);
        }
        for (MethodView n : this.nodes.values()) {
            if (n == this.selectedNode || !n.visible) continue;
            g.setColor(n.visible ? n.getColor() : this.disabledBgColor);
            g.fillRoundRect(n.x, n.y, n.w, n.h, r, r);
            g.setColor(n.visible ? Color.BLACK : this.disabledFgColor);
            g.drawRoundRect(n.x, n.y, n.w, n.h, r, r);
            g.drawString(n.method.getMethodName(), n.x + 5, n.y + fm.getHeight());
            g.drawString(this.makeDetailText(n), n.x + 5, n.y + fm.getHeight() * 2);
        }
        MethodView n = this.selectedNode;
        if (n != null) {
            g.setColor(n.getColor());
            g.setStroke(this.selStroke);
            g.fillRoundRect(n.x, n.y, n.w, n.h, r, r);
            g.setColor(Color.BLUE);
            g.drawRoundRect(n.x, n.y, n.w, n.h, r, r);
            g.setColor(Color.BLACK);
            g.drawString(n.method.getMethodName(), n.x + 5, n.y + fm.getHeight());
            g.drawString(this.makeDetailText(n), n.x + 5, n.y + fm.getHeight() * 2);
            g.setStroke(this.defaultStroke);
            g.setColor(Color.BLUE);
            g.setStroke(this.selLinkStroke);
            g.setColor(Color.BLUE);
            g.setStroke(this.selLinkStroke);
            for (LinkView l : this.selectedLinks) {
                l.paint(g);
            }
        }
    }

    private String makeDetailText(MethodView n) {
        return String.format("N:%.1f AN:%.3f H:%d", n.method.getNetTime(), n.method.getNetTime() / (double)n.method.getHits(), n.method.getHits());
    }

    private void computeGeometry() {
        for (MethodView n : this.nodes.values()) {
            n.x = n.ix * (methodWidth + spacingX) + offsetX;
            n.y = n.iy * (methodHeight + spacingY) + offsetY;
            n.w = methodWidth;
            n.h = methodHeight;
        }
        this.links.clear();
        this.selectedLinks.clear();
        for (MethodView src : this.nodes.values()) {
            if (!src.visible) continue;
            for (MethodView dst : src.children) {
                if (!dst.visible) continue;
                LinkView link = new LinkView(src, dst);
                if (this.selectedNode == src || this.selectedNode == dst) {
                    this.selectedLinks.add(link);
                    continue;
                }
                this.links.add(link);
            }
        }
    }

    private void refresh() {
        this.geometryOk = false;
        this.selectedNode = null;
        this.createNodes();
        this.layNodes(this.rootNodes, 0, 0);
        this.applyNCut(40);
    }

    private void layNodes(List<MethodView> nodeList, int level, int y) {
        for (int i = 0; i < this.iyMax.length; ++i) {
            this.iyMax[i] = 0;
        }
        this.ixMax = 1;
        Collections.sort(nodeList, this.byNetTimeComparator);
        for (MethodView rootNode : nodeList) {
            rootNode.ix = level;
            this.iyMax[0] = this.iyMax[0] + 1;
            rootNode.iy = rootNode.iy;
            rootNode.visible = true;
            this.matrix[rootNode.ix][rootNode.iy] = rootNode;
            this.lay(1, rootNode.children);
        }
        ++level;
        int ymax_ = -1;
        for (int i = 0; i < this.iyMax.length; ++i) {
            ymax_ = Math.max(this.iyMax[i], ymax_);
        }
        ArrayList<MethodView> colNodes = new ArrayList<MethodView>();
        for (int ix = 0; ix < this.ixMax; ++ix) {
            int iy;
            colNodes.clear();
            for (iy = 0; iy < this.iyMax[ix]; ++iy) {
                colNodes.add(this.matrix[ix][iy]);
            }
            Collections.sort(colNodes, this.byNetTimeComparator);
            iy = 0;
            Iterator i$ = colNodes.iterator();
            while (i$.hasNext()) {
                MethodView n;
                this.matrix[ix][iy] = n = (MethodView)i$.next();
                n.iy = iy++;
            }
        }
        this.setPreferredSize(new Dimension(this.ixMax * (methodWidth + spacingX) + offsetX, ymax_ * (methodHeight + spacingY) + offsetY));
        this.repaint();
        this.revalidate();
    }

    private void swapY(int x, int y1, int y2) {
        MethodView aux = this.matrix[x][y1];
        this.matrix[x][y1] = this.matrix[x][y2];
        this.matrix[x][y2] = aux;
        int yAux = this.matrix[x][y1].iy;
        this.matrix[x][y1].iy = this.matrix[x][y2].iy;
        this.matrix[x][y2].iy = yAux;
    }

    private void dumpNode(MethodView rootNode) {
        System.out.format("%23s: ix=%2d iy=%2d\n", rootNode.method.getMethodName(), rootNode.ix, rootNode.iy);
    }

    private void lay(int ix, List<MethodView> nodes) {
        for (MethodView n : nodes) {
            if (n.visible) continue;
            n.ix = ix;
            int n2 = ix;
            this.iyMax[n2] = this.iyMax[n2] + 1;
            n.iy = n.iy;
            n.visible = true;
            this.matrix[n.ix][n.iy] = n;
            this.lay(ix + 1, n.children);
        }
        this.ixMax = Math.max(this.ixMax, ix);
    }

    public void applyNCut(int n) {
        ArrayList<MethodView> aux = new ArrayList<MethodView>(this.nodes.values());
        Collections.sort(aux, this.byNetTimeComparator);
        int ncut = n;
        for (MethodView node : aux) {
            node.visible = --ncut >= 0;
        }
        if (this.selectedNode != null && !this.selectedNode.visible) {
            this.selectedNode = null;
        }
        this.geometryOk = false;
    }

    private void createNodes() {
        maxTime = -1.0;
        this.nodes.clear();
        if (this.snapshot == null) {
            return;
        }
        for (Snapshot.Method m : this.snapshot.getMethods().values()) {
            MethodView n = new MethodView();
            n.method = m;
            maxTime = Math.max(maxTime, m.getNetTime());
            this.nodes.put(m, n);
        }
        for (MethodView node : this.nodes.values()) {
            for (Snapshot.Method m : node.method.getChildrenTimes().keySet()) {
                node.children.add(this.nodes.get(m));
            }
        }
        this.findRootNodes();
    }

    private void findRootNodes() {
        for (MethodView node : this.nodes.values()) {
            for (Snapshot.Method childMethod : node.method.getChildrenTimes().keySet()) {
                if (childMethod == node.method) continue;
                this.nodes.get((Object)childMethod).root = false;
            }
        }
        this.rootNodes = new ArrayList<MethodView>();
        for (MethodView node : this.nodes.values()) {
            if (!node.root) continue;
            this.rootNodes.add(node);
        }
    }

    static {
        offsetX = 16;
        offsetY = 28;
        spacingX = 64;
        spacingY = 20;
        methodWidth = 150;
        methodHeight = 32;
        r = 10;
        k = 70;
    }
}

