/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.config.serverbeans.AccessLog;
import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.AuditModule;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.config.serverbeans.DiagnosticService;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.JaccProvider;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.LogService;
import com.sun.enterprise.config.serverbeans.MessageSecurityConfig;
import com.sun.enterprise.config.serverbeans.ModuleLogLevels;
import com.sun.enterprise.config.serverbeans.ProviderConfig;
import com.sun.enterprise.config.serverbeans.RequestPolicy;
import com.sun.enterprise.config.serverbeans.ResponsePolicy;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.ThreadPools;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.config.util.ConfigApiLoggerInfo;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.grizzly.config.dom.FileCache;
import org.glassfish.grizzly.config.dom.Http;
import org.glassfish.grizzly.config.dom.HttpRedirect;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.grizzly.config.dom.PortUnification;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.ProtocolFinder;
import org.glassfish.grizzly.config.dom.Protocols;
import org.glassfish.grizzly.config.dom.Ssl;
import org.glassfish.grizzly.config.dom.ThreadPool;
import org.glassfish.grizzly.config.dom.Transport;
import org.glassfish.grizzly.config.dom.Transports;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="defaultconfigupgrade")
public class DefaultConfigUpgrade
implements ConfigurationUpgrade,
PostConstruct {
    @Inject
    Configs configs;
    @Inject
    ServiceLocator habitat;
    private static final String DEFAULT_CONFIG = "default-config";
    private static final String INSTALL_ROOT = "com.sun.aas.installRoot";
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DefaultConfigUpgrade.class);
    private static final Logger logger = ConfigApiLoggerInfo.getLogger();
    private XMLStreamReader parser;
    private InputStreamReader reader;

    @Override
    public void postConstruct() {
        Config defaultConfig = this.configs.getConfigByName(DEFAULT_CONFIG);
        if (defaultConfig != null) {
            logger.log(Level.INFO, "NCLS-CFGAPI-00022");
            return;
        }
        String installRoot = System.getProperty(INSTALL_ROOT);
        if (installRoot == null) {
            logger.log(Level.INFO, "NCLS-CFGAPI-00023");
            return;
        }
        logger.log(Level.INFO, "NCLS-CFGAPI-00024");
        InputStream template = null;
        ZipFile templatezip = null;
        String templatefilename = Version.getDefaultDomainTemplate();
        File templatefile = new File(new File(new File(new File(installRoot, "common"), "templates"), "gf"), templatefilename);
        try {
            templatezip = new ZipFile(templatefile);
            ZipEntry domEnt = templatezip.getEntry("config/domain.xml");
            if (domEnt == null) {
                throw new RuntimeException(localStrings.getLocalString("DefaultConfigUpgrade.cannotGetDomainXmlTemplate", "DefaultConfigUpgrade failed. Cannot get default domain.xml from {0)", new Object[]{templatefile.getAbsolutePath()}));
            }
            template = templatezip.getInputStream(domEnt);
            ConfigSupport.apply((SingleConfigCode)new MinDefaultConfigCode(), (ConfigBeanProxy)this.configs);
            defaultConfig = this.configs.getConfigByName(DEFAULT_CONFIG);
            this.createParser(template);
            this.createDefaultConfigAttr(defaultConfig);
            this.createHttpServiceConfig(defaultConfig);
            this.createAdminServiceConfig(defaultConfig);
            this.createLogServiceConfig(defaultConfig);
            this.createSecurityServiceConfig(defaultConfig);
            this.createJavaConfig(defaultConfig);
            this.createAvailabilityService(defaultConfig);
            this.createNetworkConfig(defaultConfig);
            this.createThreadPools(defaultConfig);
            this.createSystemProperties(defaultConfig);
        }
        catch (TransactionFailure ex) {
            logger.log(Level.SEVERE, "NCLS-CFGAPI-00025", ex);
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.SEVERE, "NCLS-CFGAPI-00025", ex);
        }
        catch (XMLStreamException ex) {
            logger.log(Level.SEVERE, "NCLS-CFGAPI-00025", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(localStrings.getLocalString("DefaultConfigUpgrade.cannotGetDomainXmlTemplate", "DefaultConfigUpgrade failed. Cannot get default domain.xml from {0)", new Object[]{templatefile.getAbsolutePath()}), ex);
        }
        finally {
            try {
                if (this.parser != null) {
                    this.parser.close();
                }
            }
            catch (Exception e) {}
            try {
                if (this.reader != null) {
                    this.reader.close();
                }
            }
            catch (Exception e) {}
            try {
                if (template != null) {
                    template.close();
                }
            }
            catch (Exception e) {}
            try {
                if (templatezip != null) {
                    templatezip.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private void createDefaultConfigAttr(Config defaultConfig) throws TransactionFailure, XMLStreamException {
        while (this.parser.next() != 1 || !this.parser.getLocalName().equals("config") || !this.parser.getAttributeValue(null, "name").equals(DEFAULT_CONFIG)) {
        }
        ConfigSupport.apply((SingleConfigCode)new DefaultConfigCode(), (ConfigBeanProxy)defaultConfig);
    }

    private void createHttpServiceConfig(Config defaultConfig) throws TransactionFailure, XMLStreamException {
        while (this.parser.next() != 1 || !this.parser.getLocalName().equals("http-service")) {
        }
        ConfigSupport.apply((SingleConfigCode)new HttpServiceConfigCode(), (ConfigBeanProxy)defaultConfig);
    }

    private void createAdminServiceConfig(Config defaultConfig) throws TransactionFailure, XMLStreamException {
        while (this.parser.next() != 1 || !this.parser.getLocalName().equals("admin-service")) {
        }
        ConfigSupport.apply((SingleConfigCode)new AdminServiceConfigCode(), (ConfigBeanProxy)defaultConfig);
    }

    private void createLogServiceConfig(Config defaultConfig) throws TransactionFailure, XMLStreamException {
        while (this.parser.next() != 1 || !this.parser.getLocalName().equals("log-service")) {
        }
        ConfigSupport.apply((SingleConfigCode)new LogServiceConfigCode(), (ConfigBeanProxy)defaultConfig);
    }

    private void createSecurityServiceConfig(Config defaultConfig) {
        while (true) {
            try {
                while (this.parser.next() != 1 || !this.parser.getLocalName().equals("security-service")) {
                }
                ConfigSupport.apply((SingleConfigCode)new SecurityServiceConfigCode(), (ConfigBeanProxy)defaultConfig);
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00027", ex);
                continue;
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00028", ex);
                continue;
            }
            break;
        }
    }

    private void createJavaConfig(Config defaultConfig) throws TransactionFailure, XMLStreamException {
        while (this.parser.next() != 1 || !this.parser.getLocalName().equals("java-config")) {
        }
        ConfigSupport.apply((SingleConfigCode)new JavaConfigCode(), (ConfigBeanProxy)defaultConfig);
    }

    private void createAvailabilityService(Config defaultConfig) throws TransactionFailure, XMLStreamException {
        while (this.parser.next() != 1 || !this.parser.getLocalName().equals("availability-service")) {
        }
        ConfigSupport.apply((SingleConfigCode)new AvailabilityServiceConfigCode(), (ConfigBeanProxy)defaultConfig);
    }

    private void createNetworkConfig(Config defaultConfig) throws TransactionFailure, XMLStreamException {
        while (this.parser.next() != 1 || !this.parser.getLocalName().equals("network-config")) {
        }
        ConfigSupport.apply((SingleConfigCode)new NetworkConfigCode(), (ConfigBeanProxy)defaultConfig);
    }

    private void createThreadPools(Config defaultConfig) throws TransactionFailure, XMLStreamException {
        while (this.parser.next() != 1 || !this.parser.getLocalName().equals("thread-pools")) {
        }
        ConfigSupport.apply((SingleConfigCode)new ThreadPoolsConfigCode(), (ConfigBeanProxy)defaultConfig);
    }

    private void createSystemProperties(Config defaultConfig) throws TransactionFailure, XMLStreamException {
        ConfigSupport.apply((SingleConfigCode)new SystemPropertyConfigCode(), (ConfigBeanProxy)defaultConfig);
    }

    private void createVirtualServer(HttpService hs) throws PropertyVetoException {
        try {
            while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("http-service")) {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("virtual-server")) continue;
                VirtualServer vs = (VirtualServer)hs.createChild(VirtualServer.class);
                hs.getVirtualServer().add(vs);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    if (attr.equals("id")) {
                        vs.setId(this.parser.getAttributeValue(i));
                    }
                    if (!attr.equals("network-listeners")) continue;
                    vs.setNetworkListeners(this.parser.getAttributeValue(i));
                }
                this.createVirtualServerProperty(vs);
            }
        }
        catch (TransactionFailure ex) {
            logger.log(Level.SEVERE, "NCLS-CFGAPI-00029", ex);
        }
        catch (XMLStreamException ex) {
            logger.log(Level.SEVERE, "NCLS-CFGAPI-00030", ex);
        }
    }

    private void createVirtualServerProperty(VirtualServer vs) throws PropertyVetoException {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("virtual-server")) {
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("property")) continue;
                Property p = (Property)vs.createChild(Property.class);
                vs.getProperty().add(p);
                this.createProperty(p);
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00029", ex);
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00030", ex);
            }
        }
    }

    private void createAdminServiceProperty(AdminService as) throws PropertyVetoException {
        while (true) {
            try {
                while (this.parser.next() != 1 || !this.parser.getLocalName().equals("property")) {
                }
                Property p = (Property)as.createChild(Property.class);
                as.getProperty().add(p);
                this.createProperty(p);
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00031", ex);
                continue;
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00032", ex);
                continue;
            }
            break;
        }
    }

    private void createModuleLogLevels(LogService ls) throws PropertyVetoException {
        try {
            while (this.parser.next() != 1 || !this.parser.getLocalName().equals("module-log-levels") || ls == null) {
            }
            ModuleLogLevels mll = (ModuleLogLevels)ls.createChild(ModuleLogLevels.class);
            ls.setModuleLogLevels(mll);
        }
        catch (TransactionFailure ex) {
            logger.log(Level.SEVERE, "NCLS-CFGAPI-00034", ex);
        }
        catch (XMLStreamException ex) {
            logger.log(Level.SEVERE, "NCLS-CFGAPI-00035", ex);
        }
    }

    private void createAuthRealm(SecurityService ss) throws PropertyVetoException {
        while (this.parser.getEventType() != 1 || !this.parser.getLocalName().equals("jacc-provider")) {
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("auth-realm") || ss == null) continue;
                AuthRealm ar = (AuthRealm)ss.createChild(AuthRealm.class);
                ss.getAuthRealm().add(ar);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (attr.equals("classname")) {
                        ar.setClassname(val);
                    }
                    if (!attr.equals("name")) continue;
                    ar.setName(val);
                }
                this.createAuthRealmProperty(ar);
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00037", ex);
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00038", ex);
            }
        }
    }

    private void createAuthRealmProperty(AuthRealm ar) throws PropertyVetoException {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("auth-realm")) {
            Object attr = null;
            Object val = null;
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("property") || ar == null) continue;
                Property p = (Property)ar.createChild(Property.class);
                ar.getProperty().add(p);
                this.createProperty(p);
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00039", new Object[]{attr, val, ex});
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00040", ex);
            }
        }
    }

    private void createJaccProvider(SecurityService ss) throws PropertyVetoException {
        while (this.parser.getEventType() != 1 || !this.parser.getLocalName().equals("audit-module")) {
            try {
                if (this.parser.getEventType() != 1 && this.parser.next() != 1 || !this.parser.getLocalName().equals("jacc-provider") || ss == null) continue;
                JaccProvider jp = (JaccProvider)ss.createChild(JaccProvider.class);
                ss.getJaccProvider().add(jp);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (attr.equals("policy-provider")) {
                        jp.setPolicyProvider(val);
                    }
                    if (attr.equals("name")) {
                        jp.setName(val);
                    }
                    if (!attr.equals("policy-configuration-factory-provider")) continue;
                    jp.setPolicyConfigurationFactoryProvider(val);
                }
                this.createJaccProviderProperty(jp);
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00041", ex);
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00042", ex);
            }
        }
    }

    private void createJaccProviderProperty(JaccProvider jp) throws PropertyVetoException {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("jacc-provider")) {
            String attr = null;
            String val = null;
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("property") || jp == null) continue;
                Property p = (Property)jp.createChild(Property.class);
                jp.getProperty().add(p);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    attr = this.parser.getAttributeLocalName(i);
                    val = this.parser.getAttributeValue(i);
                    if (attr.equals("name")) {
                        p.setName(val);
                    }
                    if (!attr.equals("value")) continue;
                    p.setValue(val);
                }
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00043", new Object[]{attr, val, ex});
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00044", ex);
            }
        }
    }

    private void createAuditModule(SecurityService ss) throws PropertyVetoException {
        while (this.parser.getEventType() != 1 || !this.parser.getLocalName().equals("message-security-config")) {
            try {
                if (this.parser.getEventType() != 1 && this.parser.next() != 1 || !this.parser.getLocalName().equals("audit-module") || ss == null) continue;
                AuditModule am = (AuditModule)ss.createChild(AuditModule.class);
                ss.getAuditModule().add(am);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (attr.equals("classname")) {
                        am.setClassname(val);
                    }
                    if (!attr.equals("name")) continue;
                    am.setName(val);
                }
                this.createAuditModuleProperty(am);
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00045", ex);
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00045", ex);
            }
        }
    }

    private void createAuditModuleProperty(AuditModule am) throws PropertyVetoException {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("audit-module")) {
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("property") || am == null) continue;
                Property p = (Property)am.createChild(Property.class);
                am.getProperty().add(p);
                this.createProperty(p);
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00046", ex);
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00047", ex);
            }
        }
    }

    private void createMessageSecurityConfig(SecurityService ss) throws PropertyVetoException {
        while (true) {
            try {
                while (!this.parser.getLocalName().equals("message-security-config") || ss == null) {
                }
                MessageSecurityConfig msc = (MessageSecurityConfig)ss.createChild(MessageSecurityConfig.class);
                ss.getMessageSecurityConfig().add(msc);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (!attr.equals("auth-layer")) continue;
                    msc.setAuthLayer(val);
                }
                this.createProviderConfig(msc);
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00041", ex);
                continue;
            }
            break;
        }
    }

    private void createProviderConfig(MessageSecurityConfig msc) throws PropertyVetoException {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("message-security-config")) {
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("provider-config") || msc == null) continue;
                ProviderConfig pc = (ProviderConfig)msc.createChild(ProviderConfig.class);
                msc.getProviderConfig().add(pc);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (attr.equals("provider-type")) {
                        pc.setProviderType(val);
                    }
                    if (attr.equals("provider-id")) {
                        pc.setProviderId(val);
                    }
                    if (!attr.equals("class-name")) continue;
                    pc.setClassName(val);
                }
                this.createRequestPolicy(pc);
                this.createResponsePolicy(pc);
                this.createProviderConfigProperty(pc);
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00048", ex);
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00049", ex);
            }
        }
    }

    private void createRequestPolicy(ProviderConfig pc) throws PropertyVetoException {
        while (true) {
            try {
                while (this.parser.next() != 1 || !this.parser.getLocalName().equals("request-policy") || pc == null) {
                }
                RequestPolicy rp = (RequestPolicy)pc.createChild(RequestPolicy.class);
                pc.setRequestPolicy(rp);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (!attr.equals("auth-source")) continue;
                    rp.setAuthSource(val);
                }
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00050", ex);
                continue;
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00051", ex);
                continue;
            }
            break;
        }
    }

    private void createResponsePolicy(ProviderConfig pc) throws PropertyVetoException {
        while (true) {
            try {
                while (this.parser.next() != 1 || !this.parser.getLocalName().equals("response-policy") || pc == null) {
                }
                ResponsePolicy rp = (ResponsePolicy)pc.createChild(ResponsePolicy.class);
                pc.setResponsePolicy(rp);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (!attr.equals("auth-source")) continue;
                    rp.setAuthSource(val);
                }
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00050", ex);
                continue;
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00051", ex);
                continue;
            }
            break;
        }
    }

    private void createProviderConfigProperty(ProviderConfig pc) throws PropertyVetoException {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("provider-config")) {
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("property") || pc == null) continue;
                Property p = (Property)pc.createChild(Property.class);
                pc.getProperty().add(p);
                this.createProperty(p);
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00052", ex);
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00053", ex);
            }
        }
    }

    private void createJvmOptions(JavaConfig jc) {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("java-config")) {
            try {
                int eventType = this.parser.next();
                if (eventType != 1 || !this.parser.getLocalName().equals("jvm-options") || jc == null) continue;
                jc.getJvmOptions().add(this.parser.getElementText());
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00055", ex);
            }
        }
    }

    private void createProtocols(NetworkConfig nc) throws PropertyVetoException {
        while (true) {
            try {
                while (this.parser.next() != 1 || !this.parser.getLocalName().equals("protocols") || nc == null) {
                }
                Protocols ps = (Protocols)nc.createChild(Protocols.class);
                nc.setProtocols(ps);
                this.createProtocol(ps);
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00058", ex);
                continue;
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00059", ex);
                continue;
            }
            break;
        }
    }

    private void createProtocol(Protocols ps) throws PropertyVetoException {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("protocols")) {
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("protocol") || ps == null) continue;
                Protocol p = (Protocol)ps.createChild(Protocol.class);
                ps.getProtocol().add(p);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (attr.equals("security-enabled")) {
                        p.setSecurityEnabled(val);
                    }
                    if (!attr.equals("name")) continue;
                    p.setName(val);
                }
                while (this.parser.next() != 1) {
                }
                if (this.parser.getLocalName().equals("http") && p != null) {
                    this.createHttp(p);
                    this.createSsl(p);
                    continue;
                }
                if (this.parser.getLocalName().equals("http-redirect") && p != null) {
                    this.createHttpRedirect(p);
                    continue;
                }
                if (!this.parser.getLocalName().equals("port-unification") || p == null) continue;
                this.createPortUnification(p);
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00060", ex);
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00091", ex);
            }
        }
    }

    private void createHttp(Protocol p) throws PropertyVetoException {
        try {
            if (this.parser.getLocalName().equals("http") && p != null) {
                Http h = (Http)p.createChild(Http.class);
                p.setHttp(h);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (attr.equals("default-virtual-server")) {
                        h.setDefaultVirtualServer(val);
                    }
                    if (attr.equals("encoded-slash-enabled")) {
                        h.setEncodedSlashEnabled(val);
                    }
                    if (!attr.equals("max-connections")) continue;
                    h.setMaxConnections(val);
                }
                this.createFileCache(h);
            }
        }
        catch (TransactionFailure ex) {
            logger.log(Level.SEVERE, "NCLS-CFGAPI-00061", ex);
        }
    }

    private void createFileCache(Http h) throws PropertyVetoException {
        while (true) {
            try {
                while (this.parser.next() != 1 || !this.parser.getLocalName().equals("file-cache") || h == null) {
                }
                FileCache fc = (FileCache)h.createChild(FileCache.class);
                h.setFileCache(fc);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (!attr.equals("enabled")) continue;
                    fc.setEnabled(val);
                }
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00062", ex);
                continue;
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00063", ex);
                continue;
            }
            break;
        }
    }

    private void createSsl(Protocol p) throws PropertyVetoException {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("protocol")) {
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("ssl") || p == null) continue;
                Ssl ssl = (Ssl)p.createChild(Ssl.class);
                p.setSsl(ssl);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (attr.equals("classname")) {
                        ssl.setClassname(val);
                    }
                    if (attr.equals("ssl3-enabled")) {
                        ssl.setSsl3Enabled(val);
                    }
                    if (attr.equals("cert-nickname")) {
                        ssl.setCertNickname(val);
                    }
                    if (!attr.equals("client-auth")) continue;
                    ssl.setClientAuth(val);
                }
                break;
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00064", ex);
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00065", ex);
            }
        }
    }

    private void createHttpRedirect(Protocol p) throws PropertyVetoException {
        try {
            HttpRedirect hr = (HttpRedirect)p.createChild(HttpRedirect.class);
            p.setHttpRedirect(hr);
            for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                String attr = this.parser.getAttributeLocalName(i);
                String val = this.parser.getAttributeValue(i);
                if (!attr.equals("secure")) continue;
                hr.setSecure(val);
            }
        }
        catch (TransactionFailure ex) {
            logger.log(Level.SEVERE, "NCLS-CFGAPI-00066", ex);
        }
    }

    private void createPortUnification(Protocol p) throws PropertyVetoException {
        try {
            PortUnification pu = (PortUnification)p.createChild(PortUnification.class);
            p.setPortUnification(pu);
            this.createProtocolFinder(pu);
        }
        catch (TransactionFailure ex) {
            logger.log(Level.SEVERE, "NCLS-CFGAPI-00067", ex);
        }
    }

    private void createProtocolFinder(PortUnification pu) throws PropertyVetoException {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("port-unification")) {
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("protocol-finder") || pu == null) continue;
                ProtocolFinder pf = (ProtocolFinder)pu.createChild(ProtocolFinder.class);
                List pfList = pu.getProtocolFinder();
                pfList.add(pf);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (attr.equals("protocol")) {
                        pf.setProtocol(val);
                    }
                    if (attr.equals("name")) {
                        pf.setName(val);
                    }
                    if (!attr.equals("classname")) continue;
                    pf.setClassname(val);
                }
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00068", ex);
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00069", ex);
            }
        }
    }

    private void createNetworkListeners(NetworkConfig nc) throws PropertyVetoException {
        while (true) {
            try {
                while (this.parser.next() != 1 || !this.parser.getLocalName().equals("network-listeners") || nc == null) {
                }
                NetworkListeners nls = (NetworkListeners)nc.createChild(NetworkListeners.class);
                nc.setNetworkListeners(nls);
                this.createNetworkListener(nls);
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00070", ex);
                continue;
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00071", ex);
                continue;
            }
            break;
        }
    }

    private void createNetworkListener(NetworkListeners nls) throws PropertyVetoException {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("network-listeners")) {
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("network-listener") || nls == null) continue;
                NetworkListener nl = (NetworkListener)nls.createChild(NetworkListener.class);
                nls.getNetworkListener().add(nl);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (attr.equals("address")) {
                        nl.setAddress(val);
                    }
                    if (attr.equals("port")) {
                        nl.setPort(val);
                    }
                    if (attr.equals("protocol")) {
                        nl.setProtocol(val);
                    }
                    if (attr.equals("transport")) {
                        nl.setTransport(val);
                    }
                    if (attr.equals("name")) {
                        nl.setName(val);
                    }
                    if (!attr.equals("thread-pool")) continue;
                    nl.setThreadPool(val);
                }
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00072", ex);
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00073", ex);
            }
        }
    }

    private void createTransports(NetworkConfig nc) throws PropertyVetoException {
        while (true) {
            try {
                while (this.parser.next() != 1 || !this.parser.getLocalName().equals("transports") || nc == null) {
                }
                Transports ts = (Transports)nc.createChild(Transports.class);
                nc.setTransports(ts);
                this.createTransport(ts);
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00074", ex);
                continue;
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00075", ex);
                continue;
            }
            break;
        }
    }

    private void createTransport(Transports ts) throws PropertyVetoException {
        while (true) {
            try {
                while (this.parser.next() != 1 || !this.parser.getLocalName().equals("transport") || ts == null) {
                }
                Transport t = (Transport)ts.createChild(Transport.class);
                ts.getTransport().add(t);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (!attr.equals("name")) continue;
                    t.setName(val);
                }
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00076", ex);
                continue;
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00077", ex);
                continue;
            }
            break;
        }
    }

    private void createThreadPool(ThreadPools ts) throws PropertyVetoException {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("thread-pools")) {
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("thread-pool") || ts == null) continue;
                ThreadPool t = (ThreadPool)ts.createChild(ThreadPool.class);
                ts.getThreadPool().add(t);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (attr.equals("max-thread-pool-size")) {
                        t.setMaxThreadPoolSize(val);
                    }
                    if (attr.equals("idle-thread-timeout-in-seconds")) {
                        t.setIdleThreadTimeoutSeconds(val);
                    }
                    if (!attr.equals("name")) continue;
                    t.setName(val);
                }
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00079", ex);
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00080", ex);
            }
        }
    }

    private void createSystemProperty(Config defaultConfig) throws PropertyVetoException {
        while (this.parser.getEventType() != 2 || !this.parser.getLocalName().equals("config")) {
            try {
                if (this.parser.next() != 1 || !this.parser.getLocalName().equals("system-property") || defaultConfig == null) continue;
                SystemProperty sp = (SystemProperty)defaultConfig.createChild(SystemProperty.class);
                defaultConfig.getSystemProperty().add(sp);
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    String attr = this.parser.getAttributeLocalName(i);
                    String val = this.parser.getAttributeValue(i);
                    if (attr.equals("name")) {
                        sp.setName(val);
                    }
                    if (!attr.equals("value")) continue;
                    sp.setValue(val);
                }
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00081", ex);
            }
            catch (XMLStreamException ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00082", ex);
            }
        }
    }

    private void createProperty(Property p) throws PropertyVetoException {
        for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
            String attr = this.parser.getAttributeLocalName(i);
            String val = this.parser.getAttributeValue(i);
            if (attr.equals("name")) {
                p.setName(val);
            }
            if (!attr.equals("value")) continue;
            p.setValue(val);
        }
    }

    private void createParser(InputStream template) throws FileNotFoundException, XMLStreamException {
        if (template != null) {
            this.reader = new InputStreamReader(template);
            this.parser = XMLInputFactory.newInstance().createXMLStreamReader("domain.xml", this.reader);
        }
    }

    private class AdminServiceConfigCode
    implements SingleConfigCode<Config> {
        private AdminServiceConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException, TransactionFailure {
            AdminService adminService = (AdminService)config.createChild(AdminService.class);
            config.setAdminService(adminService);
            DasConfig dc = (DasConfig)adminService.createChild(DasConfig.class);
            adminService.setDasConfig(dc);
            for (int i = 0; i < DefaultConfigUpgrade.this.parser.getAttributeCount(); ++i) {
                String attr = DefaultConfigUpgrade.this.parser.getAttributeLocalName(i);
                String val = DefaultConfigUpgrade.this.parser.getAttributeValue(i);
                if (attr.equals("system-jmx-connector-name")) {
                    adminService.setSystemJmxConnectorName(val);
                }
                if (!attr.equals("type")) continue;
                adminService.setType(val);
            }
            DefaultConfigUpgrade.this.createAdminServiceProperty(adminService);
            return null;
        }
    }

    private static class AvailabilityServiceConfigCode
    implements SingleConfigCode<Config> {
        private AvailabilityServiceConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException {
            try {
                AvailabilityService as = (AvailabilityService)config.createChild(AvailabilityService.class);
                config.setAvailabilityService(as);
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00056", ex);
            }
            return null;
        }
    }

    private class DefaultConfigCode
    implements SingleConfigCode<Config> {
        private DefaultConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException, TransactionFailure {
            config.setDynamicReconfigurationEnabled(DefaultConfigUpgrade.this.parser.getAttributeValue(null, "dynamic-reconfiguration-enabled"));
            return null;
        }
    }

    private static class DiagnosticServiceConfigCode
    implements SingleConfigCode<Config> {
        private DiagnosticServiceConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException, TransactionFailure {
            DiagnosticService ds = (DiagnosticService)config.createChild(DiagnosticService.class);
            config.setDiagnosticService(ds);
            return null;
        }
    }

    private class HttpServiceConfigCode
    implements SingleConfigCode<Config> {
        private HttpServiceConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException, TransactionFailure {
            HttpService httpService = (HttpService)config.createChild(HttpService.class);
            config.setHttpService(httpService);
            AccessLog al = (AccessLog)httpService.createChild(AccessLog.class);
            httpService.setAccessLog(al);
            DefaultConfigUpgrade.this.createVirtualServer(httpService);
            return config;
        }
    }

    private class JavaConfigCode
    implements SingleConfigCode<Config> {
        private JavaConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException {
            try {
                JavaConfig jc = (JavaConfig)config.createChild(JavaConfig.class);
                config.setJavaConfig(jc);
                for (int i = 0; i < DefaultConfigUpgrade.this.parser.getAttributeCount(); ++i) {
                    String attr = DefaultConfigUpgrade.this.parser.getAttributeLocalName(i);
                    String val = DefaultConfigUpgrade.this.parser.getAttributeValue(i);
                    if (attr.equals("debug-options")) {
                        jc.setDebugOptions(val);
                    }
                    if (attr.equals("system-classpath")) {
                        jc.setSystemClasspath(val);
                    }
                    if (!attr.equals("classpath-suffix")) continue;
                    jc.setClasspathSuffix(val);
                }
                DefaultConfigUpgrade.this.createJvmOptions(jc);
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00054", ex);
            }
            return null;
        }
    }

    private class LogServiceConfigCode
    implements SingleConfigCode<Config> {
        private LogServiceConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException {
            LogService ls = null;
            try {
                ls = (LogService)config.createChild(LogService.class);
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00033", ex);
            }
            config.setLogService(ls);
            for (int i = 0; i < DefaultConfigUpgrade.this.parser.getAttributeCount(); ++i) {
                String attr = DefaultConfigUpgrade.this.parser.getAttributeLocalName(i);
                String val = DefaultConfigUpgrade.this.parser.getAttributeValue(i);
                if (attr.equals("log-rotation-limit-in-bytes")) {
                    ls.setLogRotationLimitInBytes(val);
                }
                if (!attr.equals("file")) continue;
                ls.setFile(val);
            }
            DefaultConfigUpgrade.this.createModuleLogLevels(ls);
            return null;
        }
    }

    private static class MinDefaultConfigCode
    implements SingleConfigCode<Configs> {
        private MinDefaultConfigCode() {
        }

        public Object run(Configs configs) throws PropertyVetoException, TransactionFailure {
            Config defaultConfig = (Config)configs.createChild(Config.class);
            defaultConfig.setName(DefaultConfigUpgrade.DEFAULT_CONFIG);
            Dom.unwrap((ConfigBeanProxy)defaultConfig).addDefaultChildren();
            configs.getConfig().add(defaultConfig);
            return defaultConfig;
        }
    }

    private class NetworkConfigCode
    implements SingleConfigCode<Config> {
        private NetworkConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException {
            try {
                NetworkConfig nc = (NetworkConfig)config.createChild(NetworkConfig.class);
                config.setNetworkConfig(nc);
                DefaultConfigUpgrade.this.createProtocols(nc);
                DefaultConfigUpgrade.this.createNetworkListeners(nc);
                DefaultConfigUpgrade.this.createTransports(nc);
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00057", ex);
            }
            return null;
        }
    }

    private class SecurityServiceConfigCode
    implements SingleConfigCode<Config> {
        private SecurityServiceConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException {
            try {
                SecurityService ss = (SecurityService)config.createChild(SecurityService.class);
                config.setSecurityService(ss);
                DefaultConfigUpgrade.this.createAuthRealm(ss);
                DefaultConfigUpgrade.this.createJaccProvider(ss);
                DefaultConfigUpgrade.this.createAuditModule(ss);
                DefaultConfigUpgrade.this.createMessageSecurityConfig(ss);
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00036", ex);
            }
            return null;
        }
    }

    private class SystemPropertyConfigCode
    implements SingleConfigCode<Config> {
        private SystemPropertyConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException {
            DefaultConfigUpgrade.this.createSystemProperty(config);
            return null;
        }
    }

    private class ThreadPoolsConfigCode
    implements SingleConfigCode<Config> {
        private ThreadPoolsConfigCode() {
        }

        public Object run(Config config) throws PropertyVetoException {
            try {
                ThreadPools tps = (ThreadPools)config.createChild(ThreadPools.class);
                config.setThreadPools(tps);
                DefaultConfigUpgrade.this.createThreadPool(tps);
            }
            catch (TransactionFailure ex) {
                logger.log(Level.SEVERE, "NCLS-CFGAPI-00078", ex);
            }
            return null;
        }
    }
}

