/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets.glassfish;

import java.lang.reflect.Method;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.glassfish.grizzly.http.server.Request;

public class GlassfishSupport {
    private final GlassfishContext context;
    private final GlassfishWrapper wrapper;
    private final GlassfishManager manager;
    private final HttpServletRequest request;
    private GlassfishSession session;

    public GlassfishSupport() {
        this.manager = null;
        this.request = null;
        this.context = null;
        this.wrapper = null;
    }

    public GlassfishSupport(Object context, Object wrapper, HttpServletRequest request) {
        this.context = new GlassfishContext(context);
        this.wrapper = new GlassfishWrapper(wrapper);
        this.manager = this.context.getManager();
        this.request = request;
    }

    public boolean isValid() {
        return this.manager != null;
    }

    public boolean isUserInRole(String role) {
        Principal userPrincipal = this.request.getUserPrincipal();
        if (userPrincipal == null) {
            return false;
        }
        if (this.context == null) {
            return false;
        }
        GlassfishRealm realm = this.context.getRealm();
        if (realm == null) {
            return false;
        }
        String servletName = null;
        if (this.wrapper != null) {
            servletName = this.wrapper.getServletName();
            String realRole = this.wrapper.findSecurityReference(role);
            if (realRole != null && realm.hasRole(servletName, userPrincipal, realRole)) {
                return true;
            }
        }
        return realm.hasRole(servletName, userPrincipal, role);
    }

    public HttpSession getSession(boolean create) {
        GlassfishSession gfSession = this.doGetSession(create);
        if (gfSession != null) {
            return gfSession.getSession();
        }
        return null;
    }

    private GlassfishSession doGetSession(boolean create) {
        if (!this.isValid()) {
            return null;
        }
        if (this.session != null && !this.session.isValid()) {
            this.session = null;
        }
        if (this.session != null) {
            return this.session;
        }
        String requestedSessionId = this.request.getRequestedSessionId();
        if (requestedSessionId != null) {
            try {
                this.session = this.manager.findSession(requestedSessionId, this.request);
            }
            catch (Exception e) {
                this.session = null;
            }
            if (this.session != null && !this.session.isValid()) {
                this.session = null;
            }
            if (this.session != null) {
                this.session.access();
                return this.session;
            }
        }
        if (!create) {
            return null;
        }
        if (requestedSessionId != null && this.context.getReuseSessionID()) {
            this.session = this.manager.createSession(requestedSessionId);
            this.manager.removeFromInvalidatedSessions(requestedSessionId);
        } else {
            this.session = this.manager.createSession();
        }
        if (this.session != null) {
            this.session.access();
            return this.session;
        }
        return null;
    }

    public void updateUserPrincipal(Request grizzlyRequest) {
        GlassfishSession gfSession = this.doGetSession(false);
        if (gfSession != null) {
            grizzlyRequest.setUserPrincipal(gfSession.getPrincipal());
            grizzlyRequest.getRequest().authType().setString(gfSession.getAuthType());
        }
    }

    private static class GlassfishContext {
        private static Method getManagerMethod;
        private static Method getReuseSessionIDMethod;
        private static Method getRealmMethod;
        private final Object context;

        private GlassfishContext(Object context) {
            this.context = context;
            this.check();
        }

        public GlassfishManager getManager() {
            return new GlassfishManager(this.exec(getManagerMethod, new Object[0]));
        }

        public boolean getReuseSessionID() {
            return (Boolean)this.exec(getReuseSessionIDMethod, new Object[0]);
        }

        public GlassfishRealm getRealm() {
            return new GlassfishRealm(this.exec(getRealmMethod, new Object[0]));
        }

        private Object exec(Method m, Object ... params) {
            try {
                return m.invoke(this.context, params);
            }
            catch (Throwable e) {
                throw new IllegalStateException("Can't call method '" + m.getName() + "'", e);
            }
        }

        private void check() {
            try {
                getManagerMethod = this.context.getClass().getMethod("getManager", new Class[0]);
                getReuseSessionIDMethod = this.context.getClass().getMethod("getReuseSessionID", new Class[0]);
                getRealmMethod = this.context.getClass().getMethod("getRealm", new Class[0]);
            }
            catch (Throwable t) {
                throw new IllegalStateException("GlassfishContext can't be initialized", t);
            }
        }
    }

    private static class GlassfishManager {
        private static volatile Boolean isChecked;
        private static Method findSessionMethod;
        private static Method createSession0Method;
        private static Method createSession1Method;
        private static Method removeFromInvalidatedSessionsMethod;
        private final Object manager;

        private GlassfishManager(Object manager) {
            this.manager = manager;
            this.check();
        }

        public GlassfishSession findSession(String requestedSessionId, HttpServletRequest request) {
            return this.wrapSession(this.exec(findSessionMethod, requestedSessionId, request));
        }

        public GlassfishSession createSession() {
            return this.wrapSession(this.exec(createSession0Method, new Object[0]));
        }

        public GlassfishSession createSession(String requestedSessionId) {
            return this.wrapSession(this.exec(createSession1Method, requestedSessionId));
        }

        private void removeFromInvalidatedSessions(String requestedSessionId) {
            if (removeFromInvalidatedSessionsMethod != null) {
                this.exec(removeFromInvalidatedSessionsMethod, requestedSessionId);
            }
        }

        private Object exec(Method m, Object ... params) {
            try {
                return m.invoke(this.manager, params);
            }
            catch (Throwable e) {
                throw new IllegalStateException("Can't call method '" + m.getName() + "'", e);
            }
        }

        private GlassfishSession wrapSession(Object session) {
            return session != null ? new GlassfishSession(session) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void check() {
            if (isChecked == null) {
                Class<GlassfishManager> clazz = GlassfishManager.class;
                synchronized (GlassfishManager.class) {
                    if (isChecked == null) {
                        try {
                            findSessionMethod = this.manager.getClass().getMethod("findSession", String.class, HttpServletRequest.class);
                            createSession0Method = this.manager.getClass().getMethod("createSession", new Class[0]);
                            createSession1Method = this.manager.getClass().getMethod("createSession", String.class);
                            try {
                                removeFromInvalidatedSessionsMethod = this.manager.getClass().getDeclaredMethod("removeFromInvalidatedSessions", String.class);
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                            isChecked = true;
                        }
                        catch (Throwable t) {
                            isChecked = false;
                            throw new IllegalStateException("GlassfishSessionManager can't be initialized", t);
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            if (!isChecked.booleanValue()) {
                throw new IllegalStateException("GlassfishSessionManager can't be initialized");
            }
        }
    }

    private static class GlassfishRealm {
        private static volatile Boolean isChecked;
        private static Method hasRoleMethod1;
        private static Method hasRoleMethod2;
        private final Object realm;

        public GlassfishRealm(Object realm) {
            this.realm = realm;
            this.check();
        }

        public boolean hasRole(String servletName, Principal principal, String role) {
            if (hasRoleMethod1 != null) {
                return (Boolean)this.exec(hasRoleMethod1, servletName, principal, role);
            }
            return (Boolean)this.exec(hasRoleMethod2, principal, role);
        }

        private Object exec(Method m, Object ... params) {
            try {
                return m.invoke(this.realm, params);
            }
            catch (Throwable e) {
                throw new IllegalStateException("Can't call method '" + m.getName() + "'", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void check() {
            if (isChecked == null) {
                Class<GlassfishSession> clazz = GlassfishSession.class;
                synchronized (GlassfishSession.class) {
                    if (isChecked == null) {
                        try {
                            try {
                                hasRoleMethod1 = this.realm.getClass().getMethod("hasRole", String.class, Principal.class, String.class);
                            }
                            catch (Throwable t) {
                                hasRoleMethod2 = this.realm.getClass().getMethod("hasRole", Principal.class, String.class);
                            }
                            isChecked = true;
                        }
                        catch (Throwable t) {
                            isChecked = false;
                            throw new IllegalStateException("GlassfishRealm can't be initialized", t);
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            if (!isChecked.booleanValue()) {
                throw new IllegalStateException("GlassfishRealm can't be initialized");
            }
        }
    }

    private static class GlassfishSession {
        private static volatile Boolean isChecked;
        private static Method isValidMethod;
        private static Method getSessionMethod;
        private static Method accessMethod;
        private static Method getPrincipalMethod;
        private static Method getAuthTypeMethod;
        private final Object session;

        public GlassfishSession(Object session) {
            this.session = session;
            this.check();
        }

        public boolean isValid() {
            return (Boolean)this.exec(isValidMethod, new Object[0]);
        }

        public HttpSession getSession() {
            return (HttpSession)this.exec(getSessionMethod, new Object[0]);
        }

        public void access() {
            this.exec(accessMethod, new Object[0]);
        }

        public Principal getPrincipal() {
            return (Principal)this.exec(getPrincipalMethod, new Object[0]);
        }

        public String getAuthType() {
            return (String)this.exec(getAuthTypeMethod, new Object[0]);
        }

        private Object exec(Method m, Object ... params) {
            try {
                return m.invoke(this.session, params);
            }
            catch (Throwable e) {
                throw new IllegalStateException("Can't call method '" + m.getName() + "'", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void check() {
            if (isChecked == null) {
                Class<GlassfishSession> clazz = GlassfishSession.class;
                synchronized (GlassfishSession.class) {
                    if (isChecked == null) {
                        try {
                            isValidMethod = this.session.getClass().getMethod("isValid", new Class[0]);
                            getSessionMethod = this.session.getClass().getMethod("getSession", new Class[0]);
                            accessMethod = this.session.getClass().getMethod("access", new Class[0]);
                            getPrincipalMethod = this.session.getClass().getMethod("getPrincipal", new Class[0]);
                            getAuthTypeMethod = this.session.getClass().getMethod("getAuthType", new Class[0]);
                            isChecked = true;
                        }
                        catch (Throwable t) {
                            isChecked = false;
                            throw new IllegalStateException("GlassfishSession can't be initialized", t);
                        }
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            }
            if (!isChecked.booleanValue()) {
                throw new IllegalStateException("GlassfishSession can't be initialized");
            }
        }
    }

    private static class GlassfishWrapper {
        private static Method findSecurityReferenceMethod;
        private static Method getServletNameMethod;
        private final Object wrapper;

        private GlassfishWrapper(Object wrapper) {
            this.wrapper = wrapper;
            this.check();
        }

        public String findSecurityReference(String name) {
            return (String)this.exec(findSecurityReferenceMethod, name);
        }

        public String getServletName() {
            return (String)this.exec(getServletNameMethod, new Object[0]);
        }

        private Object exec(Method m, Object ... params) {
            try {
                return m.invoke(this.wrapper, params);
            }
            catch (Throwable e) {
                throw new IllegalStateException("Can't call method '" + m.getName() + "'", e);
            }
        }

        private void check() {
            try {
                findSecurityReferenceMethod = this.wrapper.getClass().getMethod("findSecurityReference", String.class);
                getServletNameMethod = this.wrapper.getClass().getMethod("getServletName", new Class[0]);
            }
            catch (Throwable t) {
                throw new IllegalStateException("GlassfishWrapper can't be initialized", t);
            }
        }
    }
}

