/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.util.ArrayList;
import java.util.List;

public final class Extension {
    private final String name;
    private final List<Parameter> parameters = new ArrayList<Parameter>();

    public Extension(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Extension extension = (Extension)o;
        return this.name.equals(extension.name) && this.parameters.equals(extension.parameters);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.parameters.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (!this.parameters.isEmpty()) {
            for (Parameter p : this.parameters) {
                sb.append("; ");
                sb.append(p.toString());
            }
        }
        return sb.toString();
    }

    public static final class Parameter {
        private final String name;
        private String value;

        public Parameter(String name, String value) {
            if (name == null) {
                throw new IllegalArgumentException("Parameter name may not be null");
            }
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            return this.name.equals(parameter.name) && !(this.value == null ? parameter.value != null : !this.value.equals(parameter.value));
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name);
            if (this.value != null) {
                sb.append('=').append(this.value);
            }
            return sb.toString();
        }
    }
}

