/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.slots;

import com.db4o.internal.Buffer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.slots.ReferencedSlot;
import com.db4o.internal.slots.Slot;

public class SlotChange
extends TreeInt {
    private int _action;
    private Slot _newSlot;
    private ReferencedSlot _shared;
    private static final int FREE_ON_COMMIT_BIT = 1;
    private static final int FREE_ON_ROLLBACK_BIT = 2;
    private static final int SET_POINTER_BIT = 3;
    private static final int FREE_POINTER_ON_COMMIT_BIT = 4;
    private static final int FREE_POINTER_ON_ROLLBACK_BIT = 5;

    public SlotChange(int n) {
        super(n);
    }

    public Object shallowClone() {
        SlotChange slotChange = new SlotChange(0);
        slotChange._action = this._action;
        slotChange._newSlot = this._newSlot;
        slotChange._shared = this._shared;
        return super.shallowCloneInternal(slotChange);
    }

    private final void doFreeOnCommit() {
        this.setBit(1);
    }

    private final void doFreeOnRollback() {
        this.setBit(2);
    }

    private final void doFreePointerOnCommit() {
        this.setBit(4);
    }

    private final void doFreePointerOnRollback() {
        this.setBit(5);
    }

    private final void doSetPointer() {
        this.setBit(3);
    }

    public void freeDuringCommit(LocalObjectContainer localObjectContainer) {
        if (this.isFreeOnCommit()) {
            localObjectContainer.freeDuringCommit(this._shared, this._newSlot);
        }
    }

    public void freeOnCommit(LocalObjectContainer localObjectContainer, Slot slot) {
        if (this._shared != null) {
            localObjectContainer.free(slot);
            return;
        }
        this.doFreeOnCommit();
        ReferencedSlot referencedSlot = localObjectContainer.produceFreeOnCommitEntry(this._key);
        if (referencedSlot.addReferenceIsFirst()) {
            referencedSlot.pointTo(slot);
        }
        this._shared = referencedSlot;
    }

    public void freeOnRollback(int n, int n2) {
        this.doFreeOnRollback();
        this._newSlot = new Slot(n, n2);
    }

    public void freeOnRollbackSetPointer(int n, int n2) {
        this.doSetPointer();
        this.freeOnRollback(n, n2);
    }

    public void freePointerOnCommit() {
        this.doFreePointerOnCommit();
    }

    public void freePointerOnRollback() {
        this.doFreePointerOnRollback();
    }

    private final boolean isBitSet(int n) {
        return (this._action | 1 << n) == this._action;
    }

    public boolean isDeleted() {
        return this.isSetPointer() && this._newSlot._address == 0;
    }

    private final boolean isFreeOnCommit() {
        return this.isBitSet(1);
    }

    private final boolean isFreeOnRollback() {
        return this.isBitSet(2);
    }

    public final boolean isSetPointer() {
        return this.isBitSet(3);
    }

    public final boolean isFreePointerOnRollback() {
        return this.isBitSet(5);
    }

    public Slot newSlot() {
        return this._newSlot;
    }

    public Slot oldSlot() {
        if (this._shared == null) {
            return null;
        }
        return this._shared.slot();
    }

    public Object read(Buffer buffer) {
        SlotChange slotChange = new SlotChange(buffer.readInt());
        slotChange._newSlot = new Slot(buffer.readInt(), buffer.readInt());
        slotChange.doSetPointer();
        return slotChange;
    }

    public void rollback(LocalObjectContainer localObjectContainer) {
        if (this._shared != null) {
            localObjectContainer.reduceFreeOnCommitReferences(this._shared);
        }
        if (this.isFreeOnRollback()) {
            localObjectContainer.free(this._newSlot);
        }
        if (this.isFreePointerOnRollback()) {
            localObjectContainer.free(this._key, 8);
        }
    }

    private final void setBit(int n) {
        this._action |= 1 << n;
    }

    public void setPointer(int n, int n2) {
        this.doSetPointer();
        this._newSlot = new Slot(n, n2);
    }

    public void write(Buffer buffer) {
        if (this.isSetPointer()) {
            buffer.writeInt(this._key);
            buffer.writeInt(this._newSlot._address);
            buffer.writeInt(this._newSlot._length);
        }
    }

    public void writePointer(Transaction transaction) {
        if (this.isSetPointer()) {
            transaction.writePointer(this._key, this._newSlot._address, this._newSlot._length);
        }
    }
}

