/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.Buffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DeleteInfo;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.TreeReader;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.slots.Slot;
import com.db4o.internal.slots.SlotChange;

public class LocalTransaction
extends Transaction {
    private Tree _slotChanges;

    public LocalTransaction(ObjectContainerBase objectContainerBase, Transaction transaction) {
        super(objectContainerBase, transaction);
    }

    protected void clearAll() {
        this._slotChanges = null;
        super.clearAll();
    }

    protected void rollbackSlotChanges() {
        if (this._slotChanges != null) {
            this._slotChanges.traverse(new Visitor4(){

                public void visit(Object object) {
                    ((SlotChange)object).rollback(LocalTransaction.this.i_file);
                }
            });
        }
    }

    public boolean isDeleted(int n) {
        return this.slotChangeIsFlaggedDeleted(n);
    }

    protected void commit6WriteChanges() {
        this.checkSynchronization();
        int n = this.countSlotChanges();
        if (n > 0) {
            int n2 = (n * 3 + 2) * 4;
            int n3 = this.i_file.getSlot(n2);
            StatefulBuffer statefulBuffer = new StatefulBuffer(this, n3, n2);
            statefulBuffer.writeInt(n2);
            statefulBuffer.writeInt(n);
            this.appendSlotChanges(statefulBuffer);
            statefulBuffer.write();
            this.flushFile();
            this.stream().writeTransactionPointer(n3);
            this.flushFile();
            if (this.writeSlots()) {
                this.flushFile();
            }
            this.stream().writeTransactionPointer(0);
            this.flushFile();
            this.i_file.free(n3, n2);
        }
    }

    private boolean writeSlots() {
        this.checkSynchronization();
        boolean bl = false;
        if (this.i_parentTransaction != null && this.parentFileTransaction().writeSlots()) {
            bl = true;
        }
        if (this._slotChanges != null) {
            this._slotChanges.traverse(new Visitor4(){

                public void visit(Object object) {
                    ((SlotChange)object).writePointer(LocalTransaction.this);
                }
            });
            bl = true;
        }
        return bl;
    }

    protected void flushFile() {
        if (this.i_file.configImpl().flushFileBuffers()) {
            this.i_file.syncFiles();
        }
    }

    private SlotChange produceSlotChange(int n) {
        SlotChange slotChange = new SlotChange(n);
        this._slotChanges = Tree.add(this._slotChanges, slotChange);
        return (SlotChange)slotChange.addedOrExisting();
    }

    private final SlotChange findSlotChange(int n) {
        this.checkSynchronization();
        return (SlotChange)TreeInt.find(this._slotChanges, n);
    }

    public Slot getCurrentSlotOfID(int n) {
        Slot slot;
        this.checkSynchronization();
        if (n == 0) {
            return null;
        }
        SlotChange slotChange = this.findSlotChange(n);
        if (slotChange != null && slotChange.isSetPointer()) {
            return slotChange.newSlot();
        }
        if (this.i_parentTransaction != null && (slot = this.parentFileTransaction().getCurrentSlotOfID(n)) != null) {
            return slot;
        }
        return this.readCommittedSlotOfID(n);
    }

    public Slot getCommittedSlotOfID(int n) {
        Slot slot;
        if (n == 0) {
            return null;
        }
        SlotChange slotChange = this.findSlotChange(n);
        if (slotChange != null && (slot = slotChange.oldSlot()) != null) {
            return slot;
        }
        if (this.i_parentTransaction != null && (slot = this.parentFileTransaction().getCommittedSlotOfID(n)) != null) {
            return slot;
        }
        return this.readCommittedSlotOfID(n);
    }

    private Slot readCommittedSlotOfID(int n) {
        try {
            this.i_file.readBytes(this._pointerBuffer, n, 8);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
        int n2 = this._pointerBuffer[3] & 0xFF | (this._pointerBuffer[2] & 0xFF) << 8 | (this._pointerBuffer[1] & 0xFF) << 16 | this._pointerBuffer[0] << 24;
        int n3 = this._pointerBuffer[7] & 0xFF | (this._pointerBuffer[6] & 0xFF) << 8 | (this._pointerBuffer[5] & 0xFF) << 16 | this._pointerBuffer[4] << 24;
        return new Slot(n2, n3);
    }

    public void setPointer(int n, int n2, int n3) {
        this.checkSynchronization();
        this.produceSlotChange(n).setPointer(n2, n3);
    }

    private boolean slotChangeIsFlaggedDeleted(int n) {
        SlotChange slotChange = this.findSlotChange(n);
        if (slotChange != null) {
            return slotChange.isDeleted();
        }
        if (this.i_parentTransaction != null) {
            return this.parentFileTransaction().slotChangeIsFlaggedDeleted(n);
        }
        return false;
    }

    private int countSlotChanges() {
        int n = 0;
        if (this.i_parentTransaction != null) {
            n += this.parentFileTransaction().countSlotChanges();
        }
        final int[] nArray = new int[]{n};
        if (this._slotChanges != null) {
            this._slotChanges.traverse(new Visitor4(){

                public void visit(Object object) {
                    SlotChange slotChange = (SlotChange)object;
                    if (slotChange.isSetPointer()) {
                        nArray[0] = nArray[0] + 1;
                    }
                }
            });
        }
        return nArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeOld() {
        Object object = this.stream().i_lock;
        synchronized (object) {
            this.i_pointerIo.useSlot(this.i_address);
            this.i_pointerIo.read();
            int n = this.i_pointerIo.readInt();
            if (n > 0) {
                StatefulBuffer statefulBuffer = new StatefulBuffer(this, this.i_address, n);
                statefulBuffer.read();
                statefulBuffer.incrementOffset(4);
                this._slotChanges = new TreeReader(statefulBuffer, new SlotChange(0)).read();
                if (this.writeSlots()) {
                    this.flushFile();
                }
                this.stream().writeTransactionPointer(0);
                this.flushFile();
                this.freeOnCommit();
            } else {
                this.stream().writeTransactionPointer(0);
                this.flushFile();
            }
        }
    }

    protected final void freeOnCommit() {
        this.checkSynchronization();
        if (this.i_parentTransaction != null) {
            this.parentFileTransaction().freeOnCommit();
        }
        if (this._slotChanges != null) {
            this._slotChanges.traverse(new Visitor4(){

                public void visit(Object object) {
                    ((SlotChange)object).freeDuringCommit(LocalTransaction.this.i_file);
                }
            });
        }
    }

    private void appendSlotChanges(final Buffer buffer) {
        if (this.i_parentTransaction != null) {
            this.parentFileTransaction().appendSlotChanges(buffer);
        }
        Tree.traverse(this._slotChanges, new Visitor4(){

            public void visit(Object object) {
                ((TreeInt)object).write(buffer);
            }
        });
    }

    public void slotDelete(int n, int n2, int n3) {
        this.checkSynchronization();
        if (n == 0) {
            return;
        }
        SlotChange slotChange = this.produceSlotChange(n);
        slotChange.freeOnCommit(this.i_file, new Slot(n2, n3));
        slotChange.setPointer(0, 0);
    }

    private void slotFreeOnCommit(int n, Slot slot) {
        if (slot == null) {
            return;
        }
        this.slotFreeOnCommit(n, slot.getAddress(), slot.getLength());
    }

    public void slotFreeOnCommit(int n, int n2, int n3) {
        this.checkSynchronization();
        if (n == 0) {
            return;
        }
        this.produceSlotChange(n).freeOnCommit(this.i_file, new Slot(n2, n3));
    }

    public void slotFreeOnRollback(int n, int n2, int n3) {
        this.checkSynchronization();
        this.produceSlotChange(n).freeOnRollback(n2, n3);
    }

    void slotFreeOnRollbackCommitSetPointer(int n, int n2, int n3) {
        Slot slot = this.getCurrentSlotOfID(n);
        if (slot == null) {
            return;
        }
        this.checkSynchronization();
        SlotChange slotChange = this.produceSlotChange(n);
        slotChange.freeOnRollbackSetPointer(n2, n3);
        slotChange.freeOnCommit(this.i_file, slot);
    }

    void slotFreeOnRollbackSetPointer(int n, int n2, int n3) {
        this.checkSynchronization();
        this.produceSlotChange(n).freeOnRollbackSetPointer(n2, n3);
    }

    public void slotFreePointerOnCommit(int n) {
        this.checkSynchronization();
        Slot slot = this.getCurrentSlotOfID(n);
        if (slot == null) {
            return;
        }
        this.slotFreeOnCommit(n, slot._address, slot._length);
    }

    void slotFreePointerOnCommit(int n, int n2, int n3) {
        this.checkSynchronization();
        this.slotFreeOnCommit(n2, n2, n3);
        this.slotFreeOnCommit(n, n, 8);
    }

    public void slotFreePointerOnRollback(int n) {
        this.produceSlotChange(n).freePointerOnRollback();
    }

    private LocalTransaction parentFileTransaction() {
        return (LocalTransaction)this.i_parentTransaction;
    }

    public void processDeletes() {
        if (this.i_delete == null) {
            this.i_writtenUpdateDeletedMembers = null;
            return;
        }
        while (this.i_delete != null) {
            Tree tree = this.i_delete;
            this.i_delete = null;
            tree.traverse(new Visitor4(){

                public void visit(Object object) {
                    DeleteInfo deleteInfo = (DeleteInfo)object;
                    if (LocalTransaction.this.isDeleted(deleteInfo._key)) {
                        return;
                    }
                    Object object2 = null;
                    if (deleteInfo._reference != null) {
                        object2 = deleteInfo._reference.getObject();
                    }
                    if (object2 == null) {
                        Object[] objectArray = LocalTransaction.this.stream().getObjectAndYapObjectByID(LocalTransaction.this, deleteInfo._key);
                        deleteInfo._reference = (ObjectReference)objectArray[1];
                        deleteInfo._reference.flagForDelete(LocalTransaction.this.stream().topLevelCallId());
                    }
                    LocalTransaction.this.stream().delete3(LocalTransaction.this, deleteInfo._reference, deleteInfo._cascade, false);
                }
            });
        }
        this.i_writtenUpdateDeletedMembers = null;
    }

    public void writeUpdateDeleteMembers(int n, ClassMetadata classMetadata, int n2, int n3) {
        this.checkSynchronization();
        TreeInt treeInt = new TreeInt(n);
        this.i_writtenUpdateDeletedMembers = Tree.add(this.i_writtenUpdateDeletedMembers, treeInt);
        if (!treeInt.wasAddedToTree()) {
            return;
        }
        if (classMetadata.canUpdateFast()) {
            this.slotFreeOnCommit(n, this.getCurrentSlotOfID(n));
            return;
        }
        StatefulBuffer statefulBuffer = this.stream().readWriterByID(this, n);
        if (statefulBuffer == null) {
            if (classMetadata.hasIndex()) {
                this.dontRemoveFromClassIndex(classMetadata.getID(), n);
            }
            return;
        }
        ObjectHeader objectHeader = new ObjectHeader(this.stream(), classMetadata, statefulBuffer);
        DeleteInfo deleteInfo = (DeleteInfo)TreeInt.find(this.i_delete, n);
        if (deleteInfo != null && deleteInfo._cascade > n3) {
            n3 = deleteInfo._cascade;
        }
        statefulBuffer.setCascadeDeletes(n3);
        classMetadata.deleteMembers(objectHeader._marshallerFamily, objectHeader._headerAttributes, statefulBuffer, n2, true);
        this.slotFreeOnCommit(n, new Slot(statefulBuffer.getAddress(), statefulBuffer.getLength()));
    }
}

